<?php

header('Access-Control-Allow-Origin: *'); 
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method"); 
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE"); 

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::post('logincredit', 'CreditBureauController@loginCredit');

Route::post('sendemail', 'NotificationsController@replaceEmailTagsNew');

Route::post('usesendgrid', 'NotificationsController@use_send_grid_');

//use_send_grid
//passRequestIdToGetOtherParams
//testSetting
//tests


Route::post('newfullanalytics', 'NewAnalyticsController@runFullAnalytics');

Route::post('tryaccount', 'AnalyticsController@tryAccount');

Route::post('doguarantor', 'AnalyticsController@doGuarantor');

Route::post('docard', 'AnalyticsController@doCard');

Route::post('doaccount', 'AnalyticsController@doAccount');

Route::post('dodirectdebit', 'AnalyticsController@doDirectDebit');

Route::post('dosms', 'AnalyticsController@doSMS');


//for notification
Route::post('storemessages', 'MessagesController@storeMessages');

Route::post('storeplatformsetting', 'MessagesController@storePlatFormSettings');

Route::post('readmessages', 'MessagesController@readMessages');

Route::post('updatereadmessages', 'MessagesController@updateReadMessages');


Route::post('desktopnotifications', 'MessagesController@getUnreadDesktopMessage');

Route::post('pushnotifications', 'MessagesController@getUnreadPushMessage');

////for notification without token

Route::post('storemessagestokenless', 'MessagesController@storeMessagesWithoutToken');

Route::post('storeplatformsettingtokenless', 'MessagesController@storePlatFormSettingsWithoutToken');

Route::post('readmessagestokenless', 'MessagesController@readMessagesWithoutToken');

Route::post('updatereadmessagestokenless', 'MessagesController@updateReadMessagesWithoutToken');


Route::post('desktopnotificationstokenless', 'MessagesController@getUnreadDesktopMessageWithoutToken');

Route::post('pushnotificationstokenless', 'MessagesController@getUnreadPushMessageWithoutToken');





//for Accounts
Route::post('displayaccounts', 'AccountsController@displayAccounts');

Route::post('savejournal', 'AccountsController@saveJournal');

Route::post('savejournalform', 'AccountsController@saveJournalForm');

Route::post('listalljournals', 'AccountsController@listAllJournals');

Route::post('listonejournal', 'AccountsController@listSingleJournal');

Route::post('approvejournal', 'AccountsController@approveJournal');

Route::post('rejectjournal', 'AccountsController@rejectJournal');


//nextorPreviousJournal
Route::post('nextjournal', 'AccountsController@nextorPreviousJournal');

Route::post('nextalljournals', 'AccountsController@nextAllJournals');

Route::post('searchalljournals', 'AccountsController@searchAllJournals');



Route::post('editjournal', 'AccountsController@editJournal');
// Route::post('nextalljournals', 'AccountsController@nextAllJournals');

Route::post('nextorpreviousjournal', 'AccountsController@nextorPreviousJournal');

Route::post('bulkapprovejournals', 'AccountsController@bulkApproveJournals');

Route::post('deletejournal', 'AccountsController@deleteJournal');

 Route::post('journalreport', 'AccountsController@getJournalReport');

Route::post('settopending', 'AccountsController@setToPending');


 Route::post('readaccountcharts', 'AccountsController@readChartOfAccount');

 Route::post('createaccountcharts', 'AccountsController@createChartOfAccount');

 Route::post('updateaccountcharts', 'AccountsController@updateChartOfAccount');

Route::post('deleteaccountcharts', 'AccountsController@deleteChartOfAccount');

Route::post('localaccounts', 'AccountsController@displayLocalAccounts');

Route::post('globalaccounts', 'AccountsController@displayGlobalAccounts');

Route::post('addnewaccount', 'AccountsController@addNewAccounts');

Route::post('editaccount', 'AccountsController@editSelectedAccounts');

Route::post('customerswithbookedloans', 'AccountsController@getCustomersWithBookedLoans');

Route::post('customerloans', 'AccountsController@getLoansForCustomer');

Route::post('generaledgereport', 'AccountsController@getGeneralLedgerReport');

Route::post('generaledgereportnew', 'AccountsController@getGeneralLedgerReportNew');

Route::post('trialbalance', 'AccountsController@getTrialBalance');

Route::post('listplgroup', 'AccountsController@listPLGroup');

Route::post('addplgroup', 'AccountsController@AddPLGroup');

Route::post('deleteplgroup', 'AccountsController@deletePLGroup');

Route::post('updateplgroup', 'AccountsController@updatePLGroup');

Route::post('deleteaccountfromplgroup', 'AccountsController@deleteAccountFromGroup');

Route::post('movegrouporder', 'AccountsController@moveGroupOrder');

Route::post('moveaccountorder', 'AccountsController@moveAccountOrder');

Route::post('plstatement', 'AccountsController@getProfitLossStatement');

Route::post('plstatementnew', 'AccountsController@getProfitLossStatementNew');

Route::post('bsstatement', 'AccountsController@getBalanceSheetStatement');


Route::post('addbsgroup', 'AccountsController@AddBSGroup');
Route::post('updatebsgroup', 'AccountsController@updateBSGroup');
Route::post('listbsgroup', 'AccountsController@listBSGroup');
Route::post('deletebsgroup', 'AccountsController@deleteBSGroup');
Route::post('deleteaccountfrombsgroup', 'AccountsController@deleteAccountFromBSGroup');
Route::post('movebsgrouporder', 'AccountsController@moveBSGroupOrder');
Route::post('movebsaccountorder', 'AccountsController@moveBSAccountOrder');

/** test PDF local */
Route::post('testpdf', 'AccountsController@testPDF');

Route::post('getpdf', 'AccountsController@getPDF');
















Route::post('tests', 'AnalyticsController@tests');

Route::post('fullanalytics', 'AnalyticsController@runFullAnalytics');

Route::post('test', 'LenderAuthController@testSetting');
Route::post('requestparams', 'LenderAuthController@passRequestIdToGetOtherParams');

Route::post('fullanalysis', 'LenderAuthController@runFullAnalytics');

Route::post('repayeligibility', 'RepaymentsController@determineRepaymentsEligibility');

Route::post('socialeligibility', 'SocialController@determineSocialEligibility');

Route::post('fulleligibility', 'LenderAuthController@check');

Route::post('facebook', 'SocialController@facebook_node');

Route::post('twitter', 'SocialController@twitter_node');
//linkedin_node

Route::post('linkedin', 'SocialController@linkedin_node');

Route::post('social', 'SocialController@social_analysis');
Route::post('tope', 'CalllogsController@endpointsForTope');



Route::post('hello', 'LenderAuthController@hello');

Route::put('leavestest', 'LenderAuthController@leavestest');



Route::post('signup', 'AuthController@signup');


Route::group([

    'middleware' => 'api',
    

], function ($router) {

    Route::post('login', 'AuthController@login');
    Route::post('logout', 'AuthController@logout');
    Route::post('refresh', 'AuthController@refresh');
    Route::post('me', 'AuthController@me');

});



// Route::get('/', function () {
//     return view('welcome');
// });

// Route::get('check', 'LenderAuthController@check');

// Route::post('login', 'AuthController@login');
// Route::post('getlender', 'LenderAuthController@getLender');

