<?php
namespace App\Http\Middleware;
use Closure;
use Exception;
//use App\Models\Lender;
use Firebase\JWT\JWT;
use Firebase\JWT\ExpiredException;

class JwtMiddleware
{
    public function handle($request, Closure $next, $guard = null)
    {      
        $token = $request->get('token');    
        if(!$token) {
            // Unauthorized response if token not there
            return response()->json([
                'error' => 'Token not provided.'
            ], 401);
        }
        try {
            $credentials = JWT::decode($token, env('JWT_SECRET'), ['HS256']);
        } catch(ExpiredException $e) {
            return response()->json([
                'error' => 'Provided token is expired.'
            ], 400);
        } catch(Exception $e) {
            return response()->json([
                'error' => 'An error while decoding token.'
            ], 400);
        }
        $lender = DB::table('people')->where('PEOPLE_ID',$credentials->lender_id)->get();
        if(!$lender){
            // Unauthorized response if lender not found
            return response()->json([
                'error' => 'Lender does not exist.'
            ], 401);
        }
        $request->auth = $lender;
        return $next($request);
    }
}