<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


use App\Http\Requests;

class SocialController extends Controller
{

    public function determineSocialEligibility($leafIds,$lender_setting,$data,$facebook,$twitterData,$linkedin,$row="")
	{	
        //$social_leafids = $leafIds;
        // $leafIds = $request->input('leafids');
        // $lender_setting = $request->input('product');
        // $data= $request->input('data');
        // $facebook= $request->input('facebook');
        // $twitterData= $request->input('twitter');
        // $linkedin= $request->input('linkedin');
        // $row= $request->input('row');	
		$grades = [];
        $newGrade = [];
 	
        $leaves = [
            'facebook_Check_reliability_score'=>1,
            'facebook_Name_Comparison'=>2,
            'facebook_Email_comparison'=>3,
            'facebook_Has_Picture'=>4,

            'linkedin_Activeness_Score'=>5,
            'linkedin_Reliability_Score'=>6,
            'linkedin_Consistency_Score'=>7,
            'linkedin_Fullname_compare'=>8,
            'linkedin_Email_compare'=>9,
            'linkedin_Headline_Job_grade_check'=>10,
            'linkedin_Headline_Industry_check'=>11,
            'linkedin_Headline_Company_check'=>12,
            'linkedin_Industry_Does_industry_match'=>13,
            'linkedin_Summary_Job_grade_check'=>14,
            'linkedin_Summary_Industry_check'=>15,
            'linkedin_Summary_Company_check'=>16,
            'linkedin_Connection_greater_than_x'=>17,
            'linkedin_Has_Pix'=>18,
            'linkedin_Location_State_within_prefered_location'=>19,
            'linkedin_Has_active_company'=>20,
            'linkedin_Company_is_submitted_company'=>21,
            'linkedin_Industry_is_submitted_industry'=>22,
            'linkedin_years_is_submitted_years'=>23,
            'linkedin_Job_grade_is_submitted_job_grade'=>24,
            'linkedin_Company_size_within_range'=>25,
            'linkedin_Office_location_is_submitted_location'=>26,
            'linkedin_Last_post_date_more_than_x'=>27,

            'twitter_activeness_score'=>28,
            'twitter_reliability_score'=>29,
            //'twitter_consistency_score'=>30,
            'twitter_fullname_compare'=>30,
            'twitter_screen_name_vs_name_submitted'=>31,
            'twitter_description_industry_check'=>32,
            'twitter_description_company_check'=>33,
            'twitter_followers_count_more_than_x'=>34,
            'twitter_following_more_than_x'=>35,
            'twitter_followers_to_following_ratio_more_than_x'=>36,
            'twitter_is_verified'=>37,
            'twitter_has_pix'=>38,
            'twitter_favorite_count_more_than_x'=>39,
            'twitter_status_count_more_than_x'=>40,
            'twitter_created_at_more_than_x_days'=>41, 
        ];
		
        $runEligibiltyData = $this->runSocialEligibilty($leafIds,$leaves,$lender_setting,$data,$facebook,$twitterData,$linkedin,$row);
        // var_dump($runEligibiltyData);
        // die();
	
		foreach($leafIds as $key=>$leafId)
		{
			$grades[$leafId] = $runEligibiltyData["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}

		$eligibility_data = [];
		$eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
		$eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible"; 
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
    }

    public function runSocialEligibilty($leafIds,$leaves,$lender_setting,$data,$facebook,$twitterData,$linkedin,$row)
	{
        //($data);
        $total = 0;
        $leaves_grade = [];
       
        if(sizeof($facebook) > 0)
        {
            
            $facebook_call = $this->facebook_node($lender_setting,$data,$facebook,$row);

            if(in_array($leaves['facebook_Check_reliability_score'],$leafIds))
            {
                $reliability_score =  $facebook_call['facebook']['reliability_score']  == 100 ? "true":"false";
                   if($reliability_score == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['facebook_Name_Comparison'],$leafIds))
            {
                $facebook_name_match =  $facebook_call['facebook']['name']['isNameMatched']  == true? "true":"false";
                if($facebook_name_match == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['facebook_Email_comparison'],$leafIds))
            {
                $facebook_email_match =  $facebook_call['facebook']['email']['isEmailMatched']  == true ? "true":"false";
                if($facebook_email_match == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['facebook_Has_Picture'],$leafIds))
            {
                $facebook_has_pic =  $facebook_call['facebook']['picture']['isPictureSet']  == true ? "true":"false";
                if($facebook_has_pic == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }

        }
        else
        {
            if(in_array($leaves['facebook_Check_reliability_score'],$leafIds))
            {
                    $leaves_grade [] = "failed";        
            }
            if(in_array($leaves['facebook_Name_Comparison'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
            }
            if(in_array($leaves['facebook_Email_comparison'],$leafIds))
            {          
                    $leaves_grade [] = "failed";        
            }
            if(in_array($leaves['facebook_Has_Picture'],$leafIds))
            {
                    $leaves_grade [] = "failed";
            }
        }
        
        if(sizeof($linkedin) > 0)
        {
            $linkedin_call = $this->linkedin_node($lender_setting,$data,$linkedin,$row);
            if(in_array($leaves['linkedin_Activeness_Score'],$leafIds))
            {
                $linkedin_Activeness_Score =  $linkedin_call['activeness']['score'] == 100 ? "true":"false";
                if($linkedin_Activeness_Score == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Reliability_Score'],$leafIds))
            {
                $linkedin_Reliability_Score =  $linkedin_call['reliability_score'] == 100 ? "true":"false";
                if($linkedin_Reliability_Score == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Consistency_Score'],$leafIds))
            {
                $linkedin_Consistency_Score =  $linkedin_call['consistency_score'] == 100 ? "true":"false";
                if($linkedin_Consistency_Score == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Fullname_compare'],$leafIds))
            {
                $linkedin_Fullname_compare =  $linkedin_call['full_name_compare'] == true ? "true":"false";
                if($linkedin_Fullname_compare == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Email_compare'],$leafIds))
            {
                $linkedin_Email_compare =  $linkedin_call['email_compare'] == true ? "true":"false";
                if($linkedin_Email_compare == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Headline_Job_grade_check'],$leafIds))
            {
                $linkedin_Headline_Job_grade_check =  $linkedin_call['job_grade_check'] == true ? "true":"false";
                if($linkedin_Headline_Job_grade_check == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Headline_Industry_check'],$leafIds))
            {
                $linkedin_Headline_Industry_check =  $linkedin_call['industry_check'] == true ? "true":"false";
                if($linkedin_Headline_Industry_check == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Headline_Company_check'],$leafIds))
            {
                $linkedin_Headline_Company_check =  $linkedin_call['company_check'] == true ? "true":"false";
                if($linkedin_Headline_Company_check == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Industry_Does_industry_match'],$leafIds))
            {
                $linkedin_Industry_Does_industry_match =  $linkedin_call['industry_match'] == true ? "true":"false";
                if($linkedin_Industry_Does_industry_match == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Summary_Job_grade_check'],$leafIds))
            {
                $linkedin_Summary_Job_grade_check =  $linkedin_call['summary_job_grade_check'] == true ? "true":"false";
                if($linkedin_Summary_Job_grade_check == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Summary_Industry_check'],$leafIds))
            {
                $linkedin_Summary_Industry_check =  $linkedin_call['summary_industry_check'] == true ? "true":"false";
                if($linkedin_Summary_Industry_check == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Summary_Company_check'],$leafIds))
            {
                $linkedin_Summary_Company_check =  $linkedin_call['summary_company_check'] == true ? "true":"false";
                if($linkedin_Summary_Company_check == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
    
            if(in_array($leaves['linkedin_Connection_greater_than_x'],$leafIds))
            {
                $linkedin_Connection_greater_than_x =  $linkedin_call['number_of_connections'] == true ? "true":"false";
                if($linkedin_Connection_greater_than_x == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Has_Pix'],$leafIds))
            {
                $linkedin_Has_Pix =  $linkedin_call['have_picture'] == true ? "true":"false";
                if($linkedin_Has_Pix == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Location_State_within_prefered_location'],$leafIds))
            {
                $linkedin_Location_State_within_prefered_location =  $linkedin_call['within_prefered_location'] == true ? "true":"false";
                if($linkedin_Location_State_within_prefered_location == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Has_active_company'],$leafIds))
            {
                $linkedin_Has_active_company =  $linkedin_call['active_company'] == true ? "true":"false";
                if($linkedin_Has_active_company == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Company_is_submitted_company'],$leafIds))
            {
                $linkedin_Company_is_submitted_company =  $linkedin_call['linkedin_company_is_equal_to_submitted_company'] == true ? "true":"false";
                if($linkedin_Company_is_submitted_company == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Industry_is_submitted_industry'],$leafIds))
            {
                $linkedin_Industry_is_submitted_industry =  $linkedin_call['linkedin_industry_is_equal_to_submitted_industry'] == true ? "true":"false";
                if($linkedin_Industry_is_submitted_industry == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_years_is_submitted_years'],$leafIds))
            {
                $linkedin_years_is_submitted_years =  $linkedin_call['linkedin_years_is_equal_to_submitted_years'] == true ? "true":"false";
                if($linkedin_years_is_submitted_years == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Job_grade_is_submitted_job_grade'],$leafIds))
            {
                $linkedin_Job_grade_is_submitted_job_grade =  $linkedin_call['linkedin_job_grade_is_equal_to_submitted_job_grade'] == true ? "true":"false";
                if($linkedin_Job_grade_is_submitted_job_grade == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Company_size_within_range'],$leafIds))
            {
                $linkedin_Company_size_within_range =  $linkedin_call['company_size_within_range'] == true ? "true":"false";
                if($linkedin_Company_size_within_range == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Office_location_is_submitted_location'],$leafIds))
            {
                $linkedin_Office_location_is_submitted_location =  $linkedin_call['office_location_equal_to_submitted_one'] == true ? "true":"false";
                if($linkedin_Office_location_is_submitted_location == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['linkedin_Last_post_date_more_than_x'],$leafIds))
            {
                $linkedin_Last_post_date_more_than_x =  $linkedin_call['last_post_date_more_than_specified'] == true ? "true":"false";
                if($linkedin_Last_post_date_more_than_x == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
    
        }
        else
        {            
            if(in_array($leaves['linkedin_Activeness_Score'],$leafIds))
            {
                $leaves_grade [] = "failed";
            }
            if(in_array($leaves['linkedin_Reliability_Score'],$leafIds))
            {       
                    $leaves_grade [] = "failed";     
            }
            if(in_array($leaves['linkedin_Consistency_Score'],$leafIds))
            {
             
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Fullname_compare'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Email_compare'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Headline_Job_grade_check'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Headline_Industry_check'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Headline_Company_check'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['linkedin_Industry_Does_industry_match'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Summary_Job_grade_check'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Summary_Industry_check'],$leafIds))
            {
                
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Summary_Company_check'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }

            if(in_array($leaves['linkedin_Connection_greater_than_x'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['linkedin_Has_Pix'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Location_State_within_prefered_location'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
              
            }
            if(in_array($leaves['linkedin_Has_active_company'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['linkedin_Company_is_submitted_company'],$leafIds))
            {
                
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Industry_is_submitted_industry'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['linkedin_years_is_submitted_years'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['linkedin_Job_grade_is_submitted_job_grade'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['linkedin_Company_size_within_range'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['linkedin_Office_location_is_submitted_location'],$leafIds))
            {
             
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['linkedin_Last_post_date_more_than_x'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
              
            }


        }
      
        if(sizeof($twitterData) > 0)
        {
            $twitter_call = $this->twitter_node($lender_setting,$data,$twitterData,$row);
            
            if(in_array($leaves['twitter_activeness_score'],$leafIds))
            {
                
                $twitter_activeness_score =  $twitter_call['activeness']['score'] == 100 ? "true":"false";
                if($twitter_activeness_score == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_reliability_score'],$leafIds))
            {          
                $twitter_reliability_score =  $twitter_call['reliability']['score'] == 100 ? "true":"false";
                if($twitter_reliability_score == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            // if(in_array($leaves['twitter_consistency_score'],$leafIds))
            // {                
               
            // }
            if(in_array($leaves['twitter_fullname_compare'],$leafIds))
            {
                $twitter_fullname_compare =  $twitter_call['fullnamecompare'] == true ? "true":"false";
                if($twitter_fullname_compare == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_screen_name_vs_name_submitted'],$leafIds))
            {
                $twitter_screen_name_vs_name_submitted =  $twitter_call['screename_vs_names_submitted_correct'] == true ? "true":"false";
                if($twitter_screen_name_vs_name_submitted == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_description_industry_check'],$leafIds))
            {
                $twitter_description_industry_check =  $twitter_call['description_industry_check'] == true ? "true":"false";
                if($twitter_description_industry_check == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_description_company_check'],$leafIds))
            {
                $twitter_description_company_check =  $twitter_call['description_company_check'] == true ? "true":"false";
                if($twitter_description_company_check == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_followers_count_more_than_x'],$leafIds))
            {
                $twitter_followers_count_more_than_x =  $twitter_call['followers_count_more_than_specified'] == true ? "true":"false";
                if($twitter_followers_count_more_than_x == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_following_more_than_x'],$leafIds))
            {
                $twitter_following_more_than_x =  $twitter_call['following_count_more_than_specified'] == true ? "true":"false";
                if($twitter_following_more_than_x == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_followers_to_following_ratio_more_than_x'],$leafIds))
            {
                $twitter_followers_to_following_ratio_more_than_x =  $twitter_call['followers_to_following_ratio_more_than_specified'] == true ? "true":"false";
                if($twitter_followers_to_following_ratio_more_than_x == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_is_verified'],$leafIds))
            {
                $twitter_is_verified =  $twitter_call['is_verified'] == true ? "true":"false";
                if($twitter_is_verified == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_has_pix'],$leafIds))
            {
                $twitter_has_pix =  $twitter_call['has_pix'] == true ? "true":"false";
                if($twitter_has_pix == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_favorite_count_more_than_x'],$leafIds))
            {
                $twitter_favorite_count_more_than_x =  $twitter_call['favorite_count_more_than_specified'] == true ? "true":"false";
                if($twitter_favorite_count_more_than_x == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_status_count_more_than_x'],$leafIds))
            {
                $twitter_status_count_more_than_x =  $twitter_call['statuses_count_more_than_specified'] == true ? "true":"false";
                if($twitter_status_count_more_than_x == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                }
            }
            if(in_array($leaves['twitter_created_at_more_than_x_days'],$leafIds))
            {
                $twitter_created_at_more_than_x_days =  $twitter_call['created_at_more_than_specified'] == true ? "true":"false";
                if($twitter_created_at_more_than_x_days == "true")
                {
                    $total++;  $leaves_grade [] = "passed";
                }
                else
                {
                    $leaves_grade [] = "failed";
                } 
            }

        }
        else
        {
            if(in_array($leaves['twitter_activeness_score'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['twitter_reliability_score'],$leafIds))
            {          
               
                    $leaves_grade [] = "failed";
               
            }
            // if(in_array($leaves['twitter_consistency_score'],$leafIds))
            // {                
               
            // }
            if(in_array($leaves['twitter_fullname_compare'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['twitter_screen_name_vs_name_submitted'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['twitter_description_industry_check'],$leafIds))
            {
                
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['twitter_description_company_check'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['twitter_followers_count_more_than_x'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['twitter_following_more_than_x'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['twitter_followers_to_following_ratio_more_than_x'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['twitter_is_verified'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['twitter_has_pix'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
                
            }
            if(in_array($leaves['twitter_favorite_count_more_than_x'],$leafIds))
            {
               
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['twitter_status_count_more_than_x'],$leafIds))
            {
                
                    $leaves_grade [] = "failed";
               
            }
            if(in_array($leaves['twitter_created_at_more_than_x_days'],$leafIds))
            {
              
                    $leaves_grade [] = "failed";
               
            }
        
        }
    
		$result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;
    }

    public function determineSocialAnalytics($lender_setting,$data,$facebook,$twitterData,$linkedin,$row="")
	{	
        //$social_leafids = $leafIds;
        // $leafIds = $request->input('leafids');
        // $lender_setting = $request->input('product');
        // $data= $request->input('data');
        // $facebook= $request->input('facebook');
        // $twitterData= $request->input('twitter');
        // $linkedin= $request->input('linkedin');
        // $row= $request->input('row');	
		$grades = [];
        $newGrade = [];
 	
        $leaves = [
            'facebook_Check_reliability_score'=>1,
            'facebook_Name_Comparison'=>2,
            'facebook_Email_comparison'=>3,
            'facebook_Has_Picture'=>4,

            'linkedin_Activeness_Score'=>5,
            'linkedin_Reliability_Score'=>6,
            'linkedin_Consistency_Score'=>7,
            'linkedin_Fullname_compare'=>8,
            'linkedin_Email_compare'=>9,
            'linkedin_Headline_Job_grade_check'=>10,
            'linkedin_Headline_Industry_check'=>11,
            'linkedin_Headline_Company_check'=>12,
            'linkedin_Industry_Does_industry_match'=>13,
            'linkedin_Summary_Job_grade_check'=>14,
            'linkedin_Summary_Industry_check'=>15,
            'linkedin_Summary_Company_check'=>16,
            'linkedin_Connection_greater_than_x'=>17,
            'linkedin_Has_Pix'=>18,
            'linkedin_Location_State_within_prefered_location'=>19,
            'linkedin_Has_active_company'=>20,
            'linkedin_Company_is_submitted_company'=>21,
            'linkedin_Industry_is_submitted_industry'=>22,
            'linkedin_years_is_submitted_years'=>23,
            'linkedin_Job_grade_is_submitted_job_grade'=>24,
            'linkedin_Company_size_within_range'=>25,
            'linkedin_Office_location_is_submitted_location'=>26,
            'linkedin_Last_post_date_more_than_x'=>27,

            'twitter_activeness_score'=>28,
            'twitter_reliability_score'=>29,
            //'twitter_consistency_score'=>30,
            'twitter_fullname_compare'=>30,
            'twitter_screen_name_vs_name_submitted'=>31,
            'twitter_description_industry_check'=>32,
            'twitter_description_company_check'=>33,
            'twitter_followers_count_more_than_x'=>34,
            'twitter_following_more_than_x'=>35,
            'twitter_followers_to_following_ratio_more_than_x'=>36,
            'twitter_is_verified'=>37,
            'twitter_has_pix'=>38,
            'twitter_favorite_count_more_than_x'=>39,
            'twitter_status_count_more_than_x'=>40,
            'twitter_created_at_more_than_x_days'=>41, 
        ];
        $leaves = array_values($leaves);
		
        $runEligibiltyData = $this->runSocialAnalytics($lender_setting,$data,$facebook,$twitterData,$linkedin,$row);
        // var_dump($runEligibiltyData);
        // die();
	
		foreach($leaves as $key=>$leafId)
		{
			$grades[$leafId] = $runEligibiltyData["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}

		$eligibility_data = [];
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
    }

    public function runSocialAnalytics($lender_setting,$data,$facebook,$twitterData,$linkedin,$row)
	{
        $total = 0;
        $leaves_grade = [];
       
       
      
       
        
        if(sizeof($facebook) > 0)
        {
            $facebook_call = $this->facebook_node($lender_setting,$data,$facebook,$row);

            $reliability_score =  $facebook_call['facebook']['reliability_score']  == 100 ? "true":"false";
            if($reliability_score == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $facebook_name_match =  $facebook_call['facebook']['name']['isNameMatched']  == true? "true":"false";
            if($facebook_name_match == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
    
            $facebook_email_match =  $facebook_call['facebook']['email']['isEmailMatched']  == true ? "true":"false";
            if($facebook_email_match == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $facebook_has_pic =  $facebook_call['facebook']['picture']['isPictureSet']  == true ? "true":"false";
            if($facebook_has_pic == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        }
        else
        {
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";

        }
      

        if(sizeof($linkedin) > 0)
        {
            $linkedin_call = $this->linkedin_node($lender_setting,$data,$linkedin,$row);

            $linkedin_Activeness_Score =  $linkedin_call['activeness']['score'] == 100 ? "true":"false";
            if($linkedin_Activeness_Score == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Reliability_Score =  $linkedin_call['reliability_score'] == 100 ? "true":"false";
            if($linkedin_Reliability_Score == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Consistency_Score =  $linkedin_call['consistency_score'] == 100 ? "true":"false";
            if($linkedin_Consistency_Score == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
    
            $linkedin_Fullname_compare =  $linkedin_call['full_name_compare'] == true ? "true":"false";
            if($linkedin_Fullname_compare == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Email_compare =  $linkedin_call['email_compare'] == true ? "true":"false";
            if($linkedin_Email_compare == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Headline_Job_grade_check =  $linkedin_call['job_grade_check'] == true ? "true":"false";
            if($linkedin_Headline_Job_grade_check == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
    
        
            $linkedin_Headline_Industry_check =  $linkedin_call['industry_check'] == true ? "true":"false";
            if($linkedin_Headline_Industry_check == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Headline_Company_check =  $linkedin_call['company_check'] == true ? "true":"false";
            if($linkedin_Headline_Company_check == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $linkedin_Industry_Does_industry_match =  $linkedin_call['industry_match'] == true ? "true":"false";
            if($linkedin_Industry_Does_industry_match == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $linkedin_Summary_Job_grade_check =  $linkedin_call['summary_job_grade_check'] == true ? "true":"false";
            if($linkedin_Summary_Job_grade_check == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $linkedin_Summary_Industry_check =  $linkedin_call['summary_industry_check'] == true ? "true":"false";
            if($linkedin_Summary_Industry_check == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Summary_Company_check =  $linkedin_call['summary_company_check'] == true ? "true":"false";
            if($linkedin_Summary_Company_check == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
    
        
            $linkedin_Connection_greater_than_x =  $linkedin_call['number_of_connections'] == true ? "true":"false";
            if($linkedin_Connection_greater_than_x == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $linkedin_Has_Pix =  $linkedin_call['have_picture'] == true ? "true":"false";
            if($linkedin_Has_Pix == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
    
            $linkedin_Location_State_within_prefered_location =  $linkedin_call['within_prefered_location'] == true ? "true":"false";
            if($linkedin_Location_State_within_prefered_location == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $linkedin_Has_active_company =  $linkedin_call['active_company'] == true ? "true":"false";
            if($linkedin_Has_active_company == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $linkedin_Company_is_submitted_company =  $linkedin_call['linkedin_company_is_equal_to_submitted_company'] == true ? "true":"false";
            if($linkedin_Company_is_submitted_company == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $linkedin_Industry_is_submitted_industry =  $linkedin_call['linkedin_industry_is_equal_to_submitted_industry'] == true ? "true":"false";
            if($linkedin_Industry_is_submitted_industry == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $linkedin_years_is_submitted_years =  $linkedin_call['linkedin_years_is_equal_to_submitted_years'] == true ? "true":"false";
            if($linkedin_years_is_submitted_years == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
    
            $linkedin_Job_grade_is_submitted_job_grade =  $linkedin_call['linkedin_job_grade_is_equal_to_submitted_job_grade'] == true ? "true":"false";
            if($linkedin_Job_grade_is_submitted_job_grade == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Company_size_within_range =  $linkedin_call['company_size_within_range'] == true ? "true":"false";
            if($linkedin_Company_size_within_range == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Office_location_is_submitted_location =  $linkedin_call['office_location_equal_to_submitted_one'] == true ? "true":"false";
            if($linkedin_Office_location_is_submitted_location == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $linkedin_Last_post_date_more_than_x =  $linkedin_call['last_post_date_more_than_specified'] == true ? "true":"false";
            if($linkedin_Last_post_date_more_than_x == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        }
        else
        {
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed"; 
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";

        }
        
     
        if(sizeof($twitterData) > 0)
        {
            $twitter_call = $this->twitter_node($lender_setting,$data,$twitterData,$row);
            $twitter_activeness_score =  $twitter_call['activeness']['score'] == 100 ? "true":"false";
            if($twitter_activeness_score == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
                    
            $twitter_reliability_score =  $twitter_call['reliability']['score'] == 100 ? "true":"false";
            if($twitter_reliability_score == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            // if(in_array($leaves['twitter_consistency_score'],$leafIds))
            // {                
                
            // }
            
            $twitter_fullname_compare =  $twitter_call['fullnamecompare'] == true ? "true":"false";
            if($twitter_fullname_compare == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_screen_name_vs_name_submitted =  $twitter_call['screename_vs_names_submitted_correct'] == true ? "true":"false";
            if($twitter_screen_name_vs_name_submitted == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
    
            $twitter_description_industry_check =  $twitter_call['description_industry_check'] == true ? "true":"false";
            if($twitter_description_industry_check == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_description_company_check =  $twitter_call['description_company_check'] == true ? "true":"false";
            if($twitter_description_company_check == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
    
            $twitter_followers_count_more_than_x =  $twitter_call['followers_count_more_than_specified'] == true ? "true":"false";
            if($twitter_followers_count_more_than_x == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_following_more_than_x =  $twitter_call['following_count_more_than_specified'] == true ? "true":"false";
            if($twitter_following_more_than_x == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_followers_to_following_ratio_more_than_x =  $twitter_call['followers_to_following_ratio_more_than_specified'] == true ? "true":"false";
            if($twitter_followers_to_following_ratio_more_than_x == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_is_verified =  $twitter_call['is_verified'] == true ? "true":"false";
            if($twitter_is_verified == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_has_pix =  $twitter_call['has_pix'] == true ? "true":"false";
            if($twitter_has_pix == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_favorite_count_more_than_x =  $twitter_call['favorite_count_more_than_specified'] == true ? "true":"false";
            if($twitter_favorite_count_more_than_x == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_status_count_more_than_x =  $twitter_call['statuses_count_more_than_specified'] == true ? "true":"false";
            if($twitter_status_count_more_than_x == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
        
            $twitter_created_at_more_than_x_days =  $twitter_call['created_at_more_than_specified'] == true ? "true":"false";
            if($twitter_created_at_more_than_x_days == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            } 
		}
        else
        {
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";
            $leaves_grade [] = "failed";

        }
       
       
		$result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;
    }
    public function social_analysis(Request $request)
    {   
       $total_for_social = 0;
        //row is for general analytics setttings while product is for specific lender settings
        $lender_setting = $request->input('product');
        //return $lender_setting;
        $data = $request->input('data');   
        $facebook = $request->input('facebook');
        $twitterData = $request->input('twitter');
        $linkedin = $request->input('linkedin');
        $row = $request->input('row');
        
        $facebook_score = $this->facebook_node($lender_setting,$data,$facebook,$row);
		
		$twitter_score = $this->twitter_node($lender_setting,$data,$twitterData,$row);

		//customer_change_frequency_score
		$linkedin_score = $this->linkedin_node($lender_setting,$data,$linkedin,$row);

        if($facebook_score['score_for_facebook'] >= $row["GENERAL_PASS_PERCENTAGE"])
        {
			$total_for_social+=$row["FACEBOOK_ANALYTICS"];
        }
        else
        {
			$total_for_social-=$row["FACEBOOK_ANALYTICS_NEGATIVE"];
		}

        if($twitter_score['score_for_twitter'] >= $row["GENERAL_PASS_PERCENTAGE"])
        {
			$total_for_social+=$row["TWITTER_ANALYTICS"];
        }
        else
        {
			$total_for_social-=$row["TWITTER_ANALYTICS_NEGATIVE"];
		}

        if($linkedin_score['score_for_linkedin'] >= $row["GENERAL_PASS_PERCENTAGE"])
        {
			$total_for_social+=$row["LINKEDIN_ANALYTICS"];
        }
        else
        {
			$total_for_social-=$row["LINKEDIN_ANALYTICS_NEGATIVE"];
        }
        
        $total_denominator_for_social=$row["FACEBOOK_ANALYTICS"]+$row["TWITTER_ANALYTICS"]+$row["LINKEDIN_ANALYTICS"];

        $customer_social_score = $total_for_social <= 0 ? 0 : ($total_for_social/$total_denominator_for_social)*100;
       $social_analytics_data = [
            "score"=>$customer_social_score,
            "facebook"=>[
                "isNameMatched"=>$facebook_score['facebook']['name']['isNameMatched'],
                "isEmailMatched"=>$facebook_score['facebook']['email']['isEmailMatched'],
                "isPictureSet"=>$facebook_score['facebook']['picture']['isPictureSet'],
                "reliability_score"=>$facebook_score['facebook']['reliability_score'],
                "score_for_facebook"=>$facebook_score['score_for_facebook'],
            ],
            "twitter"=>[
                "activeness_score"=>$twitter_score['activeness']['score'],
                "reliability_score"=>$twitter_score['reliability']['score'],
                //3leftout
                "fullnamecompare"=>$twitter_score['fullnamecompare'],
                "screename_vs_names_submitted_correct"=>$twitter_score['screename_vs_names_submitted_correct'],
                //6
                "description_industry_check"=>$twitter_score['description_industry_check'],
                //7
                "description_company_check"=>$twitter_score['description_company_check'],
                "followers_count_more_than_specified"=>$twitter_score['followers_count_more_than_specified'],
                "following_count_more_than_specified"=>$twitter_score['following_count_more_than_specified'],

                "followers_to_following_ratio_more_than_specified"=>$twitter_score['followers_to_following_ratio_more_than_specified'],
                "is_verified"=>$twitter_score['is_verified'],
                "has_pix"=>$twitter_score['has_pix'],
                "favorite_count_more_than_specified"=>$twitter_score['favorite_count_more_than_specified'],
                "statuses_count_more_than_specified"=>$twitter_score['statuses_count_more_than_specified'],
                "created_at_more_than_specified"=>$twitter_score['created_at_more_than_specified'],
                "score_for_twitter"=>$twitter_score['score_for_twitter'],
            ],
            "linkedin"=>[
                //1activenessscore
                "activeness_score"=>$linkedin_score['activeness']['score'],
                "reliability_score"=>$linkedin_score['reliability_score'],
                "consistency_score"=>$linkedin_score['consistency_score'],
                //3 consistencyscore
                //
                "full_name_compare"=>$linkedin_score['full_name_compare'],
                "email_compare"=>$linkedin_score['email_compare'],
                "job_grade_check"=>$linkedin_score['job_grade_check'],
                "industry_check"=>$linkedin_score['industry_check'],
                "company_check"=>$linkedin_score['company_check'],
                "industry_match"=>$linkedin_score['industry_match'],
                "summary_job_grade_check"=>$linkedin_score['summary_job_grade_check'],
                "summary_industry_check"=>$linkedin_score['summary_industry_check'],
                "summary_company_check"=>$linkedin_score['summary_company_check'],
                "number_of_connections"=>$linkedin_score['number_of_connections'],
                "have_picture"=>$linkedin_score['have_picture'],
                "within_prefered_location"=>$linkedin_score['within_prefered_location'],
                "active_company"=>$linkedin_score['active_company'],
                "linkedin_company_is_equal_to_submitted_company"=>$linkedin_score['linkedin_company_is_equal_to_submitted_company'],
                "linkedin_industry_is_equal_to_submitted_industry"=>$linkedin_score['linkedin_industry_is_equal_to_submitted_industry'],
                "linkedin_years_is_equal_to_submitted_years"=>$linkedin_score['linkedin_years_is_equal_to_submitted_years'],
                "linkedin_job_grade_is_equal_to_submitted_job_grade"=>$linkedin_score['linkedin_job_grade_is_equal_to_submitted_job_grade'],
                "company_size_within_range"=>$linkedin_score['company_size_within_range'],
                "office_location_equal_to_submitted_one"=>$linkedin_score['office_location_equal_to_submitted_one'],
                "last_post_date_more_than_specified"=>$linkedin_score['last_post_date_more_than_specified'],
                "score_for_linkedin"=>$linkedin_score['score_for_linkedin'],

            ]
       ];
       return $social_analytics_data;

    }

    public function facebook_node($lender_setting,$data,$facebook,$row)
    {
        $email = false;
        $first = false;
        $last = false;
           //check if his first or last name on linkedin corresponds with what he filled in
            // - Name Comparison    
           $score_name = 0;
            //    var_dump($facebook);
            //    dd($facebook);
           $firstCheck = stripos($data['LEGAL_NAME'], $facebook['name'] );
           if($firstCheck !== false){
            $first = true;
           }
           $lastCheck = stripos($facebook['name'], $data['LEGAL_NAME'] );
           if($lastCheck !== false){
            $last = true;
           }
           if($first == true || $last == true)
           {            
                $score_name++;            
                $total_score_name = ($score_name/1) * 100;
                $analytics['facebook']['name']['isNameMatched'] = true;
                $analytics['facebook']['name']['score'] = $total_score_name;
           }
           else
           {
                $total_score_name = ($score_name/1) * 100;
                $analytics['facebook']['name']['isNameMatched'] = false;
                $analytics['facebook']['name']['score'] = $total_score_name;
           }           
           //Compare Profile Email With Social Profile Email 
           $score_email = 0;
           if(!empty($facebook['email']))
           {
                $emailCheck = stripos($data['EMAIL'], $facebook['email']);
                if($emailCheck !== false){
                $score_email++;
                $total_score_email = ($score_email/1) * 100;
                $analytics['facebook']['email']['isEmailMatched'] = true;
                $analytics['facebook']['email']['score'] = $total_score_email;

                $email = true;
                }
                else
                {
                    $total_score_email = ($score_email/1) * 100;        
                    $analytics['facebook']['email']['isEmailMatched'] = false;
                    $analytics['facebook']['email']['score'] = $total_score_email;

                    $total_score_email = ($score_email/1) * 100;
                }

           }
           else
           {
                $analytics['facebook']['email']['isEmailMatched'] = false;
                $total_score_email = ($score_email/1) * 100;
                $analytics['facebook']['email']['score'] = $total_score_email;
           }
          
            $score_picture = 0;

           if(array_key_exists('picture', $facebook) && !empty($facebook['picture']['url'])){
                $score_picture++;
                $total_score_picture = ($score_picture/1) * 100;
                $analytics['facebook']['picture']['isPictureSet'] = true;
                $analytics['facebook']['picture']['score'] = $total_score_picture; 
           }
           else{
            $total_score_picture = ($score_picture/1) * 100;
            $analytics['facebook']['picture']['isPictureSet'] = false;
            $analytics['facebook']['picture']['score'] = $total_score_picture; 
           }

    
        $reliability_score = ($total_score_name + $total_score_email + $total_score_picture)/3;
        $analytics['facebook']['reliability_score'] = $reliability_score;
      
        $total_score_reliability =  $reliability_score == 100 ? 100 : $reliability_score;
        
        $analytics['score_for_facebook'] = ($total_score_reliability + $total_score_name + $total_score_email + $total_score_picture)/4;
        return $analytics;
        
    }
    public function twitter_node($lender_setting,$data,$twitterData,$row)
    {
        $total = 0;
           //$data,$row,$linkedin,$lender_setting
           //$lender_setting = $request->input('product');
           //$PEOPLE_ID  = $request->input('PEOPLE_ID');
           //$lender_id = $request->input('lender_id');
        //    $data = $request->input('data');
        //    $twitterData = $request->input('twitter');

           //$data,$row,$twitterData,$lender_setting
        //1 ACtiveness Score
        $response['activeness']['statuses_count'] = $twitterData['statuses_count'];
        $statusCount = $twitterData['statuses_count'] > 0 ? 1 : 0;
        $response['activeness']['following'] = $twitterData['following'] == true ? true : false;
        $following = $twitterData['following'] == true ? 1 : 0;
        
        $response['activeness']['default_profile'] = $twitterData['default_profile'] == true ? true :  false;
        $default_profile = $twitterData['default_profile'] == true ? 1 : 0;

        $response['activeness']['default_profile_image'] = $twitterData['default_profile_image'] == true ? true : false;
        $default_profile_image = $twitterData['default_profile_image'] == true ? 1 : 0;
        $activeness_score = ($statusCount + $following + $default_profile + $default_profile_image) * 100/ 4 ; 
        $response['activeness']['score'] = $activeness_score;

        if($activeness_score == 100)
        {
            $total++;
        }

        //2 Reliability Score (Fullname, Verified compare)
        $response['reliability']['fullname_used'] = !empty($twitterData['name']) && count(explode(' ',$twitterData['name'])) >= 2?  true : false;
        $name_score = $response['reliability']['fullname_used'] == true ? 1 : 0;

        $response['reliability']['verified']= $twitterData['verified'] == true ? true : false;
        $verified = $twitterData['verified'] == true ? 1 : 0;

        $reliability_score = ($name_score + $verified) * 100/ 2;
        $response['reliability']['score'] =  $reliability_score ;
        if($reliability_score == 100)
        {
            $total++;
        }
        // 3- Consistency Score (Industry check)   
        
        

        //4 Fullname compare
        if(stripos($data['LEGAL_NAME'],$twitterData['name'])!==false || stripos($twitterData['name'],$data['LEGAL_NAME'])!==false)
        {
            $response['fullnamecompare'] = true;
            $total++;
        }
        else
        {
            $response['fullnamecompare'] = false;
        }
        // 5 Screen name vs name submitted
        if(stripos($data['LEGAL_NAME'],$twitterData['screen_name'])!==false || stripos($twitterData['screen_name'],$data['LEGAL_NAME'])!==false)
        {
            $response['screename_vs_names_submitted_correct'] = true;
            $total++;
        }
        else
        {
            $response['screename_vs_names_submitted_correct'] = false;
        }
        // 6 Description: Industry check
        $industry_check = DB::table('people_customers as C')->join('occupation as O','O.OCCUPATION_ID','=','C.WORK_SECTOR')->select('O.DESCRIPTION')->where('O.OCCUPATION_ID', $data['WORK_SECTOR'])->where('O.IS_TYPE',2)->get();

        if(!empty($industry_check))
        {
            $industry_check = $industry_check[0]->DESCRIPTION;
        }
        else
        {
            $industry_check = 0;
        }
        
        if(stripos( $industry_check,$twitterData['description']) !== false ||stripos( $industry_check,$twitterData['description']) !== false )
        {
            $response['description_industry_check'] = true;
            $total++;           
        }
        else
        {
            $response['description_industry_check'] = false;
        }

        // 7 Description: Company check
        $company_check = $data['COMPANY_OF_WORK_ID'];
        if(stripos($company_check,$twitterData['description']) !== false ||stripos( $company_check,$twitterData['description']) !== false )
        {
            $response['description_company_check'] = true;
            $total++;           
        }
        else
        {
            $response['description_company_check'] = false;
        }

        // 8 Followers Count >x
        if($twitterData['followers_count'] > $lender_setting['FOLLOWERS_COUNT_ALLOWED'])
        {
            $response['followers_count_more_than_specified'] = true;
            $total++;
        }
        else
        {
            $response['followers_count_more_than_specified'] = false;
        }
        // 9 Following > x
        if($twitterData['following'] > $lender_setting['FOLLOWING_COUNT_ALLOWED'])
        {
            $response['following_count_more_than_specified'] = true;
            $total++;
        }
        else
        {
            $response['following_count_more_than_specified'] = false;
        }
        //10 Followers/Following Ratio > x
        $ratio = is_int($twitterData['followers_count'])&& is_int($twitterData['following']) ? ($twitterData['followers_count']/$twitterData['following']) : 0;
        if($ratio > $lender_setting['FOLLOWERS_TO_FOLLOWING_RATIO_ALLOWED'])
        {
            $response['followers_to_following_ratio_more_than_specified'] = true;
            $total++;
        }
        else
        {
            $response['followers_to_following_ratio_more_than_specified'] = false;
        }
        // 11 Is verified?
        
        if($twitterData['verified'] != false)
        {
            $response['is_verified'] = true;
            $total++;
        }
        else
        {
            $response['is_verified'] = false;
        }
         // 12 Has Pix?
        
         if($twitterData['profile_background_image_url'] != false || empty($twitterData['profile_background_image_url'] )&& $twitterData['profile_image_url'] != false || empty($twitterData['profile_image_url']))
         {
             $response['has_pix'] = true;
             $total++;
         }
         else
         {
             $response['has_pix'] = false;
         }
         //13 favorite_count>x
         if(!empty($twitterData['status']['favorite_count']))
         {
            if($twitterData['status']['favorite_count'] > $lender_setting['FAVOURITE_COUNT_ALLOWED'])
            {
                $response['favorite_count_more_than_specified'] = true;
                $total++;
            }
            else
            {
                $response['favorite_count_more_than_specified'] = false;
            }
         }
         else
         {
            $response['favorite_count_more_than_specified'] = false;
         }
        
        //14  - Status_count>x
        if($twitterData['statuses_count'] > $lender_setting['STATUSES_COUNT_ALLOWED'])
        {
            $response['statuses_count_more_than_specified'] = true;
            $total++;
        }
        else
        {
            $response['statuses_count_more_than_specified'] = false;
        }
        //15sysdate-Created_at > than x days
        if($twitterData['created_at'] > $lender_setting['CREATED_AT_ALLOWED'])
        {
            $response['created_at_more_than_specified'] = true;
            $total++;
        }
        else
        {
            $response['created_at_more_than_specified'] = false;
        }
        
        //i have 3 left so 15-3 =12
        $response['score_for_twitter'] = ($total/15) * 100;//should be 15 not 12

        return $response;
    }
    public function linkedin_node($lender_setting,$data,$linkedin,$row)
    {
        $total = 0;
        $response['within_prefered_location'] = false;
        //$data,$row,$linkedin,$lender_setting
        // $lender_setting = $request->input('product');
        // //$PEOPLE_ID  = $request->input('PEOPLE_ID');
        // //$lender_id = $request->input('lender_id');
        // $data = $request->input('data');
        // $linkedin = $request->input('linkedin');
        //$facebook = $request->input('facebook'); 
        //1 Activeness Score  (1. calculated by checking if there is a recent post and 2. if he recently changed companies within last 6 months)
        $activeness_score = 0;
        $response['activeness']['recent_post_available'] = !empty($linkedin['currentShare']['comment']) ? true : false;
        // $recent_post = $response['activeness']['recent_post_available'] == true ? 1 : 0;
        if($response['activeness']['recent_post_available'])
        {
            $activeness_score++;
        }

        if(!empty($linkedin['positions']['values']) && count($linkedin['positions']['values']) > 1)
        {
          
            foreach($linkedin['positions']['values'] as $value)
            {
              if($linkedin['positions']['values'][0]['company']['name'] !== $linkedin['positions']['values'][1]['company']['name'])
              {
                    $month_year[] = '01'.'-'.$value['startDate']['month'].'-'.$value['startDate']['year'];
                    
              }  
              else
              {
                $response['activeness']['changed_companies_within_six_months'] = false;
                break;
              }
              
              
            }
        }
        else
        {
            $response['activeness']['changed_companies_within_six_months'] = false;
        }

        if(!empty($month_year))
        {
            $month_year_diff = date_diff(date_create($month_year[0]), date_create($month_year[1]));
            if($month_year_diff->m <= 6)
            {
                $response['activeness']['changed_companies_within_six_months'] = true;
                $activeness_score++;
            }

        }


        $activeness_score = ($activeness_score) * 100/ 2 ; 
        $response['activeness']['score'] = $activeness_score;

        if($activeness_score == 100)
        {
            $total++;
        }


       
        $consistency_score = 0;
        $reliability_score=0;

        // 4  - Fullname compare
        if(stripos($data['LEGAL_NAME'],"{$linkedin['firstName']} {$linkedin['lastName']}") !== false || stripos("{$linkedin['firstName']} {$linkedin['lastName']}",$data['LEGAL_NAME']) !== false || stripos("{$linkedin['lastName']} {$linkedin['firstName']}",$data['LEGAL_NAME']) !== false || stripos($data['LEGAL_NAME'],"{$linkedin['lastName']} {$linkedin['firstName']}") !== false)
        {
            $response['full_name_compare'] = true;
            $total++;
            $reliability_score++;
        }
        else
        {
            $response['full_name_compare'] = false;
        }

        // 5  - Email addy compare
        if($data['EMAIL'] == $linkedin['emailAddress'])
        {
            $response['email_compare'] = true;
            $total++;
            $consistency_score++;
        }
        else
        {
            $response['email_compare'] = false;
        }

        // dd(DB::table('people_customers as C')->join('occupation as O','O.OCCUPATION_ID','=','C.OCCUPATION_ID')->select('O.DESCRIPTION')->where('C.OCCUPATION_ID', $data['WORK_DESIGNATION'])->get());

        // 6- Headline: Job grade check     
        // var_dump( DB::table('people_customers as C')->join('occupation as O','O.OCCUPATION_ID','=','C.WORK_DESIGNATION')->select('O.DESCRIPTION')->where('O.OCCUPATION_ID', $data['WORK_DESIGNATION'])->get()) ;

        $job_grade = DB::table('people_customers as C')->join('occupation as O','O.OCCUPATION_ID','=','C.WORK_DESIGNATION')->select('O.DESCRIPTION')->where('O.OCCUPATION_ID', $data['WORK_DESIGNATION'])->where('O.IS_TYPE',4)->get();

        if(!empty($job_grade))
        {
            $job_grade = $job_grade[0]->DESCRIPTION;
        }
        else
        {
            $job_grade = 0;
        }

        //dd($job_grade );
        //$response['job_grade'] = $job_grade;
        
        if(stripos( $job_grade,$linkedin['headline']) !== false ||stripos($job_grade,$linkedin['headline']) !== false )
        {
            $response['job_grade_check'] = true;
            $total++;
            $reliability_score++;
            
        }
        else
        {
            $response['job_grade_check'] = false;
        }
        
        // 7 - Headline: Industry check
        // dd(DB::table('people_customers as C')->join('occupation as O','O.OCCUPATION_ID','=','C.WORK_SECTOR')->select('O.DESCRIPTION')->where('C.OCCUPATION_ID', $data['WORK_SECTOR'])->get());
        $industry_check = DB::table('people_customers as C')->join('occupation as O','O.OCCUPATION_ID','=','C.WORK_SECTOR')->select('O.DESCRIPTION')->where('O.OCCUPATION_ID', $data['WORK_SECTOR'])->where('O.IS_TYPE',2)->get();

        if(!empty($industry_check))
        {
            $industry_check = $industry_check[0]->DESCRIPTION;
        }
        else
        {
            $industry_check = 0;
        }
        // var_dump(DB::table('people_customers as C')->join('occupation as O','O.OCCUPATION_ID','=','C.WORK_SECTOR')->select('O.DESCRIPTION')->where('O.OCCUPATION_ID', $data['WORK_SECTOR'])->get());
        // die();

        if(stripos( $industry_check,$linkedin['industry']) !== false ||stripos( $industry_check,$linkedin['industry']) !== false )
        {
            $response['industry_check'] = true;
            $total++;
            
        }
        else
        {
            $response['industry_check'] = false;
        }

        /// 8 - Headline: Company check
        // $company_check = DB::table('people_customers as C')->join('occupation as O','O.OCCUPATION_ID','=','C.OCCUPATION_ID')->select('O.DESCRIPTION')->where('C.OCCUPATION_ID', $data['COMPANY_OF_WORK_ID'])->get()[0]->DESCRIPTION;
        $company_check = $data['COMPANY_OF_WORK_ID'];


        if(stripos($company_check,$linkedin['industry']) !== false ||stripos( $company_check,$linkedin['industry']) !== false )
        {
            $response['company_check'] = true;
            $total++;
        }
        else
        {
            $response['company_check'] = false;
        }


        // 9   - Industry: Does industry match?
        if($industry_check == $linkedin['industry'])
        {
            $response['industry_match'] = true;
            $total++;
            $reliability_score++;
        }
        else
        {
            $response['industry_match'] = false;
        }

        //10 - Summary: Job grade check
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                //var_dump($value['summary']);
                if(!empty($value['summary']))
                {
                    if(stripos($value['summary'],$job_grade))
                    {
                        $response['summary_job_grade_check'] = true;
                        $total++;
                        break;
                    }
                    else
                    {
                        $response['summary_job_grade_check'] = false;
                    }
                }
                else
                {
                    $response['summary_job_grade_check'] = false;
                }
                
            }
        }
        else
        {
            $response['summary_job_grade_check'] = false;
        }
       
        //  11 - Summary: Industry check
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if(!empty($value['summary']))
                {
                    if(stripos($value['summary'], $industry_check))
                    {
                        $response['summary_industry_check'] = true;
                        $total++;
                        break;
                    }
                    else
                    {
                        $response['summary_industry_check'] = false;
                    }
                }
                else
                {
                     $response['summary_industry_check'] = false;
                    
                }
               
            }
    
        }
        else
        {
            $response['summary_industry_check'] = false;
        }
       

        //12 - Summary: Company check
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if(!empty($value['summary']))
                {
                    if(stripos($value['summary'], $company_check))
                    {
                        $response['summary_company_check'] = true;
                        $total++;
                        break;
                    }
                    else
                    {
                        $response['summary_company_check'] = false;
                    }
                }
                else
                {
                    $response['summary_company_check'] = false;
                }
               
            }
        }
        else
        {
            $response['summary_company_check'] = false;
        }
       

        //13  - Connection > x
        if($linkedin['numConnections'] > $lender_setting['ALLOWED_CONNECTIONS'])
        {
            $response['number_of_connections'] = true;
            $total++;
        }
        else
        {
            $response['number_of_connections'] = false;
        }


        //14 - Has Pix?
        if(!empty($linkedin['pictureUrl']))
        {
            $response['have_picture'] = true;
            $total++;
        }
        else
        {
            $response['have_picture'] = false;
        }

        //15 - Location State within prefered location
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if($response['within_prefered_location'] = true)
                {
                   break;
                }
                if(!empty($value['location']['name']))
                {
                    foreach($lender_setting['PREFERED_LOCATION_STATE'] as $prefered_state)
                    {
                        //$lender_setting['PREFERED_LOCATION_STATE']
                        if((stripos($value['location']['name'], $prefered_state) || stripos($prefered_state,$value['location']['name'])) && $value['isCurrent'] == true)
                        {
                            $response['within_prefered_location'] = true;
                            $total++;   
                            $consistency_score++;
                            break;
                        }
                        else
                        {
                            $response['within_prefered_location'] = false;
                        }
                    }
                   
                }
                else
                {
                    $response['within_prefered_location'] = false;
                }
               
            }
        }
        else
        {
            $response['within_prefered_location'] = false;
        }

        //16 - Has active company?
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if(!empty( $value['isCurrent']))
                {
                    if($value['isCurrent'] == true)
                    {
                        $response['active_company'] = true;
                        $total++;
                        break;
                    }
                    else
                    {
                        $response['active_company'] = false;
                    }
                   
                }
                else
                {
                    $response['active_company'] = false;
                }
            }
        }
        else
        {
            $response['active_company'] = false;
        }


        //17 - Check company: Company =submitted company?
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if(!empty($value['company']['name']))
                {
                    if($value['company']['name'] == $company_check)
                    {
                        $response['linkedin_company_is_equal_to_submitted_company'] = true;
                        $total++;
                        $reliability_score++;
                        break;
                    }
                    else
                    {
                        $response['linkedin_company_is_equal_to_submitted_company'] = false;
                    }
                   
                } 
                else
                {
                    $response['linkedin_company_is_equal_to_submitted_company'] = false;
                }
            }
        }
        else
        {
            $response['linkedin_company_is_equal_to_submitted_company'] = false;
        }

        //18- Check company: Industry=submitted industry
        if($industry_check == $linkedin['industry'])
        {
            $response['linkedin_industry_is_equal_to_submitted_industry'] = true;
            $total++;
        }
        else
        {
            $response['linkedin_industry_is_equal_to_submitted_industry'] = false;
        }


        //19- Check company: # years= #years
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if(!empty($value['startDate']['year']))
                {
                    if($linkedin['positions']['values'][0] && $value['startDate']['year'] == $data['WORK_END_DATE'])
                    {
                        $response['linkedin_years_is_equal_to_submitted_years'] = true;
                        $total++;
                        $consistency_score++;
                        break;
                    }
                    else
                    {
                        $response['linkedin_years_is_equal_to_submitted_years'] = false;
                    }
                   
                } 
                else
                {
                    $response['linkedin_years_is_equal_to_submitted_years'] = false;
                }
            }
        }
        else
        {
            $response['linkedin_years_is_equal_to_submitted_years'] = false;
        }


        //20- Check company: Job grade=submitted job grade
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if(!empty($value['title']))
                {
                    if(stripos($value['title'],$job_grade) !== false || stripos($job_grade,$value['title']) !== false)
                    {
                        $response['linkedin_job_grade_is_equal_to_submitted_job_grade'] = true;
                        $total++;
                        break;
                    }
                    else
                    {
                        $response['linkedin_job_grade_is_equal_to_submitted_job_grade'] = false;
                    }
                   
                } 
                else
                {
                    $response['linkedin_job_grade_is_equal_to_submitted_job_grade'] = false;
                }
            }
        }
        else
        {
            $response['linkedin_job_grade_is_equal_to_submitted_job_grade'] = false;
        }


        // 21 - Check company: Company size within range?
     
        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if(!empty($value['company']['size']))
                {
                    $exploded_size = explode('-',$value['company']['size']);
                    if($exploded_size[0] >= $lender_setting['MIN_RANGE'] && $exploded_size[1] <= $lender_setting['MAX_RANGE'] )
                    {
                        $response['company_size_within_range'] = true;
                        $total++;
                        $reliability_score++;
                        break;
                    }
                    else
                    {
                        $response['company_size_within_range'] = false;
                    }
                   
                } 
                else
                {
                    $response['company_size_within_range'] = false;
                }
            }
        }
        else
        {
            $response['company_size_within_range'] = false;
        }

        //22 - Check company: Office location = comparible submitted location

        if(!empty($linkedin['positions']['values']))
        {
            foreach($linkedin['positions']['values'] as $value)
            {
                if(!empty($value['location']['name']))
                {
                    if(stripos($value['location']['name'], $data['WORK_ADDRESS']) !== false || stripos($data['WORK_ADDRESS'], $value['location']['name']) !== false)
                    {
                        $response['office_location_equal_to_submitted_one'] = true;
                        $total++;
                        break;
                    }
                    else
                    {
                        $response['office_location_equal_to_submitted_one'] = false; 
                    }
                   
                } 
                else
                {
                    $response['office_location_equal_to_submitted_one'] = false;
                }
            }
        }
        else
        {
            $response['office_location_equal_to_submitted_one'] = false;
        }

        // /23 - Last post date >x 
        if(!empty($linkedin['currentShare']['timestamp']))
        {
            $last_post_date = $linkedin['currentShare']['timestamp'];
           if(date('F',$last_post_date/1000) > $lender_setting['LAST_POST_DATE_ALLOWED'])
           {
                $response['last_post_date_more_than_specified'] = true;
                $total++;
           
           }
           else
           {
            $response['last_post_date_more_than_specified'] = false;
           }
        }
        else
        {
            $response['last_post_date_more_than_specified'] = false;
        }
        // ///3 - Consistency Score  (email, location of office, #years)
        $total_consistency_score =( $consistency_score/3) * 100;
        $response['consistency_score'] = $total_consistency_score;
        if($total_consistency_score == 100)
        {
            $total++;
        }
        // 2 Reliability Score  (Fullname, job grade, industry, company, office size check)
        $total_reliability_score = ($reliability_score/5) * 100;
        $response['reliability_score'] = $total_reliability_score;
        if($total_reliability_score == 100)
        {
            $total++;
        }
        $response['score_for_linkedin'] = ($total/23) * 100;    
        return $response;

    }
}
