<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


use App\Http\Requests;

class RepaymentsController extends Controller
{
    public function determineRepaymentsEligibility($leafIds,$PEOPLE_ID="",$lender_id="",$data,$row="",$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid,$timesLate,$default_loan,$lateonfirstperiod=0,$lateonsecondperiod=0,$lateonotherperiod=0)
	{		
        //$leafIds,$PEOPLE_ID="",$lender_id="",$data,$row="",$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid
		$grades = [];
		$newGrade = [];
        
        // $leafIds = $request->input('leafIds');
        // $row = $request->input('row');
        // $PEOPLE_ID  = $request->input('PEOPLE_ID');
        // $lender_id = $request->input('lender_id');
        // $data = $request->input('data');
        // $accounts_phone = $request->input('accounts_phone');
        // $accounts_email = $request->input('accounts_email');
        // $product = $request->input('product');
        // $loans_nol12 = $request->input('loans_nol12');
        // $loans_nol1 = $request->input('loans_nol1');
        // $lender = $request->input('lender');
        // $allrepaymentCreditClanLoans = $request->input('allrepaymentCreditClanLoans');
        // $loans = $request->input('loans');
        // $accounts = $request->input('accounts');
        // $allrepaymentLoans = $request->input('allrepaymentLoans');
        // $total_lateness = $request->input('total_lateness');
        // $total_schedules = $request->input('total_schedules');
        // $max_lateness = $request->input('max_lateness');
        // $loans_nol = $request->input('loans_nol');
        // $loans_id = $request->input('loans_id');
		// $max_date_paid = $request->input('max_date_paid');
	
		$leaves = [
			
			'Maximum_lateness_less_than_5_days'=>1,

			'Maximum_lateness_less_than_15_days'=>2,
			'Maximum_lateness_less_than_30_days'=>3,
			'Maximum_lateness_less_than_60_days'=>4,
			'Maximum_lateness_less_than_90_days'=>5,

			'times_late_less_than_1'=>6,
			'times_late_less_than_2'=>7,

			'times_late_less_than_5'=>8,
			'times_late_less_than_20'=>9,

			'First_lateness_period_on_last_lateness_less_than_thirty_days'=>10,
			'First_lateness_period_less_than_sixty_days'=>11,
			'First_lateness_period_less_than_ninety_days'=>12,
			//'Total_default_amount_less_than_zero'=>18,
			'Default_loan_less_than_zero'=>13,
			'Times_repaid_early_more_than_one'=>14,
			'Times_repaid_early_more_than_three'=>15,
			
			'Times_repaid_early_more_than_five'=>16,
			'Ever_received_higher_principal'=>17,
			'Ever_received_heigher_tenure'=>18,
			'Ever_received_higher_interest_rate'=>19,
		];
		
		$runEligibiltyData = $this-> runRepaymentsEligibilty($leafIds,$leaves,$PEOPLE_ID,$lender_id,$data,$row,$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid,$timesLate,$default_loan,$lateonfirstperiod,$lateonsecondperiod,$lateonotherperiod);
		//return $runEligibiltyData;
		//dd($leafIds);
		 //dd($runEligibiltyData);
	
		foreach($leafIds as $key=>$leafId)
		{
			$grades[$leafId] = $runEligibiltyData["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}

		$eligibility_data = [];
		$eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
		$eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible"; 
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
    }
	
    public function runRepaymentsEligibilty($leafIds,$leaves,$PEOPLE_ID,$lender_id,$data,$row,$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid,$timesLate,$default_loan,$lateonfirstperiod,$lateonsecondperiod,$lateonotherperiod)
    {
	
        $total= 0;
        $leaves_grade = [];
        $avg_lateness = 0;
        $received_higher = false;
        $received_higher_duration =false;
        $received_higher_rate = false;

        if($total_lateness > 0)
        {
			$avg_lateness = $total_lateness/$total_schedules;
        } 
        // $internal_repayments = $this->analyseCreditClanRepayments($PEOPLE_ID,$lender_id,$data,$row,$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid = 0);

        // $external_repayments = $this->analyseExternalRepayments($PEOPLE_ID,$lender_id,$data,$row,$accounts_email,$accounts_phone, $loans_nol1,$loans_nol12,$loans,$max_lateness,$allrepaymentLoans);

        if(in_array($leaves['Maximum_lateness_less_than_5_days'],$leafIds))
		{
            if($max_date_paid <= 5)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
            
        }
        if(in_array($leaves['Maximum_lateness_less_than_15_days'],$leafIds))
		{
            if($max_date_paid <= 15)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
        }
        if(in_array($leaves['Maximum_lateness_less_than_30_days'],$leafIds))
		{
            if($max_date_paid <= 30)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
        }
        if(in_array($leaves['Maximum_lateness_less_than_60_days'],$leafIds))
		{
            if($max_date_paid <= 60)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
        }
        if(in_array($leaves['Maximum_lateness_less_than_90_days'],$leafIds))
		{
            if($max_date_paid <= 90)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
        }
        // $timesLate = DB::select("select * from repayment_schedule as a join loan_request as b on a.request_id=b.request_id
        // where a.lender_id=111 and a.people_id=6666 and a.date_paid > a.repayment_date and b.booked=1");
        //$timesLate = count($timesLate);

        if(in_array($leaves['times_late_less_than_1'],$leafIds))
		{   
            $times_late_less_than_1 =  $timesLate < 1 ? "true":"false";
            if($times_late_less_than_1 == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        }
        if(in_array($leaves['times_late_less_than_2'],$leafIds))
		{
            $times_late_less_than_2 =  $timesLate < 2 ? "true":"false";
            if($times_late_less_than_2 == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        }
        if(in_array($leaves['times_late_less_than_5'],$leafIds))
		{
            $times_late_less_than_5 =  $timesLate < 5 ? "true":"false";
            if($times_late_less_than_5 == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        }
        if(in_array($leaves['times_late_less_than_20'],$leafIds))
		{
            $times_late_less_than_20 =  $timesLate < 20 ? "true":"false";
            if($times_late_less_than_20 == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        }
       
        if(in_array($leaves['First_lateness_period_on_last_lateness_less_than_thirty_days'],$leafIds))
		{
            if($lateonfirstperiod > 0)
            {
                $total++;  $leaves_grade [] = "failed";
            }
            else
            {
                $leaves_grade [] = "passed";
			}
        } 
        if(in_array($leaves['First_lateness_period_less_than_sixty_days'],$leafIds))
		{
            if($lateonsecondperiod > 0)
            {
                $total++;  $leaves_grade [] = "failed";
            }
            else
            {
                $leaves_grade [] = "passed";
			}
        }
        if(in_array($leaves['First_lateness_period_less_than_ninety_days'],$leafIds))
		{
            if($lateonotherperiod > 0)
            {
                $total++;  $leaves_grade [] = "failed";
            }
            else
            {
                $leaves_grade [] = "passed";
			}
        }
        // if(in_array($leaves['Total_default_amount_more_than_zero'],$leafIds))
		// {
            
        // }
        
        if(in_array($leaves['Default_loan_less_than_zero'],$leafIds))
		{
            // $default_loan = DB::select('select a.request_id,max(repayment_date),max(date_paid) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id
            // where a.LENDER_ID=11606 and b.BOOKED=1
            // group by a.request_id
            // having max(date_paid) > max(repayment_date)');
            //$default_loan = count($default_loan);
            if($default_loan < 0 )
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
			}

        }

        $times_early = DB::select("select * from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where  a.people_id=$PEOPLE_ID and date(a.date_paid) < date(a.repayment_date) and b.booked=1 and a.date_paid is NOT NULL");
		
        if(in_array($leaves['Times_repaid_early_more_than_one'],$leafIds))
		{
            if($times_early <= 3)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
			}
        }
        if(in_array($leaves['Times_repaid_early_more_than_three'],$leafIds))
		{
            if($times_early  <= 5)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
			}
        }
        if(in_array($leaves['Times_repaid_early_more_than_five'],$leafIds))
		{
            if($times_early > 5)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
			}
        } 
		 
        if(in_array($leaves['Ever_received_higher_principal'],$leafIds))
		{
            if(!empty($loans_id)){
                $amount = $loans_id[0]['REQUEST_PRINCIPAL'];  
                foreach($loans_id as $loan){
                    if($loan['REQUEST_PRINCIPAL'] > $amount){
                        $received_higher = true;
                        $amount = $loan['REQUEST_PRINCIPAL'];
                        continue;
                    }
                    
                    if($loan['REQUEST_PRINCIPAL'] < $amount){
                        $received_lower = true;
                        $amount = $loan['REQUEST_PRINCIPAL'];
                        continue;
                    }
                    
                }
            }
            	
            if($received_higher)
            {	
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }

        }
        if(in_array($leaves['Ever_received_heigher_tenure'],$leafIds))
		{
            if(!empty($loans_id)){ 
                $duration = $loans_id[0]['REQUEST_TENOR_IN_DAYS']; 
                foreach($loans_id as $loan){
                    if($loan['REQUEST_TENOR_IN_DAYS'] > $duration){
                        $received_higher_duration = true;
                        $duration = $loan['REQUEST_TENOR_IN_DAYS'];
                        continue;
                    }
                    
                    if($loan['REQUEST_TENOR_IN_DAYS'] < $duration){
                        $received_lower_duration = true;
                        $duration = $loan['REQUEST_TENOR_IN_DAYS'];
                        continue;
                    }
                    
                }
            }
            if($received_higher_duration)
            {
               
                $total++;  $leaves_grade [] = "passed";
                
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        }
        if(in_array($leaves['Ever_received_higher_interest_rate'],$leafIds))
		{
            if(!empty($loans_id)){  
                $interest = $loans_id[0]['REQUEST_RATE'];
                foreach($loans_id as $loan){
                    if($loan['REQUEST_RATE'] > $interest){
                        $received_higher_rate = true;
                        $interest = $loan['REQUEST_RATE'];
                        continue;
                    }
                    
                    if($loan['REQUEST_RATE'] < $interest){
                        $received_lower_rate = true;
                        $interest = $loan['REQUEST_RATE'];
                        continue;
                    }
                    
                }
            }

            	
            if($received_higher_rate)
            {
                $total++;  $leaves_grade [] = "passed";     
            }
            else
            {
                $leaves_grade [] = "failed";
            }

        }
        $result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;
    
    }

	public function determineRepaymentsAnalytics($leafIds,$PEOPLE_ID="",$lender_id="",$data,$row="",$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid,$timesLate,$default_loan,$lateonfirstperiod=0,$lateonsecondperiod=0,$lateonotherperiod=0)
	{		
    	//$leafIds,$PEOPLE_ID="",$lender_id="",$data,$row="",$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid
		$grades = [];
		$newGrade = [];
        
	
		$leaves = [
			
			'Maximum_lateness_less_than_5_days'=>1,

			'Maximum_lateness_less_than_15_days'=>2,
			'Maximum_lateness_less_than_30_days'=>3,
			'Maximum_lateness_less_than_60_days'=>4,
			'Maximum_lateness_less_than_90_days'=>5,

			'times_late_less_than_1'=>6,
			'times_late_less_than_2'=>7,

			'times_late_less_than_5'=>8,
			'times_late_less_than_20'=>9,

			'First_lateness_period_on_last_lateness_less_than_thirty_days'=>10,
			'First_lateness_period_less_than_sixty_days'=>11,
			'First_lateness_period_less_than_ninety_days'=>12,
			//'Total_default_amount_less_than_zero'=>18,
			'Default_loan_less_than_zero'=>13,
			'Times_repaid_early_more_than_one'=>14,
			'Times_repaid_early_more_than_three'=>15,
			
			'Times_repaid_early_more_than_five'=>16,
			'Ever_received_higher_principal'=>17,
			'Ever_received_heigher_tenure'=>18,
			'Ever_received_higher_interest_rate'=>19,
		];
		$leaves = array_values($leaves);
		$runEligibiltyData = $this-> runRepaymentsAnalytics($leafIds,$leaves,$PEOPLE_ID,$lender_id,$data,$row,$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid,$timesLate,$default_loan,$lateonfirstperiod,$lateonsecondperiod,$lateonotherperiod);
		//return $runEligibiltyData;
		//dd($leafIds);
		 //dd($runEligibiltyData);
	
		foreach($leaves as $key=>$leafId)
		{
			$grades[$leafId] = $runEligibiltyData["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}

		$eligibility_data = [];
		// $eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
		// $eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible"; 
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
    }
	public function runRepaymentsAnalytics($leafIds,$leaves,$PEOPLE_ID,$lender_id,$data,$row,$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid,$timesLate,$default_loan,$lateonfirstperiod,$lateonsecondperiod,$lateonotherperiod)
    {
        $total= 0;
        $leaves_grade = [];
        $avg_lateness = 0;
        $received_higher = false;
        $received_higher_duration =false;
        $received_higher_rate = false;

        if($total_lateness > 0 && $total_schedules >0)
        {
			$avg_lateness = $total_lateness/$total_schedules;
        } 
        // $internal_repayments = $this->analyseCreditClanRepayments($PEOPLE_ID,$lender_id,$data,$row,$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid = 0);

        // $external_repayments = $this->analyseExternalRepayments($PEOPLE_ID,$lender_id,$data,$row,$accounts_email,$accounts_phone, $loans_nol1,$loans_nol12,$loans,$max_lateness,$allrepaymentLoans);

            if($max_date_paid <= 5)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
      
     
            if($max_date_paid <= 15)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
   
    
            if($max_date_paid <= 30)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
        
      
            if($max_date_paid <= 60)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
     
       
            if($max_date_paid <= 90)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
				$leaves_grade [] = "failed";
            }
          // $timesLate = DB::select("select * from repayment_schedule as a join loan_request as b on a.request_id=b.request_id
        // where a.lender_id=111 and a.people_id=6666 and a.date_paid > a.repayment_date and b.booked=1");
        //$timesLate = count($timesLate);

         
            $times_late_less_than_1 =  $timesLate < 1 ? "true":"false";
            if($times_late_less_than_1 == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
      
       
            $times_late_less_than_2 =  $timesLate < 2 ? "true":"false";
            if($times_late_less_than_2 == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
      
       
            $times_late_less_than_5 =  $timesLate < 5 ? "true":"false";
            if($times_late_less_than_5 == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
            $times_late_less_than_20 =  $timesLate < 20 ? "true":"false";
            if($times_late_less_than_20 == "true")
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
       
       
       
            if($lateonfirstperiod > 0)
            {
                $total++;  $leaves_grade [] = "failed";
            }
            else
            {
                $leaves_grade [] = "passed";
			}
       
      
            if($lateonsecondperiod > 0)
            {
                $total++;  $leaves_grade [] = "failed";
            }
            else
            {
                $leaves_grade [] = "passed";
			}
       
       
            if($lateonotherperiod > 0)
            {
                $total++;  $leaves_grade [] = "failed";
            }
            else
            {
                $leaves_grade [] = "passed";
			}
        
        // if(in_array($leaves['Total_default_amount_more_than_zero'],$leafIds))
		// {
            
        // }
        
       
            // $default_loan = DB::select('select a.request_id,max(repayment_date),max(date_paid) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id
            // where a.LENDER_ID=11606 and b.BOOKED=1
            // group by a.request_id
            // having max(date_paid) > max(repayment_date)');
            //$default_loan = count($default_loan);
            if($default_loan < 0 )
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
			}

      

        $times_early = DB::select("select * from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where  a.people_id=$PEOPLE_ID and date(a.date_paid) < date(a.repayment_date) and b.booked=1 and a.date_paid is NOT NULL");
		$times_early = count($times_early);

        if($times_early  <= 3)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
			}
     
      
            if($times_early <= 5)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
			}
       
      
            if($times_early > 5)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
			}
       
      
            if(!empty($loans_id)){
                $amount = $loans_id[0]['REQUEST_PRINCIPAL'];  
                foreach($loans_id as $loan){
                    if($loan['REQUEST_PRINCIPAL'] > $amount){
                        $received_higher = true;
                        $amount = $loan['REQUEST_PRINCIPAL'];
                        continue;
                    }
                    
                    if($loan['REQUEST_PRINCIPAL'] < $amount){
                        $received_lower = true;
                        $amount = $loan['REQUEST_PRINCIPAL'];
                        continue;
                    }
                    
                }
            }
            	
            if($received_higher)
            {	
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                $leaves_grade [] = "failed";
            }
       
            if(!empty($loans_id)){ 
                $duration = $loans_id[0]['REQUEST_TENOR_IN_DAYS']; 
                foreach($loans_id as $loan){
                    if($loan['REQUEST_TENOR_IN_DAYS'] > $duration){
                        $received_higher_duration = true;
                        $duration = $loan['REQUEST_TENOR_IN_DAYS'];
                        continue;
                    }
                    
                    if($loan['REQUEST_TENOR_IN_DAYS'] < $duration){
                        $received_lower_duration = true;
                        $duration = $loan['REQUEST_TENOR_IN_DAYS'];
                        continue;
                    }
                    
                }
            }
            if($received_higher_duration)
            {
               
                $total++;  $leaves_grade [] = "passed";
                
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
      
            if(!empty($loans_id)){  
                $interest = $loans_id[0]['REQUEST_RATE'];
                foreach($loans_id as $loan){
                    if($loan['REQUEST_RATE'] > $interest){
                        $received_higher_rate = true;
                        $interest = $loan['REQUEST_RATE'];
                        continue;
                    }
                    
                    if($loan['REQUEST_RATE'] < $interest){
                        $received_lower_rate = true;
                        $interest = $loan['REQUEST_RATE'];
                        continue;
                    }
                    
                }
			}
			        	
            if($received_higher_rate)
            {
                $total++;  $leaves_grade [] = "passed";     
            }
            else
            {
                $leaves_grade [] = "failed";
            }

      
        $result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;
    
    }
    public function analyseRepayments(Request $request)
    {
        $row = $request->input('row');
        $PEOPLE_ID  = $request->input('PEOPLE_ID');
        $lender_id = $request->input('lender_id');
        $data = $request->input('data');
        $accounts_phone = $request->input('accounts_phone');
        $accounts_email = $request->input('accounts_email');
        $product = $request->input('product');
        $loans_nol12 = $request->input('loans_nol12');
        $loans_nol1 = $request->input('loans_nol1');
        $lender = $request->input('lender');
        $allrepaymentCreditClanLoans = $request->input('allrepaymentCreditClanLoans');
        $loans = $request->input('loans');
        $accounts = $request->input('accounts');
        $allrepaymentLoans = $request->input('allrepaymentLoans');
        $total_lateness = $request->input('total_lateness');
        $total_schedules = $request->input('total_schedules');
        $max_lateness = $request->input('max_lateness');
		
        $loans_nol = $request->input('loans_nol');
        $loans_id = $request->input('loans_id');
		$max_date_paid = $request->input('max_date_paid');

        $total_for_repayments = 0;

        $internal_score = $this->analyseCreditClanRepayments($PEOPLE_ID,$lender_id,$data,$row,$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid);

        $external_score = $this->analyseExternalRepayments($PEOPLE_ID,$lender_id,$data,$row,$accounts_email,$accounts_phone, $loans_nol1,$loans_nol12,$loans,$max_lateness,$allrepaymentLoans);

		if($internal_score['internal_repayments']['score'] >= $row["GENERAL_PASS_PERCENTAGE"]){
			$total_for_repayments+=$row["INTERNAL_REPAYMENTS_ANALYTICS"];
		}else{
			$total_for_repayments-=$row["INTERNAL_REPAYMENTS_ANALYTICS_NEGATIVE"];
		}

		if($external_score['external_repayments']['score'] >= $row["GENERAL_PASS_PERCENTAGE"]){
			$total_for_repayments+=$row["EXTERNAL_REPAYMENTS_ANALYTICS"];
		}else{
			$total_for_repayments-=$row["EXTERNAL_REPAYMENTS_ANALYTICS_NEGATIVE"];
        }
        $total_denominator_for_repayments=$row["INTERNAL_REPAYMENTS_ANALYTICS"]+$row["EXTERNAL_REPAYMENTS_ANALYTICS"];

		$no_of_times_borrowed = $loans_nol['nol'] > 1 ?  [
		"not_a_first_time_borrower"=>$internal_score['internal_repayments']['not_a_first_time_borrower'],
		"borrowed_once"=>$internal_score['internal_repayments']['borrowed_once'],
		"borrowed_twice"=>$internal_score['internal_repayments']['borrowed_twice'],
		"borrowed_five"=>$internal_score['internal_repayments']['borrowed_five'],
		"borrowed_ten"=>$internal_score['internal_repayments']['borrowed_ten'],
		] : $internal_score['internal_repayments']['borrowed_before'];

        $lateness_of_payment =  $max_date_paid > 0 ? [
            "lateness_of_payment_btw_1-5_days"=>$internal_score['internal_repayments']
            ['lateness_of_payment_btw_1-5_days'],
            "lateness_of_payment_btw_6-15_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_6-15_days'],
            "lateness_of_payment_btw_16-30_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_16-30_days'],
            "lateness_of_payment_btw_31-60_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_31-60_days'],
            "lateness_of_payment_btw_61-90_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_61-90_days'],
        ] : $internal_score['internal_repayments']['lateness_of_payment'] ;
        $customer_repayments_score = $total_for_repayments <= 0 ? 0 : ($total_for_repayments/$total_denominator_for_repayments)*100;
        $lateness = $total_lateness > 0 ?
        (["average_lateness_of_payment_btw_0-30_days"=>$internal_score['internal_repayments'][' average_lateness_of_payment_btw_0-30_days'],
        "average_lateness_of_payment_btw_30-60_days"=>$internal_score['internal_repayments']['average_lateness_of_payment_btw_30-60_days'],
        "average_lateness_of_payment_btw_60-90_days"=>$internal_score['internal_repayments']['average_lateness_of_payment_btw_60-90_days'],]) : $internal_score['internal_repayments']['avg_lateness']; 

        $repaid_early = (sizeOf($allrepaymentCreditClanLoans) > 0) ?[  
        "repaid_early"=>$internal_score['internal_repayments']['repaid_early'],
        "repaid_btw_1-3_days"=>$internal_score['internal_repayments']['repaid_btw_1-3_days'],
        "repaid_btw_4-5_days"=>$internal_score['internal_repayments']['repaid_btw_4-5_days'],
        "repaid_in_more_than_5_days"=>$internal_score['internal_repayments']['repaid_in_more_than_5_days']
        ] : $internal_score['internal_repayments']['repaid_early'];

        $repayment_analysis = [
            "data"=>[
                "score"=>$customer_repayments_score,
                "internal_repayments"=>[                             
                    // "not_a_first_time_borrower"=>$internal_score['internal_repayments']['not_a_first_time_borrower'],
                    // "borrowed_once"=>$internal_score['internal_repayments']['borrowed_once'],
                    // "borrowed_twice"=>$internal_score['internal_repayments']['borrowed_twice'],
                    // "borrowed_five"=>$internal_score['internal_repayments']['borrowed_five'],
                    // "borrowed_ten"=>$internal_score['internal_repayments']['borrowed_ten'],
                    // "lateness_of_payment_btw_1-5_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_1-5_days'],
                    // "lateness_of_payment_btw_6-15_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_6-15_days'],
                    // "lateness_of_payment_btw_16-30_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_16-30_days'],
                    // "lateness_of_payment_btw_31-60_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_31-60_days'],
					// "lateness_of_payment_btw_61-90_days"=>$internal_score['internal_repayments']['lateness_of_payment_btw_61-90_days'],
					'borrowing_status'=>$no_of_times_borrowed,
                    'lateness_of_payment'=> $lateness_of_payment,
                    'lateness'=> $lateness,
                    'repaid_early'=> $repaid_early,
                    // "average_lateness_of_payment_btw_0-30_days"=>$internal_score['internal_repayments'][' average_lateness_of_payment_btw_0-30_days'],
                    // "average_lateness_of_payment_btw_30-60_days"=>$internal_score['internal_repayments']['average_lateness_of_payment_btw_30-60_days'],
                    // "average_lateness_of_payment_btw_60-90_days"=>$internal_score['internal_repayments']['average_lateness_of_payment_btw_60-90_days'],
                    // "repaid_early"=>$internal_score['internal_repayments']['repaid_early'],
                    // "repaid_btw_1-3_days"=>$internal_score['internal_repayments']['repaid_btw_1-3_days'],
                    // "repaid_btw_4-5_days"=>$internal_score['internal_repayments']['repaid_btw_4-5_days'],
                    // "repaid_in_more_than_5_days"=>$internal_score['internal_repayments']['repaid_in_more_than_5_days'],
                    "received_higher_principal"=>$internal_score['internal_repayments']['received_higher_principal'],
                    "received_lower_principal"=>$internal_score['internal_repayments']['received_lower_principal'],
                    "received_higher_tenure_days"=>$internal_score['internal_repayments']['received_higher_tenure_days'],
                    "received_lower_tenure_days"=>$internal_score['internal_repayments']['received_lower_tenure_days'],
                    "received_higher_interest_rate"=>$internal_score['internal_repayments']['received_higher_interest_rate'],
                    "received_lower_interest_rate"=>$internal_score['internal_repayments']['received_lower_interest_rate'],
					"score"=>$internal_score['internal_repayments']['score'],
					// "den"=>$internal_score['internal_repayments']['denominator']
                ],

                "external_repayments"=>[
                    "external_requests_allowed"=>$external_score["external_repayments"]['external_requests_allowed'],
                    "external_lateness_exists"=>$external_score["external_repayments"]['external_lateness_exists'],
                    "received_higher_principal"=>$external_score["external_repayments"]['received_higher_principal'],
                    "received_higher_tenure_days"=>$external_score["external_repayments"]['received_higher_tenure_days'],
                    "received_higher_interest_rate"=>$external_score["external_repayments"]['received_higher_interest_rate'],
                    "score"=>$external_score["external_repayments"]['score'],			
                ],	
            ],
        ];
        return $repayment_analysis;
	}
	
	public function analyseCreditClanRepayments($PEOPLE_ID,$lender_id,$data,$row,$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid = 0)
	{
		$total = 0;
		$score = 0;
		$denominator = 0;
		$ids = [];
		//get all the customers loans acrooss creditclan
		// $accounts = $this->db->query("select PEOPLE_ID from people_customers where people_id = '".$PEOPLE_ID."'")->result_array();
		if(!empty($accounts)){
			foreach($accounts as $account){
				$ids[]=$account['PEOPLE_ID'];				
			}
		}				
		//we got all customer ids acrross creditclan
		//is he first time with the lender
		// $loans = $this->db->query("select count(request_id) as nol from loan_request where people_id = '".$PEOPLE_ID."' and platform_id = '".$lender_id."' and booked = 1")->row_array();		
		if($loans_nol['nol'] > 0){
			// $total++;
			$response['internal_repayments']['not_a_first_time_borrower'] = "true";
			$score+=$row["NOT_A_FIRST_BORROWER_SCORE"];
		} 
		else
		{
			$response['internal_repayments']['not_a_first_time_borrower'] = "false";
		}
		$denominator+=$row["NOT_A_FIRST_BORROWER_SCORE"];
		$loans_nol = $loans_nol['nol'];
		if($loans_nol > 1){
			$denominator=$denominator+$row["BORROWED_ONE_SCORE"]+$row["BORROWED_TWO_SCORE"]+$row["BORROWED_FIVE_SCORE"]+$row["BORROWED_TEN_SCORE"];
            //check number of times he has borrowed           
			if($loans_nol > 1 && $loans_nol <= 2){
				$response['internal_repayments']['borrowed_once'] = "true";
				$score+=$row["BORROWED_ONE_SCORE"];
			}else{
				$denominator-=$row["BORROWED_ONE_SCORE"];
				$response['internal_repayments']['borrowed_once'] = "false";
			}

			if($loans_nol > 2 && $loans_nol <= 5){ 
				$response['internal_repayments']['borrowed_twice'] = "true";
				$score+=$row["BORROWED_TWO_SCORE"];
			}else{
				$response['internal_repayments']['borrowed_twice'] = "false";
				$denominator-=$row["BORROWED_TWO_SCORE"];
			} 

			if($loans_nol > 5 && $loans_nol <= 10){ 
				$response['internal_repayments']['borrowed_five'] = "true";
				$score+=$row["BORROWED_FIVE_SCORE"];
			}else{
				$response['internal_repayments']['borrowed_five'] = "false";
				$denominator-=$row["BORROWED_FIVE_SCORE"];
			} 

			if($loans_nol > 10){ 
				$response['internal_repayments']['borrowed_ten'] = "true";
				$score+=$row["BORROWED_TEN_SCORE"];
			}else{
				$response['internal_repayments']['borrowed_ten'] = "false";
				$denominator-=$row["BORROWED_TEN_SCORE"];
			} 
		}	
		else
		{
			$response['internal_repayments']['borrowed_before'] = "false";
		}	
		//lets check his maximum lateness
		//get all his repayments
        $id=implode(',',$ids);      
		// $loans = $this->db->query("select a.* from loan_request as a where a.people_id in(".$id.") and a.booked = 1 order by disbursement_date")->result_array();
		// if(!empty($loans_id)){
		// 	foreach($loans_id as $loan){				
		// 		// $allrepayment = $this->db->query("select * from repayment_schedule where request_id = '".$loan['REQUEST_ID']."'")->result_array();
                //$max_date_paid = 0;               				
		// 		foreach($allrepayment as $repay){
		// 			if(empty($repay['DATE_PAID']) && $repay['IS_PAID']==0){
		// 				$repay['DATE_PAID']=date('Y-m-d');
		// 			}					 
		// 			//whats the diff between the date_paid and repayment date
		// 			if(!empty($repay['DATE_PAID'])){
		// 				$days_used = date_diff($repay['DATE_PAID'],$repay["REPAYMENT_DATE"]);	
		// 				if($days_used->days > $max_date_paid){
		// 					$max_date_paid = $days_used;
		// 				}
		// 			}
		// 		}			
		// 	}
		// }		 
		if($max_date_paid > 0){
		 	$denominator=$denominator+$row["LATENESS_FIVE_SCORE"]+$row["LATENESS_FIFTEEN_SCORE"]+$row["LATENESS_THIRTY_SCORE"]+$row["LATENESS_SIXTY_SCORE"]+$row["LATENESS_NINETY_SCORE"];			
			//check the max lateness
			if($max_date_paid > 0 && $max_date_paid <= 5){
				$response['internal_repayments']['lateness_of_payment_btw_1-5_days'] = "true";
				$score-=$row["LATENESS_FIVE_SCORE"];
			}else{
				$response['internal_repayments']['lateness_of_payment_btw_1-5_days'] = "false";
				$denominator-=$row["LATENESS_FIVE_SCORE"];
			}


			if($max_date_paid > 5 && $max_date_paid <= 15){ 
				$response['internal_repayments']['lateness_of_payment_btw_6-15_days'] = "true";
				$score-=$row["LATENESS_FIFTEEN_SCORE"];
			}else{
				$response['internal_repayments']['lateness_of_payment_btw_6-15_days'] = "false";
				$denominator-=$row["LATENESS_FIFTEEN_SCORE"];
			} 

			if($max_date_paid > 15 && $max_date_paid <= 30){ 
				$response['internal_repayments']['lateness_of_payment_btw_16-30_days'] = "true";
				$score-=$row["LATENESS_THIRTY_SCORE"];
			}else{
				$response['internal_repayments']['lateness_of_payment_btw_16-30_days'] = "false";
				$denominator-=$row["LATENESS_THIRTY_SCORE"];
			} 

			if($max_date_paid > 30 && $max_date_paid <= 60){ 
				$response['internal_repayments']['lateness_of_payment_btw_31-60_days'] = "true";
				$score-=$row["LATENESS_SIXTY_SCORE"];
			}else{
				$response['internal_repayments']['lateness_of_payment_btw_31-60_days'] = "false";
				$denominator-=$row["LATENESS_SIXTY_SCORE"];
			} 

			if($max_date_paid > 60 && $max_date_paid <= 90){ 
				$response['internal_repayments']['lateness_of_payment_btw_61-90_days'] = "true";
				$score-=$row["LATENESS_NINETY_SCORE"];
			}else{
				$response['internal_repayments']['lateness_of_payment_btw_61-90_days'] = "false";
				$denominator-=$row["LATENESS_NINETY_SCORE"];
			} 
		}
        else
        {
            $response['internal_repayments']['lateness_of_payment'] = "false";
        }
		
		//get all requests
		//
		//$total_lateness=0;
		$avg_lateness = 0;
		//$total_schedules=0;
		// $loans_id = $this->db->query("select a.* from loan_request as a where a.people_id in(".$id.") and a.booked = 1")->result_array();
		
		// if(!empty($loans_id )){
		// 	foreach($loans_id as $loan){
        //         // $allrepayment = $this->db->query("select * from repayment_schedule where request_id = '".$loan['REQUEST_ID']."' order by period")->result_array();
                
		// 		$total_schedules+=sizeof($allrepayment);
		// 		if(!empty($allrepayment)){
		// 			foreach($allrepayment as $repay){
		// 				if(empty($repay['DATE_PAID']) && $repay['IS_PAID']==0){
		// 					$repay['DATE_PAID']=date('Y-m-d');
		// 				}										
		// 				$days_used = date_diff($repay['DATE_PAID'],$repay["REPAYMENT_DATE"]);							
		// 				$total_lateness+=$days_used->days;
		// 			}
		// 		}
		// 	}
		// }		
		if($total_lateness > 0){
			$avg_lateness = $total_lateness/$total_schedules;
		}		
		if($avg_lateness > 0){
			$denominator=$denominator+$row["LATENESS_INTERVAL_THIRTY"]+$row["LATENESS_INTERVAL_SIXTY"]+$row["LATENESS_INTERVAL_NINETY"];
			//count the lateness
			//check the lateness count lateness
			if($avg_lateness >= 0 && $avg_lateness <= 30){
				$response['internal_repayments']['average_lateness_of_payment_btw_0-30_days'] = "true";
				$score-=$row["LATENESS_INTERVAL_THIRTY"];
			}else{
                $response['internal_repayments']['average_lateness_of_payment_btw_0-30_days'] = "false";
				$denominator-=$row["LATENESS_INTERVAL_THIRTY"];
			}
			if($avg_lateness >= 30 && $avg_lateness <= 60){
				$response['internal_repayments']['average_lateness_of_payment_btw_30-60_days'] = "true";
				$score-=$row["LATENESS_INTERVAL_SIXTY"];
			}else{
                $response['internal_repayments']['average_lateness_of_payment_btw_30-60_days'] = "false";
				$denominator-=$row["LATENESS_INTERVAL_SIXTY"];
			}
			if($avg_lateness >= 60 && $avg_lateness <= 90){
				$response['internal_repayments']['average_lateness_of_payment_btw_60-90_days'] = "true";
				$score-=$row["LATENESS_INTERVAL_NINETY"];
			}else{
                $response['internal_repayments']['average_lateness_of_payment_btw_60-90_days'] = "false";
				$denominator-=$row["LATENESS_INTERVAL_NINETY"];
			}
        }
        else
        {
            $response['internal_repayments']['avg_lateness'] = "false"; 
        }	
		//no of default loans
		// $allrepaymentCreditClanLoans = $this->db->query("select a.* from repayment_schedule as a join loan_request as b on a.request_id = b.people_id join people_customers as c on a.people_id = c.people_id where b.people_id in(".$id.") and b.booked = 1 and a.date_paid < a.repayment_date")->result_array();		
		$denominator=$denominator+$row['REPAID_EARLY_EXISTS_SCORE'];
			
		$denominator=$denominator+$row["REPAID_EARLY_ONE_SCORE"]+$row["REPAY_EARLY_TWO_SCORE"]+$row["REPAID_EARLY_FIVE_SCORE"];
		if(sizeof($allrepaymentCreditClanLoans) > 0){			
			$score=$score+$row['REPAID_EARLY_EXISTS_SCORE'];
			$response['internal_repayments']['repaid_early'] = "true";
			//check the max lateness
			$max_date_paid = sizeof($allrepaymentCreditClanLoans);
			if($max_date_paid > 0 && $max_date_paid <= 3){
				$response['internal_repayments']['repaid_btw_1-3_days'] = "true";
				$score+=$row["REPAID_EARLY_ONE_SCORE"];
			}else{
                $response['internal_repayments']['repaid_btw_1-3_days'] = "false";
				$denominator-=$row["REPAID_EARLY_ONE_SCORE"];
			}
			if($max_date_paid > 3 && $max_date_paid <= 5){
				$response['internal_repayments']['repaid_btw_4-5_days'] = "true";
				$score+=$row["REPAY_EARLY_TWO_SCORE"];
			}else{
                $response['internal_repayments']['repaid_btw_4-5_days'] = "false";
				$denominator-=$row["REPAY_EARLY_TWO_SCORE"];
			}			
			if($max_date_paid > 5){
				$response['internal_repayments']['repaid_in_more_than_5_days'] = "true";
				$score+=$row["REPAID_EARLY_FIVE_SCORE"];
			}else{
                $response['internal_repayments']['repaid_in_more_than_5_days'] = "false";
				$denominator-=$row["REPAID_EARLY_FIVE_SCORE"];
			}
        }
        else
        {
            $response['internal_repayments']['repaid_early'] = "false";
        }				
		// $loans = $this->db->query("select a.* from loan_request as a where a.people_id in(".$id.") and a.booked = 1 order by disbursement_date")->result_array();		
		$received_higher= false;
		$received_lower = false;
		
		$received_higher_rate= false;
		$received_lower_rate = false;
		
		$received_higher_duration= false;
		$received_lower_duration = false;
		
		if(!empty($loans_id)){
			$amount = $loans_id[0]['REQUEST_PRINCIPAL'];  
			foreach($loans_id as $loan){
				if($loan['REQUEST_PRINCIPAL'] > $amount){
					$received_higher = true;
					$amount = $loan['REQUEST_PRINCIPAL'];
					continue;
				}
				
				if($loan['REQUEST_PRINCIPAL'] < $amount){
					$received_lower = true;
					$amount = $loan['REQUEST_PRINCIPAL'];
					continue;
				}
				
			}
		}
		if(!empty($loans_id)){  
			$interest = $loans_id[0]['REQUEST_RATE'];
			foreach($loans_id as $loan){
				if($loan['REQUEST_RATE'] > $interest){
					$received_higher_rate = true;
					$interest = $loan['REQUEST_RATE'];
					continue;
				}
				
				if($loan['REQUEST_RATE'] < $interest){
					$received_lower_rate = true;
					$interest = $loan['REQUEST_RATE'];
					continue;
				}
				
			}
		}
		if(!empty($loans_id)){ 
			$duration = $loans_id[0]['REQUEST_TENOR_IN_DAYS']; 
			foreach($loans_id as $loan){
				if($loan['REQUEST_TENOR_IN_DAYS'] > $duration){
					$received_higher_duration = true;
					$duration = $loan['REQUEST_TENOR_IN_DAYS'];
					continue;
				}
				
				if($loan['REQUEST_TENOR_IN_DAYS'] < $duration){
					$received_lower_duration = true;
					$duration = $loan['REQUEST_TENOR_IN_DAYS'];
					continue;
				}
				
			}
		}
		
		if($received_higher){
			$response['internal_repayments']['received_higher_principal'] = "true";
			$score=$score+$row['RECEIVED_HIGHER_PRINCIPAL_SCORE'];
			$denominator=$denominator+$row['RECEIVED_HIGHER_PRINCIPAL_SCORE'];
			
			
		}else{
            $response['internal_repayments']['received_higher_principal'] = "false";
			$denominator=$denominator+$row['RECEIVED_HIGHER_PRINCIPAL_SCORE'];
		}
		
		if($received_lower){
			$response['internal_repayments']['received_lower_principal'] = "true";
			$score=$score-$row['RECEIVED_HIGHER_PRINCIPAL_SCORE'];
			$denominator=$denominator+$row['RECEIVED_HIGHER_PRINCIPAL_SCORE'];
			
			
		}else{
            $response['internal_repayments']['received_lower_principal'] = "false";
			$denominator=$denominator+$row['RECEIVED_HIGHER_PRINCIPAL_SCORE'];
		}
		
		if($received_higher_duration){
			$response['internal_repayments']['received_higher_tenure_days'] = "true";
			$score=$score+$row['HIGHER_TENOR_SCORE'];
			$denominator=$denominator+$row['HIGHER_TENOR_SCORE'];
			
			
		}else{
            $response['internal_repayments']['received_higher_tenure_days'] = "false";
			$denominator=$denominator+$row['HIGHER_TENOR_SCORE'];
		}
		
		if($received_lower_duration){
			$response['internal_repayments']['received_lower_tenure_days'] = "true";
			$score=$score-$row['HIGHER_TENOR_SCORE'];
			$denominator=$denominator+$row['HIGHER_TENOR_SCORE'];
			
			
		}else{
            $response['internal_repayments']['received_lower_tenure_days'] = "false";
			$denominator=$denominator+$row['HIGHER_TENOR_SCORE'];
		}
		
		
		if($received_higher_rate){
			$response['internal_repayments']['received_higher_interest_rate'] = "true";
			$score=$score+$row['RECEIVED_HIGHER_INTEREST_SCORE'];
			$denominator=$denominator+$row['RECEIVED_HIGHER_INTEREST_SCORE'];
			
			
		}else{
            $response['internal_repayments']['received_higher_interest_rate'] = "false";
			$denominator=$denominator+$row['RECEIVED_HIGHER_INTEREST_SCORE'];
		}
		
        if($received_lower_rate)
        {
			$response['internal_repayments']['received_lower_interest_rate'] = "true";
			$score=$score-$row['LOWER_INTEREST_RATE_SCORE'];
			$denominator=$denominator+$row['LOWER_INTEREST_RATE_SCORE'];
			
			
		}else{
            $response['internal_repayments']['received_lower_interest_rate'] = "false";
			$denominator=$denominator+$row['LOWER_INTEREST_RATE_SCORE'];
        }
        
       



         $response['internal_repayments']['denominator'] = $denominator;
        
        
         
         

		$response['internal_repayments']['score'] = $score<=0?0:($score/$denominator)*100;
		return $response;
		//return $score <= 0 ? 0 : ($score/$denominator)*100;
	}
	
    public function analyseExternalRepayments($PEOPLE_ID,$lender_id,$data,$row,$accounts_email,$accounts_phone, $loans_nol1,$loans_nol12,$loans,$max_lateness,$allrepaymentLoans)
    {
		 
		$score = 0;
		$denominator = 0;
		$ids = [];
		//get all the customers loans acrooss creditclan
		// $accounts_email = $this->db->query("select PEOPLE_ID from people_customers where LOWER(email) = '".strtolower($data['EMAIL'])."' AND LENDER_ID != '".$lender_id."'")->result_array();
		if(!empty($accounts_email)){
			foreach($accounts_email as $account){
				$ids[]=$account['PEOPLE_ID'];
				
			}
		}
		
		// $accounts_phone = $this->db->query("select PEOPLE_ID from people_customers where PHONE = '".$data['PHONE']."' AND LENDER_ID != '".$lender_id."'")->result_array();
		if(!empty($accounts_phone)){
			foreach($accounts_phone as $account){
				if(!in_array($account['PEOPLE_ID'],$ids)){
					$ids[]=$account['PEOPLE_ID'];
				}				
			}
		}
		
		if(empty($ids)){
			return 0;
		}
		$a = implode(',',$ids);
		//we got all customer ids acrross creditclan
		//is he first time with th elender
		// $loans_nol1 = $this->db->query("select count(request_id) as nol from loan_request where people_id IN (".$PEOPLE_ID.") and booked = 1 and loan_status !=5 and lender_id != '".$lender_id."'")->row_array();
		$score = $score + $row['EXTERNAL_REQUESTS_ONGOING_SCORE'];
		if($loans_nol1['nol'] > $row['EXTERNAL_REQUESTS_ONGOING_ALLOWED']){
			$response['external_repayments']['external_requests_allowed'] = "true";
			$score = $score - $row['EXTERNAL_REQUESTS_ONGOING_SCORE'];
        }
        else
        {
            $response['external_repayments']['external_requests_allowed'] = "false";
        }
		$denominator = $denominator + $row['EXTERNAL_REQUESTS_ONGOING_SCORE'];
		
		
		// $loans_nol12 = $this->db->query("select count(request_id) as nol from loan_request where people_id IN (".$PEOPLE_ID.") and (loan_status between 1 and 2) and lender_id != '".$lender_id."'")->row_array();
		$score = $score + $row['EXTERNAL_REQUESTS_ONGOING_SCORE'];
		if($loans_nol12['nol'] > $row['EXTERNAL_REQUESTS_ONGOING_ALLOWED']){
			$response['external_repayments']['external_requests_allowed'] = "true";
			$score = $score - $row['EXTERNAL_REQUESTS_ONGOING_SCORE'];
        }
        else
        {
            $response['external_repayments']['external_requests_allowed'] = "false";
        }
		
		$denominator = $denominator + $row['EXTERNAL_REQUESTS_ONGOING_SCORE'];
		 
		//lets check his maximum lateness
		//get all his repayments
		$id=implode(',',$ids);
		$everbeenlate = false;
		//$max_lateness = 0;
		// $loans = $this->db->query("select a.* from loan_request as a where a.people_id in(".$id.") and a.booked = 1 and lender_id != '".$lender_id."' order by disbursement_date")->result_array();
		// if(!empty($loans)){
		// 	foreach($loans as $loan){				
		// 		// $allrepaymentExternal = $this->db->query("select * from repayment_schedule where request_id = '".$loan['REQUEST_ID']."'")->result_array();
		// 		$max_date_paid = 0;				
		// 		foreach($allrepaymentExternal as $repay){
		// 			if(empty($repay['DATE_PAID']) && $repay['IS_PAID']==0 && $repay['REPAYMENT_DATE'] < date('Y-m-d')){
		// 				$everbeenlate = true;
		// 				$lateness = date_diff(date('Y-m-d'),$repay["REPAYMENT_DATE"]);
							
		// 				if($lateness->days > $max_lateness){
		// 					$max_lateness = $lateness;
		// 				}
		// 			}
					 
		// 			//whats the diff between the date_paid and repayment date
		// 			if(!empty($repay['DATE_PAID'])){

		// 				$lateness = date_diff($repay['DATE_PAID'],$repay["REPAYMENT_DATE"],1);	
		// 				if($lateness->days > 0){
		// 					$everbeenlate = true;
		// 					if($lateness > $max_lateness){
		// 						$max_lateness = $lateness;
		// 					}
		// 				}

		// 			}

		// 		}
				
		// 	}
		// }
		 //$everbeenlate && this was here
		if($max_lateness > $row["EXTERNAL_LATENESS_MAX_COUNT"]){
			$response['external_repayments']['external_lateness_exists'] = "true";
		 	$denominator=$denominator+$row["EXTERNAL_LATENESS_EXISTS"];
			$score-=$row["EXTERNAL_LATENESS_EXISTS"];
		}
        else
        {
            $response['external_repayments']['external_lateness_exists'] = "false";
        }
		
		$denominator=$denominator+$row['EXTERNAL_EVER_REPAID_EARLY_EXISTS'];
		 
		if(sizeof($allrepaymentLoans) > 0){
			$response['external_repayments']['repaid_early_loans'] = "true";
			$score=$score+$row['EXTERNAL_EVER_REPAID_EARLY_EXISTS'];
			
        }
        else
        {
            $response['external_repayments']['repaid_early_loans'] = "false";
        }
		
		$received_higher= false;
		$received_lower = false;
		
		$received_higher_rate= false;
		$received_lower_rate = false;
		
		$received_higher_duration= false;
		$received_lower_duration = false;
		
		if(!empty($loans)){
			$amount = $loans[0]['REQUEST_PRINCIPAL'];  
			foreach($loans as $loan){
				if($loan['REQUEST_PRINCIPAL'] > $amount){
					$received_higher = true;
					$amount = $loan['REQUEST_PRINCIPAL'];
					continue;
				}
				
				if($loan['REQUEST_PRINCIPAL'] < $amount){
					$received_lower = true;
					$amount = $loan['REQUEST_PRINCIPAL'];
					continue;
				}
				
			}
		}
		if(!empty($loans)){  
			$interest = $loans[0]['REQUEST_RATE'];
			foreach($loans as $loan){
				if($loan['REQUEST_RATE'] > $interest){
					$received_higher_rate = true;
					$interest = $loan['REQUEST_RATE'];
					continue;
				}
				
				if($loan['REQUEST_RATE'] < $interest){
					$received_lower_rate = true;
					$interest = $loan['REQUEST_RATE'];
					continue;
				}
				
			}
		}
		if(!empty($loans)){ 
			$duration = $loans[0]['REQUEST_TENOR_IN_DAYS']; 
			foreach($loans as $loan){
				if($loan['REQUEST_TENOR_IN_DAYS'] > $duration){
					$received_higher_duration = true;
					$duration = $loan['REQUEST_TENOR_IN_DAYS'];
					continue;
				}				
				if($loan['REQUEST_TENOR_IN_DAYS'] < $duration){
					$received_lower_duration = true;
					$duration = $loan['REQUEST_TENOR_IN_DAYS'];
					continue;
				}				
			}
		}
		
		if($received_higher){
			$response['external_repayments']['received_higher_principal'] = "true";
			$score=$score+$row['EXTERNAL_EVER_RECEIVED_HIGHER_PRINCIPAL'];
			$denominator=$denominator+$row['EXTERNAL_EVER_RECEIVED_HIGHER_PRINCIPAL'];
			
			
		}else{
            $response['external_repayments']['received_higher_principal'] = "false";
			$denominator=$denominator+$row['EXTERNAL_EVER_RECEIVED_HIGHER_PRINCIPAL'];
		}
		
		 
		if($received_higher_duration)
		{
			$response['external_repayments']['received_higher_tenure_days'] = "true";
			$score=$score+$row['EXTERNAL_EVER_RECEIVED_HIGHER_TENOR'];
			$denominator=$denominator+$row['EXTERNAL_EVER_RECEIVED_HIGHER_TENOR'];	
		}
		else
		{
            $response['external_repayments']['received_higher_tenure_days'] = "false";
			$denominator=$denominator+$row['EXTERNAL_EVER_RECEIVED_HIGHER_TENOR'];
		}
	
		if($received_higher_rate)
		{
			$response['external_repayments']['received_higher_interest_rate'] = "true";
			$score=$score+$row['EXTERNAL_EVER_RECEIVED_HIGHER_INTEREST'];
			$denominator=$denominator+$row['EXTERNAL_EVER_RECEIVED_HIGHER_INTEREST'];	
		}
		else
		{
            $response['external_repayments']['received_higher_interest_rate'] = "false";
			$denominator=$denominator+$row['EXTERNAL_EVER_RECEIVED_HIGHER_INTEREST'];
		}
		$response['external_repayments']['score'] = $score<=0?0:($score/$denominator)*100;
 		return $response;
		//return $score <= 0 ? 0 : ($score/$denominator)*100;
	}
}
