<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Requests;
use Firebase\JWT\JWT;
use Lcobucci\Jose\Parsing\Encoder;

//use SendGrid\Email;
// use SendGrid\Content;
// use SendGrid\Mail;
use SendGrid;




class NotificationsController extends Controller
{
    private $username; 
    private $password;
    public $transport; 
    public $mailer; 
    public $message; 
    public function sendPushNotification($request) 
    {
       
        $app_id = $request->app_id;
        $api_key = $request->api_key;
        $content = array(
            "en" => $request->message,
           
			);
		
		$fields = array(
			'app_id' => $app_id,
			'filters' => array(["field" => "tag", "key"=>"email", "relation" => "=", "value" => $request->email]),
			'data' => array("FO"=>"BAR"),//"state" => $request->state, "params"=>$request->params
			'contents' => $content
		);
		
		$fields = json_encode($fields);
    	print("\nJSON sent:\n");
    	print($fields);
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
												   'Authorization: Basic'.' '. $api_key));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

		$response = curl_exec($ch);
		curl_close($ch);
		
		return $response;
    }

    public function getTags($template_content)
    {
       //$text = '[This] is a  [boy] thas test\ string, [eat] my [shorts].';
        preg_match_all("/\[[^\]]*\]/", $template_content, $matches);
      

        return $matches[0];
    }

    public function replaceEmailTags()
    {
        $templates = DB::table('email_messages As M')->join('email_templates as T','M.EMAIL_TEMPLATE_ID','=','T.EMAIL_TEMPLATE_ID')->select('M.*','T.TEMPLATE_CONTENT', 'T.TEMPLATE_NAME')->get();
      
        $customer_ids =[];
        $lender_ids =[];
        $request_ids =[];

        foreach($templates as $template)
        {
            //echo($template->LENDER_ID);
            // customer
            if(!in_array($template->RECEIVER_ID, $customer_ids))
            {
                $customer_ids[] = $template->RECEIVER_ID;
            }
            if(!in_array($template->LENDER_ID, $lender_ids))
            {
                $lender_ids[] = $template->LENDER_ID;
            }
            if(!in_array($template->REQUEST_ID, $request_ids))
            {
                $request_ids[] = $template->REQUEST_ID;
            }
            
        }

        $customers = DB::table('people_customers')->select('*')->whereIn('PEOPLE_ID',$customer_ids)->get()->groupBy('PEOPLE_ID')->toArray();
       
        $lenders = DB::table('people')->select('*')->whereIn('PEOPLE_ID',$lender_ids)->get()->groupBy('PEOPLE_ID')->toArray();

        $requests = DB::table('loan_request')->select('*')->whereIn('REQUEST_ID',$request_ids)->get()->groupBy('REQUEST_ID')->toArray();

        $emailGroups = [];
        //dd($customers);
        foreach($templates as $template)
        {
            $_cust = $customers[$template->RECEIVER_ID];
            $_lender = $lenders[$template->LENDER_ID];
            $_request = $requests[$template->REQUEST_ID];
            $emailGroups[] = [
                'customer'=>$_cust[0],
                'lender'=>$_lender[0],
                'request'=>$_request[0],
                'email'=>$template
            ];
        }

       // $tags = get_class_methods('TagsController');
        //parse
        foreach($emailGroups as $key=>$emailGroup)
        {
            $newTag = new TagsController($emailGroup['lender'], $emailGroup['customer'], $emailGroup['request']);
            //dd($newTag);
           $tagsExtracted = $this->getTags($emailGroup['email']->TEMPLATE_CONTENT);
           //dd($tagsExtracted);
           foreach($tagsExtracted as $tagExtracted)
           {
                $end = strlen($tagExtracted) - 2;
                $_method = substr($tagExtracted,1,$end);
                $emailGroup['email']->TEMPLATE_CONTENT = str_ireplace($tagExtracted,$newTag->$_method(),$emailGroup['email']->TEMPLATE_CONTENT);
           }
           
            // send
            Mail::to($emailGroup['customer']->EMAIL)->send(new EmailNotification($emailGroup['email']));
           // echo $emailGroup['email']->TEMPLATE_CONTENT;
        }
        return ($emailGroups);
             
    
    }


    public function replaceEmailTagsNew()
    {
        
        // $subject = DB::table('template-section')->select('subject')->where('email_type',$email_group->TYPE_OF_EMAIL)->get();

        $templates = DB::table('email_messages As M')->join('template-section as T','M.EMAIL_TYPE','=','T.email_type')->select('M.*','T.email_type', 'T.content')->get();

       //return $templates;

        $customer_ids =[];
        $lender_ids =[];
        $request_ids =[];

        foreach($templates as $template)
        {
            
            if(!in_array($template->RECEIVER_ID, $customer_ids))
            {
                $customer_ids[] = $template->RECEIVER_ID;
            }
            if(!in_array($template->LENDER_ID, $lender_ids))
            {
                $lender_ids[] = $template->LENDER_ID;
            }
            if(!in_array($template->REQUEST_ID, $request_ids))
            {
                $request_ids[] = $template->REQUEST_ID;
            }
            
        }
       
        $customers = collect(DB::table('people_customers')->select('*')->whereIn('PEOPLE_ID',$customer_ids)->get())->groupBy('PEOPLE_ID')->toArray();
       
     
        
        $lenders = collect(DB::table('people')->select('*')->whereIn('PEOPLE_ID',$lender_ids)->get())->groupBy('PEOPLE_ID')->toArray();

        $requests = collect(DB::table('loan_request')->select('*')->whereIn('REQUEST_ID',$request_ids)->get())->groupBy('REQUEST_ID')->toArray();

        $emailGroups = [];

        foreach($templates as $template)
        {
            $_cust = $customers[$template->RECEIVER_ID];
            $_lender = $lenders[$template->LENDER_ID];
            $_request = $requests[$template->REQUEST_ID];
            $emailGroups[] = [
                'customer'=>$_cust[0],
                'lender'=>$_lender[0],
                'request'=>$_request[0],
                'email'=>$template
            ];
        }

        
        //return  $emailGroups; 
        foreach($emailGroups as $key=>$emailGroup)
        {
            $newTag = new TagsController($emailGroup['lender'], $emailGroup['customer'], $emailGroup['request']);
           $lender_details =  DB::table('app_keys')->select('email_footer_content','email_template_logo','LOGO_IMAGE_URL','ICON')->where('company_id',$emailGroup['lender']->PEOPLE_ID)->get();
           if(!empty($lender_details))
           {
                $header = $lender_details[0]->email_template_logo;
                $footer = $lender_details[0]->email_footer_content;
           }
           else
           {
                $header = "";
                $footer ="";
           }
           




           $tagsExtracted = $this->getTags($emailGroup['email']->content);
           //dd($tagsExtracted);
           foreach($tagsExtracted as $tagExtracted)
           {
                $end = strlen($tagExtracted) - 2;
                $_method = substr($tagExtracted,1,$end);
                $emailGroup['email']->content = str_ireplace($tagExtracted,$newTag->$_method(),$emailGroup['email']->content);
           }
           
            // send\
            if($emailGroup['lender']->PEOPLE_ID=='0')
            continue;
                            
            if (!filter_var($emailGroup['customer']->EMAIL, FILTER_VALIDATE_EMAIL))
            continue;
            $this->process_welcome_emails($templates,$emailGroup['email']->content,$emailGroup['lender']->PEOPLE_ID,$emailGroup['customer']->PEOPLE_ID,$emailGroup['email'],$header,$footer);
            // Mail::to($emailGroup['customer']->EMAIL)->send(new EmailNotification($emailGroup['email']));
           // echo $emailGroup['email']->TEMPLATE_CONTENT;
        }
        return ($emailGroups);
             
    
    }

    public function process_welcome_emails($templates,$content,$lender_id,$RECEIVER_ID,$email_group,$header,$footer)
    {          
		//$emails = $this->email_sms_service_model->getPendingEmails_e(14);
		$emails = $templates;
		 
		$t=[];
        // if(!empty($emails))
        // {
        //     foreach ($emails as $k => $row) 
        //     {		
				//loan disbursed 
							//$lender_id = $row->LENDER_ID;
							//$user_details = $this->email_sms_service_model->getCustomerDetails($row->RECEIVER_ID);
                            $user_details = DB::table('people_customers')->select('*')->where('PEOPLE_ID',$RECEIVER_ID)->get()[0];
							// get lenders info
                            // $lender_info = $this->email_sms_service_model->getLenderInfo($lender_id);
                            
                            $lender_info = DB::table('people')->select('*')->where('PEOPLE_ID',$lender_id)->get()[0];	
				
							// if($row->IS_SEVEN_HUNDRED == "1"){
								
							// }
                //							if($row->LENDER_ID!=6760)
                //							continue;
							// checking does user still exist? if not skip sending mail
							if(!empty($user_details)){
								
								// if($lender_id=='0')
								// continue;
							 
								// if (!filter_var($user_details->EMAIL, FILTER_VALIDATE_EMAIL))
                                // continue;
                                
								$data["data"] = $user_details;
								$data["receiver"] = $user_details;
								$data["lender"] = $lender_info;
								//$data["email"] = $row; 
								$data["sender"] = $lender_info;
								
								$token=array();
								$token['platform_id'] = $lender_info->PEOPLE_ID;
								$token['email'] = $user_details->EMAIL; 
                                $token['date_sent'] = date('Y-m-d');
                                
								$access_token = JWT::encode($token, "1234567890");  
                                // $data["token"] = $access_token; 
                                
								// get email template to be sent
                                // $body = $this->load->view("email_templates/welcome_email",$data,TRUE);
                                // http://app.creditclan.com/private?token
                                //Confirm email
                                $subject = DB::table('template-section')->select('subject')->where('email_type',$email_group->EMAIL_TYPE)->get();
                                if(!empty($subject)
                                )
                                {
                                    $subject = $subject[0]->subject; 
                                }
                                // $subject = "Welcome to - ".ucwords($lender_info->LEGAL_NAME);
                                $button_url ="";
                                $access_token_ ="";
                                $button_name = "";
                              

                                //$body = $content;

                                if($email_group->TYPE_OF_EMAIL == 3)
                                {
                                    $button_url = "http://app.creditclan.com/private?token=";
                                    $access_token_ =  $access_token;
                                    $button_name ="Activate Account";
                                }
                                if($email_group->TYPE_OF_EMAIL == 19)
                                {
                                    $button_url = "http://private.creditclan.com/repayment?token=";
                                    $access_token_ =  $access_token;
                                    $button_name ="Repay";

                                }
                               if($email_group->TYPE_OF_EMAIL == 17)
                                {
                                    $button_url = $email_group->REPAYMENT_LINK;
                                    // $access_token_ =  $access_token;
                                    $button_name ="Add Card";

                                }
                               if($email_group->TYPE_OF_EMAIL == 18)
                                {
                                    $button_url = $email_group->REPAYMENT_LINK;
                                    // $access_token_ =  $access_token;
                                    $button_name ="Confirm Your BVN";

                                 

                                    // $subject = "BVN Confirmation - ".ucwords($lender_info->LEGAL_NAME);
                                }
                               if($email_group->TYPE_OF_EMAIL == 16)
                                {
                                     //    var_dump($email_group->REPAYMENT_LINK);
                                    $button_url = $email_group->REPAYMENT_LINK;
                                    // $access_token_ =  $access_token;
                                    $button_name ="Confirm Your Bank Account";


                                    // $subject = "Bank Account Confirmation - ".ucwords($lender_info->LEGAL_NAME);
                                }
                               if($email_group->TYPE_OF_EMAIL == 1)
                                {
                                    $button_url = $email_group->REPAYMENT_LINK;
                                    // $access_token_ =  $access_token;
                                    $button_name ="Click to download";

                                    

                                    // $subject = "Document Upload - ".ucwords($user_details->LEGAL_NAME);
                                }
                            //    if($email_group->TYPE_OF_EMAIL == 5)
                            //     {
                            //         $button_url = "http://private.creditclan.com/repayment?token=";
                            //         $access_token_ =  $data;
                            //         $button_name ="Repay";

                              
                                   
                            //         // $subject = "Document Upload - ".ucwords($user_details->LEGAL_NAME);
                            //     }


                               if(!empty($button_name) && !empty($button_url))
                               {
                                    $button_row = $this->getButtonOne($button_url,$button_name);
                                    //     $button_row = 

                                    //     "<tr>
                                    //     <td colspan='4' class='text-center'>
                                    //     <div class='button-wrap' style='text-align: center;
                                    //     padding: 2rem; '>
                                    //         <button class='mobile-button' style='16px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; font-weight:normal; text-align:center; background-color: #2a83e9; text-decoration: none; border: none; -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; display: inline-block;'><a style='text-decoration:none; color: #ffffff; font-size: 18px; letter-spacing: 1px; text-decoration: none; font-family: Arial, Helvetica, sans-serif;' href='".$button_url."' class='explore'>
                                    //             $button_name
                                    //         </a></button>
                                    //     </div>
                                    //     </td>
                                    // </tr>";
                                  
                                //   var_dump( $button_row);
                                //   die(); 

                                   
                               }
                               if(!empty($button_name) && !empty($button_url)&& !empty($access_token_))
                               {
                                    $button_row = $this->getButtonTwo($button_url,$button_name,$access_token_);
                                    // $button_row = "<tr>
                                    // <td colspan='4' class='text-center'>
                                    // <div class='button-wrap' style='text-align: center;
                                    // padding: 2rem;'>
                                    //     <button style='16px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; font-weight:normal; text-align:center; background-color: #2a83e9; text-decoration: none; border: none; -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; display: inline-block;'><a style='text-decoration:none; color: #ffffff; font-size: 18px; letter-spacing: 1px; text-decoration: none;  font-family: Arial, Helvetica, sans-serif;' href='".$button_url. $access_token_."' class='explore'>
                                    //         $button_name
                                    //     </a></button>
                                    // </div>
                                    // </td>
                                    //     </tr>";
                          
                           
                               }
                               if(empty($button_name) || empty($button_url))
                               {
                                    $button_row = "<tr></tr>";
                               }
                               
                            //    var_dump($button_url);
                            //    var_dump($button_name);
                            //    die();

                             

                                $body = $this->getHTMLBody($header,$content,$button_row,$footer);
                        
								if($lender_info->USE_SENDGRID=="1"){
									 
								$t[] =$this->use_send_grid($user_details->EMAIL,$user_details->LEGAL_NAME,$body,"",$lender_info->HAS_SMTP,$lender_info->SMTP_SERVER,$lender_info->SMTP_USERNAME,$lender_info->SMTP_PASSWORD,$lender_info->SMTP_PORT,$email_group->EMAIL_MESSAGE_ID,$lender_info->LEGAL_NAME,$subject,$lender_info->SENDER_EMAIL,$lender_info->USE_SSL,$lender_info->SMTP_PORT_,$lender_info->SG_USERNAME,$lender_info->SG_EMAIL,$lender_info->SG_API,$lender_info->PEOPLE_ID);
								}else{
									$t[] =$this->send_email($user_details->EMAIL,$user_details->LEGAL_NAME,$body,"",$lender_info->HAS_SMTP,$lender_info->SMTP_SERVER,$lender_info->SMTP_USERNAME,$lender_info->SMTP_PASSWORD,$lender_info->SMTP_PORT,$email_group->EMAIL_MESSAGE_ID,$lender_info->LEGAL_NAME,$subject,$lender_info->SENDER_EMAIL,$lender_info->USE_SSL,$lender_info->SMTP_PORT_,$lender_info->PEOPLE_ID);
								}
								
								 
							}
		// 	}
			
		// }
		echo json_encode($t);
	}

    public function showButton($type_of_email)
    {
        $button_url ="";
        $access_token = "";
        $button_name ="";
        if($type_of_email == 3)
        {
            $button_url = "http://app.creditclan.com/private?token=";
            $access_token_ =  $access_token;
            $button_name ="Activate Account";

            //     $button_html =  "<tr>
            //     <td>
            //         <div class='static-content'>
            //            <a class='btn btn-primary' href='".$button_url=$access_token_."'>$button_name</a>
            //         </div>
            //     </td>
            // </tr>";
        }
        if($type_of_email == 19)
        {
            $button_url = "http://private.creditclan.com/repayment?token=";
            $access_token_ =  $access_token;
            $button_name ="Repay";

            $button_html =  "<tr>
            <td>
                <div class='static-content'>
                   <a class='btn btn-primary' href='".$button_url=$access_token_."'>$button_name</a>
                </div>
            </td>
            </tr>";
        }
       if($type_of_email == 17)
        {
            $button_url = $email_group->REPAYMENT_LINK;
            // $access_token_ =  $access_token;
            $button_name ="Add Card";

                $button_html =  "<tr>
                <td>
                    <div class='static-content'>
                    <a class='btn btn-primary' href='".$button_url."'>$button_name</a>
                    </div>
                </td>
            </tr>";
        }
       if($type_of_email == 18)
        {
            $button_url = $email_group->REPAYMENT_LINK;
            // $access_token_ =  $access_token;
            $button_name ="Confirm your BVN";

                $button_html =  "<tr>
                <td>
                    <div class='static-content'>
                    <a class='btn btn-primary' href='".$button_url."'>$button_name</a>
                    </div>
                </td>
            </tr>";

            $subject = "BVN Confirmation - ".ucwords($lender_info->LEGAL_NAME);
        }
       if($type_of_email == 16)
        {
            //    var_dump($email_group->REPAYMENT_LINK);
            $button_url = $email_group->REPAYMENT_LINK;
            // $access_token_ =  $access_token;
            $button_name ="Confirm your bank account";

                $button_html =  "<tr>
                <td>
                    <div class='static-content'>
                    <button><a class='btn btn-primary' href='".$button_url."'>$button_name</a></button>
                    </div>
                </td>
            </tr>";

            $subject = "Bank Account Confirmation - ".ucwords($lender_info->LEGAL_NAME);
        }
       if($type_of_email == 1)
        {
            $button_url = $email_group->REPAYMENT_LINK;
            // $access_token_ =  $access_token;
            $button_name ="Click to download";

                $button_html =  "<tr>
                <td>
                    <div class='static-content'>
                    <button><a class='btn btn-primary' href='".$button_url."'>$button_name</a></button>
                    </div>
                </td>
            </tr>";

            $subject = "Document Upload - ".ucwords($user_details->LEGAL_NAME);
        }
       if($type_of_email == 5)
        {
            $button_url = "http://private.creditclan.com/repayment?token=";
            $access_token_ =  $data;
            $button_name ="Repay";

            $button_html =  "<tr>
            <td>
                <div class='static-content'>
                   <a class='btn btn-primary' href='".$button_url=$access_token_."'>$button_name</a>
                </div>
            </td>
            </tr>";
           
            $subject = "Document Upload - ".ucwords($user_details->LEGAL_NAME);
        }
    }

    public function use_send_grid($USER_MAIL,$LEGAL_NAME,$body,$s,$HAS_SMTP,$SMTP_SERVER,$SMTP_USERNAME,$SMTP_PASSWORD,$SMTP_PORT,$EMAIL_MESSAGE_ID,$LLEGAL_NAME,$subject,$LSENDER_EMAIL,$USE_SSL,$SMTP_PORT_,$SG_USERNAME,$SG_EMAIL,$SG_API)
    {
        
        // $request_body = json_decode(json_encode([
        //     "personalizations"=> [
        //     [
        //         "to"=> [
        //         [
        //             "email"=> "sochineme@gmail.com"
        //         ]
        //         ],
        //         "subject"=> "hello"
        //     ]
        //     ],
        //     "from"=> [
        //     "email"=>"test@name.com"
        //     ],
        //     "content"=> [
        //     [
        //         "type"=> "text/plain",
        //         "value"=> "how far"
        //     ]
        //     ]
        // ]));
        
        //$apiKey = getenv('SENDGRID_API_KEY');
        // $sg = new \SendGrid($SG_API);
        
        // $response = $sg->client->mail()->send()->post($request_body);
        // echo $response->statusCode();
        // echo $response->body();

        //     $from = new SendGrid\Email($SG_USERNAME, $SG_EMAIL);
        //     $subject = $subject;
        //     $to = new SendGrid\Email($LEGAL_NAME, $USER_MAIL);
        //     $content = new SendGrid\Content("text/html", $body);

        //     $mail = new SendGrid\Mail($from, $subject, $to, $content);

        //     $apiKey = $SG_API;
        //     $sg = new \SendGrid($apiKey);
            
        
        //     $response = $sg->client->mail()->send()->post($mail);
            
        //     $t= $response->body();
        //    // $t= $response->body();
        //     echo $response->statusCode();
        //     // DB::delete("delete from email_messages where EMAIL_MESSAGE_ID = '".$EMAIL_MESSAGE_ID."'");
        //     return $t;var
            //var_dump($SG_USERNAME);
            // $from = new SendGrid\Email("nebechi", "nebs@creditclan.com");
            var_dump($SG_USERNAME);
            var_dump($SG_EMAIL);
            var_dump($subject);
            var_dump($LEGAL_NAME);
            var_dump($USER_MAIL);
            var_dump($body);
            
            $from = new SendGrid\Email($SG_USERNAME, $SG_EMAIL);
        //$subject = "New One From Me";
        $subject = $subject;
        //$to = new SendGrid\Email("Example User", "sochineme@gmail.com");
        $to = new SendGrid\Email($LEGAL_NAME, $USER_MAIL);
        // $content = new SendGrid\Content("text/plain", "and easy to do anywhere, even with PHP");
        $content = new SendGrid\Content("text/html", $body);
        $mail = new SendGrid\Mail($from, $subject, $to, $content);

        //$apiKey = getenv('SENDGRID_API_KEY');
        $sg = new \SendGrid($SG_API);

        $response = $sg->client->mail()->send()->post($mail);
        echo $response->statusCode();
        print_r($response->headers());
        echo $response->body();


		// $from = new Email($SG_USERNAME, $SG_EMAIL);
		// 								$subject = $subject;
		// 								$to = new Email($LEGAL_NAME, $USER_MAIL);
                                       
        //                                 $content = new Content("text/html", $body);

		// 								$mail = new Mail($from, $subject, $to, $content);

		// 								$apiKey = $SG_API;
        //                                 $sg = new \SendGrid($apiKey);
                                        
                                       
		// 								$response = $sg->client->mail()->send()->post($mail);
										 
        //                                 $t= $response->body();
        //                                // $t= $response->body();
        //                                 echo $response->statusCode();
		// 								// DB::delete("delete from email_messages where EMAIL_MESSAGE_ID = '".$EMAIL_MESSAGE_ID."'");
		// return $t;
	}

  

    public function send_email($receiver_email,$receiver_name,$body,$attachment="",$has_smtp="0",$smtp_host="",$smtp_username="",$smtp_password="",$smtp_port="",$email_message_id="",$lender_name="",$subject="",$sender_mail="no-reply@creditclan.com",$use_ssl='1',$smtp_port_=143,$lender_id="")
    {
		// check if $has_smtp is set to 1. if not use detault credentials
		
        if($has_smtp == "1")
        {
			// user has credentials 
			// override default smtp credentials
			
			if($lender_id=="17036"){

				$this->transport = \Swift_SmtpTransport::newInstance()
						->setUsername('credit@vfd-mfb.com')->setPassword('@money098#')
						->setHost('smtp.office365.com')
						->setPort('587')->setEncryption('tls');
			}else{
				$this->username = $smtp_username;
				$this->password = $smtp_password;
				$this->transport = \Swift_SmtpTransport::newInstance($smtp_host, $smtp_port, 'ssl')
					  ->setUsername($smtp_username)
					  ->setPassword($smtp_password);

				if($use_ssl=='0'){

					$this->transport = \Swift_SmtpTransport::newInstance($smtp_host, $smtp_port_)
					  ->setUsername($smtp_username)
					  ->setPassword($smtp_password);
				}
			}
			$this->mailer = \Swift_Mailer::newInstance($this->transport);
			$this->message = \Swift_Message::newInstance();
        }else
        {
			$sender_mail = $this->username;
			$lender_name = "Creditclan Support";
		}

        // var_dump($sender_mail)

		// set message headers
		if(!empty($attachment)){
			// Create your file contents in the normal way, but don't write them to disk
			// Create the attachment with your data

			$file = Swift_Attachment::newInstance($attachment, 'document.pdf', 'application/pdf');

			// Attach it to the message

			if(empty($lender_name)){
                $this->message->setSubject($subject)
                //$message = (new Swift_Message($subject))
				->setFrom(array('no-reply@creditclan.com' => 'Creditclan Support Team'))
				->setTo(array($receiver_email => $receiver_name))
				->setBody($body, 'text/html')
				->attach($file);
			}
			else{
                $this->message->setSubject($subject)
                //$message = (new Swift_Message($subject))
				->setFrom(array($sender_mail => ucfirst($lender_name)))
				->setTo(array($receiver_email => $receiver_name))
				->setBody($body, 'text/html')
				->attach($file);
			}
		}
		else{
			if(empty($lender_name)){
                $this->message->setSubject($subject)
                // $message = (new Swift_Message($subject))
				->setFrom(array('no-reply@creditclan.com' => 'Creditclan Support Team'))
				->setTo(array($receiver_email => $receiver_name))
				->setBody($body, 'text/html');
			}
			else{
				if($lender_id=="17036"){
					$this->message->setSubject($subject)
				->setFrom(array("credit@vfd-mfb.com" => "VFD-MFB"))
				->setTo(array($receiver_email => $receiver_name))
				->setBody($body, 'text/html');
				}else{
                    $this->message->setSubject($subject)
                    //$message = (new \Swift_Message($subject))
				->setFrom(array($sender_mail => ucfirst($lender_name)))
				->setTo(array($receiver_email => $receiver_name))
				->setBody($body, 'text/html');
				}
				
			}
		}
		 
		try{
			if($this->mailer->send($this->message)){
				// DB::delete("delete from email_messages WHERE EMAIL_MESSAGE_ID = '".$email_message_id."'");	

				return TRUE;
			}else{
				return FALSE;
			}

		}catch(Swift_TransportException $e){
			$response = $e->getMessage() ;
			return $response;
		}

	}



    public function replaceSmsTags()
    {
        $templates = DB::table('sms_messages As M')->join('sms_template as T','M.SMS_TEMPLATE_ID','=','T.SMS_TEMPLATE_ID')->select('M.*','T.TEMPLATE_CONTENT')->get();
        //dd($templates);
        $customer_ids =[];
        $lender_ids =[];
        $request_ids =[];

        foreach($templates as $template)
        {
            //echo($template->LENDER_ID);
            // customer
            if(!in_array($template->RECEIVER_ID, $customer_ids))
            {
                $customer_ids[] = $template->RECEIVER_ID;
            }
            if(!in_array($template->LENDER_ID, $lender_ids))
            {
                $lender_ids[] = $template->LENDER_ID;
            }
            if(!in_array($template->REQUEST_ID, $request_ids))
            {
                $request_ids[] = $template->REQUEST_ID;
            }
            
        }
        //dd($lender_ids);
        $customers = DB::table('people_customers')->select('*')->whereIn('PEOPLE_ID',$customer_ids)->get()->groupBy('PEOPLE_ID')->toArray();
       
        
        $lenders = DB::table('people')->select('*')->whereIn('PEOPLE_ID',$lender_ids)->get()->groupBy('PEOPLE_ID')->toArray();

        $requests = DB::table('loan_request')->select('*')->whereIn('REQUEST_ID',$request_ids)->get()->groupBy('REQUEST_ID')->toArray();

        $smsGroups = [];
        //dd($customers);
        foreach($templates as $template)
        {
            $_cust = $customers[$template->RECEIVER_ID];
            $_lender = $lenders[$template->LENDER_ID];
            $_request = $requests[$template->REQUEST_ID];
            $smsGroups[] = [
                'customer'=>$_cust[0],
                'lender'=>$_lender[0],
                'request'=>$_request[0],
                'SMS'=>$template
            ];
        }
        //return $smsGroups;

        foreach($smsGroups as $key=>$smsGroup)
        {
            $newTag = new TagsController($smsGroup['lender'], $smsGroup['customer'], $smsGroup['request']);
            //dd($newTag);
           $tagsExtracted = $this->getTags($smsGroup['SMS']->TEMPLATE_CONTENT);
           //dd($tagsExtracted);
           foreach($tagsExtracted as $tagExtracted)
           {
                $end = strlen($tagExtracted) - 2;
                $_method = substr($tagExtracted,1,$end);
                $smsGroup['SMS']->TEMPLATE_CONTENT = str_ireplace($tagExtracted,$newTag->$_method(),$smsGroup['SMS']->TEMPLATE_CONTENT);
           }           
            // send
            //echo $smsGroup['SMS']->TEMPLATE_CONTENT;

           // $app_id = empty($request->app_id) ? "646466" : $request->app_id;

            $pushMessage = ["email"=>$smsGroup['customer']->EMAIL,"message"=>$smsGroup['SMS']->TEMPLATE_CONTENT,"app_id"=>$smsGroup['lender']->app_id,"api_key"=>$smsGroup['lender']->api_key];
            $pushMessage = json_encode($pushMessage);
            $pushMessage = json_decode($pushMessage);
            if($smsGroup['SMS']->IS_PUSH)
            {
                $this->sendPushNotification($pushMessage);
            }
            
           // echo $smsGroup['SMS']->TEMPLATE_CONTENT;
           if($smsGroup['SMS']->IS_SMS)
           {
                 $this->send_message_($smsGroup['customer']->PHONE,$smsGroup['SMS']->TEMPLATE_CONTENT,"CREDITCLAN");
           }
           
        }
        //dd($tagsExtracted);
        return $smsGroups;
        
    }
    public function send_message_($recepient,$sms_message,$sender)
    {
        $curl = curl_init();
        //http://www.estoresms.com/smsapi.php?username=user&password=1234&sender=@@sender@@&recipient=@@recipient@@&m
        //essage=@@message@@&dnd=true
        $url = "http://www.estoresms.com/smsapi.php?username=creditclan&password=cr3d!tcl@n&sender=".UrlEncode($sender)."&recipient=".UrlEncode($recepient)."&message=".UrlEncode($sms_message)."&dnd=true";
        curl_setopt_array($curl, array(            
          CURLOPT_URL => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "cache-control: no-cache"         
          ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            // error return false
            return FALSE;
        } else {
          // sms sent to smsmobile
            return TRUE;
        }
    }
    public function deleteEmail()
    {
        DB::table('email_messages')->delete();
    }
    public function deleteSMS()
    {
        DB::table('sms_messages')->delete();
    }

    public function getHTMLBody($header,$content,$button_row,$footer)
    {

        $body = "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
        <html xmlns='http://www.w3.org/1999/xhtml'>
        <head>
        <meta http-equiv='Content-Type' content='text/html; charset=utf-8' />
        <!--[if !mso]><!-->
        <meta http-equiv='X-UA-Compatible' content='IE=edge' />
        <!--<![endif]-->
        <meta name='viewport' content='width=device-width, initial-scale=1.0' />
        <title></title> 


        <style type='text/css'>
        @import url('https://fonts.googleapis.com/css?family=Poppins');
        * {
        margin: 0;
        padding: 0;
        font-family: Poppins, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        border-sizing: border-box;
        }

        img {
        display: inline-block;
        }

        .table-wrapper {
        max-width: 500px;
        margin: 20px auto;
        border-radius: 4px;
        border: 1px solid rgba(0, 0, 0, 0.1);
        min-height: 100px;
        position: relative;
        background: #fff;
        }
        .table-wrapper::before {
        content: ''';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
        background: linear-gradient(to right, #0267c1, #d65108);
        }

        .logo {
        display: flex;
        align-items: center;
        justify-content: center;
        }
        .logo a {
        display: block;
        width: 30px;
        height: 30px;
        }
        .logo img {
        width: 120px;
        }
        .logo .c-name {
        display: inline-block;
        font-weight: 600;
        }

        .thumbs {
        width: 100px;
        margin: auto;
        height: 136px;
        }
        .thumbs img {
        width: 100%;
        }

        .name {
        display: block;
        color: #0267c1;
        font-weight: 600;
        font-size: 1.1rem;
        }

        .hgroup h1 {
        font-size: 20px;
        font-weight: 600;
        color: #333;
        }
        .hgroup h2 {
        font-size: 19px;
        }
        .hgroup p {
        font-size: 15px;
        color: slategrey;
        margin-top: 15px;
        text-align: justify;
        line-height: 25px;
        }

        .items {
        padding: 30px;
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        }

        .item {
        text-align: center;
        padding: 20px;
        }
        .item .icon {
        margin-bottom: 10px;
        }
        .item .icon img {
        width: 60px;
        }
        .item .title {
        margin-bottom: 5px;
        font-size: 16px;
        font-weight: 600;
        }
        .item .subtitle {
        font-size: 13px;
        color: slategrey;
        padding: 1rem;
        }

        .button-wrap {
        text-align: center;
        padding: 2rem;
        }

        a.explore {
        padding: 15px 25px;
        font: inherit;
        background: #0267c1;
        background: linear-gradient(to right, #0267c1, #0280ef);
        border-radius: 50px;
        border: 0;
        color: #fff;
        margin: auto;
        display: inline-block;
        transition: all 0.2s ease-in-out;
        cursor: pointer;
        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.1);
        }

        button.explore:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 10px -7px rgba(0, 0, 0, 0.1);
        }

        footer {
        font-size: 12px;
        color: slategrey;
        text-align: center;
        padding: 30px;
        }

        .rad {
        margin: 0 !important;
        text-align: center !important;
        font-size: 18px !important;
        }

        .raised {
        font-size: 16px;
        color: #777;
        display: block;
        color: steelblue;
        }

        table {
        border: 0;
        width: 100%;
        border-collapse: collapse;
        }
        table td {
        padding: 0;
        }

        .text-center {
        text-align: center;
        }

        .fb {
        height: 30px;
        width: 30px;
        }

        .ig {
        height: 35px;
        width: 35px;
        }

        .top {
        width: 100%;
        text-align: center;
        box-shadow: 0 10px 20px -5px rgba(0, 0, 0, 0.05);
        border-radius: 0 0 50% 50%/1%;
        text-align: center;
        }
        .mobile-button {
        color: #3d3d3d;
        font-family: lato, sans-serif;
        line-height: 1.3em;
        margin: 10px;
        font-size: 14px;
        }
        </style>



        </head>
        <body style='font-family: Poppins, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif; margin: 0;
        padding: 0; border-sizing: border-box;'>	
            <div class='table-wrapper' style='max-width: 500px;
            margin: 20px auto;
            border-radius: 4px;
            border: 1px solid rgba(0, 0, 0, 0.1);
            min-height: 100px;
            position: relative;
            background: #fff;'>
          <table style=' border: 0;
          width: 100%;
          border-collapse: collapse;'>
            <tr>
              <td colspan='4'  style=' padding: 0; padding: 30px 30px 20px; text-align: center;'>
                <div class='logo' style='display: block;
                margin-left: auto;
                margin-right: auto;
                width: 50%;'><img src='".$header."' style='display: inline-block; width:120px !important; height:58px !important' border='0;  '>
                  <div class='c-name' style='display: inline-block;
                  font-weight: 600;'>
            <!--             Creditclan -->
                  </div>
                </div>
              </td>
            </tr>
            <tr>
              <td colspan='4' class='text-center' style='padding: 30px 30px 30px 30px text-align: center;'>
                <div class='hgroup' style=' font-size: 15px;
                color: slategrey;
                margin: 15px;
                text-align: justify;
                line-height: 25px;'>
                    $content
                </div>
              </td>
            </tr>
                $button_row                                      
        <tr>
          <td colspan='4' class='text-center'>
            <footer style='font-size: 12px; text-decoration:none;
            color: slategrey;
            text-align: center;
            padding: 30px;'>
               $footer
          </footer>
          </td>
        </tr>
          </table>
        </div>
        </body>
        </html>";
        return $body;
    }
    public function getButtonOne($button_url,$button_name)
    {
            $button_row = 
            "<tr>
            <td colspan='4' class='text-center'>
            <div class='button-wrap' style='text-align: center;
            padding: 0.8rem; border-radius: 5px;'>
            <button style=' background-color: #468fe3;
            border: none;
            color: white;
            padding: 8px 8px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 10px; border-radius: 5px;'>
              <a  href='".$button_url."' style='font-size:16px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; font-weight:normal; text-align:center; text-decoration: none; display: inline-block; padding: 10px 15px'>
               $button_name
                </a></button>
            </div>
            </td>
        </tr>";
        return $button_row;
       
    }

    public function getButtonTwo($button_url,$button_name,$access_token_)
    {
            
        // $button_row = "<tr>
        // <td colspan='4' class='text-center'>
        // <div class='button-wrap' style='text-align: center;
        // padding: 2rem;'>
        //     <button style='10px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; font-weight:normal; text-align:center; background-color: #2a83e9; text-decoration: none; border: none; -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; display: inline-block;'><a style='text-decoration:none; color: #ffffff; font-size: 18px; letter-spacing: 1px; text-decoration: none;  font-family: Arial, Helvetica, sans-serif;' href='".$button_url. $access_token_."' class='explore'>
        //         $button_name
        //     </a></button>
        // </div>
        // </td>
        //     </tr>";
        // return $button_row ;

        $button_row = 
        "<tr>
        <td colspan='4' class='text-center'>
        <div class='button-wrap' style='text-align: center;
        padding: 1rem; border-radius: 5px;'>
        <button style=' background-color: #468fe3;
        border: none;
        color: white;
        padding: 10px 15px;
        text-align: center;
        text-decoration: none;
        display: inline-block;
        font-size: 10px; border-radius: 5px;'>
          <a  href='".$button_url. $access_token_."' style='font-size:16px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; font-weight:normal; text-align:center; text-decoration: none; display: inline-block; padding: 10px 15px'>
           $button_name
            </a></button>
        </div>
        </td>
        </tr>";
     return $button_row;
    }

}
//http://res.cloudinary.com/africacodes-concepts-limited/image/upload/v1507561173/rldxc3sktikztnfvvs9s.jpg
