<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Lcobucci\JWT\Parser;

use App\Http\Requests;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


class NewAnalyticsController extends Controller
{
    public function getprofileanalyticsdata(Request $request)
    {
		$loan_request_id  = $request->loan_request_id;
		return json_encode($request->request_id);
	}
    public function tests(Request $request)
	{
		$nebs['data']['grades']['passed'] = "1,2,3";
		$nebs = json_decode(json_encode($nebs));
		return $nebs->data->grades->passed;
	  
	
    }   
    public function determineBVNAnalytics($data,$bvn_validation_paystack,$product,$result_age,$result_mobile)
	{
		$grades = [];
		$newGrade = [];
	
		$leaves = [
			'compare_names_with_bvn'=>1,
			'compare_dob'=>2,
			'compare_phone_number'=>3,
			// 'date_of_birth_correct'=>4,
			// 'vanity_number'=>5,
			// 'mobile_validation_done'=>6,
		];
		$leaves = array_values($leaves);
		$runBVNAnalytics = $this->runBVNAnalytics($data,$bvn_validation_paystack,$product,$result_age,$result_mobile);
	
		foreach($leaves as $key=>$leafId)
		{
			$grades[$leafId] = $runBVNAnalytics["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}

	
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
	
	
    }  
    public function runBVNAnalytics($data,$bvn_validation_paystack,$product,$result_age,$result_mobile)
	{
        $total = 0;
        $leaves_grade = [];
       
        if(!empty($bvn_validation_paystack[0]))
        {
            // var_dump(json_decode($bvn_validation_paystack[0]->PAYSTACK_RESPONSE));
            // die();
            $paystack_response = json_decode($bvn_validation_paystack[0]->PAYSTACK_RESPONSE);
            $paystack_response = $paystack_response->data;
            $first_name =$paystack_response->first_name;
            $last_name = $paystack_response->last_name;

            if(stripos($data['LEGAL_NAME'],$first_name) !== false || stripos($data['LEGAL_NAME'],$last_name) !== false)
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                    $leaves_grade [] = "failed";
            }	
            ////- Compare DOB

            $dob = $data['BIRTH_DAY'] . '-' . $data['BIRTH_MONTH'] . '-' . $data['BIRTH_YEAR'];		
            $user_dob = date("Y-m-d", strtotime($dob));
            
            // $bvn_data = $paystack_response;
            $bvn_dob = date("Y-m-d", strtotime( $paystack_response->formatted_dob));
            if($user_dob ==  $bvn_dob )
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                    $leaves_grade [] = "failed";
            }

            // - Compare Phone number
            $formatted_number = str_replace("+234","0",$paystack_response->mobile);

            if($formatted_number == $data['PHONE'])
            {
                $total++;  $leaves_grade [] = "passed";
            }
            else
            {
                    $leaves_grade [] = "failed";
            }


        }
      
        $result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;
	} 
	public function getToken($token)
    {
        $parser = new Parser;
        $parsedToken = $parser->parse($token);
        $lender_id = $parsedToken->getClaims()['lender_id'];   
        return $lender_id;  
    }
    public function determineProfileAnalytics($data,$suspicious_names,$product,$result_age,$result_mobile,$lender)
	{		
		$grades = [];
		$newGrade = [];
	
		$leaves = [
			'suspicious_name'=>1,
			'gibberish_name'=>2,

			'within_age_range'=>3,
			'date_of_birth_correct'=>4,

			'vanity_number'=>5,
			'mobile_validation_done'=>6,

			'name_found_in_email'=>7,
			'common_mail_extension'=>8,
			'email_confirmed'=>9,
			'email_validation_done'=>10,

			'customer_home_state_allowed'=>11,
			'preferred_gender'=>12,

			'id_card_attached'=>13,
			'selfie_taken'=>14,

			'marital_status_allowed'=>15,
			'number_of_dependants_allowed'=>16,
			'number_of_children_allowed'=>17,
			'state_of_origin_allowed'=>18,
			'nok_relationship_allowed'=>19,
			'nok_email_verified'=>20,
			'nok_phone_verified'=>21,
			
			'home_valid_gps_address'=>22,
			'home_address_state_allowed'=>23,
			'home_within_allowed_ownership_status'=>24,
			'home_within_allowed_years_of_residence'=>25,
			'home_address_attached'=>26,
			'home_within_exclusion_country'=>27,
			'home_paying_above_minimum_allowed_rent'=>28,
			'home_premium_area'=>29,

			'office_valid_gps'=>30,
			'office_address_state_allowed'=>31,
			'office_premium_area'=>32,

			'monthly_expense_to_income_ratio_below_specified'=>33,
			'monthly_debt_to_income_ratio_below_specified'=>34,
			'monthly_deductions_percent_above_specified'=>35,
			'bonus_to_gross_annual_percent_above_specified'=>36,
			'rent_to_gross_annual_percent_above_specified'=>37,
			'school_fees_to_income_accepted'=>38,
			'feeding_to_income_accepted'=>39,
			'transport_to_income_accepted'=>40,
			'spouse_to_income_accepted'=>41,


			'net_gross_value_above_accepted'=>42,
			'net_monthly_income_above_accepted'=>43,
			'monthly_deductions_percent_above_specified_income'=>44,
			'bonus_to_gross_annual_percent_above_specified_income'=>45,
			'statement_attached'=>46,
			'payslip_attached'=>47,

			'total_expense_accepted'=>48,
			'rent_expense_accepted'=>49,
			'transport_expense_accepted'=>50,
			'school_fees_expense_accepted'=>51,
			'feeding_expense_accepted'=>52,
			'spouse_earning_accepted'=>53,
			'expense_verified'=>54,

			'work_popular_company'=>55,
			'work_allowed'=>56,
			'work_sector_allowed'=>57,
			'work_excluded_company'=>58,//worng
			'work_years_allowed'=>59,
			'work_email_verified'=>60,
			// 'is_number_correct'=>61,
			'qualification_document_presented'=>61,
			'within_accepted_school'=>62,
			'yrs_since_grad_accepted'=>63,
			'min_qualification_accepted'=>64,
			'other_qualifications_accepted'=>65,

			// 'address_changed'=>66,
			// 'age_changed'=>67,
			// 'name_changed'=>68,
			// 'mobile_changed'=>69,
			// 'email_changed'=>70,
			// 'state_changed'=>71,
			// 'gender_changed'=>72,		
			'work_designation_allowed'=>73,
			//'is_number_correct'=>​74,
		];
		$leaves['is_number_correct'] = 74;
		$leaves = array_values($leaves);
		$runProfileAnalytics = $this->runProfileAnalytics($data,$suspicious_names,$product,$result_age,$result_mobile);
	
		foreach($leaves as $key=>$leafId)
		{
			$grades[$leafId] = $runProfileAnalytics["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}

	
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
	}
	public function runProfileAnalytics($data,$suspicious_names,$product,$result_age,$result_mobile)
	{
       
		$total = 0;
		
			$b = [];
			if(!empty($suspicious_names)){
				foreach($suspicious_names as $suspicious_name){
					array_push($b,strtolower($suspicious_name['name']));
				}
			}	
			$fullname = explode(" ",$data["LEGAL_NAME"]);
			//1
			if(!empty($fullname) && !empty($suspicious_names)){ 
				foreach($fullname as $name){
					if(in_array(strtolower($name),$b)){	
						$response_suspicious_names = "true";
							// $leaves_grade [] = "failed";
							$leaves_grade[] = "failed";
						break;
					}
					else
					{		
							$response_suspicious_names = "false";
								  
					}
				} 
				if($response_suspicious_names == "false")
				{
					$total++;  //$leaves_grade [] = "passed";
					$leaves_grade[] = "passed";
				}
		  
			}
			else
			{
				$total++;  //$leaves_grade [] = "passed";
					$leaves_grade[] = "passed";
			}
			
			//2
			$result = [];
			$gib_name = $data['LEGAL_NAME'];
			for($i = 0; $i < strlen( $gib_name ); $i++)
			{
				if ( isset( $result[ $gib_name[ $i ] ] ) )
				{
						$result[ $gib_name[ $i ] ]++;
				} else {
						$result[ $gib_name[ $i ] ] = 1;
				}
			}
			$gibberish =  ( max( $result ) / strlen( $gib_name ) * 100 >= 33 ) ? false : true;	
			$response_gibberish_name = $gibberish == false ? "true":"false";
			if($response_gibberish_name == "true")
			{
					$leaves_grade [] = "failed";
			}
			else
			{
				$total++;  $leaves_grade [] = "passed";		
			}
		//3
		$age = date("Y") - $data['BIRTH_YEAR'];
					
			$response_within_age_range = ($age >= $product['MIN_AGE'] && $age <= $product['MAX_AGE']) ? "true":"false";
			if($response_within_age_range == "true")
			{
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
					$leaves_grade [] = "failed";
			}			
			//4	
			//date of birth
			$dob = $data['BIRTH_DAY'] . '-' . $data['BIRTH_MONTH'] . '-' . $data['BIRTH_YEAR'];		
			$user_dob = date("Y-m-d", strtotime($dob));
			// $bvn_age_score=false;
			//condition for comparing bvn age 
			if(!empty($result_age['PAYSTACK_RESPONSE'])){
				$bvn = json_decode($result_age['PAYSTACK_RESPONSE'],true);
				$bvn_data = $bvn['data'];
				$bvn_dob = date("Y-m-d", strtotime( $bvn_data['dob'] ));
				if( $bvn_dob ==  $user_dob){
					$response_date_of_birth_correct =  "true";
					$total++;  $leaves_grade [] = "passed";	
				} 
				else
				{
					$response_date_of_birth_correct =  "false";
						$leaves_grade [] = "failed";
				}
			}	
			else
			{
				$response_date_of_birth_correct =  "no data";
					$leaves_grade [] = "failed";
			}
			//5		
			$number=str_split($data['PHONE']);
			$unique_digits_count = count(array_count_values($number));
			$response_vanity_number = $unique_digits_count <= 5 ? "true":"false";
			if($response_vanity_number == "true")
			{
				  $leaves_grade [] = "passed";
			}
			else
			{
				$total++; $leaves_grade [] = "failed";
			}
			//dd($response_vanity_number);			
			//6	
			$validation_done = explode(',',$data['VALIDATION_DONE']);	
			$response_validation_done = $validation_done[0]=="1" ? "true":"false";
			if($response_validation_done == "true")
			{
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
					$leaves_grade [] = "failed";
			}
			
		
			//7				
			$explodedNames = explode(" ",$data['LEGAL_NAME']);
				
			foreach($explodedNames as $explodedName)
			{
				if(stripos($data['EMAIL'],$explodedName) !== false)
				{
					$response_name_found_in_email ="true";
					$total++;  $leaves_grade [] = "passed";
					break;
				}

			}
			if(empty($response_name_found_in_email)) 
			{
				$response_name_found_in_email ="false";
					$leaves_grade [] = "failed";
			}
		
			//8
			if($this->strpos_array($data['EMAIL'],["gmail.com","yahoo.com","hotmail.com","outlook.com"]) === true)
			{
				$response_common_mail_extension ="true";
				$total++;  $leaves_grade [] = "passed";	
			}
			else
			{
				$response_common_mail_extension ="false";
					$leaves_grade [] = "failed";
			}
			//.9		
			$validation_done = explode(',',$data['VALIDATION_DONE']);
			 
			if($validation_done[2]=="1"){
				$response_validation_done ="true";	
				$total++;  $leaves_grade [] = "passed";
			}
			else 
			{
				$response_validation_done ="false";
					$leaves_grade [] = "failed";
			}
			//10
			$validation_done = explode(',',$data['VALIDATION_DONE']);
			 
			if($validation_done[2]=="1"){
				$response_validation_done ="true";	
				$total++;  $leaves_grade [] = "passed";
			}
			else 
			{
				$response_validation_done ="false";
					$leaves_grade [] = "failed";
			}
			//11			
			$allowed_states = $product['ALLOW_ADDRESS_STATES'];	
			if(in_array($data['HOME_STATE'],$allowed_states)){
				$response_customer_home_state_allowed ="true";
				$total++;  $leaves_grade [] = "passed";	
			}	
			else 
			{
				$response_customer_home_state_allowed ="false";
					$leaves_grade [] = "failed";
			}
			//12
			$allowed_gender = $product['PREFERRED_BORROWER_GENDER'];		
			// $allowed_gender = explode(',',$product['PREFERRED_BORROWER_GENDER']);
			//condition for checking if customer gender is allowed
			if(in_array($data['GENDER'],$allowed_gender)){
				$response['gender']['preferred_gender'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else  
			{
				$response['gender']['preferred_gender'] ="false";
					$leaves_grade [] = "failed";
			}
		//13	
		if(!empty($data['ATTACHMENT1_IDCARD'])){
				$response['identity']['id_card_attached'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else  
			{
				$response['identity']['id_card_attached'] ="false";
					$leaves_grade [] = "failed";
			}
			//14		
			if(!empty($data['PASSPORT_ATTACHMENT_URL'])){
				$response['identity']['selfie_taken'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['identity']['selfie_taken'] ="false";
					$leaves_grade [] = "failed";
			}
			
			//15
			$allowed_marital_status = $product['ALLOW_MARITAL_STATUS'];
			// $allowed_marital_status = explode(',',$product['ALLOW_MARITAL_STATUS']);
			if(in_array($data['MARITAL_STATUS'],$allowed_marital_status))
			{
				$total++;  $leaves_grade [] = "passed";
				$response['marital_status']['marital_status_allowed'] ="true";
			}	
			else
			{
				$response['marital_status']['marital_status_allowed'] ="false";	
					$leaves_grade [] = "failed";
			}	
			//16
			if(($data['NUMBER_OF_DEPENDANTS'] >= $product['MIN_DEPENDANTS']) && ($data['NUMBER_OF_DEPENDANTS'] <= $product['MAX_DEPENDANTS']))
			{
				$response['marital_status']['number_of_dependants_allowed'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['marital_status']['number_of_dependants_allowed'] ="false";
					$leaves_grade [] = "failed";
			}
			
			//17
			if(($data['NUMBER_OF_CHILDREN'] >= $product['MIN_NO_OF_CHILDREN']) && ($data['NUMBER_OF_CHILDREN'] <= $product['MAX_NO_OF_CHILDREN']))
			{
					$response['marital_status']['number_of_children_allowed'] ="true";
					$total++;  $leaves_grade [] = "passed";
			}
			else
			{
					$response['marital_status']['number_of_children_allowed'] ="false";
						$leaves_grade [] = "failed";
			}
			//18			
			$allowed_state_of_origin = $product['ALLOWED_STATE_OF_ORIGIN'];
			// $allowed_state_of_origin = explode(',',$product['ALLOWED_STATE_OF_ORIGIN']);	
			//condition for checking if user state is allowed
			if(in_array($data['STATE_OF_ORIGIN'],$allowed_state_of_origin)){
				$response['state_of_origin']['state_of_origin_allowed'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['state_of_origin']['state_of_origin_allowed'] ="false";
					$leaves_grade [] = "failed";
			}
			
			//19
			$allowed_nok= $product['ALLOWED_NOK'];
			//$allowed_nok= explode(',',$product['ALLOWED_NOK']);	
			if(in_array($data['NOK_RELATIONSHIP'],$allowed_nok))
			{
				$response['nok']['nok_relationship_allowed'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}	
			else
			{
				$response['nok']['nok_relationship_allowed'] ="false";
					$leaves_grade [] = "failed";
			}	
			//20	
			if($data['NOK_EMAIL_VERIFIED'] == 1){
				$response['nok']['email_verified'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['nok']['email_verified'] ="false";
					$leaves_grade [] = "failed";
			}
			
		//21
			if($data['NOK_PHONE_VERIFIED'] == 1){
				$response['nok']['phone_verified'] ="true";
				$total++;  $leaves_grade [] = "passed";		
			}
			else
			{
				$response['nok']['phone_verified'] ="false";
					$leaves_grade [] = "failed";
			}
			
			//22
			if(!empty($data['HOME_ADDRESS']))
			{
				$geo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyDo9iJ7vED5HmaBJQcqrpqcQlxEo2jlRqA&address='.urlencode($data['HOME_ADDRESS']).'&sensor=false',false);
			}
			else
			{
				$geo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyDo9iJ7vED5HmaBJQcqrpqcQlxEo2jlRqA&address='.urlencode("ssbhddkdi").'&sensor=false',false);
			}
			
			//,stream_context_create($arrContextOptions)
			$geo = json_decode($geo, true); // Convert the JSON to an array

			if (isset($geo['status']) && ($geo['status'] == 'OK')) {
				$response['home_address']['valid_gps_address'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['home_address']['valid_gps_address'] ="false";
					$leaves_grade [] = "failed";
			}
			//23
			$allowed_states = $product['ALLOW_ADDRESS_STATES_HOME'];	
			// $allowed_states = explode(',',$product['ALLOW_ADDRESS_STATES_HOME']);	
			//condition for checking if state with that adrdress is allowed
			if(in_array($data['HOME_STATE'],$allowed_states)){
				$response['home_address']['address_state_allowed'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['home_address']['address_state_allowed'] ="false";
					$leaves_grade [] = "failed";
			}
		
			//24
			$allowed_noc = $product['ALLOWED_OWNERSHIP_STATUS'];
			// $allowed_noc = explode(',',$product['ALLOWED_OWNERSHIP_STATUS']);	
			if(in_array($data['NOC'],$allowed_noc))
			{
				$response['home_address']['within_allowed_ownership_status'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['home_address']['within_allowed_ownership_status'] ="false";
					$leaves_grade [] = "failed";
			}
			//25
			if($data['RESIDENT_YEARS'] >= $product['ALLOWED_RESIDENT_YEARS']){
				$response['home_address']['within_allowed_years_of_residence'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['home_address']['within_allowed_years_of_residence'] ="false";
					$leaves_grade [] = "failed";
			}
			//26
			if(!empty($data['HOME_ATTACHMENT']))
			{
				$response['home_address']['address_attached'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else{
				$response['home_address']['address_attached'] ="false";
					$leaves_grade [] = "failed";
			}
			//27
			$excluded_coutries = $product['EXCLUDED_COUNTRIES']; 	
			// $excluded_coutries = explode(',',$product['EXCLUDED_COUNTRIES']);
			if(in_array($data['HOME_COUNTRY'],$excluded_coutries)){
				$response['home_address']['within_exclusion_countries'] ="true";

					$leaves_grade [] = "failed";
			}
			else
			{
				$total++;  $leaves_grade [] = "passed";
				$response['home_address']['within_exclusion_countries'] ="false";
				
			}
			//28				
			if($data['MONTHLY_RENT_EXPENSES'] > $product['ALLOWED_MONTHLY_RENT']){
				$response['home_address']['paying_above_minimum_allowed_rent'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else{
				$response['home_address']['paying_above_minimum_allowed_rent'] ="false";
					$leaves_grade [] = "failed";
			}
			//29
			// $location_premium_factor = $product['LOCATION_PREMIUM_FACTOR'];	
			$location_premium_factor = explode(',',$product['LOCATION_PREMIUM_FACTOR']);
			if(in_array($data['HOME_LGA'],$location_premium_factor)){
				$response['home_address']['premium_area'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['home_address']['premium_area'] ="false";
					$leaves_grade [] = "failed";
			}
			//30
			// $geo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyDo9iJ7vED5HmaBJQcqrpqcQlxEo2jlRqA&address='.urlencode($data['WORK_ADDRESS']).'&sensor=false',false);

			if(!empty($data['WORK_ADDRESS']))
			{
				$geo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyDo9iJ7vED5HmaBJQcqrpqcQlxEo2jlRqA&address='.urlencode($data['WORK_ADDRESS']).'&sensor=false',false);
			}
			else
			{
				$geo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyDo9iJ7vED5HmaBJQcqrpqcQlxEo2jlRqA&address='.urlencode("ssbhddkdi").'&sensor=false',false);
			}
			//,stream_context_create($arrContextOptions)
			$geo = json_decode($geo, true); // Convert the JSON to an array
			if (isset($geo['status']) && ($geo['status'] == 'OK')) {
				$response['office_address']['valid_gps'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['office_address']['valid_gps'] ="false";
					$leaves_grade [] = "failed";
			}
			//31
			$allowed_states = $product['ALLOW_OFFICE_ADDRESS_STATES'];	
			// $allowed_states = explode(',',$product['ALLOW_OFFICE_ADDRESS_STATES']);		
			//condition for checking if user state is allowed
			if(!empty($allowed_states))
			{
				if(in_array($data['WORK_STATE_ID'],$allowed_states))
				{
					$response['office_address']['office_address_state_allowed'] ="true";
					$total++;  $leaves_grade [] = "passed";
				}
				else{
					$response['office_address']['office_address_state_allowed'] ="false";
						$leaves_grade [] = "failed";
				}
			}else{
				$response['office_address']['office_address_state_allowed'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			//32
			//$office_premium_factor = $product['OFFICE_PREMIUM_FACTOR'];
			$office_premium_factor = explode(',',$product['OFFICE_PREMIUM_FACTOR']);
			if(in_array($data['WORK_STATE_ID'],$office_premium_factor)){
				$response['office_address']['premium_area'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['office_address']['premium_area'] ="false";
					$leaves_grade [] = "failed";
			}		
			
		//33
		$net_monthly_income = !empty($data['NET_MONTHLY_INCOME']) ? $data['NET_MONTHLY_INCOME'] : 0.000001;
			$total_expenses = $data['MONTHLY_RENT_EXPENSES'] + $data['MONTHLY_TEL_INTERNET'] + $data['MONTHLY_TRANSPORT'];

			if($total_expenses/$net_monthly_income <= $product['MAX_EXPENSE_INCOME_RATIO']){
				$response['income_ratios']['monthly_expense_to_income_ratio_below_specified'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income_ratios']['monthly_expense_to_income_ratio_below_specified'] = "false";
					$leaves_grade [] = "failed";
			}

			//34
			$debt_to_income_ratio = ($data['MONTHLY_DEBT']/$net_monthly_income);
			if($debt_to_income_ratio <= $product['MAX_DEBT_INCOME_RATIO'])
			{
				$response['income_ratios']['monthly_debt_to_income_ratio_below_specified'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income_ratios']['monthly_debt_to_income_ratio_below_allowed'] = "false";
					$leaves_grade [] = "failed";
			}
			//35
			$gross_annual_income = !empty($data['GROSS_ANNUAL_INCOME']) ? $data['GROSS_ANNUAL_INCOME'] : 0.00001;
			$monthly_deductions_to_gross_percentage = (($data['GROSS_ANNUAL_INCOME'] - ($data['NET_MONTHLY_INCOME'] * 12))/$gross_annual_income) * 100;
			if($monthly_deductions_to_gross_percentage >= $product['MIN_MONTHLY_DEDUCTIONS_TO_GROSS_PERCENTAGE']){
				$response['income_ratios']['monthly_deductions_percent_above_specified'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income_ratios']['monthly_deductions_percent_above_specified'] = "false";
					$leaves_grade [] = "failed";
			}
			//36
			$bonus_to_gross_annual = ($data['BONUS']/$gross_annual_income) * 100; 
			if($bonus_to_gross_annual  >= $product['MIN_BONUS_TO_GROSS_ANNUAL_PERCENTAGE'])
			{
				$response['income_ratios']['bonus_to_gross_annual_percent_above_specified'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income_ratios']['bonus_to_gross_annual_percent_above_specified'] = "false";
					$leaves_grade [] = "failed";
			}
			
			//37			
			$rent_to_gross_percentage = (($data['MONTHLY_RENT_EXPENSES'] * 12)/$gross_annual_income) * 100 ;
			if(($rent_to_gross_percentage  >= $product['MIN_RENT_TO_GROSS_ANNUAL_PERCENTAGE']) && ($rent_to_gross_percentage  <= $product['MAX_RENT_TO_GROSS_ANNUAL_PERCENTAGE'])){
				$response['income_ratios']['rent_to_gross_annual_percent_above_specified'] = "true";
				$total++;  $leaves_grade [] = "passed";

			} 		   
			else
			{
				$response['income_ratios']['rent_to_gross_annual_percent_above_specified'] = "false";
					$leaves_grade [] = "failed";
			}
			//38		
			$school_fees_to_income = ($data['SCHOOL_FEES_EXPENSES']/$net_monthly_income);
			if(($school_fees_to_income  >= $product['MIN_SCHOOL_FEES_TO_INCOME']) && ($school_fees_to_income  <= $product['MAX_SCHOOL_FEES_TO_INCOME'])){
				$response['income_ratios']['school_fees_to_income_accepted'] = "true";
				$total++;  $leaves_grade [] = "passed";
			} 
			else
			{
				$response['income_ratios']['school_fees_to_income_accepted'] = "false";
					$leaves_grade [] = "failed";
			}  
			//39			
			$feeding_to_income = ($data['FEEDING_EXPENSES']/$net_monthly_income);
			if(($feeding_to_income  >= $product['MIN_FEEDING_TO_INCOME']) && ($feeding_to_income  <= $product['MAX_FEEDING_TO_INCOME'])){
				$response['income_ratios']['feeding_to_income_accepted'] = "true";
				$total++;  $leaves_grade [] = "passed";
			} 
			else
			{
				$response['income_ratios']['feeding_to_income_accepted'] = "false";
					$leaves_grade [] = "failed";
			}
			//40		
			$transport_to_income = ($data['MONTHLY_TRANSPORT']/$net_monthly_income);
			if(($transport_to_income  >= $product['MIN_TRANSPORT_TO_INCOME']) && ($transport_to_income  <= $product['MAX_TRANSPORT_TO_INCOME'])){
				$response['income_ratios']['transport_to_income_accepted'] = "true";
				$total++;  $leaves_grade [] = "passed";
			} 
			else
			{
				$response['income_ratios']['transport_to_income_accepted'] = "false";
					$leaves_grade [] = "failed";
			}
			//41		
			$spouse_to_income = ($data['MONTHLY_TRANSPORT']/$net_monthly_income);
			if(($spouse_to_income  >= $product['MIN_SPOUSE_TO_INCOME']) && ($spouse_to_income  <= $product['MAX_SPOUSE_TO_INCOME'])){
				$response['income_ratios']['spouse_to_income_accepted'] = "true";
				$total++;  $leaves_grade [] = "passed";
			} 
			else
			{
				$response['income_ratios']['spouse_to_income_accepted'] = "false";
					$leaves_grade [] = "failed";
			}   
			//42
			if(!empty($data['NET_GROSS_VALUE']))
			{
				if($data['NET_GROSS_VALUE'] >= $product['ALLOW_NET_GROSS_VALUE']){
					$response['income']['net_gross_value_above_accepted'] = "true";
					$total++;  $leaves_grade [] = "passed";
				}
				else
				{
					$response['income']['net_gross_value_above_accepted'] = "false";
						$leaves_grade [] = "failed";
				}

			}		
			else
			{
				$response['income']['net_gross_value_above_accepted'] = "false";
					$leaves_grade [] = "failed";
			}
			//43		
			if($data['NET_MONTHLY_INCOME'] >= $product['ALLOWED_MONTHLY_INCOME']){
				$response['income']['net_monthly_income_above_accepted'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income']['net_monthly_income_above_accepted'] = "false";
					$leaves_grade [] = "failed";
			}
			//44
			$monthly_deductions_to_gross_percentage =(($data['GROSS_ANNUAL_INCOME'] - ($data['NET_MONTHLY_INCOME'] * 12))/$gross_annual_income) * 100;
			if($monthly_deductions_to_gross_percentage >= $product['MIN_MONTHLY_DEDUCTIONS_TO_GROSS_PERCENTAGE_INCOME']){
				$response['income']['monthly_deductions_percent_above_specified_income'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income']['monthly_deductions_percent_above_specified_income'] = "false";
					$leaves_grade [] = "failed";
			}
			//45
			$bonus_to_gross_annual = ($data['BONUS']/$gross_annual_income) * 100; 
			//dd($bonus_to_gross_annual);
			if($bonus_to_gross_annual  >= $product['MIN_BONUS_TO_GROSS_ANNUAL_PERCENTAGE_INCOME']){	
				$response['income']['bonus_to_gross_annual_percent_above_specified_income'] = "true";	
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income']['bonus_to_gross_annual_percent_above_specified_income'] = "false";
					$leaves_grade [] = "failed";
			}
			//46
			if(!empty($data['NO_OF_BANK_STATEMENTS']) && $data['NO_OF_BANK_STATEMENTS'] != null){
				$response['income']['statement_attached'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income']['statement_attached'] = "false";
					$leaves_grade [] = "failed";
			}
			//47
			if(!empty($data['NO_OF_PAYSLIPS']) && $data['NO_OF_PAYSLIPS'] != null)
			{
				$response['income']['payslip_attached'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['income']['payslip_attached'] = "false";
					$leaves_grade [] = "failed";
			}
			//48		
			$total_expenses = $data['MONTHLY_RENT_EXPENSES'] + $data['MONTHLY_TEL_INTERNET'] + $data['MONTHLY_TRANSPORT'];

			if(($total_expenses >= $product['MIN_TOTAL_EXPENSES']) && ($total_expenses <= $product['MAX_TOTAL_EXPENSES'])){
				$response['expenses']['total_expense_accepted'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['expenses']['total_expense_accepted'] ="false";
					$leaves_grade [] = "failed";
			}		
			//49	
			if(($data['MONTHLY_RENT_EXPENSES'] >= $product['MIN_MONTHLY_RENT_EXPENSE']) && ($data['MONTHLY_RENT_EXPENSES'] <= $product['MAX_MONTHLY_RENT_EXPENSE'])){
				$response['expenses']['rent_expense_accepted'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['expenses']['rent_expense_accepted'] ="false";
					$leaves_grade [] = "failed";
			}			
			//50
			if(($data['MONTHLY_TRANSPORT'] >= $product['MIN_MONTHLY_TRANSPORT']) && ($data['MONTHLY_TRANSPORT'] <= $product['MAX_MONTHLY_TRANSPORT'])){
				$response['expenses']['transport_expense_accepted'] ="true";
				$total++;  $leaves_grade [] = "passed";
			} 
			else
			{
				$response['expenses']['transport_expense_accepted'] ="false";
					$leaves_grade [] = "failed";
			}			
			//51
			if(($data['SCHOOL_FEES_EXPENSES'] >= $product['MIN_SCHOOL_FEES_EXPENSE']) && ($data['SCHOOL_FEES_EXPENSES'] <= $product['MAX_SCHOOL_FEES_EXPENSE'])){
				$response['expenses']['school_fees_expense_accepted'] ="true";
				$total++;  $leaves_grade [] = "passed";
			} 
			else
			{
				$response['expenses']['school_fees_expense_accepted'] ="false";
					$leaves_grade [] = "failed";
			}		
			//52
			if(($data['FEEDING_EXPENSES'] >= $product['MIN_FEEDING_EXPENSES']) && ($data['FEEDING_EXPENSES'] <= $product['MAX_FEEDING_EXPENSES'])){
				$response['expenses']['feeding_expense_accepted'] ="true";
				$total++;  $leaves_grade [] = "passed";
			}  
			else
			{
				$response['expenses']['feeding_expense_accepted'] ="false";
					$leaves_grade [] = "failed";
			}			
			//53
			if(!empty($data['SPOUSE_INCOME']))
			{
				if(($data['SPOUSE_INCOME'] >= $product['MIN_SPOUSE_INCOME']) && ($data['SPOUSE_INCOME'] <= $product['MAX_SPOUSE_INCOME'])){
					$response['expenses']['spouse_earning_accepted'] ="true";
					$total++;  $leaves_grade [] = "passed";
				} 
				else
			{
				$response['expenses']['spouse_earning_accepted'] ="false";
					$leaves_grade [] = "failed";
			}
			}				 
			else
			{
				$response['expenses']['spouse_earning_accepted'] ="false";
					$leaves_grade [] = "failed";
			}
			//54	
			if(!empty($data['EXPENSE_VERIFIED']))
			{
				if($data['EXPENSE_VERIFIED'] == 0){
					$response['expenses']['expense_verified'] ="true";
					$total++;  $leaves_grade [] = "passed";
				}
				else
				{
					$response['expenses']['expense_verified'] ="false";
						$leaves_grade [] = "failed";
				}
			}				
			else
			{
				$response['expenses']['expense_verified'] ="false";
					$leaves_grade [] = "failed";
			}
			//55		
			$popular_companies = ['GTB','UBA'];			
			if(in_array($data['COMPANY_OF_WORK_ID'],$popular_companies)){
				$response['work']['popular_company'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['work']['popular_company'] = "false";
					$leaves_grade [] = "failed";
			}
						
			// $allowed_occupation = explode(',',$product['PREFERRED_BORROWER_OCCUPATION']);
			//56
			$allowed_occupation = $product['PREFERRED_BORROWER_OCCUPATION'];
				
			if(in_array($data['OCCUPATION_ID'],$allowed_occupation)){
				$response['work']['work_allowed'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['work']['work_allowed'] = "false";
					$leaves_grade [] = "failed";
			}
			//57
			// $allowed_sector = explode(',',$product['PREFERRED_OCCUPATION_SECTOR']);	
			$allowed_sector = $product['PREFERRED_OCCUPATION_SECTOR'];	
			if(in_array($data['OCCUPATION_ID'],$allowed_sector)){
				$response['work']['work_sector_allowed'] = "true";
				$total++;  $leaves_grade [] = "passed";

			}
			else
			{
				$response['work']['work_sector_allowed'] = "false";
					$leaves_grade [] = "failed";	
			}				
			
			//checkagain			
		
			//58
			//checkagain		
			if($data['OCCUPATION_ID']!=3 && $data['OCCUPATION_ID']==7 && $data['OCCUPATION_ID']!=20){

				$excluded_companies = explode(',',$lender['EXCLUDED_COMPANIES']);
				//$excluded_companies = $lender['EXCLUDED_COMPANIES'];		
				//condition for checking for excluding companies
				if(!empty($excluded_companies)){
					if(in_array($data['COMPANY_ID'],$excluded_companies)){
						$response['work']['excluded_company'] = "true";
						$leaves_grade [] = "failed";
					}
					else
					{
						$response['work']['excluded_company'] = "false";
							$leaves_grade [] = "failed";
							$total++;  $leaves_grade [] = "passed";		
					}				
				}
				else
				{
					$response['work']['excluded_company'] = "false";
					$total++;  $leaves_grade [] = "passed";	
				}		
			}
			else
			{
				$response['work']['excluded_company'] = "false";
				$leaves_grade [] = "failed";
			}
			//59
			//checkagain		
			if($data['OCCUPATION_ID']!=3 && $data['OCCUPATION_ID']==7 && $data['OCCUPATION_ID']!=20){			
				if(date('Y')-$data['WORK_END_DATE'] >= $product['ALLOWED_WORK_YEARS'])
				{
					$response['work']['work_years_allowed'] = "true";
					$total++;  $leaves_grade [] = "passed";
				}
				else
				{
					$response['work']['work_years_allowed'] = "false";	
					$leaves_grade [] = "failed";		
				}
			}
			else
			{
				$response['work']['work_years_allowed'] = "false";
				$leaves_grade [] = "failed";
			}
			//60
			//checkagain		
			if($data['OCCUPATION_ID']==1){
				if($data['WORK_EMAIL_VERIFIED']==1){
					$response['work']['email_verified'] = "true";
					$total++;  $leaves_grade [] = "passed";
				}	
				else
				{
					$response['work']['email_verified'] = "false";
						$leaves_grade [] = "failed";
				}					
			}
			else
			{
				$response['work']['email_verified'] = "false";
				$leaves_grade [] = "failed";
			}
			
			//61
			if(!empty($product["QUALIFYING_DOCUMENTS"]))
			{
				$qdocs = explode(',',$product["QUALIFYING_DOCUMENTS"]);
				if(in_array(1016,$qdocs)){	
					$response['education']['qualification_document_presented'] = "true";	
					$total++;  $leaves_grade [] = "passed";		
				}
				else
				{
					$response['education']['qualification_document_presented'] = "false";
						$leaves_grade [] = "failed";
				}
			}		
			else
			{
				$response['education']['qualification_document_presented'] = "false";
					$leaves_grade [] = "failed";
			}
			//62
			$accepted_schools = explode(',',$product['ACCEPTED_SCHOOLS']);
			//$accepted_schools = $product['ACCEPTED_SCHOOLS'];
			if(in_array($data['EDUCATION_INSTITUTION'],$accepted_schools))
			{
				$response['education']['within_accepted_school'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['education']['within_accepted_school'] = "false";
					$leaves_grade [] = "failed";
			}				
			///63
			$years_since_graduation = date('Y') - $data['QUALIFICATION_YEAR'];
			if($years_since_graduation >= $product['MIN_YRS_SINCE_GRADUATION'])
			{
				$response['education']['yrs_since_grad_accepted'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['education']['yrs_since_grad_accepted'] = "false";
					$leaves_grade [] = "failed";
			}	
			//64	

			// $minimum_qualification = explode(',',$product['MIN_QUALIFICATION']);
			$minimum_qualification = $product['MIN_QUALIFICATION'];
			if(in_array($data['EDUCATION_QUALIFICATION'],$minimum_qualification))
			{
				$response['education']['min_qualification_accepted'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['education']['min_qualification_accepted'] = "false";
					$leaves_grade [] = "failed";
			}
			//65
			// $minimum_qualification = explode(',',$product['MIN_QUALIFICATION']);	
			$minimum_qualification = $product['MIN_QUALIFICATION'];	
			if(in_array($data['HAS_OTHER_QUALIFICATIONS'],$minimum_qualification))
			{
				$response['education']['other_qualifications_accepted'] = "true";
				$total++;  $leaves_grade [] = "passed";
			}
			else
			{
				$response['education']['other_qualifications_accepted'] = "false";
					$leaves_grade [] = "failed";
				
			}
			
		
			// if($data['ADDRESS_UPDATE_COUNT'] > 1)
			// {
			// 	$response['change_frequency']['address_changed'] ="true";
			// 		$leaves_grade [] = "failed";
			// }
			// else
			// {
			// 	$response['change_frequency']['address_changed'] ="false";
			// 	$total++;  $leaves_grade [] = "passed";
			// }
		
			// if($data['AGE_UPDATE_COUNT'] > 1)
			// {
			// 	$response['change_frequency']['age_changed'] ="true";
			// 		$leaves_grade [] = "failed";
			// }
			// else
			// {
			// 	$response['change_frequency']['age_changed'] ="false";
			// 	$total++;  $leaves_grade [] = "passed";
			// }	

		
			// if($data['NAME_UPDATE_COUNT'] > 1)
			// {
			// 	$response['change_frequency']['name_changed'] ="true";
			// 		$leaves_grade [] = "failed";
			// }
			// else
			// {
			// 	$response['change_frequency']['name_changed'] ="false";
			// 	$total++;  $leaves_grade [] = "passed";
			// }	
		
			// if(!empty($data['MOBILE_UPDATE_COUNT']))
			// {
			// 	if($data['MOBILE_UPDATE_COUNT'] > 1)
			// 	{
			// 		$response['change_frequency']['mobile_changed'] ="true";
			// 			$leaves_grade [] = "failed";
			// 	}
			// 	else
			// 	{
			// 		$response['change_frequency']['mobile_changed'] ="false";
			// 		$total++;  $leaves_grade [] = "passed";
			// 	}	
			// }			
			// else
			// {
			// 	$response['change_frequency']['mobile_changed'] ="false";
			// 	$total++;  $leaves_grade [] = "passed";
			// }	
		
			// if(!empty($data['EMAIL_UPDATE_COUNT']))
			// {
			// 	if($data['EMAIL_UPDATE_COUNT'] > 1)
			// 	{
			// 		$response['change_frequency']['email_changed'] ="true";
			// 			$leaves_grade [] = "failed";
			// 	}
			// 	else
			// 	{
			// 		$response['change_frequency']['email_changed'] ="false";
			// 		$total++;  $leaves_grade [] = "passed";
			// 	}	
			// }
			// else
			// {
			// 	$response['change_frequency']['email_changed'] ="false";
			// 	$total++;  $leaves_grade [] = "passed";
			// }	
					
			// if(!empty($data['STATE_UPDATE_COUNT']))
			// {
			// 	if($data["STATE_UPDATE_COUNT"] > 1){
			// 		$response['change_frequency']['state_changed'] ="true";
			// 			$leaves_grade [] = "failed";	
			// 	}
			// 	else  
			// 	{
			// 		$response['change_frequency']['state_changed'] ="false";
			// 		$total++;  $leaves_grade [] = "passed";
	
			// 	}		
			// }
			
			// else  
			// {
			// 	$response['change_frequency']['state_changed'] ="false";
			// 	$total++;  $leaves_grade [] = "passed";

			// }		

			// if(!empty($data['GENDER_UPDATE_COUNT']))
			// {
			// 	if($data["GENDER_UPDATE_COUNT"] > 1){
			// 		$response['change_frequency']['gender_changed'] ="true";
			// 			$leaves_grade [] = "failed";	
			// 	}
			// 	else  
			// 	{
			// 		$response['change_frequency']['gender_changed'] ="false";
			// 		$total++;  $leaves_grade [] = "passed";
			// 	}	
			// }		
			// else  
			// {
			// 	$response['change_frequency']['gender_changed'] ="false";
			// 	$total++;  $leaves_grade [] = "passed";
			// }


			if($data['OCCUPATION_ID']!=3 && $data['OCCUPATION_ID']==7 && $data['OCCUPATION_ID']!=20){
				// $work_designation = explode(',',$product['PREFERRED_DESIGNATION']);	
				$work_designation = $product['PREFERRED_DESIGNATION'];	
				//condition for checking if work designation is allowed
				if(!empty($work_designation)){
					if(in_array($data['WORK_DESIGNATION'],$work_designation)){
						$response['work']['work_designation_allowed'] = "true";
						$total++;  $leaves_grade [] = "passed";
					}
					else
					{
						$response['work']['work_designation_allowed'] = "false";
							$leaves_grade [] = "failed";	
					}					
				}
				else
				{
					$response['work']['work_designation_allowed'] = "false";
					$total++;  $leaves_grade [] = "passed";	
				}			
			}
			else
			{
				$response['work']['work_designation_allowed'] = "false";
				$leaves_grade [] = "failed";
			}	


			if(!empty($result_mobile)){
				if($result_mobile['BVN_PHONE'] == $data['PHONE']){			
					// var_dump($result_mobile['BVN_PHONE']);
					// var_dump($data['PHONE']);				
					$response_is_number_correct ="true";
					$total++;  $leaves_grade [] = "passed";
				} 
				else
				{
					$response_is_number_correct ="false";
						$leaves_grade [] = "failed";
				}
			}
			else
			{
				$response_is_number_correct ="no data";
					$leaves_grade [] = "failed";
			}

			$result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;

		//return $eligibility_data;

    }
    public function runFullAnalytics(Request $request)
    {
        $output = [];
		$status = [];
		$profile_compared_data = [];

        $sms_consistency_score = 0;
        $sms_activeness_score = 0;
        $sms_ownership_score = 0;
        $sms_reliability_score = 0;
        $sms_lowrisk_score = 0;
        // $consistency_array = ["1","2","3","5","7"];
        // $activeness_array = ["9"];
        // $ownership_array = ["16"];
        // $reliability_array = ["1","2","4","6"];
        // $lowrisk_array = ["1","2","3","6"];

        $borrower_id  = $request->borrower_id;
        $lender_id  = $request->lender_id;
		$loan_request_id  = $request->loan_request_id;
		$request_principal = $request->principal; 
		$request_maturity_date = $request->maturity_date;
		$account_card_id = $request->account_card_id;
		$card_id = $request->card_id;

		$general_pass_percentage = DB::table('people')->select('GENERAL_PASS_PERCENTAGE')->where('PEOPLE_ID',$lender_id)->get()[0]->GENERAL_PASS_PERCENTAGE;
			
		$data = DB::table('people_customers As M')->select('*')->where('PEOPLE_ID',$borrower_id)->get();
		$data = $data[0];   
		$data = json_decode(json_encode($data),true);
		
		
	
			$bvn_validation_paystack = DB::table('bvn_validation_paystack')->select('PAYSTACK_RESPONSE','BVN_PHONE')->where('BVN',$data['BVN'])->get();
			//var_dump($bvn_validation_paystack[0]);
		   //$lender = $lender_settings;
		  
		   
		//    $result_age = "";
		//    $result_mobile ="";
		   if(!empty($bvn_validation_paystack[0]))
		   {
				$result_mobile = [
					"BVN_PHONE"=> $bvn_validation_paystack[0]->BVN_PHONE,
				];
				$result_age = [
					"PAYSTACK_RESPONSE"=> $bvn_validation_paystack[0]->PAYSTACK_RESPONSE,
				];
		
		   }
		   else
		   {
				$result_mobile = [
					"BVN_PHONE"=> "",
				];
				$result_age = [
					"PAYSTACK_RESPONSE"=> ""
				];
		   }
	
       $suspicious_names = [
        ['name'=>'Subomi'],['name'=>'Nebechi']
        ];

	
		$collection = DB::table('people_customers')->select('USER_CALL_LOGS','SMS_LOGS','FACEBOOK_DATA','TWITTER_DATA','LINKEDIN_DATA')->where('PEOPLE_ID',$borrower_id)->get();
		
		$collection = $collection[0];

		$facebook = json_decode($collection->FACEBOOK_DATA,true);	
		$twitterData = json_decode($collection->TWITTER_DATA,true);
		$linkedin = json_decode($collection->LINKEDIN_DATA,true);
		$sms_logs = json_decode($collection->SMS_LOGS);
		$collection = json_decode($collection->USER_CALL_LOGS);
		
		$collection = collect($collection);
		/*$collection = DB::table('customer_metadata')->select('call_logs','sms_logs')->where('people_customer_id',$borrower_id)->get();
		if(!empty($collection)){
			$collection = $collection[0];
			if(!empty($collection->call_logs)){
				$collection = json_decode($collection->call_logs);
				$collection = collect($collection);
				$datesIncoming = $collection->where("type","1")->pluck('date');
				var_dump($datesIncoming);
				exit();
			}else{
				$sms_logs = [];
			}
		}else{
			$sms_logs = [];
		} */
		$leafids = [
			'guarantor'=>$request->guarantor,//implode(',',json_decode($general_leafids->guarantor_leaves)),
			'card'=>$request->card,//implode(',',json_decode($general_leafids->card_leaves)),
			'account'=>$request->account,//implode(',',json_decode($general_leafids->account_leaves)),
			'direct_debit'=>$request->direct_debit,//implode(',',json_decode($general_leafids->directdebit_leaves)),
			'smslogs'=>$request->smslogs,//implode(',',json_decode($general_leafids->sms_leaves)),
			'social'=>$request->social,//implode(',',json_decode($general_leafids->social_leaves)),
			'repayments'=>$request->repayments,//implode(',',json_decode($general_leafids->repayment_leaves)),
            'calllogs'=>$request->calllogs,//implode(',',json_decode($general_leafids->calllog_leaves)),
			'profile'=>$request->profile,//implode(',',json_decode($general_leafids->value)),
            //'crawler'=>$request->crawler
            'BVN'=>$request->BVN,
		];
	
		$lender =[];
		$leaves_settings=DB::table('leaves_setting')->select('setting','category')->where('lender_id',$lender_id)->get();
		$a = [];

		$setting_lender = $leaves_settings[0]->setting;
		$setting_lender = json_decode($setting_lender,true);
		foreach($setting_lender as $key=>$category_setting)
		{
			if(is_array($category_setting))
			{
				$lender = array_merge($lender,$category_setting);
			}
        }
        
        $lender['ALLOWED_CONNECTIONS'] = ($lender['ALLOWED_CONNECTIONS'] != "") ? (int)$lender['ALLOWED_CONNECTIONS'] : 0;

        $lender['MIN_RANGE'] = ($lender['MIN_RANGE'] != "") ? (int)$lender['MIN_RANGE'] : 0;

        $lender['MAX_RANGE'] = ($lender['MAX_RANGE'] != "") ? (int)$lender['MAX_RANGE'] : 0;

        $lender['FOLLOWERS_COUNT_ALLOWED'] = ($lender['FOLLOWERS_COUNT_ALLOWED'] != "") ? (int)$lender['FOLLOWERS_COUNT_ALLOWED'] : 0;

        $lender['FOLLOWING_COUNT_ALLOWED'] = ($lender['FOLLOWING_COUNT_ALLOWED'] != "") ? (int)$lender['FOLLOWING_COUNT_ALLOWED'] : 0;

        $lender['FOLLOWERS_TO_FOLLOWING_RATIO_ALLOWED'] = ($lender['FOLLOWERS_TO_FOLLOWING_RATIO_ALLOWED'] != "") ? (float)$lender['FOLLOWERS_TO_FOLLOWING_RATIO_ALLOWED'] : 0;

        $lender['FAVOURITE_COUNT_ALLOWED'] = ($lender['FAVOURITE_COUNT_ALLOWED'] != "") ? (int)$lender['FAVOURITE_COUNT_ALLOWED'] : 0;

        $lender['STATUSES_COUNT_ALLOWED'] = ($lender['STATUSES_COUNT_ALLOWED'] != "") ? (int)$lender['STATUSES_COUNT_ALLOWED'] : 0;



        $lender['GUARANTOR_ALLOWED_SECTOR'] = implode(',',$lender['GUARANTOR_ALLOWED_SECTOR']);
        $lender['GUARANTOR_ALLOWED_DESIGNATION'] = implode(',',$lender['GUARANTOR_ALLOWED_DESIGNATION']);
        $lender['ALLOWED_ACCOUNT_BANKS'] = implode(',',$lender['ALLOWED_ACCOUNT_BANKS']);
        $lender['ALLOWED_CARD_BANKS'] = implode(',',$lender['ALLOWED_CARD_BANKS']);
        $lender['ALLOWED_CARD_TYPE'] = implode(',',$lender['ALLOWED_CARD_TYPE']);
        // var_dump($lender);
        // die();
        //for sms
        $lender['PERCENTAGE_OVERALL'] = ($lender['PERCENTAGE_OVERALL'] != "") ? (int)$lender['PERCENTAGE_OVERALL'] : 0;
        $lender['PERCENTAGE_INCOME_TO_CREDIT'] = ($lender['PERCENTAGE_INCOME_TO_CREDIT'] != "") ? (int)$lender['PERCENTAGE_INCOME_TO_CREDIT'] : 0;

        $lender['PERCENTAGE_OVERSPENDING'] = ($lender['PERCENTAGE_OVERSPENDING'] != "") ? (int)$lender['PERCENTAGE_OVERSPENDING'] : 0;

        $lender['PERCENTAGE_CREDIT_DEBIT_INCOME'] = ($lender['PERCENTAGE_CREDIT_DEBIT_INCOME'] != "") ? (int)$lender['PERCENTAGE_CREDIT_DEBIT_INCOME'] : 0;

        $lender['PERCENTAGE_INCOME_TO_DEBIT'] = ($lender['PERCENTAGE_INCOME_TO_DEBIT'] != "") ? (int)$lender['PERCENTAGE_INCOME_TO_DEBIT'] : 0;

        $lender['PERCENTAGE_AIRTIME_TO_INCOME'] = ($lender['PERCENTAGE_AIRTIME_TO_INCOME'] != "") ? (int)$lender['PERCENTAGE_AIRTIME_TO_INCOME'] : 0;

        $lender['PERCENTAGE_OTHER_EXPENSES_TO_INCOME'] = ($lender['PERCENTAGE_OTHER_EXPENSES_TO_INCOME'] != "") ? (int)$lender['PERCENTAGE_OTHER_EXPENSES_TO_INCOME'] : 0;

        $lender['PERCENTAGE_INCOME_TO_MONTHLY_SALARY_TOTAL'] = ($lender['PERCENTAGE_INCOME_TO_MONTHLY_SALARY_TOTAL'] != "") ? (int)$lender['PERCENTAGE_INCOME_TO_MONTHLY_SALARY_TOTAL'] : 0;

        $lender['PERCENTAGE_AVERAGE_CREDIT'] = ($lender['PERCENTAGE_AVERAGE_CREDIT'] != "") ? (int)$lender['PERCENTAGE_AVERAGE_CREDIT'] : 0;

        $lender['PERCENTAGE_AVERAGE_DEBIT'] = ($lender['PERCENTAGE_AVERAGE_DEBIT'] != "") ? (int)$lender['PERCENTAGE_AVERAGE_DEBIT'] : 0;


		$product = $lender;
		
		$lender_extra = [
		
		];
		$customer = [
			"LEGAL_NAME"=> $data['LEGAL_NAME'],
			"BORROWER_NAME"=> $data['LEGAL_NAME'],
			"MONTHLY_INCOME"=> $data['NET_MONTHLY_INCOME'],
			"MONTHLY_AIRTIME_SPENDING"=> $data['MONTHLY_TEL_INTERNET'],
			"MONTHLY_OTHER_EXPENSES_SPENDING"=> $data['MONTHLY_TEL_INTERNET'] + $data['MONTHLY_TRANSPORT']
		];

		$guarantor_eligibility_settings = 
		[
			"guarantor"=> [
				"category_id"=> "1",
				"settings"=> $leafids['guarantor']
			],
			"card"=> [
				"category_id"=> "2",
				"settings"=> $leafids['card']
			],
			"account"=> [
				"category_id"=> "3",
				"settings"=> $leafids['account']
			],
			"direct_debit"=> [
				"category_id"=> "4",
				"settings"=>  $leafids['direct_debit']
			]
		
		];

		$rg_id =DB::table('request_guarantors')->select('RG_ID','DATE_ADDED','DATE_MODIFIED')->where('REQUEST_ID',$loan_request_id)->where('STATUS',1)->get();
		$nodata_rg_id = [
			'RG_ID'=>"",
			'DATE_ADDED'=>"",
			'DATE_MODIFIED'=>"",
		];
		$nodata_rg_id = json_decode(json_encode($nodata_rg_id));
		$rg_id = !empty($rg_id) ? $rg_id[0] :$nodata_rg_id;

			$work_rg_id = DB::table('guarantor_work')->select('WORK_DESIGNATION','WORK_SECTOR','MONTHLY_INCOME')->where('RG_ID',$rg_id->RG_ID)->get();
			$nodata_work_rg_id = [
				'WORK_DESIGNATION'=>"",
				'WORK_SECTOR'=>"",
				'MONTHLY_INCOME'=>"",
			];
			$nodata_work_rg_id = json_decode(json_encode($nodata_work_rg_id));
			$work_rg_id = !empty($work_rg_id) ? $work_rg_id[0] : $nodata_work_rg_id;
			$address_rg_id = DB::table('guarantor_address')->select('ADDRESS','NATURE_OF_ACCOMODATION','TIME_AT_CURRENT_ADDRESS')->where('RG_ID',$rg_id->RG_ID)->get();
			$nodata_address_rg_id = [
				'ADDRESS'=>"13 modupe street, somolu lagos",
				'NATURE_OF_ACCOMODATION'=>"",
				'TIME_AT_CURRENT_ADDRESS'=>"",
			];
			$nodata_address_rg_id = json_decode(json_encode($nodata_address_rg_id));
			$address_rg_id = !empty($address_rg_id) ? $address_rg_id[0] : $nodata_address_rg_id;

			$accountcard_rg_id = DB::table('guarantor_repayment')->select('ACCOUNT_CARD_ID')->where('RG_ID',$rg_id->RG_ID)->where('REPAYMENT_TYPE',3)->get();

			$nodata_accountcard_rg_id = [
				'ACCOUNT_CARD_ID'=>"",
			];
			$nodata_accountcard_rg_id = json_decode(json_encode($nodata_accountcard_rg_id));

			$accountcard_rg_id = !empty($accountcard_rg_id) ? $accountcard_rg_id[0]->ACCOUNT_CARD_ID : $nodata_accountcard_rg_id->ACCOUNT_CARD_ID;

			// if(!empty($accountcard_rg_id))
			// {
				$accountcard = DB::table('account_cards')->select('CARD_NAME','EXP_YEAR','EXP_MONTH','BANK_ID','CARD_TYPE')->where('ACCOUNT_CARD_ID',$accountcard_rg_id)->get();

				$nodata_accountcard = [
					'CARD_NAME'=>"",
					'EXP_YEAR'=>"",
					'EXP_MONTH'=>"",
					'BANK_ID'=>"",
					'CARD_TYPE'=>"",
				];
				$nodata_accountcard = json_decode(json_encode($nodata_accountcard));
				$accountcard = !empty($accountcard) ? $accountcard[0] : $nodata_accountcard;
			//}
			
		
	
		// $address_rg_id = DB::table('guarantor_address')->select('ADDRESS','NATURE_OF_ACCOMODATION','TIME_AT_CURRENT_ADDRESS')->where('RG_ID',$rg_id->RG_ID)->get()[0];
		//var_dump($address_rg_id);

		// $accountcard_rg_id = DB::table('guarantor_repayment')->select('ACCOUNT_CARD_ID')->where('RG_ID',$rg_id->RG_ID)->where('REPAYMENT_TYPE',3)->get()[0]->ACCOUNT_CARD_ID;
		// $accountcard = DB::table('account_cards')->select('CARD_NAME','EXP_YEAR','EXP_MONTH','BANK_ID','CARD_TYPE')->where('ACCOUNT_CARD_ID',$accountcard_rg_id)->get()[0];

		$guarantor =  [
			"work"=> [
			  "WORK_SECTOR"=> $work_rg_id->WORK_SECTOR,//"4",//
			  "WORK_DESIGNATION"=>$work_rg_id->WORK_DESIGNATION,//"12",// 
			  "MONTHLY_INCOME"=> $work_rg_id->MONTHLY_INCOME//100000//
			],
			"address"=> [
				"ADDRESS"=> $address_rg_id->ADDRESS,// // "ADDRESS"=> "15, Bode Thomas Street, Surulere, Lagos",
			  "NATURE_OF_ACCOMMODATION"=>$address_rg_id->NATURE_OF_ACCOMODATION,//"2",// 
			  "TIME_AT_CURRENT_ADDRESS"=> $address_rg_id->TIME_AT_CURRENT_ADDRESS//3//
			],
			"basic"=> [
			  "PHONE_VERIFIED"=> true,
			  "EMAIL_VERIFIED"=> true
			],
			"card"=> [
			"BANK_ID"=> $accountcard->BANK_ID,//"2",
			"EXP_YEAR"=> $accountcard->EXP_YEAR,//"2023",
			"EXP_MONTH"=> $accountcard->EXP_MONTH,//"04",
			"CARD_TYPE"=> $accountcard->CARD_TYPE //"3"
			  ]
		];	
		// var_dump($guarantor);
		// die();
		// $loan_request_data = DB::table('loan_request')->select('REQUEST_PRINCIPAL','MATURITY_DATE')->where('REQUEST_ID',$loan_request_id)->get()[0];
		$loan = [
			"REQUEST_PRINCIPAL"=> $request_principal,//250000,
			"MATURITY_DATE"=>  $request_maturity_date//"2019-10-05T14:41:46.762Z"
		];

		$request_guarantor = [
			"DATE_ADDED"=>$rg_id->DATE_ADDED,//"2019-01-05T14:41:46.762Z",//
			"DATE_MODIFIED"=>$rg_id->DATE_MODIFIED//"2019-01-15T14:41:46.762Z"// 
		];
		$accountcard = DB::table('account_cards')->select('CARD_NAME','BANK_ID','EXP_YEAR','EXP_MONTH','CARD_TYPE')->where('ACCOUNT_CARD_ID',$account_card_id)->get();
		$nodata_accountcard = [
			'CARD_NAME'=>"",
			'EXP_YEAR'=>"",
			'EXP_MONTH'=>"",
			'BANK_ID'=>"",
			'CARD_TYPE'=>"",
		];
		$nodata_accountcard = json_decode(json_encode($nodata_accountcard));
		$accountcard = !empty($accountcard) ? $accountcard[0] : $nodata_accountcard;
		$account = [
			"CARD_NAME"=>$accountcard->CARD_NAME,//"John Doe",//$accountcard->CARD_NAME,//"John Doe",
			"BANK_ID"=>$accountcard->BANK_ID//"2"//$accountcard->BANK_ID//"2"
		];
		//var_dump($account);
		$cardcard = DB::table('account_cards')->select('CARD_NAME','BANK_ID','EXP_YEAR','EXP_MONTH','CARD_TYPE','PAYSTACK_CHECK_ID')->where('ACCOUNT_CARD_ID',$card_id)->get();
		
		// $paystack_response = json_decode($cardcard->PAYSTACK_CHECK_ID,true); 
		//var_dump($account);
		$cardcard = DB::table('account_cards')->select('CARD_NAME','BANK_ID','EXP_YEAR','EXP_MONTH','CARD_TYPE','PAYSTACK_CHECK_ID')->where('ACCOUNT_CARD_ID',$card_id)->get();
		
		if(!empty($cardcard)){
			$cardcard = $cardcard[0];
			
			$paystack_response = json_decode($cardcard->PAYSTACK_CHECK_ID,true);
		 
			if(!empty($paystack_response)){
				$cardbank = DB::table('banks_list')->select('bank_id')->where('paystack_bank_name',$paystack_response['authorization']['bank'])->get();
				$cardbrand = DB::table('card_types')->select('card_type_id')->where('card_name',$paystack_response['authorization']['brand'])->get()[0];
				if(!empty($cardbank)){
					$cardbank = $cardbank[0];
					
					
					$card = [
						"BANK_ID"=>empty($cardbank)?0:$cardbank->bank_id,//"3", 
						"EXP_YEAR"=> $paystack_response['authorization']['exp_year'],//"2023",
						"EXP_MONTH"=> $paystack_response['authorization']['exp_month'],//"04",
						"CARD_TYPE"=> $cardbrand->card_type_id,//"3"
					];
					
				}else{
					
					$card = [
						"BANK_ID"=>"",//"3", 
						"EXP_YEAR"=> $paystack_response['authorization']['exp_year'],//"2023",
						"EXP_MONTH"=> $paystack_response['authorization']['exp_month'],//"04",
						"CARD_TYPE"=> $cardbrand->card_type_id,//"3"
					];
				} 
				
			}else{
				$card = [
					"BANK_ID"=>"",//"3",
					"EXP_YEAR"=> "",//"2023",
					"EXP_MONTH"=> "",//"04",
					"CARD_TYPE"=>"",//"3"
				];
			}
		}else{
			 $card = [
				"BANK_ID"=>"",//"3",
				"EXP_YEAR"=> "",//"2023",
				"EXP_MONTH"=> "",//"04",
				"CARD_TYPE"=>"",//"3"
			];
		}
		
		$direct_debit = DB::table('direct_debit_request')->select('IS_ACTIVE','ACCOUNT_CARD_ID')->where('request_id',$loan_request_id)->get();
		
		$output['passed'] = "";
		$output['failed'] = "";
		$output['passed_total'] = 0;
        $output['failed_total'] = 0;
       
		if($leafids['guarantor'])
		{
			// $payload = array(
			// 	'lender' => $lender,
			// 	'guarantor' => $guarantor,
			// 	'loan'=>$loan,
			// 	'request_guarantor'=>$request_guarantor,
			// 	'customer'=>$customer,
			// 	'account'=>$account,
			// 	'card'=>$card,
			// 	'direct_debit'=>$direct_debit,	
			// );
			 
			// $payload = json_encode($payload);
			 
			// // Prepare new cURL resource
			// $ch = curl_init('https://lendertest.creditclan.com/public/doguarantor');
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			// curl_setopt($ch, CURLOPT_POST, true);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// // Set HTTP Header for POST request 
			// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			// 	'Content-Type: application/json',
			// 	'Content-Length: ' . strlen($payload))
			// );
			 
			// // Submit the POST request
			// $result_g = curl_exec($ch);
			
			// // Close cURL session handle
			// curl_close($ch);
		
			// $output['guarantor'] = json_decode($result_g);
			$output['guarantor'] = ($request->prefetch_value);
			//get node_id and leaf_id by category
			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',6)->get();
			$rers = collect($rers)->groupBy('node_id');
			//return $output;
			// var_dump($rers->toArray());
			// // var_dump($output['guarantor']);
			//  die();
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['guarantor']->passed))
					{
						$passed_ids = explode(',',$output['guarantor']->passed);
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['guarantor']->failed))
					{
						$failed_ids = explode(',',$output['guarantor']->failed);
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
					if(!empty($output['guarantor']->no_data))
					{
						$no_data_ids = explode(',',$output['guarantor']->no_data);
						foreach($no_data_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
					}
				}			
			}
			// var_dump($b);
			// return $b;
            // die();		
            $d = [];
          
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			// var_dump($d);
            // die();
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$guarantor_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$guarantor_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $guarantor_node_values->negative_score;
				}
	
			}
            $category_score_guarantor= ($node_score_sum)/(count($d) * 10);	
           $status['guarantor'] = true;
        }
        else
        {
            $status['guarantor'] = false;
        }
      	
		 
		if($leafids['card']&& $card['CARD_TYPE']!="")
		{	
			// $payload = array(
			// 	'lender' => $lender,
			// 	'guarantor' => $guarantor,
			// 	'loan'=>$loan,
			// 	//'request_guarantor'=>$request_guarantor,
			// 	'customer'=>$customer,
			// 	'account'=>$account,
			// 	'card'=>$card,
			// 	//'direct_debit'=>$direct_debit,	
			// ); 
			// $payload = json_encode($payload);	 
			// // Prepare new cURL resource
			// $ch = curl_init('https://lendertest.creditclan.com/public/docard');
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			// curl_setopt($ch, CURLOPT_POST, true);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// // Set HTTP Header for POST request 
			// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			// 	'Content-Type: application/json',
			// 	'Content-Length: ' . strlen($payload))
			// );
			 
			// // Submit the POST request
			// $result_card = curl_exec($ch);
			// $output['card'] = json_decode($result_card);	
			// // Close cURL session handle

			// curl_close($ch);

			$payload = array(
                'lender' => $lender,
                //'guarantor' => $guarantor,
                'loan'=>$loan,
                //'request_guarantor'=>$request_guarantor,
                'customer'=>$customer,
                'account'=>$account,
                'card'=>$card,
                //'direct_debit'=>$direct_debit,    
            );
        
            
            $cardAnalytics = new CardController;
            $cardAnalyticsData = $cardAnalytics->determineCardAnalytics($data,$payload,$lender,$card_leafids="");
            
            $output['card'] = json_decode($cardAnalyticsData);
            
            if(!empty($output['card']->data->grades->passed))
            {
                $output['passed'] .=','. implode(',',$output['card']->data->grades->passed);
                $output['passed_total'] += count($output['card']->data->grades->passed);
            }
            if(!empty($output['card']->data->grades->failed))
            {
                $output['failed'] .=','. implode(',',$output['card']->data->grades->failed);
                $output['failed_total'] += count($output['card']->data->grades->failed);
            }
            $status['card'] = true;

			//get node_id and leaf_id by category
			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',8)->get();
			$rers = collect($rers)->groupBy('node_id');
			//return $output;
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['card']->data->grades->passed))
					{
						$passed_ids = $output['card']->data->grades->passed;
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['card']->data->grades->failed))
					{
						$failed_ids =$output['card']->data->grades->failed;
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
					// if(!empty($output['card']->no_data))
					// {
					// 	$no_data_ids = explode(',',$output['card']->no_data);
					// 	foreach($no_data_ids as $failed_id)
					// 	{
					// 		if($rere->leaf_id == $failed_id)
					// 		{
					// 			$b[$key][] = 0;
					// 		}
					// 	}
					// }
				}			
			}		
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$card_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$card_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $card_node_values->negative_score;
				}
	
			}
			$category_score_card = $node_score_sum/(count($d) * 10);
            $status['card'] = true;
        }
        else
        {
            $category_score_card ="sfs";
            $output['card']['data']['grades']['failed'] = [1,2,3,4];
            $output['card'] =  json_decode(json_encode($output['card']));
            $status['card'] = false;
        }
		
		if($leafids['account'])
		{
			// $payload = array(
			// 	'lender' => $lender,
			// 	//'guarantor' => $guarantor,
			// 	//'loan'=>$loan,
			// 	//'request_guarantor'=>$request_guarantor,
			// 	'customer'=>$customer,
			// 	'account'=>$account,
			// 	'card'=>$card,
			// 	//'direct_debit'=>$direct_debit,	
			// );
			
			// $payload = json_encode($payload);	 
			// // Prepare new cURL resource
			// $ch = curl_init('https://lendertest.creditclan.com/public/doaccount');
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			// curl_setopt($ch, CURLOPT_POST, true);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// // Set HTTP Header for POST request 
			// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			// 	'Content-Type: application/json',
			// 	'Content-Length: ' . strlen($payload))
			// );
			// // Submit the POST request
			// $result_account = curl_exec($ch);
			// $output['account'] = json_decode($result_account);
			// // Close cURL session handle
			// curl_close($ch);

			$payload = array(
                'lender' => $lender,
                //'guarantor' => $guarantor,
                //'loan'=>$loan,
                //'request_guarantor'=>$request_guarantor,
                'customer'=>$customer,
                'account'=>$account,
                'card'=>$card,
                //'direct_debit'=>$direct_debit,    
            );

            // $account_leafids = explode(',',$leafids['account']);
            // $account_leafids = array_map(function($value) {
            //     return intval($value);
            // }, $account_leafids);
            // sort($account_leafids);
            
            $accountAnalytics = new AccountController;
            $accountAnalyticsData = $accountAnalytics->determineAccountAnalytics($data,$payload,$lender,$account_leafids="");
            
			$output['account'] = json_decode($accountAnalyticsData);

			if(!empty($output['account']->data->grades->passed))
            {
                $output['passed'] .=','. implode(',',$output['account']->data->grades->passed);
                $output['passed_total'] += count($output['account']->data->grades->passed);
            }
            if(!empty($output['account']->data->grades->failed))
            {
                $output['failed'] .=','. implode(',',$output['account']->data->grades->failed);
                $output['failed_total'] += count($output['account']->data->grades->failed);
            }
			

			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',9)->get();
			$rers = collect($rers)->groupBy('node_id');
			//return $output;
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['account']->data->grades->passed))
					{
						$passed_ids = $output['account']->data->grades->passed;
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['account']->data->grades->failed))
					{
						$failed_ids = $output['account']->data->grades->failed;
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
					// if(!empty($output['account']->no_data))
					// {
					// 	$no_data_ids = explode(',',$output['account']->no_data);
					// 	foreach($no_data_ids as $failed_id)
					// 	{
					// 		if($rere->leaf_id == $failed_id)
					// 		{
					// 			$b[$key][] = 0;
					// 		}
					// 	}
					// }
				}			
			}		
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$accounts_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$accounts_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $accounts_node_values->negative_score;
				}	
			}
			$category_score_accounts = $node_score_sum/(count($d) * 10);
            $status['account'] = true;
        }
        else
        {
            $status['account'] = false;
        }
		if($leafids['direct_debit'])
		{
			// $payload = array(
			// 	'lender' => $lender,
			// 	'guarantor' => $guarantor,
			// 	'loan'=>$loan,
			// 	'request_guarantor'=>$request_guarantor,
			// 	'customer'=>$customer,
			// 	'account'=>$account,
			// 	'card'=>$card,
			// 	'direct_debit'=>$direct_debit,	
			// );
			 
			// $payload = json_encode($payload);	 
			// // Prepare new cURL resource
			// $ch = curl_init('https://lendertest.creditclan.com/public/dodirectdebit');
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			// curl_setopt($ch, CURLOPT_POST, true);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// // Set HTTP Header for POST request 
			// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			// 	'Content-Type: application/json',
			// 	'Content-Length: ' . strlen($payload))
			// );
			 
			// // Submit the POST request
			// $result_direct_debit = curl_exec($ch);
			// $output['direct_debit'] = json_decode($result_direct_debit);
		
			// // Close cURL session handle
            // curl_close($ch);
            
            $output['direct_debit'] = ($request->prefetch_value);
			
			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',7)->get();
			$rers = collect($rers)->groupBy('node_id');
			//return $output;
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['direct_debit']->passed))
					{
						$passed_ids = explode(',',$output['direct_debit']->passed);
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['direct_debit']->failed))
					{
						$failed_ids = explode(',',$output['direct_debit']->failed);
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
					if(!empty($output['direct_debit']->no_data))
					{
						$no_data_ids = explode(',',$output['direct_debit']->no_data);
						foreach($no_data_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
					}
				}			
			}		
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$dd_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$dd_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $dd_node_values->negative_score;
				}	
			}
			$category_score_directdebit = $node_score_sum/(count($d) * 10);
            $status['direct_debit'] = true;
        }
        else
        {
            $status['direct_debit'] = false;
        }
		
		if($leafids['smslogs'])
		{
			// $payload = array(
			// 	'customer' => $customer,
			// 	'lender' => $lender,
			// 	//'analytics_weight_settings' => $analytics_weight_settings,
			// 	'sms_logs' => empty($sms_logs)?[]:$sms_logs,
			// 	//'eligibility_settings'=>$eligibility_settings,
			// );
			 
			// $payload = json_encode($payload);	 
			// // Prepare new cURL resource
			// $ch = curl_init('https://lendertest.creditclan.com/public/dosms');
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			// curl_setopt($ch, CURLOPT_POST, true);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// // Set HTTP Header for POST request 
			// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			// 	'Content-Type: application/json',
			// 	'Content-Length: ' . strlen($payload)) 
			// );
			 
			// // Submit the POST request
			// $result_s = curl_exec($ch);
            // $output['sms'] = json_decode($result_s); 
			 
            $output['sms'] = json_decode(json_encode($request->prefetch_value));//($request->prefetch_value);
			
            if(!empty($output['sms']->analytics->passed))
            {
                $passed_sms = explode(',',$output['sms']->analytics->passed);
                foreach($passed_sms as $sms_id)
                {
                    if($sms_id == "1")
                    {
                        $sms_consistency_score += 1;
                        $sms_reliability_score += 1;
                        $sms_lowrisk_score += 1;
                    }
                    if($sms_id == "2")
                    {
                        $sms_consistency_score += 1;
                        $sms_reliability_score += 1;
                        $sms_lowrisk_score += 1;
                    }
                    if($sms_id == "3")
                    {
                        $sms_consistency_score += 1;
                        $sms_reliability_score += 1;
                        $sms_lowrisk_score += 1;
                    }
                    if($sms_id == "4")
                    {    
                        $sms_reliability_score += 1;  
                    }
                    if($sms_id == "5")
                    {    
                        $sms_reliability_score += 1;
                        //$sms_activeness_score += 1;  
                        $sms_consistency_score += 1;  
                    }
                    if($sms_id == "6")
                    {    
                        $sms_reliability_score += 1; 
                        $sms_lowrisk_score += 1;
                    }
                    if($sms_id == "7")
                    {    
                        //$sms_activeness_score += 1;  
                        $sms_consistency_score += 1;
                    }
                    // if($sms_id == "8")
                    // {    
                    //     $sms_reliability_score += 1;  
                    // }
                    if($sms_id == "9")
                    {    
                        $sms_activeness_score += 1;  
                    }
                    if($sms_id == "16")
                    {    
                        $sms_ownership_score += 1;  
                    }

                }
            }
            $sms_consistency_score = ($sms_consistency_score/5) * 100;
            $sms_reliability_score = ($sms_reliability_score/6) * 100;
            $sms_activeness_score = ($sms_activeness_score) * 100;
            $sms_ownership_score = ($sms_ownership_score) * 100;
            $sms_lowrisk_score = ($sms_lowrisk_score/4) * 100;
			//->join('node_weights as n','g.node_id','=','n.node_id')
			//,'n.positive_score','n.negative_score'
			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',5)->get();
			$rers = collect($rers)->groupBy('node_id');
			//return $output;
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['sms']->analytics->passed))
					{
						$passed_ids = explode(',',$output['sms']->analytics->passed);
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['sms']->analytics->failed))
					{
						$failed_ids = explode(',',$output['sms']->analytics->failed);
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
					if(!empty($output['sms']->analytics->no_data))
					{
						$no_data_ids = explode(',',$output['sms']->analytics->no_data);
						foreach($no_data_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
					}
				}			
			}		
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$sms_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$sms_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $sms_node_values->negative_score;
				}
	
			}
			$category_score_sms = $node_score_sum/(count($d) * 10);$status['sms'] = true;		
        }
        else
        {
            $status['sms'] = false;
        }	
		// var_dump(['sms'=>$category_score_sms,'dd'=>$category_score_dd,'accounts'=>$category_score_accounts,'card'=>$category_score_card,'guarantor'=>$category_score_guarantor,'output'=>$output]);
		// die();
		//this is for profile
			
		if($leafids['profile'])
		{
			$determineProfileAnalytics = $this->determineProfileAnalytics($data,$suspicious_names,$product,$result_age,$result_mobile,$lender);

			$output['profile'] = json_decode($determineProfileAnalytics);
			
			

			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',1)->get();
			$rers = collect($rers)->groupBy('node_id');
			
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['profile']->data->grades->passed))
					{
						$passed_ids = $output['profile']->data->grades->passed;
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['profile']->data->grades->failed))
					{
						$failed_ids = $output['profile']->data->grades->failed;
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
				}			
			}	
			
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$profile_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$profile_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $profile_node_values->negative_score;
				}
	
			}
			
			$category_score_profile = $node_score_sum/(count($d) * 10);
				
			$age = empty($data['AGE'])?0:$data['AGE'];
			$monthly_income = $data['NET_MONTHLY_INCOME'];

			$all_lender_borrowers = DB::select("select count(*) as count from people_customers where lender_id=$lender_id");
			$lender_borrowers = !empty($all_lender_borrowers[0]->count) ? $all_lender_borrowers[0]->count : 0;
			// var_dump($all_lender_borrowers);
			// die();
			
			$all_lender_borrowers = !empty($all_lender_borrowers[0]->count) ? $all_lender_borrowers[0]->count : 1;
			$younger_borrowers = 0;
			 
			$younger_borrowers = DB::select("select count(*) as count from people_customers where lender_id=$lender_id and age < $age");
			
			$younger_borrowers = !empty($younger_borrowers) ? $younger_borrowers[0]->count : 0;
			
			$younger_borrowers = ($younger_borrowers/$all_lender_borrowers) * 100;
			
			$lower_income_earners = DB::select("select count(*) as count from people_customers where lender_id=$lender_id and NET_MONTHLY_INCOME < $monthly_income");

			$lower_income_earners = !empty($lower_income_earners) ? $lower_income_earners[0]->count : 0;

			$lower_income_earners = ($lower_income_earners/$all_lender_borrowers) * 100;

			$less_educated_borrowers = DB::select("select count(*) as count from people_customers as a join  education_levels as b on a.EDUCATION_QUALIFICATION =b.EDUCATION_LEVEL_ID where a.lender_id=$lender_id and b.rank < (select b.rank from people_customers as a join education_levels as b on a.EDUCATION_QUALIFICATION = b.EDUCATION_LEVEL_ID where a.PEOPLE_ID=$borrower_id)");

			$less_educated_borrowers = !empty($less_educated_borrowers) ? $less_educated_borrowers[0]->count : 0;

			$less_educated_borrowers = ($less_educated_borrowers/$all_lender_borrowers) * 100;

			$profile_compared_data = [
				"other_borrowers"=>$lender_borrowers,
				"older_than"=>$younger_borrowers,
				"more_income_than"=>$lower_income_earners,
				"more_educated_than"=>$less_educated_borrowers,
			];

            $status['profile'] = true;
        }
        else
        {
            $status['profile'] = false;
        }
		
		//this is for calllogs
		if($leafids['calllogs'] && sizeof($collection) > 0)
		{
			
			$callLog = new CalllogsController;
			$CallLogsAnalytics = $callLog->determineCallLogsAnalytics($data,$collection,$lender);
			$output['calllogs'] = json_decode($CallLogsAnalytics);
			//return json_encode($output);

			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',2)->get();
			$rers = collect($rers)->groupBy('node_id');
			
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['calllogs']->data->grades->passed))
					{
						$passed_ids = $output['calllogs']->data->grades->passed;
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['calllogs']->data->grades->failed))
					{
						$failed_ids = $output['calllogs']->data->grades->failed;
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
				}			
			}		
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$calllogs_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$calllogs_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $calllogs_node_values->negative_score;
				}
			}
			$category_score_calllogs = $node_score_sum/(count($d) * 10);
			// if(!empty($output['calllogs']->data->grades->passed))
			// {
			// 	$output['passed'] .=','. implode(',',$output['calllogs']->data->grades->passed);
			// 	$output['passed_total'] += count($output['calllogs']->data->grades->passed);
			// }
			// if(!empty($output['calllogs']->data->grades->failed))
			// {
			// 	$output['failed'] .=','. implode(',',$output['calllogs']->data->grades->failed);
			// 	$output['failed_total'] += count($output['calllogs']->data->grades->failed);
            // }
            $status['calllogs'] = true;
        }
        else
        {
            $status['calllogs'] = false;
        }
		$social = 0;
		if(sizeof($facebook) > 0){
			$social++;
		}
		if(sizeof($twitterData) > 0){
			$social++;
		}
		if(sizeof($linkedin) > 0){
			$social++;
		}
		//this is for social
		if($leafids['social'] && $social > 0)
		{
			// $social_leafids = explode(',',$leafids['social']);
			// $social_leafids = array_map(function($value) {
			// 	return intval($value);
			// }, $social_leafids);
			// sort($social_leafids);
			$social = new SocialController;
			$socialAnalytics = $social->determineSocialAnalytics($lender,$data,$facebook,$twitterData,$linkedin,$row="");
			$output['social'] = json_decode($socialAnalytics);
			
			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',3)->get();
			$rers = collect($rers)->groupBy('node_id');
			
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['social']->data->grades->passed))
					{
						$passed_ids = $output['social']->data->grades->passed;
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['social']->data->grades->failed))
					{
						$failed_ids = $output['social']->data->grades->failed;
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
				}			
			}		
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$social_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$social_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $social_node_values->negative_score;
				}
			}
			$category_score_social = $node_score_sum/(count($d) * 10);

			// if(!empty($output['social']->data->grades->passed))
			// {
			// 	$output['passed'] .=','. implode(',',$output['social']->data->grades->passed);
			// 	$output['passed_total'] += count($output['social']->data->grades->passed);
			// }
			// if(!empty($output['social']->data->grades->failed))
			// {
			// 	$output['failed'] .=','. implode(',',$output['social']->data->grades->failed);
			// 	$output['failed_total'] += count($output['social']->data->grades->failed);
            // }
            $status['social'] = true;
        }
        else
        {
            $status['social'] = false;
        }
		$repayment_performance = [];
		$repayment_data= [];
		if($leafids['repayments'])
		{
			$loans_borrowed = DB::select("select count(*) as count from loan_request where people_id=$borrower_id and booked=1"); 
			$loans_borrowed = !empty($loans_borrowed) ? $loans_borrowed[0]->count :0; 
			//$loans_borrowed = $loans_borrowed[0]->count;

			$total_amount_borrowed = DB::select("select sum(REQUEST_PRINCIPAl) as max_borrowed from loan_request where people_id=$borrower_id and booked=1");

			$total_amount_borrowed = !empty($total_amount_borrowed) ? $total_amount_borrowed[0]->max_borrowed :0;
			
			$times_early_all = DB::select("select count(*) as count_early from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where  a.people_id=$borrower_id and date(a.date_paid) < date(a.repayment_date) and b.booked=1 and a.date_paid is NOT NULL");

			$times_early_all = !empty($times_early_all) ? $times_early_all[0]->count_early :0;

			$max_early= DB::select("select max(datediff(repayment_date,date_paid)) as dd from repayment_schedule where date(date_paid) < date(repayment_date) and request_id in(select request_id from loan_request where people_id=$borrower_id and booked = 1) and date_paid is NOT NULL");
			if(!empty($max_early))
			{
				$max_early = $max_early[0]->dd;
			}
			else
			{
				$max_early = 0;
			}

			$highest_principal = DB::select("select max(REQUEST_PRINCIPAl) as hp from loan_request where people_id=$borrower_id and booked=1"); 
			$highest_principal = !empty($highest_principal) ? $highest_principal[0]->hp :0;  


			$highest_tenure= DB::select("select max(REQUEST_TENOR_IN_DAYS) as ht from loan_request where people_id=$borrower_id and booked=1"); 

			$highest_tenure = !empty($highest_tenure) ? (($highest_tenure[0]->ht)/30) :0; 


			$highest_interest_rate = DB::select("select max(REQUEST_RATE_IN_DAYS) as hir from loan_request where people_id=$borrower_id and booked=1");

			$highest_interest_rate = !empty($highest_interest_rate) ? ($highest_interest_rate[0]->hir) * 30 :0; 

		
			//$loans_borrowed = count($loans_borrowed);
			//$loans_borrowed = count($loans_borrowed);

			$timesLate = DB::select("select * from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.lender_id=$lender_id and a.people_id=$borrower_id and date(a.date_paid) > DATE_ADD(date(a.repayment_date), INTERVAL 2 DAY) and b.booked=1 and a.date_paid is NOT NULL");
			$timesLate = count($timesLate);
	
			$default_loan = 
			DB::select("select a.request_id,max(date(repayment_date)),max(date(date_paid)) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.LENDER_ID=$lender_id and a.PEOPLE_ID=$borrower_id and b.booked=1 and a.date_paid is NOT NULL group by a.request_id having max(date(date_paid)) > max(date(a.repayment_date))");
			//$creditclanLoans = $default_loan;
			$default_loan = count($default_loan);
				
			///max_lateness_days
			$maxlate = DB::select("select repayment_date,date_paid,datediff(date_paid,repayment_date) as dd from repayment_schedule where date(date_paid) > date(repayment_date) and request_id in(select request_id from loan_request where people_id=$borrower_id and booked = 1) and date_paid is NOT NULL order by  dd desc");
			if(!empty($maxlate))
			{
				$creditclanLoans = $maxlate[0]->dd;
			}
			else
			{
				$creditclanLoans = 0;
			}
					
			$lateonfirstperiod = DB::select("select a.repayment_date,a.date_paid,datediff(a.REPAYMENT_DATE,a.DATE_PAID) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.lender_id=$lender_id and a.people_id=$borrower_id and date(a.date_paid) > DATE_ADD(date(a.repayment_date), INTERVAL 2 DAY)  and b.booked=1 and a.period=1 and a.date_paid is NOT NULL");
			$lateonfirstperiod = count($lateonfirstperiod);
			
			$lateonsecondperiod = DB::select("select a.repayment_date,a.date_paid,datediff(a.REPAYMENT_DATE,a.DATE_PAID) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.lender_id=$lender_id and a.people_id=$borrower_id and date(a.date_paid) > DATE_ADD(date(a.repayment_date), INTERVAL 2 DAY) and b.booked=1 and a.period=2 and a.date_paid is NOT NULL");
			$lateonsecondperiod = count($lateonsecondperiod);
			
			$lateonotherperiod = DB::select("select a.repayment_date,a.date_paid,datediff(a.REPAYMENT_DATE,a.DATE_PAID) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.lender_id=$lender_id and a.people_id=$borrower_id and date(a.date_paid) > DATE_ADD(date(a.repayment_date), INTERVAL 2 DAY) and b.booked=1 and a.period>2 and a.date_paid is NOT NULL");
			$lateonotherperiod = count($lateonotherperiod);
			$accounts =  [
				[
					"PEOPLE_ID"=>$data['PEOPLE_ID']
				]	
			];
			$no_of_loans =  DB::table('loan_request')->select('REQUEST_ID')->where('PEOPLE_ID',$borrower_id)->where('BOOKED', 1)->get();
			$no_of_loans = count($no_of_loans);
			$loans_id = DB::table('loan_request')->select('REQUEST_ID','REQUEST_PRINCIPAL','REQUEST_TENOR_IN_DAYS','REQUEST_RATE')->where('PEOPLE_ID',$borrower_id)->get();
			$loans_id = (json_decode(json_encode($loans_id),true));
			
			$total_schedules =  DB::table('repayment_schedule')->join('loan_request','loan_request.request_id','=','repayment_schedule.request_id')->select('REPAYMENT_SCHEDULE_ID')->where('loan_request.people_id', $borrower_id)->where('loan_request.booked', 1)->get();
			$total_schedules = count($total_schedules);
			 
			//$no_of_loans = count($no_of_loans);
			$loans_nol=[
				"nol"=> "$no_of_loans"
			];
			$total_lateness = $timesLate;
			//not used but needed to run
			$allrepaymentCreditClanLoans = $creditclanLoans;
			//
			$max_date_paid = $creditclanLoans;

			$repayments = new RepaymentsController;

			$repaymentsAnalytics = $repayments->determineRepaymentsAnalytics($leafIds="",$borrower_id,$lender_id="",$data,$row="",$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid,$timesLate,$default_loan,$lateonfirstperiod,$lateonsecondperiod,$lateonotherperiod);

            $output['repayments'] =json_decode($repaymentsAnalytics);

            $avoid_lateness = 0;
            $tendency_to_repay_early = 0;
            $avoids_default=0;
            foreach($output['repayments']->data->grades->passed as $passed_repayments)
            {
                if($passed_repayments == 6)
                {
                    $avoid_lateness += 1;
                }
                if($passed_repayments == 7)
                {
                    $avoid_lateness += 1;
                }
                if($passed_repayments == 8)
                {
                    $avoid_lateness += 1;
                }
                if($passed_repayments == 9)
                {
                    $avoid_lateness += 1;
                }
                if($passed_repayments == 13)
                {
                    $avoids_default += 1;
                }
                if($passed_repayments == 14)
                {
                    $tendency_to_repay_early += 1;
                }
                if($passed_repayments == 15)
                {
                    $tendency_to_repay_early += 1;
                }
                if($passed_repayments == 16)
                {
                    $tendency_to_repay_early += 1;
                }
               
            }

			$avoid_lateness = ($avoid_lateness/4) * 100;

            $tendency_to_repay_early = 	($tendency_to_repay_early/3) * 100;
            $avoids_default = ($avoids_default) * 100;

            $repayment_performance = [
                'avoid_lateness'=>$avoid_lateness,
                'tendency_to_repay_early'=>$tendency_to_repay_early,
                'avoids_default'=>$avoids_default,
            ];
			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',4)->get();

			$rers = collect($rers)->groupBy('node_id');

			// $node_weights = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',4)->get();
			
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['repayments']->data->grades->passed))
					{
						$passed_ids = $output['repayments']->data->grades->passed;
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['repayments']->data->grades->failed))
					{
						$failed_ids = $output['repayments']->data->grades->failed;
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
				}			
			}		
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;

			// var_dump($d);
			// die();
			foreach($d as $key=>$e)
			{
				$repayment_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$repayment_node_values->positive_score;
				}
				else
				{
					$node_score_sum -=$repayment_node_values->negative_score;
				}
			}
			// var_dump($node_score_sum);
			// die();
			$category_score_repayments = $node_score_sum/(count($d) * 10);


			$repayment_data = [
				'loans_borrowed' => $loans_borrowed,
				'total_amount_borrowed' => $total_amount_borrowed,
				'times_late' => $timesLate,
				'early_repayment' => $times_early_all,
				'maximum_days_early' => $max_early,
				'highest_principal' => $highest_principal,
				'highest_tenure' => $highest_tenure,
				'highest_interest_rate' => $highest_interest_rate,

			];

            $status['repayments'] = true;
        }
        else
        {
            $status['repayments'] = false;
        }


        if($leafids['BVN'])
		{
			$determineBVNAnalytics = $this->determineBVNAnalytics($data,$bvn_validation_paystack,$product,$result_age,$result_mobile);

			$output['BVN'] = json_decode($determineBVNAnalytics);
			
			

			$rers = DB::table('global_leaves')->select('node_id','leaf_id')->where('category_id',10)->get();
			$rers = collect($rers)->groupBy('node_id');
			
			$b = [];
			foreach($rers->toArray() as $key=>$rer)
			{
				foreach($rer as $rerkey=>$rere)
				{
					if(!empty($output['BVN']->data->grades->passed))
					{
						$passed_ids = $output['BVN']->data->grades->passed;
						foreach($passed_ids as $passed_id)
						{
							if($rere->leaf_id == $passed_id)
							{
								$b[$key][] = 1;
							}
						}
					}
					if(!empty($output['BVN']->data->grades->failed))
					{
						$failed_ids = $output['BVN']->data->grades->failed;
						foreach($failed_ids as $failed_id)
						{
							if($rere->leaf_id == $failed_id)
							{
								$b[$key][] = 0;
							}
						}
		
					}
				}			
			}	
			
			$d = [];
			foreach($b as $key=>$c)
			{
				$d[$key] = array_sum($c)/count($c);
			}
			$node_score_sum = 0;
			foreach($d as $key=>$e)
			{
				$BVN_node_values = DB::table('node_weights')->select('positive_score','negative_score')->where('node_id',$key)->get()[0];
				if($e > $general_pass_percentage)
				{
					$node_score_sum+=$BVN_node_values->positive_score;
				}
				else
				{
					$node_score_sum -= $BVN_node_values->negative_score;
				}
	
			}
			
			$category_score_BVN = $node_score_sum/(count($d) * 10);
				
            $status['BVN'] = true;
        }
        else
        {
            $status['BVN'] = false;
        }
		$allCategories = DB::table('category_weights')->select('description','weight')->get();

        $categories_all = DB::table('category_weights as c')->join('global_leaves as g','c.category_id','=','g.category_id')->select('c.description as category','g.leaf_id','g.description')->get();

		$categories_all = collect($categories_all)->groupBy('category');
        $description_profile = [];
        $description_profile['passed'] = [];
        $description_profile['failed'] = [];
        $description_calllogs = [];
        $description_calllogs['passed'] = [];
        $description_calllogs['failed'] = [];
        $description_social = [];
        $description_social['passed'] = [];
        $description_social['failed'] = [];
        $description_repayments = [];
        $description_repayments['passed'] = [];
        $description_repayments['failed'] = [];
        $description_guarantor = [];
        $description_guarantor['passed'] = [];
        $description_guarantor['failed'] = [];
        $description_card = [];
        $description_card['passed'] = [];
        $description_card['failed'] = [];
        $description_account = [];
        $description_account['passed'] = [];
        $description_account['failed'] = [];
        $description_direct_debit = [];
        $description_direct_debit['passed'] = [];
        $description_direct_debit['failed'] = [];
        $description_sms = [];
        $description_sms['passed'] = [];
        $description_sms['failed'] = [];
        $description_BVN = [];
        $description_BVN['passed'] = [];
        $description_BVN['failed'] = [];
        
		if(!isset($category_score_profile))
		{
			$category_score_profile = 0;
			$allCategories[0]->weight = 0;
        }
        else
        {
            foreach($categories_all['profile'] as $ids)
			{
                if(!empty($output['profile']->data->grades->passed))
                {
                    foreach($output['profile']->data->grades->passed as $passed_profile)
                    {
                        if($passed_profile == $ids->leaf_id)
                        {
                            $description_profile['passed'][] = $ids->description;
                        }	
                                    
                    }
                }

                if(!empty($output['profile']->data->grades->failed))
                {
                    foreach($output['profile']->data->grades->failed as $failed_profile)
                    {
                        if($failed_profile == $ids->leaf_id)
                        {
                            $description_profile['failed'][] = $ids->description;
                        }			
                    }
                }
				
				
			}
        }
		if(!isset($category_score_calllogs))
		{
			$category_score_calllogs = 0;
			$allCategories[1]->weight = 0;
        }
        else
        {
            foreach($categories_all['calllogs'] as $ids)
			{
                if(!empty($output['calllogs']->data->grades->passed))
                {
                    foreach($output['calllogs']->data->grades->passed as $passed_calllogs)
                    {
                        if($passed_calllogs == $ids->leaf_id)
                        {
                            $description_calllogs['passed'][] = $ids->description;
                        }	
                                    
                    }
                }

                if(!empty($output['calllogs']->data->grades->failed))
                {
                    foreach($output['calllogs']->data->grades->failed as $failed_calllogs)
                    {
                        if($failed_calllogs == $ids->leaf_id)
                        {
                            $description_calllogs['failed'][] = $ids->description;
                        }			
                    }
                }
				
				
			}
        }
		if(!isset($category_score_social))
		{
			$category_score_social = 0;
			$allCategories[2]->weight = 0;
        }
        else
        {
            foreach($categories_all['social'] as $ids)
			{
                if(!empty($output['social']->data->grades->passed))
                {
                    foreach($output['social']->data->grades->passed as $passed_social)
                    {
                        if($passed_social == $ids->leaf_id)
                        {
                            $description_social['passed'][] = $ids->description;
                        }	
                                    
                    }
                }

                if(!empty($output['social']->data->grades->failed))
                {
                    foreach($output['social']->data->grades->failed as $failed_social)
                    {
                        if($failed_social == $ids->leaf_id)
                        {
                            $description_social['failed'][] = $ids->description;
                        }			
                    }
                }
				
				
			} 
        }

		if(!isset($category_score_repayments))
		{
			$category_score_repayments = 0;
			$allCategories[3]->weight = 0;
        }
        else
        {
            foreach($categories_all['repayments'] as $ids)
			{
                if(!empty($output['repayments']->data->grades->passed))
                {
                    foreach($output['repayments']->data->grades->passed as $passed_repayments)
                    {
                        if($passed_repayments == $ids->leaf_id)
                        {
                            $description_repayments['passed'][] = $ids->description;
                        }	
                                    
                    }
                }

                if(!empty($output['repayments']->data->grades->failed))
                {
                    foreach($output['repayments']->data->grades->failed as $failed_repayments)
                    {
                        if($failed_repayments == $ids->leaf_id)
                        {
                            $description_repayments['failed'][] = $ids->description;
                        }			
                    }
                }
				
				
			}
        }
		if(!isset($category_score_sms))
		{
			$category_score_sms = 0;
			$allCategories[4]->weight = 0;
        }
        else
        {
            foreach($categories_all['sms'] as $ids)
			{
                if(!empty($output['sms']->analytics->passed))
                {
                    $sms_passed = explode(",",$output['sms']->analytics->passed);
                    foreach($sms_passed as $passed_sms)
                    {
                        if($passed_sms == $ids->leaf_id)
                        {
                            $description_sms['passed'][] = $ids->description;
                        }									
                    }
                }

                if(!empty($output['sms']->analytics->failed))
                {
                    $sms_failed = explode(',',$output['sms']->analytics->failed);
                    foreach($sms_failed as $failed_sms)
                    {
                        if($failed_sms == $ids->leaf_id)
                        {
                            $description_sms['failed'][] = $ids->description;
                        }		
                    }
                }
			
                if(!empty($output['sms']->analytics->no_data))
                {
                    $sms_no_data = explode(',',$output['sms']->analytics->no_data);
                    foreach($sms_no_data as $failed_sms)
                    {
                        if($failed_sms == $ids->leaf_id)
                        {
                            $description_sms['failed'][] = $ids->description;
                        }			
                    }
                }
			
			}
        }
		if(!isset($category_score_guarantor))
		{
			$category_score_guarantor = 0;
			$allCategories[5]->weight = 0;
        }
        else
        {
            foreach($categories_all['guarantor'] as $ids)
			{
                if(!empty($output['guarantor']->passed))
                {
                    $guarantor_passed = explode(',',$output['guarantor']->passed);
                    foreach($guarantor_passed as $passed_guarantor)
                    {
                        if($passed_guarantor == $ids->leaf_id)
                        {
                            $description_guarantor['passed'][] = $ids->description;
                        }									
                    }
                }

                if(!empty($output['guarantor']->failed))
                {
                    $guarantor_failed = explode(',',$output['guarantor']->failed);
                    foreach($guarantor_failed as $failed_guarantor)
                    {
                        if($failed_guarantor == $ids->leaf_id)
                        {
                            $description_guarantor['failed'][] = $ids->description;
                        }		
                    }
                }
				
                if(!empty($output['guarantor']->no_data))
                {
                    $guarantor_no_data = explode(',',$output['guarantor']->no_data);
                    foreach($guarantor_no_data as $failed_guarantor)
                    {
                        if($failed_guarantor == $ids->leaf_id)
                        {
                            $description_guarantor['failed'][] = $ids->description;
                        }			
                    }
                }
				
            }
           
        }
		if(!isset($category_score_directdebit))
		{
			$category_score_directdebit = 0;
			$allCategories[6]->weight = 0;
        }
        else
        {
            foreach($categories_all['directdebit'] as $ids)
			{
                if(!empty($output['direct_debit']->passed))
                {
                    $direct_debit_passed = explode(',',$output['direct_debit']->passed);
                    foreach($direct_debit_passed as $passed_direct_debit)
                    {
                        if($passed_direct_debit == $ids->leaf_id)
                        {
                            $description_direct_debit['passed'][] = $ids->description;
                        }									
                    }
                }

                if(!empty($output['direct_debit']->failed))
                {
                    $direct_debit_failed = explode(',',$output['direct_debit']->failed);
                    foreach($direct_debit_failed as $failed_direct_debit)
                    {
                        if($failed_direct_debit == $ids->leaf_id)
                        {
                            $description_direct_debit['failed'][] = $ids->description;
                        }		
                    }
                }
			
                if(!empty($output['direct_debit']->no_data))
                {
                    $direct_debit_no_data = explode(',',$output['direct_debit']->no_data);
                    foreach($direct_debit_no_data as $failed_direct_debit)
                    {
                        if($failed_direct_debit == $ids->leaf_id)
                        {
                            $description_direct_debit['failed'][] = $ids->description;
                        }			
                    }
                }
				
			}
        }
		if(!isset($category_score_card))
		{
			$category_score_card = 0;
			$allCategories[7]->weight = 0;
        }
        else
        {
            foreach($categories_all['card'] as $ids)
			{
                if(!empty($output['card']->data->grades->passed))
                {
                    $card_passed = $output['card']->data->grades->passed;
                    foreach($card_passed as $passed_card)
                    {
                        if($passed_card == $ids->leaf_id)
                        {
                            $description_card['passed'][] = $ids->description;
                        }									
                    }
                }

                if(!empty($output['card']->data->grades->failed))
                {
                    $card_failed =$output['card']->data->grades->failed;
                    foreach($card_failed as $failed_card)
                    {
                        if($failed_card == $ids->leaf_id)
                        {
                            $description_card['failed'][] = $ids->description;
                        }		
                    }
                }
				
				
				// $card_no_data = explode(',',$output['card']->no_data);
				// foreach($card_no_data as $failed_card)
				// {
				// 	if($failed_card == $ids->leaf_id)
				// 	{
				// 		$description_card['failed'][] = $ids->description;
				// 	}			
				// }
			} 
        }
		if(!isset($category_score_accounts))
		{
			$category_score_accounts = 0;
			$allCategories[8]->weight = 0;
        }
        else
        {
            foreach($categories_all['accounts'] as $ids)
			{
                if(!empty($output['account']->data->grades->passed))
                {
                    $account_passed =  $output['account']->data->grades->passed;
                    foreach($account_passed as $passed_account)
                    {
                        if($passed_account == $ids->leaf_id)
                        {
                            $description_account['passed'][] = $ids->description;
                        }									
                    }
                }
                if(!empty($output['account']->data->grades->failed))
                {
                    $account_failed = $output['account']->data->grades->failed;
                    foreach($account_failed as $failed_account)
                    {
                        if($failed_account == $ids->leaf_id)
                        {
                            $description_account['failed'][] = $ids->description;
                        }		
                    }
                }
				
			
				// $account_no_data = explode(',',$output['account']->no_data);
				// foreach($account_no_data as $failed_account)
				// {
				// 	if($failed_account == $ids->leaf_id)
				// 	{
				// 		$description_account['failed'][] = $ids->description;
				// 	}			
				// }
			}
        }

        if(!isset($category_score_BVN))
		{
			$category_score_BVN = 0;
			$allCategories[0]->weight = 0;
        }
        else
        {
            foreach($categories_all['BVN'] as $ids)
			{
                if(!empty($output['BVN']->data->grades->passed))
                {
                    foreach($output['BVN']->data->grades->passed as $passed_BVN)
                    {
                        if($passed_BVN == $ids->leaf_id)
                        {
                            $description_BVN['passed'][] = $ids->description;
                        }	
                                    
                    }
                }

                if(!empty($output['BVN']->data->grades->failed))
                {
                    foreach($output['BVN']->data->grades->failed as $failed_BVN)
                    {
                        if($failed_BVN == $ids->leaf_id)
                        {
                            $description_BVN['failed'][] = $ids->description;
                        }			
                    }
                }
							
			}
        }

	

		$totalSummationOfAllCategoriesTimesWeight = 	(($allCategories[0]->weight * $category_score_profile) + ($allCategories[1]->weight * $category_score_calllogs) +
		($allCategories[2]->weight * $category_score_social) +
		($allCategories[3]->weight * $category_score_repayments) +
		($allCategories[4]->weight * $category_score_sms) +
		($allCategories[5]->weight * $category_score_guarantor) +
		($allCategories[6]->weight * $category_score_directdebit) +
		($allCategories[7]->weight * $category_score_card) +
		($allCategories[8]->weight * $category_score_accounts)+
		($allCategories[9]->weight * $category_score_BVN));

		$summationOfAllWeights = ($allCategories[0]->weight + $allCategories[1]->weight +$allCategories[2]->weight + $allCategories[3]->weight + $allCategories[4]->weight +$allCategories[5]->weight+ $allCategories[6]->weight + $allCategories[7]->weight + $allCategories[8]->weight + $allCategories[9]->weight);
        if($summationOfAllWeights == 0)
        {
            $final_analytics_score = 0;
        }
        else
        {
            $final_analytics_score = $totalSummationOfAllCategoriesTimesWeight/$summationOfAllWeights;
        }
			
		$final_analytics_score = $final_analytics_score < 0 ? 0 : $final_analytics_score;

            $sms_highlights = [
                'consistency_score'=>$sms_consistency_score,
                'activeness_score'=>$sms_activeness_score,
                'ownership_score'=>$sms_ownership_score,
                'reliability_score'=>$sms_reliability_score,
                'lowrisk_score'=>$sms_lowrisk_score,
            ];
			$description = [
				'guarantor'=> $description_guarantor,
				'card'=> $description_card,
				'account'=> $description_account,
				'direct_debit'=> $description_direct_debit,
				'sms'=> $description_sms,
				'profile'=> $description_profile,
				'calllogs'=> $description_calllogs,
				'social'=> $description_social,
                'repayments'=> $description_repayments,
                'BVN'=> $description_BVN
			];

		
        $final_analytics = json_encode(['final_analytics_score'=>$final_analytics_score ,
        'status'=>$status,
		'sms'=>$category_score_sms,'dd'=>$category_score_directdebit,'accounts'=>$category_score_accounts,'card'=>$category_score_card,'guarantor'=>$category_score_guarantor,'profile'=>$category_score_profile,'calllog'=>$category_score_calllogs,'social'=>$category_score_social,'repayments'=>$category_score_repayments,'sms_highlights'=>$sms_highlights,'repayment_performance'=>$repayment_performance,
		'repayment_data'=>$repayment_data,
		'profile_compared_data'=>$profile_compared_data,'output'=>$output,
		'description'=>$description]);

	

		if($request->guarantor)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'GUARANTOR_ANALYTICS'=> $final_analytics,
					'GUARANTOR_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'GUARANTOR_ANALYTICS'=> $final_analytics,
					'GUARANTOR_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
		
        }
        
		if($request->account)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'ACCOUNT_ANALYTICS'=> $final_analytics,
					'ACCOUNT_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'ACCOUNT_ANALYTICS'=> $final_analytics,
					'ACCOUNT_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}

			
		}
		if($request->direct_debit)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'DIRECT_DEBIT_ANALYTICS'=> $final_analytics,
					'DIRECT_DEBIT_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'DIRECT_DEBIT_ANALYTICS'=> $final_analytics,
					'DIRECT_DEBIT_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			
		}
		if($request->card)
		{

			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'CARD_ANALYTICS'=> $final_analytics,
					'CARD_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'CARD_ANALYTICS'=> $final_analytics,
					'CARD_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			
		}

		if($request->smslogs)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'SMS_LOGS_ANALYTICS'=> $final_analytics,
					'SMS_LOGS_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'SMS_LOGS_ANALYTICS'=> $final_analytics,
					'SMS_LOGS_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			
		}
		if($request->profile)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'PROFILE_ANALYTICS'=> $final_analytics,
					'PROFILE_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'PROFILE_ANALYTICS'=> $final_analytics,
					'PROFILE_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			
		}
		if($request->social)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'SOCIAL_ANALYTICS'=> $final_analytics,
					'SOCIAL_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'SOCIAL_ANALYTICS'=> $final_analytics,
					'SOCIAL_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
		
		}
		if($request->repayments)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'REPAYMENTS_ANALYTICS'=> $final_analytics,
					'REPAYMENTS_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'REPAYMENTS_ANALYTICS'=> $final_analytics,
					'REPAYMENTS_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			
		}
		if($request->calllogs)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'CALLOG_ANALYTICS'=> $final_analytics,
					'CALLOG_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'CALLOG_ANALYTICS'=> $final_analytics,
					'CALLOG_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			
        }
        
        if($request->BVN)
		{
			$guarantor = DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->get();
			if(!empty($guarantor))
			{
				DB::table('analytics_results')->where('REQUEST_ID',$loan_request_id)->update([
					'BVN_ANALYTICS'=> $final_analytics,
					'BVN_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
			else
			{
				DB::table('analytics_results')->insert([
                    'REQUEST_ID'=> $loan_request_id,
					'LENDER_ID'=>$lender_id,
					'PEOPLE_ID'=>$borrower_id,
					'BVN_ANALYTICS'=> $final_analytics,
					'BVN_ANALYTICS_LAST_DONE'=> Carbon::now()
				]);
			}
		
		}

		return  $final_analytics;
	
    }
    public function strpos_array($haystack, $needles) 
	{
		$pos_arr = [];	
		foreach ($needles as $str) 
		{
			$pos = stripos($haystack, $str);
			if ($pos !== FALSE) 
			{
				$pos_arr[] = $pos;
			}		
		}
		if($pos_arr == [])
		{
			return false;
		}
		else
		{
			return true;
		}

	}

}