<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Lcobucci\JWT\Parser;

use App\Http\Requests;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class MessagesController extends Controller
{
    // private $token;
    // public function __construct($token)
    // {
    //     $this->token = $token;
    // }
    public function getUserId($token)
    {
        $parser = new Parser;
        $parsedToken = $parser->parse($token);
        $user_id = $parsedToken->getClaims()['id'];   
        return $user_id;  
    }
    public function getToken($token)
    {
        $parser = new Parser;
        $parsedToken = $parser->parse($token);
        $lender_id = $parsedToken->getClaims()['lender_id'];   
        return $lender_id;  
    }
    public function storeMessagesWithoutToken(Request $request)
    {
        //$token = $request->token;
        //$lender_id = $this->getToken($token);
        $lender_id = $request->lender_id;
        //$user_id = $this->getUserId($token);
        $people_id = $request->people_id;

        $message = $request->message;
        $notification_type = $request->notification_type;
        $people_people_ids = [];
        $has_viewed = [];
        $people_people_ids_ = DB::table('people_peoples')->select('PEOPLE_PEOPLE_ID')->where('PEOPLE_MASTER_ID',$lender_id)->get();
        foreach($people_people_ids_ as $person)
        {
            $has_viewed[] = 0;
            $people_people_ids[] = $person->PEOPLE_PEOPLE_ID;
        }
        $people_people_ids = implode(',',$people_people_ids);
        $has_viewed = implode(',',$has_viewed);
        $stored_message = DB::table('platform_notifications')->insertGetId([
            'date_added'=>Carbon::now(),
            'message'=>$message,
            'is_read'=>0,
            'lender_id'=>$lender_id,
            'people_id'=>$people_id,
            'notification_type'=>$notification_type,
            'people_people_id'=> $people_people_ids,
            'has_viewed'=> $has_viewed
        ]);
        if(!empty($stored_message))
        {
            return json_encode(['response'=>"message was stored successfully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"message was not be stored! Try Again",'status'=>false]);
        }
    }

    public function storePlatFormSettingsWithoutToken(Request $request)
    {
        // $token = $request->token;
        // $lender_id = $this->getToken($token);
        $lender_id = $request->lender_id;
        //$user_id = $this->getUserId($token);
        $notification_type = $request->notification_type;
        $use_email = $request->use_email;
        $use_push = $request->use_push;
        $use_desktop = $request->use_desktop;
        $platform_setting = DB::table('platform_notification_settings')->insertGetId([
            'notification_type'=>$notification_type,
            'lender_id'=>$lender_id,
            'use_email'=>$use_email == true ? 1:0,
            'use_push'=>$use_push == true ? 1:0,
            'use_desktop'=>$use_desktop == true ? 1:0
        ]);
        if(!empty($platform_setting))
        {
            return json_encode(['response'=>"notification settings was added successfully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"notification settings could not be added",'status'=>false]);
        }
    }

    public function readMessagesWithoutToken(Request $request)
    {
        // $token = $request->token;
        // $lender_id = $this->getToken($token);
        $lender_id = $request->lender_id;
        $lender_messages = DB::table('platform_notifications as n')->select('people_people_id','has_viewed')->where('lender_id',$lender_id)->groupBy('notification_id')->get();


        $stored_messages = DB::select("select n.*,s.use_email,s.use_push,s.use_desktop,p.LEGAL_NAME,pp.LEGAL_NAME as people_name,a.FILE_NAME,pp.PEOPLE_PEOPLE_ID as pp_id from platform_notifications as n join platform_notification_settings as s on n.notification_type=s.notification_type join people_customers as p on n.people_id=p.PEOPLE_ID left join attachments as a on p.PASSPORT_ATTACHMENT_URL=a.ATTACHMENT_ID left join people_peoples as pp on pp.PEOPLE_MASTER_ID=n.lender_id where n.lender_id=$lender_id order by pp_id");
        //return  $stored_messages ;
        //->where('n.is_read',0)
        $people_notify = [];
        $viewed_notify = [];
        if(!empty($stored_messages))
        {
            foreach($lender_messages as $stored_message)
            {
                $people_notify_ = explode(',',$stored_message->people_people_id);
                $people_notify = array_merge( $people_notify,$people_notify_);
                $viewed_notify_ = explode(',',$stored_message->has_viewed);
                $viewed_notify = array_merge( $viewed_notify,$viewed_notify_);
            }

            // return json_encode(['response'=> $people_notify,'status'=>$viewed_notify]);
           

            foreach($people_notify as $k=>$pp)
            {
                foreach($viewed_notify as $key=>$p)
                {
                    if($k == $key)
                    {
                        $a[$pp][] = $p;
                    }
                   
                }
            }
            $grouped_people_ids = $a;
            $a = [];
            foreach($grouped_people_ids as $value)
            {
                $a = array_merge($a,$value);
            }
            //return $a;
            $t = false;
            foreach($stored_messages as $k=>$message)
            {
                $t = false;
                foreach($a as $key=>$d)
                {
                    
                    if($k == $key && $d == 1)
                    {
                     
                        $message->read = true;
                      
                        break;
                       
                    }
                
                        if($k == $key && $d == 0)
                        {
                            $message->read = false;
                          
                            break;
                           
                        }
                }
           
            }
           // return $stored_messages;
            foreach($stored_messages as $k=>$message)
            {
                if($message->read == true)
                {
                    unset($stored_messages[$k]); //removes the array at given index
                   
                }
               
            }
            $reindex = array_values($stored_messages); //normalize index
            $stored_messages = $reindex;
        }
      
        return json_encode(['response'=> $stored_messages,'status'=>true]);
        
    }

    public function updateReadMessagesWithoutToken(Request $request)
    {
        // $token = $request->token;
        // $lender_id = $this->getToken($token);
        $lender_id = $request->lender_id;
        //$people_id = $request->people_id;
        $people_people_ids =  $request->people_people_ids;
      
       $notification_id = $request->notification_id;

        $message_data = DB::table('platform_notifications as n')->select('people_people_id','has_viewed')->where('notification_id',$notification_id)->get();

        if(!empty($message_data))
        {
            $all_people_people_ids = explode(',', $message_data[0]->people_people_id);

            $all_has_viewed = explode(',', $message_data[0]->has_viewed);

            foreach($all_people_people_ids as $k=>$person_id)
            {
                foreach($all_has_viewed as $v=>$view)
                {
                    if($k ==$v)
                    {
                        $groups[$person_id] = $view;
                        break;
                    }
                }
            }
            foreach($groups as $person_id=>$view)
            {
                if(in_array($person_id,$people_people_ids) && $view == 0)
                {
                    $groups[$person_id] = 1;
                }
            }
            $groups = array_values($groups);
            $groups = implode(',',$groups);
        }

        $updated_read_messages = DB::table('platform_notifications as n')->where('notification_id',$notification_id)->update([
            'has_viewed'=>$groups
        ]);
        // foreach($stored_messages as $message)
        // {
        //     $customer = DB::table('people_customers')->select('LEGAL_NAME','PASSPORT_ATTACHMENT_URL')->where('PEOPLE_ID',$message->people_id)->get();
        //     $
        // }
        
        return json_encode(['response'=> 'read messages updated successfully','status'=>true]);
        
    }


    public function getUnreadDesktopMessageWithoutToken(Request $request)
    {
        // $token = $request->token;
        // $lender_id = $this->getToken($token);
        $lender_id = $request->lender_id;
        $lender_messages = DB::table('platform_notifications as n')->join('platform_notification_settings as s','s.notification_type','=','n.notification_type')->select('people_people_id','has_viewed')->where('n.lender_id',$lender_id)->where('s.use_desktop',1)->groupBy('notification_id')->get();


        $stored_messages = DB::select("select n.*,s.use_email,s.use_push,s.use_desktop,p.LEGAL_NAME,pp.LEGAL_NAME as people_name,a.FILE_NAME,pp.PEOPLE_PEOPLE_ID as pp_id from platform_notifications as n join platform_notification_settings as s on n.notification_type=s.notification_type join people_customers as p on n.people_id=p.PEOPLE_ID left join attachments as a on p.PASSPORT_ATTACHMENT_URL=a.ATTACHMENT_ID left join people_peoples as pp on pp.PEOPLE_MASTER_ID=n.lender_id where n.lender_id=$lender_id and s.use_desktop=1 order by pp_id");
        //return  $stored_messages ;
        //->where('n.is_read',0)
        $people_notify = [];
        $viewed_notify = [];
        if(!empty($stored_messages))
        {
            foreach($lender_messages as $stored_message)
            {
                $people_notify_ = explode(',',$stored_message->people_people_id);
                $people_notify = array_merge( $people_notify,$people_notify_);
                $viewed_notify_ = explode(',',$stored_message->has_viewed);
                $viewed_notify = array_merge( $viewed_notify,$viewed_notify_);
            }

            // return json_encode(['response'=> $people_notify,'status'=>$viewed_notify]);
           

            foreach($people_notify as $k=>$pp)
            {
                foreach($viewed_notify as $key=>$p)
                {
                    if($k == $key)
                    {
                        $a[$pp][] = $p;
                    }
                   
                }
            }
            $grouped_people_ids = $a;
            $a = [];
            foreach($grouped_people_ids as $value)
            {
                $a = array_merge($a,$value);
            }
            //return $a;
            $t = false;
            foreach($stored_messages as $k=>$message)
            {
                $t = false;
                foreach($a as $key=>$d)
                {
                    
                    if($k == $key && $d == 1)
                    {
                     
                        $message->read = true;
                      
                        break;
                       
                    }
                
                        if($k == $key && $d == 0)
                        {
                            $message->read = false;
                          
                            break;
                           
                        }
                }
           
            }
           // return $stored_messages;
            foreach($stored_messages as $k=>$message)
            {
                if($message->read == true)
                {
                    unset($stored_messages[$k]); //removes the array at given index
                   
                }
               
            }
            $reindex = array_values($stored_messages); //normalize index
            $stored_messages = $reindex;
        }
      
        return json_encode(['response'=> $stored_messages,'status'=>true]);
    }

    public function getUnreadPushMessageWithoutToken(Request $request)
    {
        // $token = $request->token;
        // $lender_id = $this->getToken($token);
        $lender_id = $request->lender_id;
        $lender_messages = DB::table('platform_notifications as n')->join('platform_notification_settings as s','s.notification_type','=','n.notification_type')->select('people_people_id','has_viewed')->where('n.lender_id',$lender_id)->where('s.use_push',1)->groupBy('notification_id')->get();


        $stored_messages = DB::select("select n.*,s.use_email,s.use_push,s.use_desktop,p.LEGAL_NAME,pp.LEGAL_NAME as people_name,a.FILE_NAME,pp.PEOPLE_PEOPLE_ID as pp_id from platform_notifications as n join platform_notification_settings as s on n.notification_type=s.notification_type join people_customers as p on n.people_id=p.PEOPLE_ID left join attachments as a on p.PASSPORT_ATTACHMENT_URL=a.ATTACHMENT_ID left join people_peoples as pp on pp.PEOPLE_MASTER_ID=n.lender_id where n.lender_id=$lender_id and s.use_push=1 order by pp_id");
        //return  $stored_messages ;
        //->where('n.is_read',0)
        $people_notify = [];
        $viewed_notify = [];
        if(!empty($stored_messages))
        {
            foreach($lender_messages as $stored_message)
            {
                $people_notify_ = explode(',',$stored_message->people_people_id);
                $people_notify = array_merge( $people_notify,$people_notify_);
                $viewed_notify_ = explode(',',$stored_message->has_viewed);
                $viewed_notify = array_merge( $viewed_notify,$viewed_notify_);
            }

            // return json_encode(['response'=> $people_notify,'status'=>$viewed_notify]);
           

            foreach($people_notify as $k=>$pp)
            {
                foreach($viewed_notify as $key=>$p)
                {
                    if($k == $key)
                    {
                        $a[$pp][] = $p;
                    }
                   
                }
            }
            $grouped_people_ids = $a;
            $a = [];
            foreach($grouped_people_ids as $value)
            {
                $a = array_merge($a,$value);
            }
            //return $a;
            $t = false;
            foreach($stored_messages as $k=>$message)
            {
                $t = false;
                foreach($a as $key=>$d)
                {
                    
                    if($k == $key && $d == 1)
                    {
                     
                        $message->read = true;
                      
                        break;
                       
                    }
                
                        if($k == $key && $d == 0)
                        {
                            $message->read = false;
                          
                            break;
                           
                        }
                }
           
            }
           // return $stored_messages;
            foreach($stored_messages as $k=>$message)
            {
                if($message->read == true)
                {
                    unset($stored_messages[$k]); //removes the array at given index
                   
                }
               
            }
            $reindex = array_values($stored_messages); //normalize index
            $stored_messages = $reindex;
        }
      
        return json_encode(['response'=> $stored_messages,'status'=>true]);
    }



    public function storeMessages(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
       
        //$user_id = $this->getUserId($token);
        $people_id = $request->people_id;

        $message = $request->message;
        $notification_type = $request->notification_type;
        $people_people_ids = [];
        $has_viewed = [];
        $people_people_ids_ = DB::table('people_peoples')->select('PEOPLE_PEOPLE_ID')->where('PEOPLE_MASTER_ID',$lender_id)->get();
        foreach($people_people_ids_ as $person)
        {
            $has_viewed[] = 0;
            $people_people_ids[] = $person->PEOPLE_PEOPLE_ID;
        }
        $people_people_ids = implode(',',$people_people_ids);
        $has_viewed = implode(',',$has_viewed);
        $stored_message = DB::table('platform_notifications')->insertGetId([
            'date_added'=>Carbon::now(),
            'message'=>$message,
            'is_read'=>0,
            'lender_id'=>$lender_id,
            'people_id'=>$people_id,
            'notification_type'=>$notification_type,
            'people_people_id'=> $people_people_ids,
            'has_viewed'=> $has_viewed
        ]);
        if(!empty($stored_message))
        {
            return json_encode(['response'=>"message was stored successfully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"message was not be stored! Try Again",'status'=>false]);
        }
    }

    public function storePlatFormSettings(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        //$user_id = $this->getUserId($token);
        $notification_type = $request->notification_type;
        $use_email = $request->use_email;
        $use_push = $request->use_push;
        $use_desktop = $request->use_desktop;
        $platform_setting = DB::table('platform_notification_settings')->insertGetId([
            'notification_type'=>$notification_type,
            'lender_id'=>$lender_id,
            'use_email'=>$use_email == true ? 1:0,
            'use_push'=>$use_push == true ? 1:0,
            'use_desktop'=>$use_desktop == true ? 1:0
        ]);
        if(!empty($platform_setting))
        {
            return json_encode(['response'=>"notification settings was added successfully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"notification settings could not be added",'status'=>false]);
        }
    }

    public function readMessages(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        //return $lender_id;
        $people_people_id = $this->getUserId($token);
        //return $people_people_id;
        //$people_people_id = $request->people_people_id;
       
        $lender_messages = DB::table('platform_notifications as n')->select('people_people_id','has_viewed')->where('lender_id',$lender_id)->groupBy('notification_id')->get();


        $stored_messages = DB::select("select n.*,s.use_email,s.use_push,s.use_desktop,p.LEGAL_NAME,pp.LEGAL_NAME as people_name,a.FILE_NAME,pp.PEOPLE_PEOPLE_ID as pp_id from platform_notifications as n join platform_notification_settings as s on n.notification_type=s.notification_type join people_customers as p on n.people_id=p.PEOPLE_ID left join attachments as a on p.PASSPORT_ATTACHMENT_URL=a.ATTACHMENT_ID left join people_peoples as pp on pp.PEOPLE_MASTER_ID=n.lender_id where n.lender_id=$lender_id order by pp_id");
        //return  $stored_messages ;
        //->where('n.is_read',0)
        $people_notify = [];
        $viewed_notify = [];
        if(!empty($stored_messages))
        {
            foreach($lender_messages as $stored_message)
            {
                $people_notify_ = explode(',',$stored_message->people_people_id);
                $people_notify = array_merge( $people_notify,$people_notify_);
                $viewed_notify_ = explode(',',$stored_message->has_viewed);
                $viewed_notify = array_merge( $viewed_notify,$viewed_notify_);
            }

            // return json_encode(['response'=> $people_notify,'status'=>$viewed_notify]);
           

            foreach($people_notify as $k=>$pp)
            {
                foreach($viewed_notify as $key=>$p)
                {
                    if($k == $key)
                    {
                        $a[$pp][] = $p;
                    }
                   
                }
            }
            $grouped_people_ids = $a;
            $a = [];
            foreach($grouped_people_ids as $value)
            {
                $a = array_merge($a,$value);
            }
            //return $a;
            $t = false;
            foreach($stored_messages as $k=>$message)
            {
                $t = false;
                foreach($a as $key=>$d)
                {
                    
                    if($k == $key && $d == 1)
                    {
                     
                        $message->read = true;
                      
                        break;
                       
                    }
                
                        if($k == $key && $d == 0)
                        {
                            $message->read = false;
                          
                            break;
                           
                        }
                }
           
            }
           // return $stored_messages;
            foreach($stored_messages as $k=>$message)
            {
                if($message->read == true)
                {
                    unset($stored_messages[$k]); //removes the array at given index
                   
                }
               
            }
            $reindex = array_values($stored_messages); //normalize index
            $stored_messages = $reindex;

            $message_for_lender_employee = [];

            foreach($stored_messages as $message)
            {
                if($message->pp_id == $people_people_id)
                {
                   $message_for_lender_employee[] =  $message;
                }
            }
        }

      
        return json_encode(['response'=> $message_for_lender_employee,'status'=>true]);
        
    }

    public function updateReadMessages(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        //$people_id = $request->people_id;
        $people_people_ids =  $request->people_people_ids;
      
       $notification_id = $request->notification_id;

        $message_data = DB::table('platform_notifications as n')->select('people_people_id','has_viewed')->where('notification_id',$notification_id)->get();

        if(!empty($message_data))
        {
            $all_people_people_ids = explode(',', $message_data[0]->people_people_id);

            $all_has_viewed = explode(',', $message_data[0]->has_viewed);

            foreach($all_people_people_ids as $k=>$person_id)
            {
                foreach($all_has_viewed as $v=>$view)
                {
                    if($k ==$v)
                    {
                        $groups[$person_id] = $view;
                        break;
                    }
                }
            }
            foreach($groups as $person_id=>$view)
            {
                if(in_array($person_id,$people_people_ids) && $view == 0)
                {
                    $groups[$person_id] = 1;
                }
            }
            $groups = array_values($groups);
            $groups = implode(',',$groups);
        }

        $updated_read_messages = DB::table('platform_notifications as n')->where('notification_id',$notification_id)->update([
            'has_viewed'=>$groups
        ]);
        // foreach($stored_messages as $message)
        // {
        //     $customer = DB::table('people_customers')->select('LEGAL_NAME','PASSPORT_ATTACHMENT_URL')->where('PEOPLE_ID',$message->people_id)->get();
        //     $
        // }
        
        return json_encode(['response'=> 'read messages updated successfully','status'=>true]);
        
    }


    public function getUnreadDesktopMessage(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        
        $lender_messages = DB::table('platform_notifications as n')->join('platform_notification_settings as s','s.notification_type','=','n.notification_type')->select('people_people_id','has_viewed')->where('n.lender_id',$lender_id)->where('s.use_desktop',1)->groupBy('notification_id')->get();


        $stored_messages = DB::select("select n.*,s.use_email,s.use_push,s.use_desktop,p.LEGAL_NAME,pp.LEGAL_NAME as people_name,a.FILE_NAME,pp.PEOPLE_PEOPLE_ID as pp_id from platform_notifications as n join platform_notification_settings as s on n.notification_type=s.notification_type join people_customers as p on n.people_id=p.PEOPLE_ID left join attachments as a on p.PASSPORT_ATTACHMENT_URL=a.ATTACHMENT_ID left join people_peoples as pp on pp.PEOPLE_MASTER_ID=n.lender_id where n.lender_id=$lender_id and s.use_desktop=1");
        //return  $stored_messages;
        //->where('n.is_read',0)
        $people_notify = [];
        $viewed_notify = [];
        if(!empty($stored_messages))
        {
            foreach($lender_messages as $stored_message)
            {
                $people_notify_ = explode(',',$stored_message->people_people_id);
                $people_notify = array_merge( $people_notify,$people_notify_);
                $viewed_notify_ = explode(',',$stored_message->has_viewed);
                $viewed_notify = array_merge( $viewed_notify,$viewed_notify_);
            }

            // return json_encode(['response'=> $people_notify,'status'=>$viewed_notify]);
           

            foreach($people_notify as $k=>$pp)
            {
                foreach($viewed_notify as $key=>$p)
                {
                    if($k == $key)
                    {
                        $a[$pp][] = $p;
                    }
                   
                }
            }
            $grouped_people_ids = $a;
            $a = [];
            foreach($grouped_people_ids as $value)
            {
                $a = array_merge($a,$value);
            }
            //return $a;
            $t = false;
            foreach($stored_messages as $k=>$message)
            {
                $t = false;
                foreach($a as $key=>$d)
                {
                    
                    if($k == $key && $d == 1)
                    {
                     
                        $message->read = true;
                      
                        break;
                       
                    }
                
                        if($k == $key && $d == 0)
                        {
                            $message->read = false;
                          
                            break;
                           
                        }
                }
           
            }
           // return $stored_messages;
            foreach($stored_messages as $k=>$message)
            {
                if($message->read == true)
                {
                    unset($stored_messages[$k]); //removes the array at given index
                   
                }
               
            }
            $reindex = array_values($stored_messages); //normalize index
            $stored_messages = $reindex;
        }
      
        return json_encode(['response'=> $stored_messages,'status'=>true]);
    }

    public function getUnreadPushMessage(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        
        $lender_messages = DB::table('platform_notifications as n')->join('platform_notification_settings as s','s.notification_type','=','n.notification_type')->select('people_people_id','has_viewed')->where('n.lender_id',$lender_id)->where('s.use_push',1)->groupBy('notification_id')->get();


        $stored_messages = DB::select("select n.*,s.use_email,s.use_push,s.use_desktop,p.LEGAL_NAME,pp.LEGAL_NAME as people_name,a.FILE_NAME,pp.PEOPLE_PEOPLE_ID as pp_id from platform_notifications as n join platform_notification_settings as s on n.notification_type=s.notification_type join people_customers as p on n.people_id=p.PEOPLE_ID left join attachments as a on p.PASSPORT_ATTACHMENT_URL=a.ATTACHMENT_ID left join people_peoples as pp on pp.PEOPLE_MASTER_ID=n.lender_id where n.lender_id=$lender_id and s.use_push=1 order by pp_id");
        //return  $stored_messages ;
        //->where('n.is_read',0)
        $people_notify = [];
        $viewed_notify = [];
        if(!empty($stored_messages))
        {
            foreach($lender_messages as $stored_message)
            {
                $people_notify_ = explode(',',$stored_message->people_people_id);
                $people_notify = array_merge( $people_notify,$people_notify_);
                $viewed_notify_ = explode(',',$stored_message->has_viewed);
                $viewed_notify = array_merge( $viewed_notify,$viewed_notify_);
            }

            // return json_encode(['response'=> $people_notify,'status'=>$viewed_notify]);
           

            foreach($people_notify as $k=>$pp)
            {
                foreach($viewed_notify as $key=>$p)
                {
                    if($k == $key)
                    {
                        $a[$pp][] = $p;
                    }
                   
                }
            }
            $grouped_people_ids = $a;
            $a = [];
            foreach($grouped_people_ids as $value)
            {
                $a = array_merge($a,$value);
            }
            //return $a;
            $t = false;
            foreach($stored_messages as $k=>$message)
            {
                $t = false;
                foreach($a as $key=>$d)
                {
                    
                    if($k == $key && $d == 1)
                    {
                     
                        $message->read = true;
                      
                        break;
                       
                    }
                
                        if($k == $key && $d == 0)
                        {
                            $message->read = false;
                          
                            break;
                           
                        }
                }
           
            }
           // return $stored_messages;
            foreach($stored_messages as $k=>$message)
            {
                if($message->read == true)
                {
                    unset($stored_messages[$k]); //removes the array at given index
                   
                }
               
            }
            $reindex = array_values($stored_messages); //normalize index
            $stored_messages = $reindex;
        }
      
        return json_encode(['response'=> $stored_messages,'status'=>true]);
    }

   

}
