<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp;
//use App\Http\Requests;
use Illuminate\Support\Facades\DB;

class LenderAuthController extends Controller
{  
	public function testSetting()
	{
		$cate = 0;
		if(empty($cate))
		{
			return "cate is empty";
		}
		else
		{
			return "cate is not empty";
		} 
	
	}
	public function passRequestIdToGetOtherParams(Request $request)
	{	
		$request_id = $request->request_id;
		$loan_request = DB::table('loan_request')->select('REQUEST_ID','PLATFORM_ID','PEOPLE_ID','REQUEST_PRINCIPAL','MATURITY_DATE','CONNECTED_CARD_ID','CONNECTED_ACCOUNT_ID')->where('REQUEST_ID',$request_id)->get()[0];
		
		
		
		$profile_leafids = DB::table('lender_leaves_single')->select('profiles_leaves')->where('lender_id',$loan_request->PLATFORM_ID)->get()[0]->profiles_leaves;
		$profile_leafids = json_decode($profile_leafids); 
		$data = DB::table('people_customers As M')->select('*')->where('PEOPLE_ID',$loan_request->PEOPLE_ID)->get();
		$data = $data[0];   
		$data = json_decode(json_encode($data),true);
		
		
		$account_leaves = DB::table('lender_leaves_single')->select('account_leaves')->where('lender_id',$loan_request->PLATFORM_ID)->get()[0]->account_leaves;
		$account_leaves = json_decode($account_leaves); 
		
		
		
		 
		$leafids = [ 
			'account'=>implode(',',$account_leaves), 
		];
		$lender =[];
		$leaves_settings=DB::table('leaves_setting')->select('setting','category')->where('lender_id',$loan_request->PLATFORM_ID)->get();
		 
		
		$a = [];

		$setting_lender = $leaves_settings[0]->setting;
		$setting_lender = json_decode($setting_lender,true);
		foreach($setting_lender as $key=>$category_setting)
		{
			if(is_array($category_setting))
			{
				$lender = array_merge($lender,$category_setting);
			}
		}
		$product = $lender;
		
		$lender_extra = [ 
			"ELIGIBILITY_SETTINGS"=>[ 
				"account"=> [
					"category_id"=> "3",
					"ids"=> $leafids['account']
				] 		
			]
		];
		$lender = array_merge($lender,$lender_extra);
		$lender['GUARANTOR_ALLOWED_SECTOR'] = implode(',',$lender['GUARANTOR_ALLOWED_SECTOR']);
        $lender['GUARANTOR_ALLOWED_DESIGNATION'] = implode(',',$lender['GUARANTOR_ALLOWED_DESIGNATION']);
        $lender['ALLOWED_ACCOUNT_BANKS'] = implode(',',$lender['ALLOWED_ACCOUNT_BANKS']);
        $lender['ALLOWED_CARD_BANKS'] = implode(',',$lender['ALLOWED_CARD_BANKS']);
		$lender['ALLOWED_CARD_TYPE'] = implode(',',$lender['ALLOWED_CARD_TYPE']);
		$customer = [
			"LEGAL_NAME"=> $data['LEGAL_NAME'],
			"BORROWER_NAME"=> $data['LEGAL_NAME'],
			"MONTHLY_INCOME"=> $data['NET_MONTHLY_INCOME'],
			"MONTHLY_AIRTIME_SPENDING"=> $data['MONTHLY_TEL_INTERNET'],
			"MONTHLY_OTHER_EXPENSES_SPENDING"=> $data['MONTHLY_TEL_INTERNET'] + $data['MONTHLY_TRANSPORT']
		];
		
		
		// $loan_request_data = DB::table('loan_request')->select('REQUEST_PRINCIPAL','MATURITY_DATE')->where('REQUEST_ID',$loan_request_id)->get()[0];
		$loan = [
			"REQUEST_PRINCIPAL"=> $loan_request->REQUEST_PRINCIPAL,//250000,
			"MATURITY_DATE"=>  $loan_request->MATURITY_DATE//"2019-10-05T14:41:46.762Z"
		];
		
		$accountcard = DB::table('account_cards')->select('CARD_NAME','BANK_ID','EXP_YEAR','EXP_MONTH','CARD_TYPE')->where('ACCOUNT_CARD_ID',$loan_request->CONNECTED_ACCOUNT_ID)->get();
		 
		if(empty($accountcard)){
			$account = [
				"CARD_NAME"=>"",//"John Doe",//$accountcard->CARD_NAME,//"John Doe",
				"BANK_ID"=>""//"2"//$accountcard->BANK_ID//"2"
			];
		}else{
			$accountcard = $accountcard[0];
			$account = [
				"CARD_NAME"=>$accountcard->CARD_NAME,//"John Doe",//$accountcard->CARD_NAME,//"John Doe",
				"BANK_ID"=>$accountcard->BANK_ID//"2"//$accountcard->BANK_ID//"2"
			];
		}
		
		 
		$payload = array(
			'lender' => $lender, 
			'customer'=>$customer,
			'account'=>$account
		);
		 

		return json_encode(["lender_id"=>$loan_request->PLATFORM_ID,
		"borrower_id"=>$loan_request->PEOPLE_ID,
		"principal"=>$loan_request->REQUEST_PRINCIPAL,
		"maturity_date"=>$loan_request->MATURITY_DATE,
		"account_card_id"=>$loan_request->CONNECTED_ACCOUNT_ID,
		"loan_request_id"=>$loan_request->REQUEST_ID,
		"card_id"=>$loan_request->CONNECTED_CARD_ID,
		"payload"=>$payload]);
		
		
		
		

		// $categories['profile'] = DB::table('global_leaves')->select('leaf_id','description')->where('category_id',1)->get()[0];
	}
  

	public function determineBVNEligibility($bvn_validation_paystack,$data,$suspicious_names,$product,$result_age,$result_mobile,$lender,$leafIds)
	{		
		$grades = [];
		$newGrade = [];
	
		$leaves = [
			'compare_names_with_bvn'=>1,
			'compare_dob'=>2,
			'compare_phone_number'=>3		
		];
	
		$runEligibiltyData = $this->runBVNEligibilty($bvn_validation_paystack,$leafIds,$leaves,$data,$suspicious_names,$product,$result_age,$result_mobile);
		//return $runEligibiltyData;
 
		foreach($leafIds as $key=>$leafId)
		{
			$grades[$leafId] = empty($runEligibiltyData["leaves_grades"][$key])?[]:$runEligibiltyData["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}
		
		$eligibility_data = [];
		$eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
		$eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible"; 
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
	}
	
	public function runBVNEligibilty($bvn_validation_paystack,$leafIds,$leaves,$data,$suspicious_names,$product,$result_age,$result_mobile)
	{ 
		$total = 0;
		$leaves_grade = [];
		// 'compare_names_with_bvn'=>1,
		// 'compare_dob'=>2,
		// 'compare_phone_number'=>3
		if(in_array($leaves['compare_names_with_bvn'],$leafIds))
		{	
			if(!empty($bvn_validation_paystack[0]))
			{
				// $paystack_response = $bvn_validation_paystack[0]->PAYSTACK_RESPONSE->data;
				$paystack_response = json_decode($bvn_validation_paystack[0]->PAYSTACK_RESPONSE);
				$paystack_response = $paystack_response->data;
				$first_name =$paystack_response->first_name;
				$last_name = $paystack_response->last_name;
	
				if(stripos($data['LEGAL_NAME'],$first_name) !== false || stripos($data['LEGAL_NAME'],$last_name) !== false)
				{
					$total++;  $leaves_grade [] = "passed";
				}
				else
				{
						$leaves_grade [] = "failed";
				}	
			
	
			}

		}
	
		if(in_array($leaves['compare_dob'],$leafIds))
		{	
			if(!empty($bvn_validation_paystack[0]))
			{
				$paystack_response = json_decode($bvn_validation_paystack[0]->PAYSTACK_RESPONSE);
				$paystack_response = $paystack_response->data;
				////- Compare DOB
				$dob = $data['BIRTH_DAY'] . '-' . $data['BIRTH_MONTH'] . '-' . $data['BIRTH_YEAR'];		
				$user_dob = date("Y-m-d", strtotime($dob));
				
				// $bvn_data = $paystack_response;
				$bvn_dob = date("Y-m-d", strtotime( $paystack_response->formatted_dob));
				if($user_dob ==  $bvn_dob )
				{
					$total++;  $leaves_grade [] = "passed";
				}
				else
				{
						$leaves_grade [] = "failed";
				}
	
			}
		}

		if(in_array($leaves['compare_phone_number'],$leafIds))
		{	
			if(!empty($bvn_validation_paystack[0]))
			{
				$paystack_response = json_decode($bvn_validation_paystack[0]->PAYSTACK_RESPONSE);
				$paystack_response = $paystack_response->data;
				// - Compare Phone number
				if($paystack_response->mobile == $data['PHONE'])
				{
					$total++;  $leaves_grade [] = "passed";
				}
				else
				{
						$leaves_grade [] = "failed";
				}
			}

		}

		$result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;
    }
    public function check(Request $request)
    {
		
		$output = [];
        $borrower_id  = $request->borrower_id;
        $lender_id  = $request->lender_id;
		$loan_request_id  = $request->loan_request_id;
		$request_principal = $request->principal; 
		$request_maturity_date = $request->maturity_date;
		$account_card_id = $request->account_card_id;
		$card_id = $request->card_id;
		
		//$leaves = $request->leaves;
		// "REQUEST_PRINCIPAL"=> $request->REQUEST_PRINCIPAL,//250000,
		// 	"MATURITY_DATE"=>  $request->MATURITY_DATE//"2019-10-05T14:41:46.762Z"
		
		$timesLate = DB::select("select * from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.lender_id=$lender_id and a.people_id=$borrower_id and a.date_paid > a.repayment_date and b.booked=1");
		$timesLate = count($timesLate);
		
		
		
		$default_loan = 
		DB::select("select a.request_id,max(date(repayment_date)),max(date(date_paid)) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.LENDER_ID=$lender_id and a.PEOPLE_ID=$borrower_id and b.booked=1 group by a.request_id having max(date(date_paid)) > max(date(repayment_date))");
		$creditclanLoans = $default_loan;
    	$default_loan = count($default_loan);
		
		///max_lateness_days
		$maxlate = DB::select("select repayment_date,date_paid,datediff(date_paid,repayment_date) as dd from repayment_schedule where date_paid > repayment_date and request_id in(select request_id from loan_request where people_id=$borrower_id and booked = 1) order by  dd desc");
		if(!empty($maxlate))
		{
			$creditclanLoans = $maxlate[0]->dd;
		}
		else
		{
			$creditclanLoans = 0;
		}
		
		
		$lateonfirstperiod = DB::select("select a.repayment_date,a.date_paid,datediff(a.REPAYMENT_DATE,a.DATE_PAID) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.lender_id=$lender_id and a.people_id=$borrower_id and date(a.date_paid) > date(a.repayment_date) and b.booked=1 and a.period=1");
		$lateonfirstperiod = count($lateonfirstperiod);
		
		$lateonsecondperiod = DB::select("select a.repayment_date,a.date_paid,datediff(a.REPAYMENT_DATE,a.DATE_PAID) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.lender_id=$lender_id and a.people_id=$borrower_id and date(a.date_paid) > date(a.repayment_date) and b.booked=1 and a.period=2");
		$lateonsecondperiod = count($lateonsecondperiod);
		
		$lateonotherperiod = DB::select("select a.repayment_date,a.date_paid,datediff(a.REPAYMENT_DATE,a.DATE_PAID) from repayment_schedule as a join loan_request as b on a.request_id=b.request_id where a.lender_id=$lender_id and a.people_id=$borrower_id and date(a.date_paid) > date(a.repayment_date) and b.booked=1 and a.period>2");
		$lateonotherperiod = count($lateonotherperiod);
		
		$profile_leafids = DB::table('lender_leaves_single')->select('profiles_leaves')->where('lender_id',$lender_id)->get()[0]->profiles_leaves;
		$profile_leafids = json_decode($profile_leafids); 
		$data = DB::table('people_customers As M')->select('*')->where('PEOPLE_ID',$borrower_id)->get();
		$data = $data[0];   
		$data = json_decode(json_encode($data),true);
		
		$bvn_validation_paystack = DB::table('bvn_validation_paystack')->select('PAYSTACK_RESPONSE','BVN_PHONE')->where('BVN',$data['BVN'])->get();
		
		$result_age = "";
		$result_mobile ="";
		if(!empty($bvn_validation_paystack[0]))
		{
			$result_mobile = [
				"BVN_PHONE"=> $bvn_validation_paystack[0]->BVN_PHONE,
			];
			$result_age = [
				"PAYSTACK_RESPONSE"=> $bvn_validation_paystack[0]->PAYSTACK_RESPONSE,
			];
		}
 
       //not added yet;
       	$suspicious_names = [
        ['name'=>'Subomi'],['name'=>'Nebechi']
        ];

		

		$collection = DB::table('people_customers')->select('USER_CALL_LOGS','SMS_LOGS','FACEBOOK_DATA','TWITTER_DATA','LINKEDIN_DATA')->where('PEOPLE_ID',$borrower_id)->get();
		
		$collection = $collection[0];
		
		$facebook = json_decode($collection->FACEBOOK_DATA,true);	
		$twitterData = json_decode($collection->TWITTER_DATA,true);
		$linkedin = json_decode($collection->LINKEDIN_DATA,true);
		$sms_logs = json_decode($collection->SMS_LOGS);
		$collection = json_decode($collection->USER_CALL_LOGS);

		
		$collection = collect($collection);
		
		 
		//$general_leafids = DB::table('lender_leaves_single')->select('*')->where('lender_id',$lender_id)->get();
		$guarantor_leaves = DB::table('lender_leaves_single')->select('guarantor_leaves')->where('lender_id',$lender_id)->get()[0]->guarantor_leaves;
		$guarantor_leaves = json_decode($guarantor_leaves); 
		
		$card_leaves = DB::table('lender_leaves_single')->select('card_leaves')->where('lender_id',$lender_id)->get()[0]->card_leaves;
		$card_leaves = json_decode($card_leaves); 
		
		//		if(isset($leaves['card'])){
		//			$card_leaves = [];
		//			foreach($leaves['card'] as $leaf){
		//				if($leaf['enabled'] == true)
		//					$card_leaves[] = $leaf['value'];
		//			}
		//		}
				
		$account_leaves = DB::table('lender_leaves_single')->select('account_leaves')->where('lender_id',$lender_id)->get()[0]->account_leaves;
		$account_leaves = json_decode($account_leaves); 
		
		$directdebit_leaves = DB::table('lender_leaves_single')->select('directdebit_leaves')->where('lender_id',$lender_id)->get()[0]->directdebit_leaves;
		$directdebit_leaves = json_decode($directdebit_leaves); 
		
		$sms_leaves = DB::table('lender_leaves_single')->select('sms_leaves')->where('lender_id',$lender_id)->get()[0]->sms_leaves;
		$sms_leaves = json_decode($sms_leaves); 
		
		$social_leaves = DB::table('lender_leaves_single')->select('social_leaves')->where('lender_id',$lender_id)->get()[0]->social_leaves;
		$social_leaves = json_decode($social_leaves); 
		
		$repayment_leaves = DB::table('lender_leaves_single')->select('repayment_leaves')->where('lender_id',$lender_id)->get()[0]->repayment_leaves;
		$repayment_leaves = json_decode($repayment_leaves); 
		
		
		$calllog_leaves = DB::table('lender_leaves_single')->select('calllog_leaves')->where('lender_id',$lender_id)->get()[0]->calllog_leaves;
		$calllog_leaves = json_decode($calllog_leaves); 

		$bvn_leaves = DB::table('lender_leaves_single')->select('bvn_leaves')->where('lender_id',$lender_id)->get()[0]->bvn_leaves;
		$bvn_leaves = json_decode($bvn_leaves); 
						 
		$leafids = [
			'guarantor'=>implode(',',$guarantor_leaves),
			'card'=>implode(',',$card_leaves),
			'account'=>implode(',',$account_leaves),
			'direct_debit'=>implode(',',$directdebit_leaves),
			'smslogs'=>implode(',',$sms_leaves),
			'social'=>implode(',',$social_leaves),
			'repayments'=>implode(',',$repayment_leaves),
            'calllogs'=>implode(',',$calllog_leaves),
			'profile'=>implode(',',$profile_leafids),
			'bvn'=>implode(',',$bvn_leaves),
		];
		$lender =[];
		$leaves_settings=DB::table('leaves_setting')->select('setting','category')->where('lender_id',$lender_id)->get();
				
		$a = [];

		$setting_lender = $leaves_settings[0]->setting;
		$setting_lender = json_decode($setting_lender,true);
		foreach($setting_lender as $key=>$category_setting)
		{
			if(is_array($category_setting))
			{
				$lender = array_merge($lender,$category_setting);
			}
		}

		  
        $lender['ALLOWED_CONNECTIONS'] = ($lender['ALLOWED_CONNECTIONS'] != "") ? (int)$lender['ALLOWED_CONNECTIONS'] : 0;

        $lender['MIN_RANGE'] = ($lender['MIN_RANGE'] != "") ? (int)$lender['MIN_RANGE'] : 0;

        $lender['MAX_RANGE'] = ($lender['MAX_RANGE'] != "") ? (int)$lender['MAX_RANGE'] : 0;

        $lender['FOLLOWERS_COUNT_ALLOWED'] = ($lender['FOLLOWERS_COUNT_ALLOWED'] != "") ? (int)$lender['FOLLOWERS_COUNT_ALLOWED'] : 0;

        $lender['FOLLOWING_COUNT_ALLOWED'] = ($lender['FOLLOWING_COUNT_ALLOWED'] != "") ? (int)$lender['FOLLOWING_COUNT_ALLOWED'] : 0;

        $lender['FOLLOWERS_TO_FOLLOWING_RATIO_ALLOWED'] = ($lender['FOLLOWERS_TO_FOLLOWING_RATIO_ALLOWED'] != "") ? (float)$lender['FOLLOWERS_TO_FOLLOWING_RATIO_ALLOWED'] : 0;

        $lender['FAVOURITE_COUNT_ALLOWED'] = ($lender['FAVOURITE_COUNT_ALLOWED'] != "") ? (int)$lender['FAVOURITE_COUNT_ALLOWED'] : 0;

		$lender['STATUSES_COUNT_ALLOWED'] = ($lender['STATUSES_COUNT_ALLOWED'] != "") ? (int)$lender['STATUSES_COUNT_ALLOWED'] : 0;
		
		$lender['GUARANTOR_ALLOWED_SECTOR'] = implode(',',$lender['GUARANTOR_ALLOWED_SECTOR']);
        $lender['GUARANTOR_ALLOWED_DESIGNATION'] = implode(',',$lender['GUARANTOR_ALLOWED_DESIGNATION']);
        $lender['ALLOWED_ACCOUNT_BANKS'] = implode(',',$lender['ALLOWED_ACCOUNT_BANKS']);
        $lender['ALLOWED_CARD_BANKS'] = implode(',',$lender['ALLOWED_CARD_BANKS']);
		$lender['ALLOWED_CARD_TYPE'] = implode(',',$lender['ALLOWED_CARD_TYPE']);

		$lender['PERCENTAGE_OVERALL'] = ($lender['PERCENTAGE_OVERALL'] != "") ? (int)$lender['PERCENTAGE_OVERALL'] : 0;
        $lender['PERCENTAGE_INCOME_TO_CREDIT'] = ($lender['PERCENTAGE_INCOME_TO_CREDIT'] != "") ? (int)$lender['PERCENTAGE_INCOME_TO_CREDIT'] : 0;

        $lender['PERCENTAGE_OVERSPENDING'] = ($lender['PERCENTAGE_OVERSPENDING'] != "") ? (int)$lender['PERCENTAGE_OVERSPENDING'] : 0;

        $lender['PERCENTAGE_CREDIT_DEBIT_INCOME'] = ($lender['PERCENTAGE_CREDIT_DEBIT_INCOME'] != "") ? (int)$lender['PERCENTAGE_CREDIT_DEBIT_INCOME'] : 0;

        $lender['PERCENTAGE_INCOME_TO_DEBIT'] = ($lender['PERCENTAGE_INCOME_TO_DEBIT'] != "") ? (int)$lender['PERCENTAGE_INCOME_TO_DEBIT'] : 0;

        $lender['PERCENTAGE_AIRTIME_TO_INCOME'] = ($lender['PERCENTAGE_AIRTIME_TO_INCOME'] != "") ? (int)$lender['PERCENTAGE_AIRTIME_TO_INCOME'] : 0;

        $lender['PERCENTAGE_OTHER_EXPENSES_TO_INCOME'] = ($lender['PERCENTAGE_OTHER_EXPENSES_TO_INCOME'] != "") ? (int)$lender['PERCENTAGE_OTHER_EXPENSES_TO_INCOME'] : 0;

        $lender['PERCENTAGE_INCOME_TO_MONTHLY_SALARY_TOTAL'] = ($lender['PERCENTAGE_INCOME_TO_MONTHLY_SALARY_TOTAL'] != "") ? (int)$lender['PERCENTAGE_INCOME_TO_MONTHLY_SALARY_TOTAL'] : 0;

        $lender['PERCENTAGE_AVERAGE_CREDIT'] = ($lender['PERCENTAGE_AVERAGE_CREDIT'] != "") ? (int)$lender['PERCENTAGE_AVERAGE_CREDIT'] : 0;

        $lender['PERCENTAGE_AVERAGE_DEBIT'] = ($lender['PERCENTAGE_AVERAGE_DEBIT'] != "") ? (int)$lender['PERCENTAGE_AVERAGE_DEBIT'] : 0;
		
		$product = $lender;
		
		// var_dump($lender);
		// die();
		
		$lender_extra = [ 
			"ELIGIBILITY_SETTINGS"=>[
				"sms"=> [
					"ids"=> $leafids['smslogs'],
					"category_id"=> "5",
				],
				
				"guarantor"=> [
					"category_id"=> "1",
					"ids"=> $leafids['guarantor']
				],
				"card"=> [
					"category_id"=> "2",
					"ids"=> $leafids['card']
				],
				"account"=> [
					"category_id"=> "3",
					"ids"=> $leafids['account']
				],
				"direct_debit"=> [
					"category_id"=> "4",
					"ids"=>  $leafids['direct_debit']
				]			
			]
		];
		$lender = array_merge($lender,$lender_extra);
		
		$customer = [
			"LEGAL_NAME"=> $data['LEGAL_NAME'],
			"BORROWER_NAME"=> $data['LEGAL_NAME'],
			"MONTHLY_INCOME"=> $data['NET_MONTHLY_INCOME'],
			"MONTHLY_AIRTIME_SPENDING"=> $data['MONTHLY_TEL_INTERNET'],
			"MONTHLY_OTHER_EXPENSES_SPENDING"=> $data['MONTHLY_TEL_INTERNET'] + $data['MONTHLY_TRANSPORT']
		];

		$guarantor_eligibility_settings = 
		[
			"guarantor"=> [
				"category_id"=> "1",
				"settings"=> $leafids['guarantor']
			],
			"card"=> [
				"category_id"=> "2",
				"settings"=> $leafids['card']
			],
			"account"=> [
				"category_id"=> "3",
				"settings"=> $leafids['account']
			],
			"direct_debit"=> [
				"category_id"=> "4",
				"settings"=>  $leafids['direct_debit']
			]
		
		];

		// $rg_id =DB::table('request_guarantors')->select('RG_ID','DATE_ADDED','DATE_MODIFIED')->where('REQUEST_ID',$loan_request_id)->where('STATUS',1)->get()[0];
		// $work_rg_id = DB::table('guarantor_work')->select('WORK_DESIGNATION','WORK_SECTOR','MONTHLY_INCOME')->where('RG_ID',$rg_id->RG_ID)->get()[0];
		// $address_rg_id = DB::table('guarantor_address')->select('ADDRESS','NATURE_OF_ACCOMODATION','TIME_AT_CURRENT_ADDRESS')->where('RG_ID',$rg_id->RG_ID)->get()[0];

		// $accountcard_rg_id = DB::table('guarantor_repayment')->select('ACCOUNT_CARD_ID')->where('RG_ID',$rg_id->RG_ID)->where('REPAYMENT_TYPE',3)->get()[0]->ACCOUNT_CARD_ID;
		// $accountcard = DB::table('account_cards')->select('CARD_NAME','EXP_YEAR','EXP_MONTH','BANK_ID','CARD_TYPE')->where('ACCOUNT_CARD_ID',$accountcard_rg_id)->get()[0];

		$guarantor =  [
			"work"=> [
			  "WORK_SECTOR"=> "4",//$work_rg_id->WORK_SECTOR,//
			  "WORK_DESIGNATION"=>"12",// $work_rg_id->WORK_DESIGNATION,//
			  "MONTHLY_INCOME"=> 100000//$work_rg_id->MONTHLY_INCOME//
			],
			"address"=> [
			  "ADDRESS"=> "15, Bode Thomas Street, Surulere, Lagos",//$address_rg_id->ADDRESS,//
			  "NATURE_OF_ACCOMMODATION"=>"2",// $address_rg_id->NATURE_OF_ACCOMODATION,//
			  "TIME_AT_CURRENT_ADDRESS"=> 3//$address_rg_id->TIME_AT_CURRENT_ADDRESS//
			],
			"basic"=> [
			  "PHONE_VERIFIED"=> true,
			  "EMAIL_VERIFIED"=> true
			],
			"card"=> [
			"BANK_ID"=> "2",//$accountcard->BANK_ID,//"2",
			"EXP_YEAR"=> "2023",//$accountcard->EXP_YEAR,//"2023",
			"EXP_MONTH"=> "04",//$accountcard->EXP_MONTH,//"04",
			"CARD_TYPE"=> "3"//$accountcard->CARD_TYPE //"3"
			  ]
		];
		
		// $loan_request_data = DB::table('loan_request')->select('REQUEST_PRINCIPAL','MATURITY_DATE')->where('REQUEST_ID',$loan_request_id)->get()[0];
		$loan = [
			"REQUEST_PRINCIPAL"=> $request_principal,//250000,
			"MATURITY_DATE"=>  $request_maturity_date//"2019-10-05T14:41:46.762Z"
		];

		$request_guarantor = [
			"DATE_ADDED"=>"2019-01-05T14:41:46.762Z",//$rg_id->DATE_ADDED,//
			"DATE_MODIFIED"=>"2019-01-15T14:41:46.762Z"// $rg_id->DATE_MODIFIED//
		];
		$accountcard = DB::table('account_cards')->select('CARD_NAME','BANK_ID','EXP_YEAR','EXP_MONTH','CARD_TYPE')->where('ACCOUNT_CARD_ID',$account_card_id)->get();
		 
		if(empty($accountcard)){
			$account = [
				"CARD_NAME"=>"",//"John Doe",//$accountcard->CARD_NAME,//"John Doe",
				"BANK_ID"=>""//"2"//$accountcard->BANK_ID//"2"
			];
		}else{
			$accountcard = $accountcard[0];
			$account = [
				"CARD_NAME"=>$accountcard->CARD_NAME,//"John Doe",//$accountcard->CARD_NAME,//"John Doe",
				"BANK_ID"=>$accountcard->BANK_ID//"2"//$accountcard->BANK_ID//"2"
			];
		}
		
		
		//var_dump($account);
		$cardcard = DB::table('account_cards')->select('CARD_NAME','BANK_ID','EXP_YEAR','EXP_MONTH','CARD_TYPE','PAYSTACK_CHECK_ID')->where('ACCOUNT_CARD_ID',$card_id)->get();
		
		if(!empty($cardcard)){
			$cardcard = $cardcard[0];
			
			$paystack_response = json_decode($cardcard->PAYSTACK_CHECK_ID,true);
		 
			if(!empty($paystack_response)){
				$cardbank = DB::table('banks_list')->select('bank_id')->where('paystack_bank_name',$paystack_response['authorization']['bank'])->get();
				$cardbrand = DB::table('card_types')->select('card_type_id')->where('card_name',$paystack_response['authorization']['brand'])->get()[0];
				if(!empty($cardbank)){
					$cardbank = $cardbank[0];
					
					
					$card = [
						"BANK_ID"=>empty($cardbank)?0:$cardbank->bank_id,//"3", 
						"EXP_YEAR"=> $paystack_response['authorization']['exp_year'],//"2023",
						"EXP_MONTH"=> $paystack_response['authorization']['exp_month'],//"04",
						"CARD_TYPE"=> $cardbrand->card_type_id,//"3"
					];
					
				}else{
					
					$card = [
						"BANK_ID"=>"",//"3", 
						"EXP_YEAR"=> $paystack_response['authorization']['exp_year'],//"2023",
						"EXP_MONTH"=> $paystack_response['authorization']['exp_month'],//"04",
						"CARD_TYPE"=> $cardbrand->card_type_id,//"3"
					];
				} 
				
			}else{
				$card = [
					"BANK_ID"=>"",//"3",
					"EXP_YEAR"=> "",//"2023",
					"EXP_MONTH"=> "",//"04",
					"CARD_TYPE"=>"",//"3"
				];
			}
		}else{
			 $card = [
				"BANK_ID"=>"",//"3",
				"EXP_YEAR"=> "",//"2023",
				"EXP_MONTH"=> "",//"04",
				"CARD_TYPE"=>"",//"3"
			];
		}
		
		
		$direct_debit = DB::table('direct_debit_request')->select('IS_ACTIVE','ACCOUNT_CARD_ID')->where('request_id',$loan_request_id)->get();
		
		$analytics_weight_settings = [
			"AIRTIME"=>[
				"POSITIVE"=> 10,
				"NEGATIVE"=> -100,
				"NO_DATA"=> 0
			],
			"CREDIT"=>[
				"POSITIVE"=> 10,
				"NEGATIVE"=> -100,
				"NO_DATA"=> 0
			],
			"DEBIT"=>[
				"POSITIVE"=> 10,
				"NEGATIVE"=> -100,
				"NO_DATA"=> 0
			],
			"LOAN"=>[
				"POSITIVE"=> 10,
				"NEGATIVE"=> -100,
				"NO_DATA"=> 0
			],
			"LOAN_REPAYMENT"=>[
				"POSITIVE"=> 10,
				"NEGATIVE"=> -100,
				"NO_DATA"=> 0
			],
			"SALARY"=>[
				"POSITIVE"=> 10,
				"NEGATIVE"=> -100,
				"NO_DATA"=> 0
			],
			"PHONE_OWNERSHIP"=>[
				"POSITIVE"=> 10,
				"NEGATIVE"=> -100,
				"NO_DATA"=> 0
			],
			"OTHER_EXPENSES"=>[
				"POSITIVE"=> 10,
				"NEGATIVE"=> -100,
				"NO_DATA"=> 0
			],

		];
		$output['passed'] = "";
		$output['failed'] = "";
		$output['passed_total'] = 0;
		$output['failed_total'] = 0;
		
		
		
		
		$status = [];
		//guarantor
		if($leafids['guarantor'])
		{
			// $payload = array(
			// 	'lender' => $lender,
			// 	'guarantor' => $guarantor,
			// 	'loan'=>$loan,
			// 	'request_guarantor'=>$request_guarantor,
			// 	'customer'=>$customer,
			// 	'account'=>$account,
			// 	'card'=>$card,
			// 	'guarantor'=>$guarantor,	
			// );
			
			// $payload = json_encode($payload);	 
			// // Prepare new cURL resource
			// $ch = curl_init('https://smsanalytics.creditclan.com/eligibility/guarantor');
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			// curl_setopt($ch, CURLOPT_POST, true);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// // Set HTTP Header for POST request 
			// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			// 	'Content-Type: application/json',
			// 	'Content-Length: ' . strlen($payload))
			// );
			 
			// // Submit the POST request
			// $result_guarantor = curl_exec($ch);
			// $output['guarantor'] = json_decode($result_guarantor);
			$output['guarantor'] = $request->prefetch_value;
			if($output['guarantor']->passed != "")
			{
				$output['passed'] .=','. $output['guarantor']->passed;
				$output['passed_total'] += count(explode(',',$output['guarantor']->passed));
			}
			if($output['guarantor']->failed != "")
			{
				$output['failed'] .= ','.$output['guarantor']->failed;
				$output['failed_total'] += count(explode(',',$output['guarantor']->failed));
			}
			// Close cURL session handle
			// curl_close($ch);	
			$status['guarantor'] = true;
		}
		else
        {
            $status['guarantor'] = false;
		}
		

		if($leafids['card'] && $card['CARD_TYPE']!="")
		{	
			$payload = array(
				'lender' => $lender,
				//'guarantor' => $guarantor,
				'loan'=>$loan,
				//'request_guarantor'=>$request_guarantor,
				'customer'=>$customer,
				'account'=>$account,
				'card'=>$card,
				//'direct_debit'=>$direct_debit,	
			);  
			
			/*$payload = json_encode($payload);	 
			
			 Prepare new cURL resource
			$ch = curl_init('https://smsanalytics.creditclan.com/eligibility/card');
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $payload); 
			 Set HTTP Header for POST request 
			curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				Content-Type: application/json')
			);
			 Submit the POST request
			$result_card = curl_exec($ch);
			 Close cURL session handle
			curl_close($ch);
			return json_encode($result_card); 
			$output['card'] = json_decode($result_card);
			
			if($output['card']->passed != "")
			{
				$output['passed'] .=','. $output['card']->passed;
				$output['passed_total'] += count(explode(',',$output['card']->passed));
			}
			if($output['card']->failed != "")
			{
				$output['failed'] .= ','.$output['card']->failed;
				$output['failed_total'] += count(explode(',',$output['card']->failed));
			}
			$status['card'] = true;	*/
			$card_leafids = explode(',',$leafids['card']);
			$card_leafids = array_map(function($value) {
				return intval($value);
			}, $card_leafids);
			sort($card_leafids);
			
			$cardEligibility = new CardController;
			$cardEligibilityData = $cardEligibility->determineCardEligibility($data,$payload,$lender,$card_leafids);
			
			$output['card'] = json_decode($cardEligibilityData);
			
			if(!empty($output['card']->data->grades->passed))
			{
				$output['passed'] .=','. implode(',',$output['card']->data->grades->passed);
				$output['passed_total'] += count($output['card']->data->grades->passed);
			}
			if(!empty($output['card']->data->grades->failed))
			{
				$output['failed'] .=','. implode(',',$output['card']->data->grades->failed);
				$output['failed_total'] += count($output['card']->data->grades->failed);
			}
			$status['card'] = true;
		}
		else
        {
            $status['card'] = false;
        }
		
		//this is for card
		/**/
		//return json_encode($output);
		if($leafids['account'])
		{
			$payload = array(
				'lender' => $lender,
				//'guarantor' => $guarantor,
				//'loan'=>$loan,
				//'request_guarantor'=>$request_guarantor,
				'customer'=>$customer,
				'account'=>$account,
				'card'=>$card,
				//'direct_debit'=>$direct_debit,	
			);
			
			/*$payload = json_encode($payload);	 
			// Prepare new cURL resource
			$ch = curl_init('https://smsanalytics.creditclan.com/eligibility/account');
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// Set HTTP Header for POST request 
			curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				'Content-Type: application/json',
				'Content-Length: ' . strlen($payload))
			);
			 
			// Submit the POST request
			$result_account = curl_exec($ch);*/
			//$output['account'] = json_decode($result_account);
			$account_leafids = explode(',',$leafids['account']);
			$account_leafids = array_map(function($value) {
				return intval($value);
			}, $account_leafids);
			sort($account_leafids);
			
			$accountEligibility = new AccountController;
			$accountEligibilityData = $accountEligibility->determineAccountEligibility($data,$payload,$lender,$account_leafids);
			
			$output['account'] = json_decode($accountEligibilityData);
			
			/*if($output['account']->passed != "")
			{
				$output['passed'] .=','. $output['account']->passed;
				$output['passed_total'] += count(explode(',',$output['account']->passed));
			}
			if($output['account']->failed != "")
			{
				$output['failed'] .= ','.$output['account']->failed;
				$output['failed_total'] += count(explode(',',$output['account']->failed));
			}*/
			
			// Close cURL session handle
			//curl_close($ch);
			if(!empty($output['account']->data->grades->passed))
			{
				$output['passed'] .=','. implode(',',$output['account']->data->grades->passed);
				$output['passed_total'] += count($output['account']->data->grades->passed);
			}
			if(!empty($output['card']->data->grades->failed))
			{
				$output['failed'] .=','. implode(',',$output['account']->data->grades->failed);
				$output['failed_total'] += count($output['account']->data->grades->failed);
			}
			$status['account'] = true;
			//$status['account'] = false;
			
		}
		else
        {
            $status['account'] = false;
        }
		
		if($leafids['direct_debit'])
		{
			// $payload = array(
			// 	'lender' => $lender,
			// 	'guarantor' => $guarantor,
			// 	'loan'=>$loan,
			// 	'request_guarantor'=>$request_guarantor,
			// 	'customer'=>$customer,
			// 	'account'=>$account,
			// 	'card'=>$card,
			// 	'direct_debit'=>$direct_debit,	
			// );
			
			// $payload = json_encode($payload);	 
			// // Prepare new cURL resource
			// $ch = curl_init('https://smsanalytics.creditclan.com/eligibility/direct_debit');
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			// curl_setopt($ch, CURLOPT_POST, true);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// // Set HTTP Header for POST request 
			// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			// 	'Content-Type: application/json',
			// 	'Content-Length: ' . strlen($payload))
			// );
			 
			// // Submit the POST request
			// $result_direct_debit = curl_exec($ch);
			// $output['direct_debit'] = json_decode($result_direct_debit);
			$output['direct_debit'] = $request->prefetch_value;
			if($output['direct_debit']->passed != "")
			{
				$output['passed'] .=','. $output['direct_debit']->passed;
				$output['passed_total'] += count(explode(',',$output['direct_debit']->passed));
			}
			if($output['direct_debit']->failed != "")
			{
				$output['failed'] .= ','.$output['direct_debit']->failed;
				$output['failed_total'] += count(explode(',',$output['direct_debit']->failed));
			}
			// Close cURL session handle
			// curl_close($ch);	
			$status['direct_debit'] = true;
		}
		else
        {
            $status['direct_debit'] = false;
        }
		 
		if($leafids['smslogs'])
		{
			// $eligibility_settings = [
			// 	"ids"=>$leafids['smslogs'],
			// 	"category_id"=> 5,
			// ];

			// $payload = array(
			// 	'customer' => $customer,
			// 	'lender' => $lender,
			// 	//'analytics_weight_settings' => $analytics_weight_settings,
			// 	'sms_logs' => empty($sms_logs)?[]:$sms_logs,
			// 	//'eligibility_settings'=>$eligibility_settings,
			// );
			 
			// $payload = json_encode($payload);	 
			// // Prepare new cURL resource
			// $ch = curl_init('https://smsanalytics.creditclan.com/eligibility/sms');
			// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			// curl_setopt($ch, CURLINFO_HEADER_OUT, true);
			// curl_setopt($ch, CURLOPT_POST, true);
			// curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			 
			// // Set HTTP Header for POST request 
			// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			// 	'Content-Type: application/json',
			// 	'Content-Length: ' . strlen($payload))
			// );
			 
			// // Submit the POST request
			// $result_s = curl_exec($ch);
			// $output['sms'] = json_decode($result_s); 

			// var_dump($output['sms']);
			// die();
			$output['sms'] = ($request->prefetch_value);
			if($output['sms']->passed != "")
			{
				$output['passed'] .=','. $output['sms']->passed;
				$output['passed_total'] += count(explode(',',$output['sms']->passed));
			}
			if($output['sms']->failed != "")
			{
				$output['failed'] .= ','.$output['sms']->failed;
				$output['failed_total'] += count(explode(',',$output['sms']->failed));
			}
			// Close cURL session handle
			// curl_close($ch);
			$status['smslogs'] = true;
		}
		else
        {
            $status['smslogs'] = false;
        }	
		
		//this is for profile
		if($profile_leafids != [] && !empty($profile_leafids))
		{
			// $profile_leafids = explode(',',$leafids['profile']);
			$profile_leafids = array_map(function($value) {
				return intval($value);
			}, $profile_leafids);		
			sort($profile_leafids);
			// var_dump($profile_leafids);
			// die();
			$determineEligibilityData = $this->determineEligibility($data,$suspicious_names,$product,$result_age,$result_mobile,$lender,$profile_leafids);


			$output['profile'] = json_decode($determineEligibilityData);
			if(!empty($output['profile']->data->grades->passed))
			{
				$output['passed'] .=','. implode(',',$output['profile']->data->grades->passed);
				$output['passed_total'] += count($output['profile']->data->grades->passed);
			}
			if(!empty($output['profile']->data->grades->failed))
			{
				$output['failed'] .=','. implode(',',$output['profile']->data->grades->failed);
				$output['failed_total'] += count($output['profile']->data->grades->failed);
			}
			$status['profile'] = true;
		}
		else
        {
            $status['profile'] = false;
        } 
		
		//this is for calllogs
		if($leafids['calllogs'] && sizeof($collection) > 0)
		{
			 
			$calllogs_leafids = explode(',',$leafids['calllogs']);
			$calllogs_leafids = array_map(function($value) {
				return intval($value);
			}, $calllogs_leafids);
			sort($calllogs_leafids);
			$callLog = new CalllogsController;
			
			$callLogEligibilityData = $callLog->determineCallLogsEligibility($data,$collection,$lender,$calllogs_leafids);
			$output['calllogs'] = json_decode($callLogEligibilityData);
			if(!empty($output['calllogs']->data->grades->passed))
			{
				$output['passed'] .=','. implode(',',$output['calllogs']->data->grades->passed);
				$output['passed_total'] += count($output['calllogs']->data->grades->passed);
			}
			if(!empty($output['calllogs']->data->grades->failed))
			{
				$output['failed'] .=','. implode(',',$output['calllogs']->data->grades->failed);
				$output['failed_total'] += count($output['calllogs']->data->grades->failed);
			}
			$status['calllogs'] = true;
		}
		else
        {
            $status['calllogs'] = false;
        }
		
		$social = 0;
		if(sizeof($facebook) > 0){
			$social++;
		}
		if(sizeof($twitterData) > 0){
			$social++;
		}
		if(sizeof($linkedin) > 0){
			$social++;
		}
		//this is for social
		if($leafids['social'] && $social > 0)
		{ 
			$social_leafids = explode(',',$leafids['social']);
			$social_leafids = array_map(function($value) {
				return intval($value);
			}, $social_leafids);
			sort($social_leafids);
			$social = new SocialController;
			$socialEligibilityData = $social->determineSocialEligibility($social_leafids,$lender,$data,$facebook,$twitterData,$linkedin,$row="");
			$output['social'] = json_decode($socialEligibilityData);
			if(!empty($output['social']->data->grades->passed))
			{
				$output['passed'] .=','. implode(',',$output['social']->data->grades->passed);
				$output['passed_total'] += count($output['social']->data->grades->passed);
			}
			if(!empty($output['social']->data->grades->failed))
			{
				$output['failed'] .=','. implode(',',$output['social']->data->grades->failed);
				$output['failed_total'] += count($output['social']->data->grades->failed);
			}
			$status['social'] = true;
		}
		else
        {
            $status['social'] = false;
        }
		
		if($leafids['repayments'])
		{
			$accounts =  [
				[
					"PEOPLE_ID"=>$data['PEOPLE_ID']
				]
	
			];
			$no_of_loans =  DB::table('loan_request')->select('REQUEST_ID')->where('PEOPLE_ID',$borrower_id)->where('BOOKED', 1)->get();
			$no_of_loans = count($no_of_loans);
			$loans_id = DB::table('loan_request')->select('*')->where('PEOPLE_ID',$borrower_id)->get();
			$loans_id = json_decode(json_encode($loans_id),true);
			// var_dump($loans_id);
			// die();
			$total_schedules =  DB::table('repayment_schedule')->join('loan_request','loan_request.request_id','=','repayment_schedule.request_id')->select('REPAYMENT_SCHEDULE_ID')->where('loan_request.people_id', $borrower_id)->where('loan_request.booked', 1)->get();
			$total_schedules = count($total_schedules);
			 
			//$no_of_loans = count($no_of_loans);
			$loans_nol=[
				"nol"=> "$no_of_loans"
			];
			//$loans_id = [];
			$total_lateness = $timesLate;

			//$total_schedules = 0;
			$allrepaymentCreditClanLoans = $creditclanLoans;

			$max_date_paid = $creditclanLoans;

			$repayments_leafids = explode(',',$leafids['repayments']);
			$repayments_leafids = array_map(function($value) {
				return intval($value);
			}, $repayments_leafids);
			sort($repayments_leafids);
		 
			
			$repayments = new RepaymentsController;
			$repaymentsEligibilityData = $repayments->determineRepaymentsEligibility($repayments_leafids,$borrower_id,$lender_id="",$data,$row="",$accounts,$loans_nol,$loans_id,$total_lateness,$total_schedules,$allrepaymentCreditClanLoans,$max_date_paid,$timesLate,$default_loan,$lateonfirstperiod,$lateonsecondperiod,$lateonotherperiod);
			$output['repayments'] =json_decode($repaymentsEligibilityData);
			if(!empty($output['repayments']->data->grades->passed))
			{
				$output['passed'] .=','. implode(',',$output['repayments']->data->grades->passed);
				$output['passed_total'] += count($output['repayments']->data->grades->passed);
			}
			if(!empty($output['repayments']->data->grades->failed))
			{
				$output['failed'] .=','. implode(',',$output['repayments']->data->grades->failed);
				$output['failed_total'] += count($output['repayments']->data->grades->failed);
			}
			$status['repayments'] = true;
		}
		else
        {
            $status['repayments'] = false;
		}
		
		if(!empty($bvn_leaves))
		{
			$bvn_leaves = array_map(function($value) {
				return intval($value);
			}, $bvn_leaves);		
			sort($bvn_leaves);

			$determineBVNEligibilityData = $this->determineBVNEligibility($bvn_validation_paystack,$data,$suspicious_names,$product,$result_age,$result_mobile,$lender,$bvn_leaves);

			$output['BVN'] = json_decode($determineBVNEligibilityData);
			if(!empty($output['BVN']->data->grades->passed))
			{
				$output['passed'] .=','. implode(',',$output['BVN']->data->grades->passed);
				$output['passed_total'] += count($output['BVN']->data->grades->passed);
			}
			if(!empty($output['BVN']->data->grades->failed))
			{
				$output['failed'] .=','. implode(',',$output['BVN']->data->grades->failed);
				$output['failed_total'] += count($output['BVN']->data->grades->failed);
			}
			$status['BVN'] = true;
		}
		else
        {
            $status['BVN'] = false;
        } 
		
		$allCategories = DB::table('category_weights')->select('description','weight')->get();

        $categories_all = DB::table('category_weights as c')->join('global_leaves as g','c.category_id','=','g.category_id')->select('c.description as category','g.leaf_id','g.description')->get();

		$categories_all = collect($categories_all)->groupBy('category');
		$description_profile = [];
        $description_profile['passed'] = [];
        $description_profile['failed'] = [];
        $description_calllogs = [];
        $description_calllogs['passed'] = [];
        $description_calllogs['failed'] = [];
        $description_social = [];
        $description_social['passed'] = [];
        $description_social['failed'] = [];
        $description_repayments = [];
        $description_repayments['passed'] = [];
        $description_repayments['failed'] = [];
        $description_guarantor = [];
        $description_guarantor['passed'] = [];
        $description_guarantor['failed'] = [];
        $description_card = [];
        $description_card['passed'] = [];
        $description_card['failed'] = [];
        $description_account = [];
        $description_account['passed'] = [];
        $description_account['failed'] = [];
        $description_direct_debit = [];
        $description_direct_debit['passed'] = [];
        $description_direct_debit['failed'] = [];
        $description_sms = [];
        $description_sms['passed'] = [];
		$description_sms['failed'] = [];
		
		$description_BVN = [];
        $description_BVN['passed'] = [];
        $description_BVN['failed'] = [];
        
		if(!empty($output['profile']))
        {
            foreach($categories_all['profile'] as $ids)
			{
				if(!empty($output['profile']->data->grades->passed))
				{
					foreach($output['profile']->data->grades->passed as $passed_profile)
					{
						if($passed_profile == $ids->leaf_id)
						{
							$description_profile['passed'][] = $ids->description;
						}	
									
					}
				}
			
				if(!empty($output['profile']->data->grades->failed))
				{
					foreach($output['profile']->data->grades->failed as $failed_profile)
					{
						if($failed_profile == $ids->leaf_id)
						{
							$description_profile['failed'][] = $ids->description;
						}			
					}
				}
				
			}
        }
		
		if(!empty($output['calllogs']))
        {
            foreach($categories_all['calllogs'] as $ids)
			{
				if(!empty($output['calllogs']->data->grades->passed))
				{
					foreach($output['calllogs']->data->grades->passed as $passed_calllogs)
					{
						if($passed_calllogs == $ids->leaf_id)
						{
							$description_calllogs['passed'][] = $ids->description;
						}	
									
					}
				}
				
				if(!empty($output['calllogs']->data->grades->failed))
				{
					foreach($output['calllogs']->data->grades->failed as $failed_calllogs)
					{
						if($failed_calllogs == $ids->leaf_id)
						{
							$description_calllogs['failed'][] = $ids->description;
						}			
					}
				}
				
			}
        }
		
		if(!empty($output['social']))
        {	
            foreach($categories_all['social'] as $ids)
			{
				if(!empty($output['social']->data->grades->passed))
				{
					foreach($output['social']->data->grades->passed as $passed_social)
					{
						if($passed_social == $ids->leaf_id)
						{
							$description_social['passed'][] = $ids->description;
						}	
									
					}
				}
			
				if(!empty($output['social']->data->grades->failed))
				{
					foreach($output['social']->data->grades->failed as $failed_social)
					{
						if($failed_social == $ids->leaf_id)
						{
							$description_social['failed'][] = $ids->description;
						}			
					}
				}
			
			} 
        }

		if(!empty($output['repayments']))
        {
            foreach($categories_all['repayments'] as $ids)
			{
				if(!empty($output['repayments']->data->grades->passed))
				{
					foreach($output['repayments']->data->grades->passed as $passed_repayments)
					{
						if($passed_repayments == $ids->leaf_id)
						{
							$description_repayments['passed'][] = $ids->description;
						}	
									
					}
				}
				
				if(!empty($output['repayments']->data->grades->failed))
				{
					foreach($output['repayments']->data->grades->failed as $failed_repayments)
					{
						if($failed_repayments == $ids->leaf_id)
						{
							$description_repayments['failed'][] = $ids->description;
						}			
					}
				}
				
			}
		}
		
		// var_dump($output['sms']);
		// die();
		if(!empty($output['sms']))
        {
            foreach($categories_all['sms'] as $ids)
			{
				if(!empty($output['sms']->passed))
				{
					$sms_passed = explode(',',$output['sms']->passed);
					foreach($sms_passed as $passed_sms)
					{
						if($passed_sms == $ids->leaf_id)
						{
							$description_sms['passed'][] = $ids->description;
						}									
					}
				}
			
				if(!empty($output['sms']->failed))
				{
					$sms_failed = explode(',',$output['sms']->failed);
					foreach($sms_failed as $failed_sms)
					{
						if($failed_sms == $ids->leaf_id)
						{
							$description_sms['failed'][] = $ids->description;
						}		
					}
				}
				
				if(!empty($output['sms']->no_data))
				{
					$sms_no_data = explode(',',$output['sms']->no_data);
					foreach($sms_no_data as $failed_sms)
					{
						if($failed_sms == $ids->leaf_id)
						{
							$description_sms['failed'][] = $ids->description;
						}			
					}
				}

				
			}
        }
		
		if(!empty($output['guarantor']))
        {
            foreach($categories_all['guarantor'] as $ids)
			{
				if(!empty($output['guarantor']->passed))
				{
					$guarantor_passed = explode(',',$output['guarantor']->passed);
					foreach($guarantor_passed as $passed_guarantor)
					{
						if($passed_guarantor == $ids->leaf_id)
						{
							$description_guarantor['passed'][] = $ids->description;
						}									
					}
				}
				if(!empty($output['guarantor']->failed))
				{
					$guarantor_failed = explode(',',$output['guarantor']->failed);
					foreach($guarantor_failed as $failed_guarantor)
					{
						if($failed_guarantor == $ids->leaf_id)
						{
							$description_guarantor['failed'][] = $ids->description;
						}		
					}
				}
				if(!empty($output['guarantor']->no_data))
				{
					$guarantor_no_data = explode(',',$output['guarantor']->no_data);
					foreach($guarantor_no_data as $failed_guarantor)
					{
						if($failed_guarantor == $ids->leaf_id)
						{
							$description_guarantor['failed'][] = $ids->description;
						}			
					}
				}
				
            }
           
        }
		
		if(!empty($output['direct_debit']))
        {
            foreach($categories_all['directdebit'] as $ids)
			{
				if(!empty($output['direct_debit']->passed))
				{
					$direct_debit_passed = explode(',',$output['direct_debit']->passed);
					foreach($direct_debit_passed as $passed_direct_debit)
					{
						if($passed_direct_debit == $ids->leaf_id)
						{
							$description_direct_debit['passed'][] = $ids->description;
						}									
					}
				}

				if(!empty($output['direct_debit']->failed))
				{
					$direct_debit_failed = explode(',',$output['direct_debit']->failed);
					foreach($direct_debit_failed as $failed_direct_debit)
					{
						if($failed_direct_debit == $ids->leaf_id)
						{
							$description_direct_debit['failed'][] = $ids->description;
						}		
					}
				}
				if(!empty($output['direct_debit']->no_data))
				{
					$direct_debit_no_data = explode(',',$output['direct_debit']->no_data);
					foreach($direct_debit_no_data as $failed_direct_debit)
					{
						if($failed_direct_debit == $ids->leaf_id)
						{
							$description_direct_debit['failed'][] = $ids->description;
						}			
					}
				}
			
			
			
			}
        }
		
		if(!empty($output['card']))
        {
			
            foreach($categories_all['card'] as $ids)
			{
				if(!empty($output['account']->data->grades->passed)){
				$card_passed = $output['card']->data->grades->passed;
				//$card_passed = explode(',',$output['card']->data->grades->passed);
				
				//$card_passed = explode(',',$output['card']->passed);
				foreach($card_passed as $passed_card)
				{
					if($passed_card == $ids->leaf_id)
					{
						$description_card['passed'][] = $ids->description;
					}									
				}
				}
				if(!empty($output['account']->data->grades->failed)){
				//$card_failed = explode(',',$output['card']->failed);
				if(isset($output['card']->data->grades->failed)){
					$card_failed = $output['card']->data->grades->failed;
					 
					foreach($card_failed as $failed_card)
					{
						if($failed_card == $ids->leaf_id)
						{
							$description_card['failed'][] = $ids->description;
						}		
					}
				}
				}
				/*$card_no_data = explode(',',$output['card']->no_data);
				foreach($card_no_data as $failed_card)
				{
					if($failed_card == $ids->leaf_id)
					{
						$description_card['failed'][] = $ids->description;
					}			
				}*/
			} 
        }
		
		if(!empty($output['account']))
        {
			
            foreach($categories_all['accounts'] as $ids)
			{
				if(!empty($output['account']->data->grades->passed)){
					$account_passed = $output['account']->data->grades->passed;
					//$account_passed = explode(',',$output['account']->passed);
					foreach($account_passed as $passed_account)
					{
						if($passed_account == $ids->leaf_id)
						{
							$description_account['passed'][] = $ids->description;
						}									
					}	
				}
				if(!empty($output['account']->data->grades->failed)){
				if(isset($output['account']->data->grades->failed)){
					$account_failed = $output['account']->data->grades->failed;
					 
					foreach($account_failed as $failed_account)
					{
						if($failed_account == $ids->leaf_id)
						{
							$description_account['failed'][] = $ids->description;
						}		
					}
				}
				}
				//$account_failed = explode(',',$output['account']->failed);
				/*foreach($account_failed as $failed_account)
				{
					if($failed_account == $ids->leaf_id)
					{
						$description_account['failed'][] = $ids->description;
					}		
				}*/
				/*$account_no_data = explode(',',$output['account']->no_data);
				foreach($account_no_data as $failed_account)
				{
					if($failed_account == $ids->leaf_id)
					{
						$description_account['failed'][] = $ids->description;
					}			
				}*/
			}
		}
		
		if(!empty($output['BVN']))
        {
            foreach($categories_all['BVN'] as $ids)
			{
				if(!empty($output['BVN']->data->grades->passed))
                {
					foreach($output['BVN']->data->grades->passed as $passed_BVN)
					{
						if($passed_BVN == $ids->leaf_id)
						{
							$description_BVN['passed'][] = $ids->description;
						}	
									
					}
				}
				
				if(!empty($output['BVN']->data->grades->failed))
                {
					foreach($output['BVN']->data->grades->failed as $failed_BVN)
					{
						if($failed_BVN == $ids->leaf_id)
						{
							$description_BVN['failed'][] = $ids->description;
						}			
					}
                }
				
			}
        }
		
		$description = [
			'guarantor'=> $description_guarantor,
			'card'=> $description_card,
			'account'=> $description_account,
			'direct_debit'=> $description_direct_debit,
			'sms'=> $description_sms,
			'profile'=> $description_profile,
			'calllogs'=> $description_calllogs,
			'social'=> $description_social,
			'repayments'=> $description_repayments,
			'BVN'=> $description_BVN,
		];
		
		$passed_plus_failed =  $output['passed_total'] + $output['failed_total'];
		$output['total_eligibilty_score'] = $passed_plus_failed <= 0 ? 0:($output['passed_total']/$passed_plus_failed)* 100;
		$output['eligible_status'] = $output['total_eligibilty_score'] == 100 ? "eligible":"not eligible" ;
		return json_encode(["status"=>$status,"output"=>$output,"description"=>$description]);
      
    }
	
    public function determineEligibility($data,$suspicious_names,$product,$result_age,$result_mobile,$lender,$leafIds)
	{		
		$grades = [];
		$newGrade = [];
        // $eligibility_type = $request->input('eligibility_type'); 
		// $row = $request->input('row');
		// $PEOPLE_ID  = $request->input('PEOPLE_ID');
		// $lender_id = $request->input('lender_id');
		// $data = $request->input('data');
		// $exclusion_names = $request->input('exclusion_names');
		// $suspicious_names = $request->input('suspicious_names');
		// $product = $request->input('product');
		// $result_age = $request->input('result_age');
		// $result_mobile = $request->input('result_mobile');
		// $lender = $request->input('lender');
		// $leafIds = $request->input('leafIds');
	
		$leaves = [
			'suspicious_name'=>1,
			'gibberish_name'=>2,

			'within_age_range'=>3,
			'date_of_birth_correct'=>4,

			'vanity_number'=>5,
			'mobile_validation_done'=>6,

			'name_found_in_email'=>7,
			'common_mail_extension'=>8,
			'email_confirmed'=>9,
			'email_validation_done'=>10,

			'customer_home_state_allowed'=>11,
			'preferred_gender'=>12,

			'id_card_attached'=>13,
			'selfie_taken'=>14,

			'marital_status_allowed'=>15,
			'number_of_dependants_allowed'=>16,
			'number_of_children_allowed'=>17,
			'state_of_origin_allowed'=>18,
			'nok_relationship_allowed'=>19,
			'nok_email_verified'=>20,
			'nok_phone_verified'=>21,
			
			'home_valid_gps_address'=>22,
			'home_address_state_allowed'=>23,
			'home_within_allowed_ownership_status'=>24,
			'home_within_allowed_years_of_residence'=>25,
			'home_address_attached'=>26,
			'home_within_exclusion_country'=>27,
			'home_paying_above_minimum_allowed_rent'=>28,
			'home_premium_area'=>29,

			'office_valid_gps'=>30,
			'office_address_state_allowed'=>31,
			'office_premium_area'=>32,

			'monthly_expense_to_income_ratio_below_specified'=>33,
			'monthly_debt_to_income_ratio_below_specified'=>34,
			'monthly_deductions_percent_above_specified'=>35,
			'bonus_to_gross_annual_percent_above_specified'=>36,
			'rent_to_gross_annual_percent_above_specified'=>37,
			'school_fees_to_income_accepted'=>38,
			'feeding_to_income_accepted'=>39,
			'transport_to_income_accepted'=>40,
			'spouse_to_income_accepted'=>41,


			'net_gross_value_above_accepted'=>42,
			'net_monthly_income_above_accepted'=>43,
			'monthly_deductions_percent_above_specified_income'=>44,
			'bonus_to_gross_annual_percent_above_specified_income'=>45,
			'statement_attached'=>46,
			'payslip_attached'=>47,

			'total_expense_accepted'=>48,
			'rent_expense_accepted'=>49,
			'transport_expense_accepted'=>50,
			'school_fees_expense_accepted'=>51,
			'feeding_expense_accepted'=>52,
			'spouse_earning_accepted'=>53,
			'expense_verified'=>54,

			'work_popular_company'=>55,
			'work_allowed'=>56,
			'work_sector_allowed'=>57,
			'work_excluded_company'=>58,
			'work_years_allowed'=>59,
			'work_email_verified'=>60,

			//'qualification_document_presented'=>61,
			'within_accepted_school'=>62,
			'yrs_since_grad_accepted'=>63,
			'min_qualification_accepted'=>64,
			'other_qualifications_accepted'=>65,

			'address_changed'=>66,
			'age_changed'=>67,
			'name_changed'=>68,
			'mobile_changed'=>69,
			'email_changed'=>70,
			'state_changed'=>71,
			'gender_changed'=>72,		
			'work_designation_allowed'=>73,
			//'is_number_correct'=>​74,
		];
		$leaves['is_number_correct'] = 74;
		$runEligibiltyData = $this->runEligibilty($leafIds,$leaves,$data,$suspicious_names,$product,$result_age,$result_mobile);
		//return $runEligibiltyData;
 
		foreach($leafIds as $key=>$leafId)
		{
			$grades[$leafId] = empty($runEligibiltyData["leaves_grades"][$key])?[]:$runEligibiltyData["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}
		
		$eligibility_data = [];
		$eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
		$eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible"; 
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
	}
	
	public function runEligibilty($leafIds,$leaves,$data,$suspicious_names,$product,$result_age,$result_mobile)
	{ 
		$total = 0;
		//1
		if(in_array($leaves['suspicious_name'],$leafIds))
		{
			$b = [];
			if(!empty($suspicious_names)){
				foreach($suspicious_names as $suspicious_name){
					array_push($b,strtolower($suspicious_name['name']));
				}
			}	
			$fullname = explode(" ",$data["LEGAL_NAME"]);
			
			if(!empty($fullname) && !empty($suspicious_names)){ 
			foreach($fullname as $name){
				if(in_array(strtolower($name),$b)){	
					$response_suspicious_names = "true";
						// $leaves_grade[] = "failed";
						$leaves_grade[] = "failed";
					break;
				}
				else
				{		
						$response_suspicious_names = "false";				  
				}
			}   
			}
			if($response_suspicious_names == "false")
			{
				$total++;  //$leaves_grade[] = "passed";
				$leaves_grade[] = "passed";
			}
		}
		//2
		if(in_array($leaves['gibberish_name'],$leafIds))
		{
			$result = [];
			$gib_name = $data['LEGAL_NAME'];
			for($i = 0; $i < strlen( $gib_name ); $i++)
			{
				if ( isset( $result[ $gib_name[ $i ] ] ) )
				{
						$result[ $gib_name[ $i ] ]++;
				} else {
						$result[ $gib_name[ $i ] ] = 1;
				}
			}
			$gibberish =  ( max( $result ) / strlen( $gib_name ) * 100 >= 33 ) ? false : true;	
			$response_gibberish_name = $gibberish == false ? "true":"false";
			if($response_gibberish_name == "true")
			{
					$leaves_grade[] = "failed";
			}
			else
			{
				$total++;  $leaves_grade[] = "passed";		
			}
		}
		//3
		$age = date("Y") - $data['BIRTH_YEAR'];
		if(in_array($leaves['within_age_range'],$leafIds))
		{			
			$response_within_age_range = ($age >= $product['MIN_AGE'] && $age <= $product['MAX_AGE']) ? "true":"false";
			if($response_within_age_range == "true")
			{
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
					$leaves_grade[] = "failed";
			}
		}
		 //4
		if(in_array($leaves['date_of_birth_correct'],$leafIds))
		{			
				
			//date of birth
			$dob = $data['BIRTH_DAY'] . '-' . $data['BIRTH_MONTH'] . '-' . $data['BIRTH_YEAR'];		
			$user_dob = date("Y-m-d", strtotime($dob));
			// $bvn_age_score=false;
			//condition for comparing bvn age 
			if(!empty($result_age['PAYSTACK_RESPONSE'])){
				$bvn = json_decode($result_age['PAYSTACK_RESPONSE'],true);
				$bvn_data = $bvn['data'];
				$bvn_dob = date("Y-m-d", strtotime( $bvn_data['formatted_dob'] ));
				if( $bvn_dob ==  $user_dob){
					$response_date_of_birth_correct =  "true";
					$total++;  $leaves_grade[] = "passed";	
				} 
				else
				{
					$response_date_of_birth_correct =  "false";
						$leaves_grade[] = "failed";
				}
			}	
			else
			{
				$response_date_of_birth_correct =  "no data";
					$leaves_grade[] = "failed";
			}
			
		}
		//5
		if(in_array($leaves['vanity_number'],$leafIds))
		{			
			$number=str_split($data['PHONE']);
			$unique_digits_count = count(array_count_values($number));
			$response_vanity_number = $unique_digits_count <= 5 ? "true":"false";
			if($response_vanity_number == "true")
			{
				  $leaves_grade[] = "passed";
			}
			else
			{
				$total++; $leaves_grade[] = "failed";
			}
			//dd($response_vanity_number);			
		}
		//6
		if(in_array($leaves['mobile_validation_done'],$leafIds))
		{			
			$validation_done = explode(',',$data['VALIDATION_DONE']);	
			$response_validation_done = $validation_done[0]=="1" ? "true":"false";
			if($response_validation_done == "true")
			{
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
					$leaves_grade[] = "failed";
			}
			
		}
	
		//7
		if(in_array($leaves['name_found_in_email'],$leafIds))
		{		
			$explodedNames = explode(" ",$data['LEGAL_NAME']);
			
			foreach($explodedNames as $explodedName)
			{
				if(stripos($data['EMAIL'],$explodedName) !== false)
				{
					$response_name_found_in_email ="true";
					$total++;  $leaves_grade[] = "passed";
					break;
				}
			}
			
			if(empty($response_name_found_in_email)) 
			{
				 
				$response_name_found_in_email ="false";
					$leaves_grade[] = "failed";
			}
		} 
		//8
		if(in_array($leaves['common_mail_extension'],$leafIds))
		{			
			if($this->strpos_array($data['EMAIL'],["gmail","yahoo","hotmail","outlook"]) === true)
			{
				$response_common_mail_extension ="true";
				$total++;  $leaves_grade[] = "passed";	
			}
			else
			{
				$response_common_mail_extension ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//dd($leaves_grade);
		//die();
		
		 //9
		if(in_array($leaves['email_confirmed'],$leafIds))
		{			
			$validation_done = explode(',',$data['VALIDATION_DONE']);
			 
			if($validation_done[2]=="1"){
				$response_validation_done ="true";	
				$total++;  $leaves_grade[] = "passed";
			}
			else 
			{
				$response_validation_done ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//10
		if(in_array($leaves['email_validation_done'],$leafIds))
		{			
			$validation_done = explode(',',$data['VALIDATION_DONE']);
			 
			if($validation_done[2]=="1"){
				$response_validation_done ="true";	
				$total++;  $leaves_grade[] = "passed";
			}
			else 
			{
				$response_validation_done ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//11
		if(in_array($leaves['customer_home_state_allowed'],$leafIds))
		{			
			$allowed_states = $product['ALLOW_ADDRESS_STATES'];	
			if(in_array($data['HOME_STATE'],$allowed_states)){
				$response_customer_home_state_allowed ="true";
				$total++;  $leaves_grade[] = "passed";	
			}	
			else 
			{
				$response_customer_home_state_allowed ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//12
		if(in_array($leaves['preferred_gender'],$leafIds))
		{	
			$allowed_gender = $product['PREFERRED_BORROWER_GENDER'];		
			// $allowed_gender = explode(',',$product['PREFERRED_BORROWER_GENDER']);
			//condition for checking if customer gender is allowed
			if(in_array($data['GENDER'],$allowed_gender)){
				$response['gender']['preferred_gender'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else  
			{
				$response['gender']['preferred_gender'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//13
		if(in_array($leaves['id_card_attached'],$leafIds))
		{			
			if(!empty($data['ATTACHMENT1_IDCARD'])){
				$response['identity']['id_card_attached'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else  
			{
				$response['identity']['id_card_attached'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//14
		if(in_array($leaves['selfie_taken'],$leafIds))
		{			
			if(!empty($data['PASSPORT_ATTACHMENT_URL'])){
				$response['identity']['selfie_taken'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['identity']['selfie_taken'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//15
		if(in_array($leaves['marital_status_allowed'],$leafIds))
		{			
			$allowed_marital_status = $product['ALLOW_MARITAL_STATUS'];
			// $allowed_marital_status = explode(',',$product['ALLOW_MARITAL_STATUS']);
			if(in_array($data['MARITAL_STATUS'],$allowed_marital_status))
			{
				$total++;  $leaves_grade[] = "passed";
				$response['marital_status']['marital_status_allowed'] ="true";
			}	
			else
			{
				$response['marital_status']['marital_status_allowed'] ="false";	
					$leaves_grade[] = "failed";
			}	
		}
		//16
		if(in_array($leaves['number_of_dependants_allowed'],$leafIds))
		{			
			if(($data['NUMBER_OF_DEPENDANTS'] >= $product['MIN_DEPENDANTS']) && ($data['NUMBER_OF_DEPENDANTS'] <= $product['MAX_DEPENDANTS']))
			{
				$response['marital_status']['number_of_dependants_allowed'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['marital_status']['number_of_dependants_allowed'] ="false";
					$leaves_grade[] = "failed";
			}
		}
		///17
		if(in_array($leaves['number_of_children_allowed'],$leafIds))
		{			
		
			if(($data['NUMBER_OF_CHILDREN'] >= $product['MIN_NO_OF_CHILDREN']) && ($data['NUMBER_OF_CHILDREN'] <= $product['MAX_NO_OF_CHILDREN']))
			{
					$response['marital_status']['number_of_children_allowed'] ="true";
					$total++;  $leaves_grade[] = "passed";
			}
			else
			{
					$response['marital_status']['number_of_children_allowed'] ="false";
						$leaves_grade[] = "failed";
			}
			
		}
		//18
		if(in_array($leaves['state_of_origin_allowed'],$leafIds))
		{			
			$allowed_state_of_origin = $product['ALLOWED_STATE_OF_ORIGIN'];
			// $allowed_state_of_origin = explode(',',$product['ALLOWED_STATE_OF_ORIGIN']);	
			//condition for checking if user state is allowed
			if(in_array($data['STATE_OF_ORIGIN'],$allowed_state_of_origin)){
				$response['state_of_origin']['state_of_origin_allowed'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['state_of_origin']['state_of_origin_allowed'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//19
		if(in_array($leaves['nok_relationship_allowed'],$leafIds))
		{	
			$allowed_nok= $product['ALLOWED_NOK'];		
			//$allowed_nok= explode(',',$product['ALLOWED_NOK']);	
			if(in_array($data['NOK_RELATIONSHIP'],$allowed_nok))
			{
				$response['nok']['nok_relationship_allowed'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}	
			else
			{
				$response['nok']['nok_relationship_allowed'] ="false";
					$leaves_grade[] = "failed";
			}	
		}
		//20
		if(in_array($leaves['nok_email_verified'],$leafIds))
		{			
			if($data['NOK_EMAIL_VERIFIED'] == 1){
				$response['nok']['email_verified'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['nok']['email_verified'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//21
		if(in_array($leaves['nok_phone_verified'],$leafIds))
		{			
			if($data['NOK_PHONE_VERIFIED'] == 1){
				$response['nok']['phone_verified'] ="true";
				$total++;  $leaves_grade[] = "passed";		
			}
			else
			{
				$response['nok']['phone_verified'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//22
		if(in_array($leaves['home_valid_gps_address'],$leafIds))
		{			
			// $arrContextOptions=array(
			// 	"ssl"=>array(
			// 		"cafile" => "cacert.pem",
			// 		"verify_peer"=> true,
			// 		"verify_peer_name"=> true,
			// 	),
			// );
			$geo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyDo9iJ7vED5HmaBJQcqrpqcQlxEo2jlRqA&address='.urlencode($data['HOME_ADDRESS']).'&sensor=false',false);
			//,stream_context_create($arrContextOptions)
			$geo = json_decode($geo, true); // Convert the JSON to an array

			if (isset($geo['status']) && ($geo['status'] == 'OK')) {
				$response['home_address']['valid_gps_address'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['home_address']['valid_gps_address'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//23
		if(in_array($leaves['home_address_state_allowed'],$leafIds))
		{			
			// $allowed_states = explode(',',$product['ALLOW_ADDRESS_STATES_HOME']);
			$allowed_states = $product['ALLOW_ADDRESS_STATES_HOME'];
		
			//condition for checking if state with that adrdress is allowed
			if(in_array($data['HOME_STATE'],$allowed_states)){
				$response['home_address']['address_state_allowed'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['home_address']['address_state_allowed'] ="false";
					$leaves_grade[] = "failed";
			}
		
			
		}
		//24
		if(in_array($leaves['home_within_allowed_ownership_status'],$leafIds))
		{	
			$allowed_noc = $product['ALLOWED_OWNERSHIP_STATUS'];
			// $allowed_noc = explode(',',$product['ALLOWED_OWNERSHIP_STATUS']);	
			if(in_array($data['NOC'],$allowed_noc))
			{
				$response['home_address']['within_allowed_ownership_status'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['home_address']['within_allowed_ownership_status'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//25
		if(in_array($leaves['home_within_allowed_years_of_residence'],$leafIds))
		{			
			if($data['RESIDENT_YEARS'] >= $product['ALLOWED_RESIDENT_YEARS']){
				$response['home_address']['within_allowed_years_of_residence'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['home_address']['within_allowed_years_of_residence'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//26
		if(in_array($leaves['home_address_attached'],$leafIds))
		{			
			// if(!empty($product["QUALIFYING_DOCUMENTS"]))
			// {
				// $qdocs = explode(',',$product["QUALIFYING_DOCUMENTS"]);
				// if(in_array(1016,$qdocs))
				// {
					if(!empty($data['HOME_ATTACHMENT']))
					{
						$response['home_address']['address_attached'] ="true";
						$total++;  $leaves_grade[] = "passed";
					}
					else{
						$response['home_address']['address_attached'] ="false";
							$leaves_grade[] = "failed";
					}
				//}
			//}
			
			// else{
			// 	$response['home_address']['address_attached'] ="false";
			// 		$leaves_grade[] = "failed";
			// }
			
			
		}
		//27
		if(in_array($leaves['home_within_exclusion_country'],$leafIds))
		{		
			$excluded_coutries = $product['EXCLUDED_COUNTRIES']; 	
			// $excluded_coutries = explode(',',$product['EXCLUDED_COUNTRIES']);
			if(in_array($data['HOME_COUNTRY'],$excluded_coutries)){
				$response['home_address']['within_exclusion_countries'] ="true";

					$leaves_grade[] = "failed";
			}
			else
			{
				$total++;  $leaves_grade[] = "passed";
				$response['home_address']['within_exclusion_countries'] ="false";
				
			}
				
		}
		//28
		if(in_array($leaves['home_paying_above_minimum_allowed_rent'],$leafIds))
		{			
			if($data['MONTHLY_RENT_EXPENSES'] > $product['ALLOWED_MONTHLY_RENT']){
				$response['home_address']['paying_above_minimum_allowed_rent'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else{
				$response['home_address']['paying_above_minimum_allowed_rent'] ="false";
					$leaves_grade[] = "failed";
			}
		}
		//29
		if(in_array($leaves['home_premium_area'],$leafIds))
		{	
			// $location_premium_factor = $product['LOCATION_PREMIUM_FACTOR'];
			$location_premium_factor = explode(',',$product['LOCATION_PREMIUM_FACTOR']);
			if(in_array($data['HOME_LGA'],$location_premium_factor)){
				$response['home_address']['premium_area'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['home_address']['premium_area'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//30
		if(in_array($leaves['office_valid_gps'],$leafIds))
		{			
			$geo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyDo9iJ7vED5HmaBJQcqrpqcQlxEo2jlRqA&address='.urlencode($data['WORK_ADDRESS']).'&sensor=false',false);
			//,stream_context_create($arrContextOptions)
			$geo = json_decode($geo, true); // Convert the JSON to an array
			if (isset($geo['status']) && ($geo['status'] == 'OK')) {
				$response['office_address']['valid_gps'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['office_address']['valid_gps'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//31
		if(in_array($leaves['office_address_state_allowed'],$leafIds))
		{		
			$allowed_states = $product['ALLOW_OFFICE_ADDRESS_STATES'];	
			// $allowed_states = explode(',',$product['ALLOW_OFFICE_ADDRESS_STATES']);		
			//condition for checking if user state is allowed
			if(!empty($allowed_states))
			{
				if(in_array($data['WORK_STATE_ID'],$allowed_states))
				{
					$response['office_address']['office_address_state_allowed'] ="true";
					$total++;  $leaves_grade[] = "passed";
				}
				else{
					$response['office_address']['office_address_state_allowed'] ="false";
						$leaves_grade[] = "failed";
				}
			}else{
				$response['office_address']['office_address_state_allowed'] ="true";
				$leaves_grade[] = "failed";
			}
		}
		//32
		if(in_array($leaves['office_premium_area'],$leafIds))
		{			
				// $office_premium_factor = $product['OFFICE_PREMIUM_FACTOR'];
			$office_premium_factor = explode(',',$product['OFFICE_PREMIUM_FACTOR']);
			if(in_array($data['WORK_STATE_ID'],$office_premium_factor)){
				$response['office_address']['premium_area'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['office_address']['premium_area'] ="false";
					$leaves_grade[] = "failed";
			}		
			
		}
		//33
		if(in_array($leaves['monthly_expense_to_income_ratio_below_specified'],$leafIds))
		{			
			$total_expenses = $data['MONTHLY_RENT_EXPENSES'] + $data['MONTHLY_TEL_INTERNET'] + $data['MONTHLY_TRANSPORT'];
			$total_expenses = ($total_expenses/$data['NET_MONTHLY_INCOME'])*100; 
			if($total_expenses <= $product['MAX_EXPENSE_INCOME_RATIO']){
				$response['income_ratios']['monthly_expense_to_income_ratio_below_specified'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income_ratios']['monthly_expense_to_income_ratio_below_specified'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//34
		if(in_array($leaves['monthly_debt_to_income_ratio_below_specified'],$leafIds))
		{			
			$debt_to_income_ratio = ($data['MONTHLY_DEBT']/$data['NET_MONTHLY_INCOME']);
			if($debt_to_income_ratio <= $product['MAX_DEBT_INCOME_RATIO'])
			{
				$response['income_ratios']['monthly_debt_to_income_ratio_below_specified'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income_ratios']['monthly_debt_to_income_ratio_below_allowed'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//35
		if(in_array($leaves['monthly_deductions_percent_above_specified'],$leafIds))
		{			
			$monthly_deductions_to_gross_percentage = (($data['GROSS_ANNUAL_INCOME'] - ($data['NET_MONTHLY_INCOME'] * 12))/ $data['GROSS_ANNUAL_INCOME']) * 100;
			if($monthly_deductions_to_gross_percentage >= $product['MIN_MONTHLY_DEDUCTIONS_TO_GROSS_PERCENTAGE']){
				$response['income_ratios']['monthly_deductions_percent_above_specified'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income_ratios']['monthly_deductions_percent_above_specified'] = "false";
					$leaves_grade[] = "failed";
			}
		}
		//36
		if(in_array($leaves['bonus_to_gross_annual_percent_above_specified'],$leafIds))
		{			
			$bonus_to_gross_annual = ($data['BONUS']/$data['GROSS_ANNUAL_INCOME']) * 100; 
			if($bonus_to_gross_annual  >= $product['MIN_BONUS_TO_GROSS_ANNUAL_PERCENTAGE'])
			{
				$response['income_ratios']['bonus_to_gross_annual_percent_above_specified'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income_ratios']['bonus_to_gross_annual_percent_above_specified'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}	
		//37
		if(in_array($leaves['rent_to_gross_annual_percent_above_specified'],$leafIds))
		{			
			$rent_to_gross_percentage = (($data['MONTHLY_RENT_EXPENSES'] * 12)/$data['GROSS_ANNUAL_INCOME']) * 100 ;
			if(($rent_to_gross_percentage  >= $product['MIN_RENT_TO_GROSS_ANNUAL_PERCENTAGE']) && ($rent_to_gross_percentage  <= $product['MAX_RENT_TO_GROSS_ANNUAL_PERCENTAGE'])){
				$response['income_ratios']['rent_to_gross_annual_percent_above_specified'] = "true";
				$total++;  $leaves_grade[] = "passed";
			} 		   
			else
			{
				$response['income_ratios']['rent_to_gross_annual_percent_above_specified'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//38
		if(in_array($leaves['school_fees_to_income_accepted'],$leafIds))
		{			
			$school_fees_to_income = ($data['SCHOOL_FEES_EXPENSES']/$data['NET_MONTHLY_INCOME']);
			if(($school_fees_to_income  >= $product['MIN_SCHOOL_FEES_TO_INCOME']) && ($school_fees_to_income  <= $product['MAX_SCHOOL_FEES_TO_INCOME'])){
				$response['income_ratios']['school_fees_to_income_accepted'] = "true";
				$total++;  $leaves_grade[] = "passed";
			} 
			else
			{
				$response['income_ratios']['school_fees_to_income_accepted'] = "false";
					$leaves_grade[] = "failed";
			}  
			
		}
		//39
		if(in_array($leaves['feeding_to_income_accepted'],$leafIds))
		{			
			$feeding_to_income = ($data['FEEDING_EXPENSES']/$data['NET_MONTHLY_INCOME']);
			if(($feeding_to_income  >= $product['MIN_FEEDING_TO_INCOME']) && ($feeding_to_income  <= $product['MAX_FEEDING_TO_INCOME'])){
				$response['income_ratios']['feeding_to_income_accepted'] = "true";
				$total++;  $leaves_grade[] = "passed";
			} 
			else
			{
				$response['income_ratios']['feeding_to_income_accepted'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//40
		if(in_array($leaves['transport_to_income_accepted'],$leafIds))
		{			
			$transport_to_income = ($data['MONTHLY_TRANSPORT']/$data['NET_MONTHLY_INCOME']);
			if(($transport_to_income  >= $product['MIN_TRANSPORT_TO_INCOME']) && ($transport_to_income  <= $product['MAX_TRANSPORT_TO_INCOME'])){
				$response['income_ratios']['transport_to_income_accepted'] = "true";
				$total++;  $leaves_grade[] = "passed";
			} 
			else
			{
				$response['income_ratios']['transport_to_income_accepted'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//41
		if(in_array($leaves['spouse_to_income_accepted'],$leafIds))
		{			
			$spouse_to_income = ($data['MONTHLY_TRANSPORT']/$data['NET_MONTHLY_INCOME']);
			if(($spouse_to_income  >= $product['MIN_SPOUSE_TO_INCOME']) && ($spouse_to_income  <= $product['MAX_SPOUSE_TO_INCOME'])){
				$response['income_ratios']['spouse_to_income_accepted'] = "true";
				$total++;  $leaves_grade[] = "passed";
			} 
			else
			{
				$response['income_ratios']['spouse_to_income_accepted'] = "false";
					$leaves_grade[] = "failed";
			}   
			
		}
		//42
		if(in_array($leaves['net_gross_value_above_accepted'],$leafIds))
		{	
			if(!empty($data['NET_GROSS_VALUE']))
			{
				if($data['NET_GROSS_VALUE'] >= $product['ALLOW_NET_GROSS_VALUE']){
					$response['income']['net_gross_value_above_accepted'] = "true";
					$total++;  $leaves_grade[] = "passed";
				}
				else
				{
					$response['income']['net_gross_value_above_accepted'] = "false";
						$leaves_grade[] = "failed";
				}

			}		
			else
			{
				$response['income']['net_gross_value_above_accepted'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//43
		if(in_array($leaves['net_monthly_income_above_accepted'],$leafIds))
		{			
			if($data['NET_MONTHLY_INCOME'] >= $product['ALLOWED_MONTHLY_INCOME']){
				$response['income']['net_monthly_income_above_accepted'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income']['net_monthly_income_above_accepted'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//44
		if(in_array($leaves['monthly_deductions_percent_above_specified_income'],$leafIds))
		{			
			$monthly_deductions_to_gross_percentage =(($data['GROSS_ANNUAL_INCOME'] - ($data['NET_MONTHLY_INCOME'] * 12))/ $data['GROSS_ANNUAL_INCOME']) * 100;
			if($monthly_deductions_to_gross_percentage >= $product['MIN_MONTHLY_DEDUCTIONS_TO_GROSS_PERCENTAGE_INCOME']){
				$response['income']['monthly_deductions_percent_above_specified_income'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income']['monthly_deductions_percent_above_specified_income'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//45
		if(in_array($leaves['bonus_to_gross_annual_percent_above_specified_income'],$leafIds))
		{			
			$bonus_to_gross_annual = ($data['BONUS']/$data['GROSS_ANNUAL_INCOME']) * 100; 
			//dd($bonus_to_gross_annual);
			if($bonus_to_gross_annual  >= $product['MIN_BONUS_TO_GROSS_ANNUAL_PERCENTAGE_INCOME']){	
				$response['income']['bonus_to_gross_annual_percent_above_specified_income'] = "true";	
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income']['bonus_to_gross_annual_percent_above_specified_income'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//46
		if(in_array($leaves['statement_attached'],$leafIds))
		{			
			if(!empty($data['NO_OF_BANK_STATEMENTS']) && $data['NO_OF_BANK_STATEMENTS'] != null){
				$response['income']['statement_attached'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income']['statement_attached'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//47
		if(in_array($leaves['payslip_attached'],$leafIds))
		{			
			if(!empty($data['NO_OF_PAYSLIPS']) && $data['NO_OF_PAYSLIPS'] != null)
			{
				$response['income']['payslip_attached'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['income']['payslip_attached'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//48
		if(in_array($leaves['total_expense_accepted'],$leafIds))
		{			
			$total_expenses = $data['MONTHLY_RENT_EXPENSES'] + $data['MONTHLY_TEL_INTERNET'] + $data['MONTHLY_TRANSPORT'];

			if(($total_expenses >= $product['MIN_TOTAL_EXPENSES']) && ($total_expenses <= $product['MAX_TOTAL_EXPENSES'])){
				$response['expenses']['total_expense_accepted'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['expenses']['total_expense_accepted'] ="false";
					$leaves_grade[] = "failed";
			}		
			
		}
		//49
		if(in_array($leaves['rent_expense_accepted'],$leafIds))
		{			
			if(($data['MONTHLY_RENT_EXPENSES'] >= $product['MIN_MONTHLY_RENT_EXPENSE']) && ($data['MONTHLY_RENT_EXPENSES'] <= $product['MAX_MONTHLY_RENT_EXPENSE'])){
				$response['expenses']['rent_expense_accepted'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['expenses']['rent_expense_accepted'] ="false";
					$leaves_grade[] = "failed";
			}			
		}
		//50
		if(in_array($leaves['transport_expense_accepted'],$leafIds))
		{			
			if(($data['MONTHLY_TRANSPORT'] >= $product['MIN_MONTHLY_TRANSPORT']) && ($data['MONTHLY_TRANSPORT'] <= $product['MAX_MONTHLY_TRANSPORT'])){
				$response['expenses']['transport_expense_accepted'] ="true";
				$total++;  $leaves_grade[] = "passed";
			} 
			else
			{
				$response['expenses']['transport_expense_accepted'] ="false";
					$leaves_grade[] = "failed";
			}			
		}
		//51
		if(in_array($leaves['school_fees_expense_accepted'],$leafIds))
		{			
			if(($data['SCHOOL_FEES_EXPENSES'] >= $product['MIN_SCHOOL_FEES_EXPENSE']) && ($data['SCHOOL_FEES_EXPENSES'] <= $product['MAX_SCHOOL_FEES_EXPENSE'])){
				$response['expenses']['school_fees_expense_accepted'] ="true";
				$total++;  $leaves_grade[] = "passed";
			} 
			else
			{
				$response['expenses']['school_fees_expense_accepted'] ="false";
					$leaves_grade[] = "failed";
			}		
		}
		//52
		if(in_array($leaves['feeding_expense_accepted'],$leafIds))
		{			
			if(($data['FEEDING_EXPENSES'] >= $product['MIN_FEEDING_EXPENSES']) && ($data['FEEDING_EXPENSES'] <= $product['MAX_FEEDING_EXPENSES'])){
				$response['expenses']['feeding_expense_accepted'] ="true";
				$total++;  $leaves_grade[] = "passed";
			}  
			else
			{
				$response['expenses']['feeding_expense_accepted'] ="false";
					$leaves_grade[] = "failed";
			}			
		}
		//53
		if(in_array($leaves['spouse_earning_accepted'],$leafIds))
		{	
			if(!empty($data['SPOUSE_INCOME']))
			{
				if(($data['SPOUSE_INCOME'] >= $product['MIN_SPOUSE_INCOME']) && ($data['SPOUSE_INCOME'] <= $product['MAX_SPOUSE_INCOME'])){
					$response['expenses']['spouse_earning_accepted'] ="true";
					$total++;  $leaves_grade[] = "passed";
				} 
				else
			{
				$response['expenses']['spouse_earning_accepted'] ="false";
					$leaves_grade[] = "failed";
			}
			}				 
			else
			{
				$response['expenses']['spouse_earning_accepted'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//54
		if(in_array($leaves['expense_verified'],$leafIds))
		{	
			if(!empty($data['EXPENSE_VERIFIED']))
			{
				if($data['EXPENSE_VERIFIED'] == 0){
					$response['expenses']['expense_verified'] ="true";
					$total++;  $leaves_grade[] = "passed";
				}
				else
				{
					$response['expenses']['expense_verified'] ="false";
						$leaves_grade[] = "failed";
				}
			}				
			else
			{
				$response['expenses']['expense_verified'] ="false";
					$leaves_grade[] = "failed";
			}
			
		}
		//55
		if(in_array($leaves['work_popular_company'],$leafIds))
		{			
			$popular_companies = ['GTB','UBA'];			
			if(in_array($data['COMPANY_OF_WORK_ID'],$popular_companies)){
				$response['work']['popular_company'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['work']['popular_company'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//56
		if(in_array($leaves['work_allowed'],$leafIds))
		{	
			$allowed_occupation = $product['PREFERRED_BORROWER_OCCUPATION'];		
			// $allowed_occupation = explode(',',$product['PREFERRED_BORROWER_OCCUPATION']);
				
			if(in_array($data['OCCUPATION_ID'],$allowed_occupation)){
				$response['work']['work_allowed'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['work']['work_allowed'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//57
		if(in_array($leaves['work_sector_allowed'],$leafIds))
		{	
			// $allowed_sector = explode(',',$product['PREFERRED_OCCUPATION_SECTOR']);
			$allowed_sector = $product['PREFERRED_OCCUPATION_SECTOR'];		
			if(in_array($data['OCCUPATION_ID'],$allowed_sector)){
				$response['work']['work_sector_allowed'] = "true";
				$total++;  $leaves_grade[] = "passed";

			}
			else
			{
				$response['work']['work_sector_allowed'] = "false";
					$leaves_grade[] = "failed";	
			}				
		}
		//58
		if(in_array($leaves['work_excluded_company'],$leafIds))
		{	
			//checkagain		
			if($data['OCCUPATION_ID']!=3 && $data['OCCUPATION_ID']==7 && $data['OCCUPATION_ID']!=20){

				$excluded_companies = explode(',',$lender['EXCLUDED_COMPANIES']);
				//$excluded_companies = $lender['EXCLUDED_COMPANIES'];		
				//condition for checking for excluding companies
				if(!empty($excluded_companies)){
					if(in_array($data['COMPANY_ID'],$excluded_companies)){
						$response['work']['excluded_company'] = "true";
						$leaves_grade[] = "failed";
					}
					else
					{
						$response['work']['excluded_company'] = "false";
							$leaves_grade[] = "failed";
							$total++;  $leaves_grade[] = "passed";		
					}				
				}
				else
				{
					$response['work']['excluded_company'] = "false";
					$total++;  $leaves_grade[] = "passed";	
				}		
			}
			else
			{
				$response['work']['excluded_company'] = "false";
				$leaves_grade[] = "failed";
			}
			
		}
		//59
		if(in_array($leaves['work_years_allowed'],$leafIds))
		{	
			//checkagain		
			if($data['OCCUPATION_ID']!=3 && $data['OCCUPATION_ID']==7 && $data['OCCUPATION_ID']!=20){			
				if(date('Y')-$data['WORK_END_DATE'] >= $product['ALLOWED_WORK_YEARS'])
				{
					$response['work']['work_years_allowed'] = "true";
					$total++;  $leaves_grade[] = "passed";
				}
				else
				{
					$response['work']['work_years_allowed'] = "false";	
					$leaves_grade[] = "failed";		
				}
			}
			else
			{
				$response['work']['work_years_allowed'] = "false";
				$leaves_grade[] = "failed";
			}
			
		}
		//60
		if(in_array($leaves['work_email_verified'],$leafIds))
		{	
			//checkagain		
			if($data['OCCUPATION_ID']==1){
				if($data['WORK_EMAIL_VERIFIED']==1){
					$response['work']['email_verified'] = "true";
					$total++;  $leaves_grade[] = "passed";
				}	
				else
				{
					$response['work']['email_verified'] = "false";
						$leaves_grade[] = "failed";
				}					
			}
			else
			{
				$response['work']['email_verified'] = "false";
				$leaves_grade[] = "failed";
			}
			
		} 
		//62
		if(in_array($leaves['within_accepted_school'],$leafIds))
		{			
			$accepted_schools = explode(',',$product['ACCEPTED_SCHOOLS']);
			//$accepted_schools = $product['ACCEPTED_SCHOOLS'];
			if(in_array($data['EDUCATION_INSTITUTION'],$accepted_schools))
			{
				$response['education']['within_accepted_school'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['education']['within_accepted_school'] = "false";
					$leaves_grade[] = "failed";
			}				
		}
		//63
		if(in_array($leaves['yrs_since_grad_accepted'],$leafIds))
		{			
			$years_since_graduation = date('Y') - $data['QUALIFICATION_YEAR'];
			if($years_since_graduation >= $product['MIN_YRS_SINCE_GRADUATION'])
			{
				$response['education']['yrs_since_grad_accepted'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['education']['yrs_since_grad_accepted'] = "false";
					$leaves_grade[] = "failed";
			}	
			
		}
		//64
		if(in_array($leaves['min_qualification_accepted'],$leafIds))
		{			
			// $minimum_qualification = explode(',',$product['MIN_QUALIFICATION']);
			$minimum_qualification = $product['MIN_QUALIFICATION'];
			if(in_array($data['EDUCATION_QUALIFICATION'],$minimum_qualification))
			{
				$response['education']['min_qualification_accepted'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['education']['min_qualification_accepted'] = "false";
					$leaves_grade[] = "failed";
			}
			
		}
		//65
		if(in_array($leaves['other_qualifications_accepted'],$leafIds))
		{	
			// $minimum_qualification = explode(',',$product['MIN_QUALIFICATION']);	
			$minimum_qualification = $product['MIN_QUALIFICATION'];	
			if(in_array($data['HAS_OTHER_QUALIFICATIONS'],$minimum_qualification))
			{
				$response['education']['other_qualifications_accepted'] = "true";
				$total++;  $leaves_grade[] = "passed";
			}
			else
			{
				$response['education']['other_qualifications_accepted'] = "false";
					$leaves_grade[] = "failed";
				
			}
			
		}
		//66
		if(in_array($leaves['address_changed'],$leafIds))
		{			
			if($data['ADDRESS_UPDATE_COUNT'] > 1)
			{
				$response['change_frequency']['address_changed'] ="true";
					$leaves_grade[] = "failed";
			}
			else
			{
				$response['change_frequency']['address_changed'] ="false";
				$total++;  $leaves_grade[] = "passed";
			}
			
		}
		//67
		if(in_array($leaves['age_changed'],$leafIds))
		{			
			if($data['AGE_UPDATE_COUNT'] > 1)
			{
				$response['change_frequency']['age_changed'] ="true";
					$leaves_grade[] = "failed";
			}
			else
			{
				$response['change_frequency']['age_changed'] ="false";
				$total++;  $leaves_grade[] = "passed";
			}	
			
		}
		//68
		if(in_array($leaves['name_changed'],$leafIds))
		{			
			if($data['NAME_UPDATE_COUNT'] > 1)
			{
				$response['change_frequency']['name_changed'] ="true";
					$leaves_grade[] = "failed";
			}
			else
			{
				$response['change_frequency']['name_changed'] ="false";
				$total++;  $leaves_grade[] = "passed";
			}	
			
		}
		//69
		if(in_array($leaves['mobile_changed'],$leafIds))
		{		
			if(!empty($data['MOBILE_UPDATE_COUNT']))
			{
				if($data['MOBILE_UPDATE_COUNT'] > 1)
				{
					$response['change_frequency']['mobile_changed'] ="true";
						$leaves_grade[] = "failed";
				}
				else
				{
					$response['change_frequency']['mobile_changed'] ="false";
					$total++;  $leaves_grade[] = "passed";
				}	
			}			
			else
			{
				$response['change_frequency']['mobile_changed'] ="false";
				$total++;  $leaves_grade[] = "passed";
			}	
			
		}
		//70
		if(in_array($leaves['email_changed'],$leafIds))
		{			
			if(!empty($data['EMAIL_UPDATE_COUNT']))
			{
				if($data['EMAIL_UPDATE_COUNT'] > 1)
				{
					$response['change_frequency']['email_changed'] ="true";
						$leaves_grade[] = "failed";
				}
				else
				{
					$response['change_frequency']['email_changed'] ="false";
					$total++;  $leaves_grade[] = "passed";
				}	
			}
			else
			{
				$response['change_frequency']['email_changed'] ="false";
				$total++;  $leaves_grade[] = "passed";
			}	
			
		}
		//71
		if(in_array($leaves['state_changed'],$leafIds))
		{		
			if(!empty($data['STATE_UPDATE_COUNT']))
			{
				if($data["STATE_UPDATE_COUNT"] > 1){
					$response['change_frequency']['state_changed'] ="true";
						$leaves_grade[] = "failed";	
				}
				else  
				{
					$response['change_frequency']['state_changed'] ="false";
					$total++;  $leaves_grade[] = "passed";
	
				}		
			}
			
			else  
			{
				$response['change_frequency']['state_changed'] ="false";
				$total++;  $leaves_grade[] = "passed";

			}		
		}
		//72
		if(in_array($leaves['gender_changed'],$leafIds))
		{	
			if(!empty($data['GENDER_UPDATE_COUNT']))
			{
				if($data["GENDER_UPDATE_COUNT"] > 1){
					$response['change_frequency']['gender_changed'] ="true";
						$leaves_grade[] = "failed";	
				}
				else  
				{
					$response['change_frequency']['gender_changed'] ="false";
					$total++;  $leaves_grade[] = "passed";
				}	
			}		
			else  
			{
				$response['change_frequency']['gender_changed'] ="false";
				$total++;  $leaves_grade[] = "passed";
			}
			
		}
		//73
		if(in_array($leaves['work_designation_allowed'],$leafIds))
		{	
			//checkagain			
			if($data['OCCUPATION_ID']!=3 && $data['OCCUPATION_ID']==7 && $data['OCCUPATION_ID']!=20){
				// $work_designation = explode(',',$product['PREFERRED_DESIGNATION']);	
				$work_designation = $product['PREFERRED_DESIGNATION'];	
				//condition for checking if work designation is allowed
				if(!empty($work_designation)){
					if(in_array($data['WORK_DESIGNATION'],$work_designation)){
						$response['work']['work_designation_allowed'] = "true";
						$total++;  $leaves_grade[] = "passed";
					}
					else
					{
						$response['work']['work_designation_allowed'] = "false";
							$leaves_grade[] = "failed";	
					}					
				}
				else
				{
					$response['work']['work_designation_allowed'] = "false";
					$total++;  $leaves_grade[] = "passed";	
				}			
			}
			else
			{
				$response['work']['work_designation_allowed'] = "false";
				$leaves_grade[] = "failed";
			}	
			
		}
		//74
		if(in_array($leaves['is_number_correct'],$leafIds))
		{			
			if(!empty($result_mobile)){
				if($result_mobile['BVN_PHONE'] == $data['PHONE']){			
					// var_dump($result_mobile['BVN_PHONE']);
					// var_dump($data['PHONE']);				
					$response_is_number_correct ="true";
					$total++;  $leaves_grade[] = "passed";
				} 
				else
				{
					$response_is_number_correct ="false";
						$leaves_grade[] = "failed";
				}
			}
			else
			{
				$response_is_number_correct ="no data";
					$leaves_grade[] = "failed";
			}
			
		} 
		$result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;

		//return $eligibility_data;

    }
		
	public function strpos_array($haystack, $needles) 
	{
		$pos_arr = [];	
		foreach ($needles as $str) 
		{
			$pos = stripos($haystack, $str);
			if ($pos !== FALSE) 
			{
				$pos_arr[] = $pos;
			}		
		}
		if($pos_arr == [])
		{
			return false;
		}
		else
		{
			return true;
		}

	}


    public function getLender(Request $request)
    {
        $id = $request->id;
        $lender = DB::table('people')->select('*')->where('PEOPLE_ID',$id)->get(); 
    }
    

}