<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class CardController extends Controller
{
    public function determineCardanalytics($data,$payload,$lender,$leafIds="")
    {        
        
        
        $grades = [];
       $newGrade = [];
    
       $leaves = [
           'bank'=>1,
           'expiry'=>2,
           'accepted type'=>3,
           'accepted bank'=>4
       ];
        
       $runAnalyticsData = $this->runCardAnalytics($data,$leafIds,$leaves,$payload,$lender);

        foreach($leafIds as $key=>$leafId)
        {
            $grades[$leafId] = $runAnalyticsData["leaves_grades"][$key];
        }
        foreach($grades as $key=>$grade)
        {
            if($grade == "passed")
            {
                $newGrade["passed"][] = $key;
            }
            else
            {
                $newGrade["failed"][] = $key;
            }
        }

        $analytics_data = [];
        // $analytics_data['score'] = ($runAnalyticsData["total"]/count($leafIds)) * 100;
        // $analytics_data['result'] = $analytics_data['score'] == 100 ? "eligible" : "not eligible";
        $analytics_data['grades'] = $newGrade;
        
        return json_encode(["data"=>$analytics_data,"status"=>true]);
    }

   public function runCardAnalytics($data,$leafIds,$leaves,$payload,$lender)
   {
       $leaves_grade = [];
       $total = 0;
        //checking if card bank is disbursement bank        
        if($payload['account']['BANK_ID']==$payload['card']['BANK_ID']){
            $total++;  $leaves_grade[] = "passed";
        }
        else
        {
                $leaves_grade[] = "failed";
        }

            //checking if card expires before loan                  
        if($payload['loan']['MATURITY_DATE']>$payload['card']['EXP_YEAR'].'-'.$payload['card']['EXP_MONTH'].'-31'){
            $total++;  $leaves_grade[] = "failed";
        }
        else
        {
                $leaves_grade[] = "passed";
        }

        //checking if card type is allowed
        $card_types = explode(',',$payload['lender']['ALLOWED_CARD_TYPE']);           
        if(in_array($payload['card']['CARD_TYPE'],$card_types)){
            $total++;  $leaves_grade[] = "passed";
        }
        else
        {
                $leaves_grade[] = "failed";
        }


            //checking if card bank is allowed
        $card_types = explode(',',$payload['lender']['ALLOWED_CARD_BANKS']);           
        if(in_array($payload['card']['BANK_ID'],$card_types)){
            $total++;  $leaves_grade[] = "passed";
        }
        else
        {
                $leaves_grade[] = "failed";
        }


       $result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
        return $result;

   }

   public function determineCardEligibility($data,$payload,$lender,$leafIds)
    {        
        
        
        $grades = [];
       $newGrade = [];
    
       $leaves = [
           'bank'=>1,
           'expiry'=>2,
           'accepted type'=>3,
           'accepted bank'=>4
       ];
        
       $runEligibiltyData = $this->runCardEligibilty($data,$leafIds,$leaves,$payload,$lender);

        foreach($leafIds as $key=>$leafId)
        {
            $grades[$leafId] = $runEligibiltyData["leaves_grades"][$key];
        }
        foreach($grades as $key=>$grade)
        {
            if($grade == "passed")
            {
                $newGrade["passed"][] = $key;
            }
            else
            {
                $newGrade["failed"][] = $key;
            }
        }

        $eligibility_data = [];
        $eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
        $eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible";
        $eligibility_data['grades'] = $newGrade;
        
        return json_encode(["data"=>$eligibility_data,"status"=>true]);
   }

   public function runCardEligibilty($data,$leafIds,$leaves,$payload,$lender)
   {
       $leaves_grade = [];
       $total = 0;
       if(in_array($leaves['bank'],$leafIds))
        {
            //checking if card bank is disbursement bank     
            
            if($payload['account']['BANK_ID']==$payload['card']['BANK_ID']){
                $total++;  $leaves_grade[] = "passed";
            }
            else
            {
                    $leaves_grade[] = "failed";
            }
       }
        if(in_array($leaves['expiry'],$leafIds))
        {
            //checking if card expires before loan     
            
            
            if($payload['loan']['MATURITY_DATE']>$payload['card']['EXP_YEAR'].'-'.$payload['card']['EXP_MONTH'].'-31'){
                $total++;  $leaves_grade[] = "failed";
            }
            else
            {
                    $leaves_grade[] = "passed";
            }
       }
        if(in_array($leaves['accepted type'],$leafIds))
        {
            //checking if card type is allowed
            $card_types = explode(',',$payload['lender']['ALLOWED_CARD_TYPE']);    
            
            
            if(in_array($payload['card']['CARD_TYPE'],$card_types)){
                $total++;  $leaves_grade[] = "passed";
            }
            else
            {
                    $leaves_grade[] = "failed";
            }
       }
        if(in_array($leaves['accepted bank'],$leafIds))
        {
            //checking if card bank is allowed
            $card_types = explode(',',$payload['lender']['ALLOWED_CARD_BANKS']);    
            
            
            if(in_array($payload['card']['BANK_ID'],$card_types)){
                $total++;  $leaves_grade[] = "passed";
            }
            else
            {
                    $leaves_grade[] = "failed";
            }
       }


       $result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
        return $result;

   }
}
