<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Brick\PhoneNumber\PhoneNumber;
use League\ISO3166\ISO3166;
use App\Http\Requests;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class CalllogsController extends Controller
{   
    public function determineCallLogsEligibility($data,$collection,$lender,$leafIds)
	{		
		$grades = [];
        $newGrade = [];
 	
        $leaves = [
            'call_spending_more_than_specified'=>1,
            'call_spending_within_specified_avg'=>2,
            'call_spending_less_than_specified_percent_of_income'=>3,
            'nameless_call_less_than_specified_percent_of_log'=>4,
            'most_freq_not_to_specified_external_country'=>5,
            'most_freq_to_specified_external_country'=>6,
            'ext_country_more_than_specified_percent_of_log'=>7,
            'not_between_specified_time_belts'=>8,
            'family_keyword_found'=>9,
            'family_keyword_more_than_specified_percent_of_log'=>10,
            'vanity_number_more_than_specified'=>11
        ];
		
        $runEligibiltyData = $this->runCallLogsEligibilty($data,$leafIds,$leaves,$collection,$lender);
     
		foreach($leafIds as $key=>$leafId)
		{
			$grades[$leafId] = $runEligibiltyData["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}

		$eligibility_data = [];
		$eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
		$eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible"; 
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"status"=>true]);
    }
    
    public function runCallLogsEligibilty($data,$leafIds,$leaves,$collection,$lender)
    {
      
        $leaves_grade = [];
        //dd($collection);
          $cachedNameList = $collection->where('cachedName',"!=","")->pluck('cachedName');
            // $cachedNameList->transform(function($item, $key){
            //     return ($item);//strtolower
            // });
        $cachedNameListArray = $cachedNameList->toArray();  
        $externalNumbers = [];
        $countOfCalls = $collection->count();
        $allNumbers = $collection->pluck('number');
        foreach($allNumbers->toArray() as $number)
        {
            if(substr($number, 0, -(strlen($number)-1)) == "+" && 
            substr($number, 0, -(strlen($number)-4)) !="+234")
            {
                $externalNumbers[] = $number;
            }
        }
        $externalNumbersCount = count($externalNumbers);
        $callDurationAndDate = $collection->pluck('duration','date');

        //dd($callDurationAndDate);             
        // $grouped = $callDurationAndDate->mapToGroups(function ($item, $key) {
        // // $start = 0;
        //     return [date("F",$key/1000)=>$item];
        // });

		$_temp = [];
		$_callDate = $callDurationAndDate->toArray();
		foreach ($_callDate as $key => $_count) {
			$_month = date("F",$key/1000);
			if (!isset($_temp[$_month])) {
				$_temp[$_month] = [];
			}
			$_temp[$_month][] = $_count;
		}

        $monthsGroups = $_temp;
        //dd($monthsGroups);
        foreach($monthsGroups as $key=>$monthGroup)
        {
            $totalDurationForMonths[$key] = array_sum($monthsGroups[$key]);
        }
        //dd($totalDurationForMonths);
        foreach($totalDurationForMonths as $key=>$totalDurationForMonth)
        {
            //$totalCallSpendForMonths[$key] = ($totalDurationForMonth * 10)/100;//$db
            $totalCallSpendForMonths[] = [$key=>(($totalDurationForMonth * 10)/100)];
        }
        $total = 0;
        if(in_array($leaves['call_spending_more_than_specified'],$leafIds))
		{
            if($totalCallSpendForMonths != [])
            {
                $callSpendingPerMonth =  array_sum($totalCallSpendForMonths)/count($totalCallSpendForMonths);
            }
            if($totalCallSpendForMonths == [])
            {
                $leaves_grade[] = "failed"; 
            }
            else
            {
                $response['analytics']['callspending']['greaterthanx']['value'] =  $callSpendingPerMonth > $lender['PH_AN_MONTHLY_CALL'] 
                ?"true":"false";//$db  
                if(  $response['analytics']['callspending']['greaterthanx']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }  
                else
                {
                    $leaves_grade[] = "failed";
                } 

                // $response['analytics']['callspending']['greaterthanx']['score'] = ( $response['analytics']['callspending']['greaterthanx']['value'] == "true") ? 1 : 0;            
                // $response['analytics']['callspending']['withinmarketrangexandy']['value'] =  ($callSpendingPerMonth > $lender['PH_AN_MONTHLY_CALL_MARKET_AVG_MIN') && $callSpendingPerMonth < $lender['PH_AN_MONTHLY_CALL_MARKET_AVG_MAX')) ?"true":"false";//$db         
                //     $response['analytics']['callspending']['withinmarketrangexandy']['score'] = ( $response['analytics']['callspending']['withinmarketrangexandy']['value'] == "true") ? 1 : 0;        
                // //     - Less than  {x%} of declared income
                // $callSpentPerMonthToDeclaredIncome =($callSpendingPerMonth/100) * 100;//$db
                // $response['analytics']['callspending']['lessthan_x_percent_ofdeclaredincome']['value'] =  ($callSpentPerMonthToDeclaredIncome <  $lender['PH_AN_PERCENTAGE_MONTHLY_CALL_TO_DECLARED_INCOME')) ?"true":"false";//$db        
                   
            }
        }

        if(in_array($leaves['call_spending_within_specified_avg'],$leafIds))
		{
            if($totalCallSpendForMonths != [])
            {
                $callSpendingPerMonth =  array_sum($totalCallSpendForMonths)/count($totalCallSpendForMonths);
            }
            if($totalCallSpendForMonths == [])
            {
                $leaves_grade[] = "failed"; 
            }
            else
            {

                $response['analytics']['callspending']['withinmarketrangexandy']['value'] =  ($callSpendingPerMonth > $lender['PH_AN_MONTHLY_CALL_MARKET_AVG_MIN'] && $callSpendingPerMonth < $lender['PH_AN_MONTHLY_CALL_MARKET_AVG_MAX']) ?"true":"false";//$db  
                
                  if(  
                    $response['analytics']['callspending']['withinmarketrangexandy']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }  
                else
                {
                    $leaves_grade[] = "failed";
                } 
                        
                //     - Less than  {x%} of declared income
                // $callSpentPerMonthToDeclaredIncome =($callSpendingPerMonth/100) * 100;//$db
                // $response['analytics']['callspending']['lessthan_x_percent_ofdeclaredincome']['value'] =  ($callSpentPerMonthToDeclaredIncome <  $lender['PH_AN_PERCENTAGE_MONTHLY_CALL_TO_DECLARED_INCOME')) ?"true":"false";//$db        
                   
            }
        }
        if(in_array($leaves['call_spending_less_than_specified_percent_of_income'],$leafIds))
		{
            if($totalCallSpendForMonths != [])
            {
                $callSpendingPerMonth =  array_sum($totalCallSpendForMonths)/count($totalCallSpendForMonths);
            }
            if($totalCallSpendForMonths == [])
            {
                $leaves_grade[] = "failed"; 
            }
            else
            {     
                $data['NET_MONTHLY_INCOME'] = (is_null($data['NET_MONTHLY_INCOME'])||empty($data['NET_MONTHLY_INCOME']) ||$data['NET_MONTHLY_INCOME']<= 0) ? 1 :$data['NET_MONTHLY_INCOME'];                       
                    //- Less than  {x%} of declared income
                $callSpentPerMonthToDeclaredIncome =($callSpendingPerMonth/$data['NET_MONTHLY_INCOME']) * 100;//$db
                $response['analytics']['callspending']['lessthan_x_percent_ofdeclaredincome']['value'] =  ($callSpentPerMonthToDeclaredIncome <  $lender['PH_AN_PERCENTAGE_MONTHLY_CALL_TO_DECLARED_INCOME']) ?"true":"false";//$db
                if(  
                    $response['analytics']['callspending']['lessthan_x_percent_ofdeclaredincome']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }  
                else
                {
                    $leaves_grade[] = "failed";
                }         
                   
            }
        }
        if(in_array($leaves['nameless_call_less_than_specified_percent_of_log'],$leafIds))
		{
            $outgoingCalledNumbersWithoutName = $collection->where("cachedName",'=',"")->pluck('number');
          
            $outgoingCalledNumbersWithoutNameCount = $outgoingCalledNumbersWithoutName->count();
            if($outgoingCalledNumbersWithoutName->toArray() != [])
            {
                //Percentage of nameless calls to total calls
                $percentageOfNamelessToTotal = ($outgoingCalledNumbersWithoutNameCount/$countOfCalls) * 100;
                $response['analytics']['namelesscalls']['namelesscalls_less_than_x_percent_oflogs'] = ($percentageOfNamelessToTotal < $lender['PH_AN_PERCENTAGE_NAMELESS_CALLS_TO_LOG']) ? "true" : "false";//$db
                if( $response['analytics']['namelesscalls']['namelesscalls_less_than_x_percent_oflogs'] == "true")
                {
                    $total++;
                    $leaves_grade [] = "passed";
                }  
                else
                {
                    $leaves_grade [] = "failed";
                }       
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        }
        if(in_array($leaves['most_freq_not_to_specified_external_country'],$leafIds))
		{
            if($externalNumbersCount == 0)
            {
                $leaves_grade[]= "failed";
            }
            else
            {
                $externalNumbersCollection = collect($externalNumbers);
                //  dd($externalNumbersCollection);
                $mostFrequentExternal = $externalNumbersCollection->mode()[0];

                $countriesNotAccepted = $lender['PH_AN_BLACKLISTED_EXTERNAL_COUNTRIES'];
                if($countriesNotAccepted == [])
                {
                    $blacklistedCountries = [];
                }
                else
                {
                    $countriesNotAcceptedISO = [];
                    $NotAcceptedISO = (new ISO3166);
                    foreach($countriesNotAccepted as $countryNotAccepted)
                    {
                        $countriesNotAcceptedISO[] = $NotAcceptedISO->name($countryNotAccepted)['alpha2'];
                    }
                    foreach($countriesNotAcceptedISO as $countryNotAcceptedISO)
                    {
                        if($countryNotAcceptedISO == PhoneNumber::parse($mostFrequentExternal)->getRegionCode())
                        {
                            $blacklistedCountries[] = "1";
                        }
                    }
                }

                // $countriesAccepted = $lender['PH_AN_ACCEPTED_EXTERNAL_COUNTRIES');
                // if($countriesAccepted == [])
                // {
                //     $acceptedCountries = [];
                // }
                // else
                // {

                //     $countriesAccepted = $lender['PH_AN_ACCEPTED_EXTERNAL_COUNTRIES');//$db
                //     $AcceptedISO = (new ISO3166);
                //     $countriesAcceptedISO = [];
                //     foreach($countriesAccepted as $countryAccepted)
                //     {
                //         $countriesAcceptedISO[] = $AcceptedISO->name($countryAccepted)['alpha2'];
                //     }
                //    // dd($countriesAcceptedISO);
                //     foreach($countriesAcceptedISO as $countryAcceptedISO)
                //     {
                //         if($countryAcceptedISO == PhoneNumber::parse($mostFrequentExternal)->getRegionCode())
                //         {
                //             $acceptedCountries[] = "1";
                //         }
                //     }
                // }
 
                $numbersAndDates = $collection->pluck('number','date');
                 //dd($numbersAndDates);
                // $groupedExternalCountries = $numbersAndDates->mapToGroups(function ($item, $key) {
                //     if(substr($item, 0, -(strlen($item)-1)) == "+" && 
                //     substr($item, 0, -(strlen($item)-4)) !="+234" )
                //     {
                //         return [date("F",$key/1000)=>$item];
                //     }
                //     else{
                //         return ['no'];
                //     }
                // })->except('0');
                // $groupedExternalCountries->transform(function($item,$key){
                //     return $item->count();
                // });
                // $externalCallFrequency = $groupedExternalCountries->avg();
                // $externalCallToTotal = ($externalCallFrequency/$allNumbers->count()) * 100;

                $response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value']= !(count($blacklistedCountries) > 0) ?"true":"false";//$db

                if($response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";

                }
                else
                {
                    $leaves_grade[] = "failed";
                }
                // $response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['score'] = ($response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value'] == "true") ? 1 : 0;

                // $response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] = (count($acceptedCountries) > 0) ?"true":"false";//$db     
                // if($response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] == "true")
                // {
                //     $total++;
                //     $leaves_grade[] = "passed";

                // }  
                // else
                // {
                //     $leaves_grade[] = "failed";
                // }  

                //     $response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['score'] = ($response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] == "true") ? 1 : 0;

                // $response['analytics']['frequentlyexternalcountry']['greaterthan_x_percent_per_monthoftotal']['value'] = $externalCallToTotal > $lender['PH_AN_PERCENTAGE_MONTHLY_EXTERNAL_COUNTRY_TO_TOTAL') ?"true":"false";
                
            }  
        }
        if(in_array($leaves['most_freq_to_specified_external_country'],$leafIds))
		{
            if($externalNumbersCount == 0)
            {
                $leaves_grade[]= "failed";
            }
            else
            {
                $externalNumbersCollection = collect($externalNumbers);
                //  dd($externalNumbersCollection);
                $mostFrequentExternal = $externalNumbersCollection->mode()[0];

                // $countriesNotAccepted = $lender['PH_AN_BLACKLISTED_EXTERNAL_COUNTRIES');
                // if($countriesNotAccepted == [])
                // {
                //     $blacklistedCountries = [];
                // }
                // else
                // {
                //     $countriesNotAcceptedISO = [];
                //     $NotAcceptedISO = (new ISO3166);
                //     foreach($countriesNotAccepted as $countryNotAccepted)
                //     {
                //         $countriesNotAcceptedISO[] = $NotAcceptedISO->name($countryNotAccepted)['alpha2'];
                //     }
                //     foreach($countriesNotAcceptedISO as $countryNotAcceptedISO)
                //     {
                //         if($countryNotAcceptedISO == PhoneNumber::parse($mostFrequentExternal)->getRegionCode())
                //         {
                //             $blacklistedCountries[] = "1";
                //         }
                //     }
                // }

                $countriesAccepted = $lender['PH_AN_ACCEPTED_EXTERNAL_COUNTRIES'];
                if($countriesAccepted == [])
                {
                    $acceptedCountries = [];
                }
                else
                {

                    $countriesAccepted = $lender['PH_AN_ACCEPTED_EXTERNAL_COUNTRIES'];//$db
                    $AcceptedISO = (new ISO3166);
                    $countriesAcceptedISO = [];
                    foreach($countriesAccepted as $countryAccepted)
                    {
                        $countriesAcceptedISO[] = $AcceptedISO->name($countryAccepted)['alpha2'];
                    }
                   // dd($countriesAcceptedISO);
                    foreach($countriesAcceptedISO as $countryAcceptedISO)
                    {
                        if($countryAcceptedISO == PhoneNumber::parse($mostFrequentExternal)->getRegionCode())
                        {
                            $acceptedCountries[] = "1";
                        }
                    }
                }
 
                $numbersAndDates = $collection->pluck('number','date');
                 //dd($numbersAndDates);
                // $groupedExternalCountries = $numbersAndDates->mapToGroups(function ($item, $key) {
                //     if(substr($item, 0, -(strlen($item)-1)) == "+" && 
                //     substr($item, 0, -(strlen($item)-4)) !="+234" )
                //     {
                //         return [date("F",$key/1000)=>$item];
                //     }
                //     else{
                //         return ['no'];
                //     }
                // })->except('0');
                // $groupedExternalCountries->transform(function($item,$key){
                //     return $item->count();
                // });
                // $externalCallFrequency = $groupedExternalCountries->avg();
                // $externalCallToTotal = ($externalCallFrequency/$allNumbers->count()) * 100;

                // $response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value']= !(count($blacklistedCountries) > 0) ?"true":"false";//$db
                // if($response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value'] == "true")
                // {
                //     $total++;
                //     $leaves_grade[] = "passed";

                // }
                // $response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['score'] = ($response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value'] == "true") ? 1 : 0;

                $response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] = (count($acceptedCountries) > 0) ?"true":"false";//$db     
                if($response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";

                }  
                else
                {
                    $leaves_grade[] = "failed";
                }  
                //     $response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['score'] = ($response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] == "true") ? 1 : 0;

                // $response['analytics']['frequentlyexternalcountry']['greaterthan_x_percent_per_monthoftotal']['value'] = $externalCallToTotal > $lender['PH_AN_PERCENTAGE_MONTHLY_EXTERNAL_COUNTRY_TO_TOTAL') ?"true":"false";
                
            }  
        }
        if(in_array($leaves['ext_country_more_than_specified_percent_of_log'],$leafIds))
		{
            if($externalNumbersCount == 0)
            {
                $leaves_grade[]= "failed";
            }
            else
            {
                $externalNumbersCollection = collect($externalNumbers);
                //  dd($externalNumbersCollection);
                $mostFrequentExternal = $externalNumbersCollection->mode()[0];

                // $countriesNotAccepted = $lender['PH_AN_BLACKLISTED_EXTERNAL_COUNTRIES');
                // if($countriesNotAccepted == [])
                // {
                //     $blacklistedCountries = [];
                // }
                // else
                // {
                //     $countriesNotAcceptedISO = [];
                //     $NotAcceptedISO = (new ISO3166);
                //     foreach($countriesNotAccepted as $countryNotAccepted)
                //     {
                //         $countriesNotAcceptedISO[] = $NotAcceptedISO->name($countryNotAccepted)['alpha2'];
                //     }
                //     foreach($countriesNotAcceptedISO as $countryNotAcceptedISO)
                //     {
                //         if($countryNotAcceptedISO == PhoneNumber::parse($mostFrequentExternal)->getRegionCode())
                //         {
                //             $blacklistedCountries[] = "1";
                //         }
                //     }
                // }

                // $countriesAccepted = $lender['PH_AN_ACCEPTED_EXTERNAL_COUNTRIES');
                // if($countriesAccepted == [])
                // {
                //     $acceptedCountries = [];
                // }
                // else
                // {

                //     $countriesAccepted = $lender['PH_AN_ACCEPTED_EXTERNAL_COUNTRIES');//$db
                //     $AcceptedISO = (new ISO3166);
                //     $countriesAcceptedISO = [];
                //     foreach($countriesAccepted as $countryAccepted)
                //     {
                //         $countriesAcceptedISO[] = $AcceptedISO->name($countryAccepted)['alpha2'];
                //     }
                //    // dd($countriesAcceptedISO);
                //     foreach($countriesAcceptedISO as $countryAcceptedISO)
                //     {
                //         if($countryAcceptedISO == PhoneNumber::parse($mostFrequentExternal)->getRegionCode())
                //         {
                //             $acceptedCountries[] = "1";
                //         }
                //     }
                // }
 
                $numbersAndDates = $collection->pluck('number','date');
                 //dd($numbersAndDates);
                //removed code start
                // $groupedExternalCountries = $numbersAndDates->mapToGroups(function ($item, $key) {
                //     if(substr($item, 0, -(strlen($item)-1)) == "+" && 
                //     substr($item, 0, -(strlen($item)-4)) !="+234" )
                //     {
                //         return [date("F",$key/1000)=>$item];
                //     }
                //     else{
                //         return ['no'];
                //     }
                // })->except('0');
                 //removed code end

                //newly implemented because of laravel 5.2 maptogroups issue
                $numbersAndDates =  $numbersAndDates->toArray();
                $temporal = [];
                foreach ($numbersAndDates as $key=>$numberAndDate) {
                	$singlemonth = date("F",$key/1000);
                	if(!isset($temporal[$singlemonth]))
                	{
                		$temporal[$singlemonth] = [];
                	}
                	if(substr($item, 0, -(strlen($item)-1)) == "+" && 
                    substr($item, 0, -(strlen($item)-4)) !="+234" )
                	{
                		$temporal[$singlemonth][] = $numberAndDate;
                	}
                	$temporal[$singlemonth] = [];
                }

                 $groupedExternalCountries =  collect($temporal);

                $groupedExternalCountries->transform(function($item,$key){
                    return $item->count();
                });
                $externalCallFrequency = $groupedExternalCountries->avg();
                $externalCallToTotal = ($externalCallFrequency/$allNumbers->count()) * 100;

                // $response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value']= !(count($blacklistedCountries) > 0) ?"true":"false";//$db
                // if($response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value'] == "true")
                // {
                //     $total++;
                //     $leaves_grade[] = "passed";

                // }
                // $response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['score'] = ($response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value'] == "true") ? 1 : 0;

                // $response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] = (count($acceptedCountries) > 0) ?"true":"false";//$db     
                // if($response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] == "true")
                // {
                //     $total++;
                //     $leaves_grade[] = "passed";

                // }  
                // else
                // {
                //     $leaves_grade[] = "failed";
                // }  
                    // $response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['score'] = ($response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] == "true") ? 1 : 0;

                $response['analytics']['frequentlyexternalcountry']['greaterthan_x_percent_per_monthoftotal']['value'] = $externalCallToTotal > $lender['PH_AN_PERCENTAGE_MONTHLY_EXTERNAL_COUNTRY_TO_TOTAL'] ?"true":"false";

                if( $response['analytics']['frequentlyexternalcountry']['greaterthan_x_percent_per_monthoftotal']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";

                }  
                else
                {
                    $leaves_grade[] = "failed";
                }  
                
            }  
        }
        if(in_array($leaves['not_between_specified_time_belts'],$leafIds))
		{
            $callDates = $collection->pluck('date');
            $callDatesCount = $callDates->count();
            $callDates = $callDates->map(function ($item, $key) {
                if(date("H",(int)$item/1000) >= 0 && date("H",(int)$item/1000)< 6){
                    return "early morning";
                }
                elseif(date("H",(int)$item/1000) >= 6 && date("H",(int)$item/1000)< 12){
                    return "morning";
                }
                elseif(date("H",(int)$item/1000) >= 12 && date("H",(int)$item/1000)< 18){
                    return "afternoon";
                }
                else{
                    return "evening";
                }
            });
            if($callDatesCount = 0)
            {
                $leaves_grade[] = "failed";
            }
            else
            {
                $response['analytics']['freqCallTimeBelt']['Notbetweenspecifictimebelts'] = !($callDates->mode()[0] == $lender['PH_AN_REJECTED_FREQUENT_CALL_TIME_BELT']) ? "true":"false";//$db
                
                if( $response['analytics']['freqCallTimeBelt']['Notbetweenspecifictimebelts'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }
                else
                {
                    $leaves_grade[] = "failed";
                }             
            }
        }
        if(in_array($leaves['family_keyword_found'],$leafIds))
		{
            $name = strtok($data['LEGAL_NAME'], " ");
            $familyTitles = ['mum', 'dad','daddy','mummy','mom','pops','papa','mama','mumcy','popsi','mami','pastor',$name];//add any body 
            //$cachedNameListArray =$cachedNameList->toArray();  
            
            $familyKeywordsFound = $this->getFamilyKeywordsInCallLogs($cachedNameListArray, $familyTitles,$v=[]) ;
            $familyKeywordsFoundCount = count($familyKeywordsFound);
            //dd($familyKeywordsFoundCount);
            if($familyKeywordsFoundCount == 0)
            {
               $leaves_grade[] = "failed";  
            }
            else
            {
                $response['analytics']['keywordsinname']['familykeywordsfound']['value'] = ($familyKeywordsFoundCount > 0 )?"true":"false";   //$db
                $response['analytics']['keywordsinname']['familykeywordsfound']['score'] = ($response['analytics']['keywordsinname']['familykeywordsfound']['value'] == "true") ? 1 : 0;
                if( $response['analytics']['keywordsinname']['familykeywordsfound']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";  
                }

             
            }
        }
        if(in_array($leaves['family_keyword_more_than_specified_percent_of_log'],$leafIds))
		{
			//customer.BORROWER_NAME')
            $name = strtok($data['LEGAL_NAME'], " ");
            $familyTitles = ['mum', 'dad','daddy','mummy','mom','pops','papa','mama','mumcy','popsi','mami','pastor',$name];//add any body 
            //$cachedNameListArray =$cachedNameList->toArray();  
            $familyKeywordsFound = $this->getFamilyKeywordsInCallLogs($cachedNameListArray, $familyTitles,$v=[]) ;
            $familyKeywordsFoundCount = count($familyKeywordsFound);
            //dd($familyKeywordsFoundCount);
            if($familyKeywordsFoundCount == 0)
            {
               $leaves_grade[] = "failed";  
            }
            else
            {
                // $response['analytics']['keywordsinname']['familykeywordsfound']['value'] = ($familyKeywordsFoundCount > 0 )?"true":"false";   //$db
                // $response['analytics']['keywordsinname']['familykeywordsfound']['score'] = ($response['analytics']['keywordsinname']['familykeywordsfound']['value'] == "true") ? 1 : 0;
                // if( $response['analytics']['keywordsinname']['familykeywordsfound']['value'] == "true")
                // {

                // }

                $percentageOfFamilyKeywords = ($familyKeywordsFoundCount/$countOfCalls) * 100;
                //dd($percentageOfFamilyKeywords);  
                $response['analytics']['keywordsinname']['Keywordscall_greater_than_x_percent_oftotal']['value'] = ($percentageOfFamilyKeywords > $lender['PH_AN_PERCENTAGE_OF_FAMILY_KEY_WORD_TO_TOTAL'])?"true":"false";//$db 

                if( $response['analytics']['keywordsinname']['Keywordscall_greater_than_x_percent_oftotal']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }
            }
        }
        if(in_array($leaves['vanity_number_more_than_specified'],$leafIds))
		{
            $allNumbers = $collection->pluck('number');
            $uniqueNumbers = $allNumbers->unique();
            $uniqueNum = $uniqueNumbers->filter(function($item, $key){
                return collect(str_split($item))->unique()->count() < 5;              
            });
            if($allNumbers->toArray() != [])
            {
                $response['analytics']['uniquenumbercount']['uniquenumber_greater_than_x'] = ($uniqueNum->count() > $lender['PH_AN_VANITY_NUMBER_COUNT'])? "true" : "false"; //$db  
                if( $response['analytics']['uniquenumbercount']['uniquenumber_greater_than_x'] == "true")
                {
                    $total++;
                    $leaves_grade [] = "passed";
                }   
               
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        }

        $result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;
      
    }
   
    public function determineCallLogsAnalytics($data,$collection,$lender)
	{		
		$grades = [];
        $newGrade = [];
 	
        $leaves = [
            'call_spending_more_than_specified'=>1,
            'call_spending_within_specified_avg'=>2,
            'call_spending_less_than_specified_percent_of_income'=>3,
            'nameless_call_less_than_specified_percent_of_log'=>4,
            'most_freq_not_to_specified_external_country'=>5,
            'most_freq_to_specified_external_country'=>6,
            'ext_country_more_than_specified_percent_of_log'=>7,
            'not_between_specified_time_belts'=>8,
            'family_keyword_found'=>9,
            'family_keyword_more_than_specified_percent_of_log'=>10,
            'vanity_number_more_than_specified'=>11
        ];
        
        $leaves = array_values($leaves);

        $callLogsAnalytics = $this->runCallLogsAnalytics($data,$collection,$lender);
     
		foreach($leaves as $key=>$leafId)
		{
			$grades[$leafId] = $callLogsAnalytics["leaves_grades"][$key];
		}
		foreach($grades as $key=>$grade)
		{
			if($grade == "passed")
			{
				$newGrade["passed"][] = $key;
			}
			else
			{
				$newGrade["failed"][] = $key;
			}
		}

		$eligibility_data = [];
		// $eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
		// $eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible"; 
		$eligibility_data['grades'] = $newGrade;
		
		return json_encode(["data"=>$eligibility_data,"response"=>$callLogsAnalytics["data"],"status"=>true]);
    }
    public function runCallLogsAnalytics($data,$collection,$lender)
    {
        // $data = $request->input('customer');
        // $leafIds= $request->leafIds;
        // $leaves= $request->leaves;
        // $collection= $request->input('customer.CALL_LOGS');
        // $collection = collect($collection);
        // $lender = $request->lender;
        if(empty($collection) || is_null($collection))
        {
            return json_encode(['data'=>"Call logs Data is Empty",'status'=>false]);
        }
        $reliability_score  = 0;
        $blacklistedCountries = [];
        $acceptedCountries = [];
       // $collection = collect($callLogs);
            $datesIncoming = $collection->whereIn("type",["1",1])->pluck('date');
           
            $_temp = [];
            $datesIncoming = $datesIncoming->toArray();
            foreach ($datesIncoming as $key => $_count) {
                $_month = date("F",(int)$_count/1000);
                $_count = date("H",(int)$_count/1000);
                if (!isset($_temp[$_month])) {
                    $_temp[$_month] = [];
                }
                $_temp[$_month][] = $_count;
            }
          
            $datesIncoming =  collect($_temp);
          
            // $datesIncoming = $datesIncoming->mapToGroups(function ($item, $key) {
            //     return [date("F",(int)$item/1000)=>date("H",(int)$item/1000)];
            // });
            //dd($datesIncoming);

            $datesIncoming = $datesIncoming->map(function ($item, $key) {
                collect($item)->map(function($item, $key){
                    if($item >= 0 && $item< 6)
                    {
                        return "early morning";
                    }
                    elseif($item >= 6 && $item< 12){
                        return "morning";
                    }
                    elseif($item >= 12 && $item< 18){
                        return "afternoon";
                    }
                    else{
                        return "evening";
                    }
                });
                return collect($item)->mode();
            });

           
            $in = [];
            $datesIncoming = $datesIncoming->toArray();
            foreach($datesIncoming as $key=>$date_incoming)
            {
                foreach($date_incoming as $date_in)
                {
                     if($date_in >= 0 && $date_in< 6)
                     {
                         $in[$key][] = "early morning";
                     }
                     if($date_in >= 6 && $date_in< 12)
                     {
                         $in[$key][] = "morning";
                     }
                     if($date_in >= 12 && $date_in< 18)
                     {
                         $in[$key][] = "afternoon";
                     }
                     if($date_in >= 18 && $date_in< 24)
                     {
                         $in[$key][] = "evening";
                     }                  
                }
            }
            // var_dump($datesIncoming);
            // die();
           //dd($datesIncoming->toArray());
             $monthlyIncomingFrequentTimebelt =[];
  
            $datesOutgoing = $collection->whereIn("type",["2",2])->pluck('date');

            //dd($datesOutgoing);
                  //- Consistency Score
            //does he call around the same timebelt
            // $dateName = $collection->where("cachedName",'!=',"")->pluck('cachedName','number');
            ///highlights
            $sametimebelts = $datesOutgoing->map(function ($item, $key) {
                // collect($item)->map(function($item, $key){
                    $item = date("H",(int)$item/1000);
                    if($item >= 0 && $item< 6)
                    {
                        return "early morning";
                    }
                    elseif($item >= 6 && $item< 12){
                        return "morning";
                    }
                    elseif($item >= 12 && $item< 18){
                        return "afternoon";
                    }
                    else{
                        return "evening";
                    }
                // });
                return (($item));
            });
         
          
            // does he call every week/day
            
            //Activeness Score
            //-how often does he call per month


            // var_dump($outDuration);
            // die();

          

            $_temp = [];
            $datesOutgoing = $datesOutgoing->toArray();
            foreach ($datesOutgoing as $key => $_count) {
                $_month = date("F",(int)$_count/1000);
                $_count = date("H",(int)$_count/1000);
                if (!isset($_temp[$_month])) {
                    $_temp[$_month] = [];
                }
                $_temp[$_month][] = $_count;
            }
          
            $datesOutgoing =  collect($_temp);
         
            

            $datesOutgoing = $datesOutgoing->map(function ($item, $key) {
                collect($item)->map(function($item, $key){
                    if($item >= 0 && $item< 6)
                    {
                        return "early morning";
                    }
                    elseif($item >= 6 && $item< 12){
                        return "morning";
                    }
                    elseif($item >= 12 && $item< 18){
                        return "afternoon";
                    }
                    else{
                        return "evening";
                    }
                });
                return (collect($item)->mode());
            });
            // var_dump($datesOutgoing);
            // die();
            //dd( $datesOutgoing);
            //dd($datesOutgoing->implode(','));
            $out = [];
           $datesOutgoing = $datesOutgoing->toArray(); 
           foreach($datesOutgoing as $key=>$date_outgoing)
           {
               foreach($date_outgoing as $date_out)
               {
                    if($date_out >= 0 && $date_out< 6)
                    {
                        $out[$key][] = "early morning";
                    }
                    if($date_out >= 6 && $date_out< 12)
                    {
                        $out[$key][] = "morning";
                    }
                    if($date_out >= 12 && $date_out< 18)
                    {
                        $out[$key][] = "afternoon";
                    }
                    if($date_out >= 18 && $date_out< 24)
                    {
                        $out[$key][] = "evening";
                    }                  
               }
           }    
        //    var_dump($out);
        //    die();
            $monthlyOutgoingFrequentTimebelt = [];

            $allDateDuration = $collection->pluck("duration","date");
            //dd($allDateDuration);
            $_temp = [];
            $allDateDuration = $allDateDuration->toArray();
            foreach ($allDateDuration as $key => $_count) {
                $_month = date("F",(int)$key/1000);
                //$_count = date("H",(int)$_count/1000);
                if (!isset($_temp[$_month])) {
                    $_temp[$_month] = [];
                }
                $_temp[$_month][] = $_count;
            }
            $allDateDuration =  collect($_temp);
                // $allDateDuration = $allDateDuration->mapToGroups(function ($item, $key) {
                //     return [date("F",(int)$key/1000)=>$item];
                // }); 
                //dd($allDateDuration);
            $allData  = $allDateDuration->map(function($item, $key)use($datesOutgoing, $datesIncoming,$out,$in){
               
                return ['month'=>$key,'total_seconds'=>collect($item)->sum(),'cost_per_sec'=>10,'total_amount_spent'=>((collect($item)->sum()*10)/100),'call_count'=>collect($item)->count(),'timebelt_outgoing'=>implode(",",$out[$key]),'new_timebelt_outgoing'=>($out[$key]),"timebelt_incoming"=>implode(",",$in[$key]),"new_timebelt_incoming"=>($in[$key])];
                });
            // var_dump($allData);
            //  die();
            $total = 0;
            $amountSpentMonthly  = $allData->map(function($item, $key){
                $total = 0;
                $total+=$item['total_amount_spent'];
                return $total;
            });
            //dd($allData);

            $outgoingDateDuration = $collection->whereIn("type",["2",2])->pluck("duration","date");

            $_temp = [];
            $outgoingDateDuration = $outgoingDateDuration->toArray();
            foreach ($outgoingDateDuration as $key => $_count) {
                $_month = date("F",(int)$key/1000);
                //$_count = date("H",(int)$_count/1000);
                if (!isset($_temp[$_month])) {
                    $_temp[$_month] = [];
                }
                $_temp[$_month][] = $_count;
            }
            $outgoingDateDuration =  collect($_temp);

            // $outgoingDateDuration = $outgoingDateDuration->mapToGroups(function ($item, $key) {
            //     return [date("F",(int)$key/1000)=>$item];
            // });   
            //dd($outgoingDateDuration);        
            $outgoingData  = $outgoingDateDuration->map(function($item, $key)use($datesOutgoing){
              
                return ['month'=>$key,'total_seconds'=>collect($item)->sum(),'cost/sec'=>10,'total_amount_spent'=>((collect($item)->sum()*10)/100),'call_count'=>collect($item)->count(),(array_values($datesOutgoing))];
                //$db
                });
            //dd($outgoingData);
            $total = 0;
            $amountSpentMonthly  = $outgoingData->map(function($item, $key){
                $total = 0;
                $total+=$item['total_amount_spent'];
                return $total;
            });
            $projectedExpenseProfile = $amountSpentMonthly->avg() ;//$db
            //dd($outgoingData);
            $incomingDateDuration = $collection->whereIn("type",["1",1])->pluck("number","date");
            $incomingDateDuration = $collection->whereIn("type",["1",1])->pluck("duration","date");

            $_temp = [];
            $incomingDateDuration = $incomingDateDuration->toArray();
            foreach ($incomingDateDuration as $key => $_count) {
                $_month = date("F",(int)$key/1000);
                //$_count = date("H",(int)$_count/1000);
                if (!isset($_temp[$_month])) {
                    $_temp[$_month] = [];
                }
                $_temp[$_month][] = $_count;
            }
            $incomingDateDuration =  collect($_temp);
            // var_dump($incomingDateDuration);
            // die();
            // $incomingDateDuration = $incomingDateDuration->mapToGroups(function ($item, $key) {
            //     return [date("F",(int)$key/1000)=>$item];
            // });
            //dd($incomingDateDuration);
            $incomingData  = $incomingDateDuration->map(function($item, $key)use($datesIncoming){
                return ['month'=>$key,'total_seconds'=>collect($item)->sum(),'call_count'=>collect($item)->count(),array_values($datesIncoming)];//$db
            });

            $montly_total_seconds = 0;
            $montly_total_cost = 0;
            $outgoing_timebelt = [];
            $incoming_timebelt = [];
            foreach(array_values($allData->toArray()) as $value)
            {
                $montly_total_seconds += $value['total_seconds'];
                $montly_total_cost += $value['total_amount_spent'];
                foreach($value['new_timebelt_outgoing'] as $out_time)
                {
                    $outgoing_timebelt[] = $out_time;
                }
                foreach($value['new_timebelt_incoming'] as $in_time)
                {
                    $incoming_timebelt[] = $in_time;
                }
                // $outgoing_timebelt[] = $value['new_timebelt_outgoing'];
                // $incoming_timebelt[] = $value['new_timebelt_incoming'];
            }
            $count_of_months = count(array_values($allData->toArray()));
            $average_monthly_calls =  $montly_total_seconds/ $count_of_months ;
            $average_monthly_call_cost =  $montly_total_cost/ $count_of_months ;
           
             //highlights
             $total_call_count = 0;
             $sametimebelts =   array_count_values($sametimebelts->toArray());
             //var_dump( $datesOutgoing);
             arsort($sametimebelts);
             $sametimebelts = array_values($sametimebelts);
             $highestTimeBelt = $sametimebelts[0]/array_sum($sametimebelts);
             $consistency_score = 0;
             if($highestTimeBelt > 60)
             {
                 $timebelt_consistency  = true;
                 $consistency_score += 1;
             }
            //  else
            //  {
            //      $timebelt_consistency  = false; 
            //  }
             //does he spend the same time/amount per call 
             $outDuration = $collection->whereIn("type",["2",2])->pluck('duration');
             $outDuration = $outDuration->map(function ($item, $key) {
                 // collect($item)->map(function($item, $key){
                    // $item = date("H",(int)$item/1000);
                     if($item >= 0 && $item < 60)
                     {
                         return "under_one_minute";
                     }   
                     elseif($item >= 60 && $item < 180){
                         return "above_one_minute";
                     }
                     elseif($item >= 180 && $item < 300){
                         return "above_three_minutes";
                     }
                     elseif($item >= 300 && $item < 420){
                         return "above_five_minutes";
                     }
                     else{
                         return "about_ten_minutes";
                     }
                 // });
                 return (($item));
             });
             $outDuration =   array_count_values($outDuration->toArray());
             //var_dump( $datesOutgoing);
             arsort($outDuration);
             $outDuration = array_values($outDuration);
             $highestDuration = $outDuration[0]/array_sum($outDuration);
             if($highestDuration > 60)
             {
                 //$same_time_consistency  = true;
                 $consistency_score += 1;
             }
            //  else
            //  {
            //      $same_time_consistency  = false; 
            //  }
             // does he call the same set of named people/numbers
             $outNumber = $collection->whereIn("type",["2",2])->pluck('number');
             $outNumber =   array_count_values($outNumber->toArray());
             //var_dump( $datesOutgoing);
             arsort($outNumber);
             $outNumber = array_values($outNumber);
             $sameNumbers = $outNumber[0]/array_sum($outNumber);
             if($sameNumbers > 60)
             {
                 //$same_numbers_consistency  = true;
                 $consistency_score += 1;
             }
            //  else
            //  {
            //      $same_numbers_consistency  = false; 
            //  }
            $consistency_score = ($consistency_score/3) * 100;
            $activeness_score = 0;
             if($average_monthly_calls > 10)
             {
                //$calls_activeness  = true;
                $activeness_score += 1;
             }
            //  else
            //  {
            //     $calls_activeness  = false;
            //  }
            $activeness_score = ($activeness_score/1) * 100;
            // Ownership Score
            // is he calling more named numbers 
            $ownership_score = 0;
            $namedNumbersCount = $collection->where("cachedNamed","!=","")->count();
            $allNumbersCount = $collection->count();
            // var_dump($namedNumbersCount);
            // var_dump($allNumbersCount);
            // var_dump($namedNumbersCount/$allNumbersCount);
            // die();
            if(($namedNumbersCount/$allNumbersCount) > 0.5)
            {
                //$named_ownership = true;
                $ownership_score += 1;
                $reliability_score +=1;
            }
            // else
            // {
            //     //$named_ownership = false;
            //     $ownership_score += 0;
            // }

            $call_centre_calls = $collection->whereIn("number",["180","200","121","111"])->count();
            // $call_centre_calls = ($call_centre_calls > 0) ? true:false;
            if($call_centre_calls > 0)
            {          
                $ownership_score += 1;
            }
           
           // $ownership_score = [$named_ownership,$call_centre_calls];

            //Reliability
            
            // $outDuration = $collection->where("cahedNamed","!=","")->count;
           
      
            $response['data']['average'] = [
                'average_monthly_calls' => $average_monthly_calls,
                'average_monthly_call_cost' => $average_monthly_call_cost,
                'outgoing_timebelt' => collect($outgoing_timebelt)->mode(),
                'incoming_timebelt' => collect($incoming_timebelt)->mode(),
            ];

            $response['data']['calls'] =       
                // 'outgoing'=>array_values($outgoingData->toArray()),'projected_expense_profile'=>$projectedExpenseProfile,'incoming'=>array_values($incomingData->toArray()
                // array_values($outgoingData->toArray()),'projected_expense_profile'=>$projectedExpenseProfile,
                // array_values($incomingData->toArray())
                array_values($allData->toArray())
            ;
           

            //- 10 Most Frequently outgoing Called numbers Named/Call freq/Last time of call
            //->dateNumberNamed
            $dateNumberNamed = $collection->pluck('number','date'); 
            //dd($dateNumberNamed);
            $dateName = $collection->where("cachedName",'!=',"")->pluck('cachedName','number');
            //dd($dateName);
            //$name = $collection->where('number',$item)->get('cachedName');
            $_temp = [];
            $dateNumberNamed = $dateNumberNamed->toArray();
            foreach ($dateNumberNamed as $key => $_count) {
                $_month = date("r",(int)$key/1000);
                //$_count = date("H",(int)$_count/1000);
                if (!isset($_temp[$_count])) {
                    $_temp[$_count] = [];
                }
                $_temp[$_count][] = $_month;
            }
            $groupedDateNumberNamed =  collect($_temp);
          
            // $groupedDateNumberNamed = $dateNumberNamed->mapToGroups(function ($item, $key) use($collection) {
            //     return [$item=>date("r",(int)$key/1000)];
            // });
            //dd($groupedDateNumberNamed);
            $frequencyDataNamed = $groupedDateNumberNamed->map(function ($item, $key) use($collection) {
                $name = $collection->where('number',$key)->pluck('cachedName')[0];
                return ['name'=>$name,'number'=>$key,'lastcalltime'=>Carbon::parse(collect($item)->max())->toDateTimeString(),'frequency'=>collect($item)->count()];
            });
            $frequencyDataNamed = $frequencyDataNamed->sortBy("frequency");
            ($response['data']['frequent_all_calls'] =        
            array_values($frequencyDataNamed->take(10)->toArray())
            );  
            //- 10 Most freq Called numbers nameless/Call freq/Last time of call
            $dateNumberNameless = $collection->where("cachedName",'=',"")->pluck('number','date'); 
            //dd($dateName);
            //$name = $collection->where('number',$item)->get('cachedName');
            $_temp = [];
            $dateNumberNameless = $dateNumberNameless->toArray();
            foreach ($dateNumberNameless as $key => $_count) {
                $_month = date("r",(int)$key/1000);
                //$_count = date("H",(int)$_count/1000);
                if (!isset($_temp[$_count])) {
                    $_temp[$_count] = [];
                }
                $_temp[$_count][] = $_month;
            }
            $groupedDateNumberNameless =  collect($_temp);

            // $groupedDateNumberNameless = $dateNumberNameless->mapToGroups(function ($item, $key) use($collection) {
            //     return [$item=>date("r",(int)$key/1000)];
            // });
            //dd($groupedDateNumberNameless);

            $frequencyDataNameless = $groupedDateNumberNameless->map(function ($item, $key) use($collection) {
                //$name = $collection->where('number',$key)->pluck('cachedName')[0];
                return ['number'=>$key,'frequency'=>collect($item)->count(),'lastcalltime'=>Carbon::parse(collect($item)->max())->toDateTimeString()];
            });
            
            $frequencyDataNameless = $frequencyDataNameless->sortBy("frequency");
           // dd($frequencyDataNameless->toArray());
            $response['data']['frequent_nameless_calls'] = array_values($frequencyDataNameless->take(10)->toArray());  
            $dates = $collection->pluck('date');

            $_temp = [];
            $dates = $dates->toArray();
            foreach ($dates as $key => $value) {
                $_month = date("F",(int)$value/1000);
                $_count = date("H",(int)$value/1000);
                if (!isset($_temp[$_month])) {
                    $_temp[$_month] = [];
                }
                $_temp[$_month][] = $_count;
            }
            $dates =  collect($_temp);

            // var_dump($dates);
            // die();
            // $dates = $dates->mapToGroups(function ($item, $key) {
            //     return [date("F",(int)$item/1000)=>date("H",(int)$item/1000)];
            // });
            //dd($dates);
            $dates = $dates->map(function ($item, $key) {
                collect($item)->transform(function($item, $key){
                    if($item >= 0 && $item< 6)
                    {
                        return "early morning";
                    }
                    elseif($item >= 6 && $item< 12){
                        return "morning";
                    }
                    elseif($item >= 12 && $item< 18){
                        return "afternoon";
                    }
                    else{
                        return "evening";
                    }
                });
                return $item;
            });
           // dd($dates);
             $monthlyTimebeltCount =[];
            foreach($dates->toArray() as $key=>$date)
            {
                if($key)
                {
                    //array_count_values($date)[] = ['month'=>$key];
                    $monthlyTimebeltCount[] = [$key=>array_count_values($date)];
                   //$monthlyTimebeltCount[$key] = array_count_values($date);

                }
            }
            //dd($monthlyTimebeltCount);
            $response['data']['timebelt'] = ($monthlyTimebeltCount);
            $uniqueNumbers = $collection->pluck('number')->unique();
           // dd($uniqueNumbers);
            $uniqueNum = $uniqueNumbers->filter(function($item, $key){
                return collect(str_split($item))->unique()->count() < 5;              
            });
            //dd($uniqueNum);
             $dateNumberVanity = $collection->whereIn("number", $uniqueNum->toArray())->pluck('number','date'); 

             $_temp = [];
             $dateNumberVanity = $dateNumberVanity->toArray();
             foreach ($dateNumberVanity as $key => $item) {
                $_month = date("r",(int)$key/1000);
                // $_count = date("H",(int)$item/1000);
                 if (!isset($_temp[$item])) {
                     $_temp[$item] = [];
                 }
                 $_temp[$item][] = $_month;
             }
             $groupedDateNumberVanity =  collect($_temp);

            // $groupedDateNumberVanity = $dateNumberVanity->mapToGroups(function ($item, $key){
            //     return [$item=>date("r",(int)$key/1000)];
            // });
            //    dd($groupedDateNumberVanity);
            $frequencyDataVanity = $groupedDateNumberVanity->map(function ($item, $key) use($collection) {
                $name = $collection->where('number',$key)->pluck('cachedName')[0];
                return ['name'=>$name,'number'=>$key,'frequency'=>collect($item)->count(),'lastcalltime'=>Carbon::parse(collect($item)->max())->toDateTimeString()];
            });
            $frequencyDataVanity = $frequencyDataVanity->sortBy("frequency");
           ( $response['data']['frequent_vanity_calls'] =        
                $frequencyDataVanity->take(10)->toArray()
            );  
            //$a = country('ca');
           // dd($a->getCallingCodes());
            $namedOutgoingCalledNumbers = $collection->whereIn("type",["2",2])->where("cachedName",'!=',"")->pluck('number'); 
           // dd($outgoingData);
            $outgoingDateNumber = $collection->whereIn("type",["2",2])->where("cachedName",'!=',"")->pluck("number","date");

            $_temp = [];
            $outgoingDateNumber = $outgoingDateNumber->toArray();
            foreach ($outgoingDateNumber as $key => $item) {
               $_month = date("r",(int)$key/1000);
               // $_count = date("H",(int)$item/1000);
                if (!isset($_temp[$item])) {
                    $_temp[$item] = [];
                }
                $_temp[$item][] = $_month;
            }
            $groupedOutgoingDateNumber =  collect($_temp);

            // $groupedOutgoingDateNumber = $outgoingDateNumber->mapToGroups(function ($item, $key) {
            //     return [$item=>date("r",(int)$key/1000)];
            // });
            $groupedOutgoingDateNumber = $groupedOutgoingDateNumber->toArray();
            arsort($groupedOutgoingDateNumber);
            $groupedOutgoingDateNumber=collect($groupedOutgoingDateNumber);

            $_temp = [];
            $groupedOutgoingDateNumber = $groupedOutgoingDateNumber->toArray();
            foreach ($groupedOutgoingDateNumber as $key => $item) {
              // $_month = date("r",(int)$key/1000);
               // $_count = date("H",(int)$item/1000);
                if (!isset($_temp[$key])) {
                    $_temp[$key] = [];
                }
                $_temp[$key][] = $item;
            }
           // $lastOutgoingCallTime =  ($_temp);
            $newTemp = [];
            foreach($_temp as $key=>$value)
            {
                if (!isset($newTemp[$key])) {
                    $newTemp[$key] = [];
                }
                $newTemp[$key] = Carbon::parse(collect($value)->max())->toDateTimeString(); 
            }
            $lastOutgoingCallTime = collect($newTemp);
            // $lastOutgoingCallTime = $lastOutgoingCallTime->map(function ($item, $key) {
            //     return [$key=>Carbon::parse(collect($item)->max())->toDateTimeString()];
            // });

            // $lastOutgoingCallTime = $groupedOutgoingDateNumber->mapToGroups(function ($item, $key) {
            //     return [$key=>Carbon::parse(collect($item)->max())->toDateTimeString()];
            // });
            $lastOutgoingCallTime = $lastOutgoingCallTime->take(10);
            $namedOutgoingCalledNumbersFrequency = (array_count_values($namedOutgoingCalledNumbers->toArray()));
            arsort($namedOutgoingCalledNumbersFrequency);
            $namedOutgoingCalledNumbersFrequency = collect($namedOutgoingCalledNumbersFrequency);
            $namedOutgoingMostFrequentCalledNumbers = $namedOutgoingCalledNumbersFrequency->keys();
            $namedOutgoingTenMostFrequentCalledNumbers = $namedOutgoingMostFrequentCalledNumbers->filter(function ($item, $key) {
                return $key < 10;
            });
            $callDurationAndDate = $collection->pluck('duration','date');
            //dd($callDurationAndDate);        
            $_temp = [];
            $callDurationAndDate = $callDurationAndDate->toArray();
            foreach ($callDurationAndDate as $key => $item) {
               $_month = date("F",(int)$key/1000);
               // $_count = date("H",(int)$item/1000);
                if (!isset($_temp[$_month])) {
                    $_temp[$_month] = [];
                }
                $_temp[$_month][] = $item;
            }
            $grouped =  collect($_temp);  

            // $grouped = $callDurationAndDate->mapToGroups(function ($item, $key) {
            // // $start = 0;
            //     return [date("F",$key/1000)=>$item];
            // });
            $monthsGroups = $grouped->toArray();
            //dd($monthsGroups);
            foreach($monthsGroups as $key=>$monthGroup)
            {
                $totalDurationForMonths[$key] = array_sum($monthsGroups[$key]);
            }
            //dd($totalDurationForMonths);
            foreach($totalDurationForMonths as $key=>$totalDurationForMonth)
            {
                //$totalCallSpendForMonths[$key] = ($totalDurationForMonth * 10)/100;//$db
                $totalCallSpendForMonths[] = [$key=>(($totalDurationForMonth * 10)/100)];
            }  
            foreach($monthsGroups as $key=>$monthGroup)
            {
                $totDurationForMonths[] = [$key=>array_sum($monthsGroups[$key])];
            }        
            $response['data']['callspending']['callspending_per_month'] =  $totalCallSpendForMonths;
            $response['data']['call']['calltotal_per_month'] =  $totDurationForMonths;           
            $response['data']['outgoingcallednumbersnamed'] = [
                'mostfrequent'=>$namedOutgoingTenMostFrequentCalledNumbers->toArray(),       
                'frequency'=> $namedOutgoingCalledNumbersFrequency->take(10),
                'lastcalltime'=>$lastOutgoingCallTime->toArray()
            ];  
            // - 10 Most freq Called numbers nameless/Call freq/Last time of call
            $namelessCalledNumbers = $collection->where("cachedName","")->pluck('number');
            $namelessDateNumber = $collection->where("cachedName",'=',"")->pluck("number","date");

            $_temp = [];
            $namelessDateNumber = $namelessDateNumber->toArray();
            foreach ($namelessDateNumber as $key => $item) {
               $_month = date("r",(int)$key/1000);
               // $_count = date("H",(int)$item/1000);
                if (!isset($_temp[$item])) {
                    $_temp[$item] = [];
                }
                $_temp[$item][] = $_month;
            }
            $groupedNamelessDateNumber =  collect($_temp);

            // $groupedNamelessDateNumber = $namelessDateNumber->mapToGroups(function ($item, $key) {
            //     return [$item=>date("r",(int)$key/1000)];
            // });
            $groupedNamelessDateNumber = $groupedNamelessDateNumber->toArray();
            arsort($groupedNamelessDateNumber);
            $groupedNamelessDateNumber=collect($groupedNamelessDateNumber);

           
            $_temp = [];
            $groupedNamelessDateNumber = $groupedNamelessDateNumber->toArray();
           
            // foreach ($groupedNamelessDateNumber as $key => $item) {
            //   // $_month = date("r",(int)$key/1000);
            //    // $_count = date("H",(int)$item/1000);
            //     if (!isset($_temp[$key])) {
            //         $_temp[$key] = [];
            //     }
            //     $_temp[$key][] = $item;
            // }
           
           
           // $lastOutgoingCallTime =  ($_temp);
            $newTemp = [];
            foreach($groupedNamelessDateNumber as $key=>$value)
            {
                if (!isset($newTemp[$key])) {
                    $newTemp[$key] = [];
                }
                $newTemp[$key] = Carbon::parse(collect($value)->max())->toDateTimeString(); 
            }
            // var_dump($newTemp);
            // die();
            $lastNamelessCallTime = collect($newTemp);

            // $lastNamelessCallTime = $groupedNamelessDateNumber->mapToGroups(function ($item, $key) {
            //     return [$key=>Carbon::parse(collect($item)->max())->toDateTimeString()];
            // });

            $lastNamelessCallTime = $lastNamelessCallTime->take(10);
            $namelessCalledNumbersFrequency =(array_count_values($namelessCalledNumbers->toArray()));
            arsort($namelessCalledNumbersFrequency);
            $namelessCalledNumbersFrequency = collect($namelessCalledNumbersFrequency);
            $namelessMostFrequentCalledNumbers = $namelessCalledNumbersFrequency->keys();
            $namelessTenMostFrequentCalledNumbers = $namelessMostFrequentCalledNumbers->filter(function ($item, $key) {
                return $key < 10;
            });
            $response['data']['callednumbersnameless'] = ['mostfrequent'=>$namelessTenMostFrequentCalledNumbers,
                'frequency'=> $namelessCalledNumbersFrequency->take(10),
                'lastcalltime'=> $lastNamelessCallTime->toArray()
            ];
            // - 10 Most Frequently incoming Call /Call freq/Last time of call
            //get numbers of all incoming calls
            $incomingCalledNumbers = $collection->whereIn("type",["1",1])->pluck('number');
            //get dates and corresponding numbers of all incoming calls
            $incomingDateNumber = $collection->whereIn("type",["1",1])->pluck("number","date");
            //group dates and numbers according to their numbers
            $_temp = [];
            $incomingDateNumber = $incomingDateNumber->toArray();
            foreach ($incomingDateNumber as $key => $item) {
               $_month = date("r",(int)$key/1000);
               // $_count = date("H",(int)$item/1000);
                if (!isset($_temp[$item])) {
                    $_temp[$item] = [];
                }
                $_temp[$item][] = $_month;
            }
            $groupedIncomingDateNumber =  collect($_temp);
            
            // $groupedIncomingDateNumber = $incomingDateNumber->mapToGroups(function ($item, $key) {
            //     return [$item=>date("r",(int)$key/1000)];
            // });

            $groupedIncomingDateNumber = $groupedIncomingDateNumber->toArray();
            arsort($groupedIncomingDateNumber);//sort according to most frequent in a descending order
            //$groupedIncomingDateNumber=collect($groupedIncomingDateNumber);

            $_temp = [];
            //$groupedNamelessDateNumber = $groupedNamelessDateNumber->toArray();
            // foreach ($groupedIncomingDateNumber as $key => $item) {
            //   // $_month = date("r",(int)$key/1000);
            //    // $_count = date("H",(int)$item/1000);
            //     if (!isset($_temp[$key])) {
            //         $_temp[$key] = [];
            //     }
            //     $_temp[$key][] = $item;
            // }
           // $lastOutgoingCallTime =  ($_temp);
            $newTemp = [];
            foreach($groupedIncomingDateNumber as $key=>$value)
            {
                if (!isset($newTemp[$key])) {
                    $newTemp[$key] = [];
                }
                $newTemp[$key] = Carbon::parse(collect($value)->max())->toDateTimeString(); 
            }
            $lastIncomingCallTime = collect($newTemp);

            // $lastIncomingCallTime = $groupedIncomingDateNumber->mapToGroups(function ($item, $key) {
            //     return [$key=>Carbon::parse(collect($item)->max())->toDateTimeString()];//get the last time of call for a particular number
            // });
            $lastIncomingCallTime = $lastIncomingCallTime->take(10);//get 10 most frequent incoming calls
            //get the frequency of each incoming call
            $incomingCalledNumbersFrequency =(array_count_values($incomingCalledNumbers->toArray()));
            arsort($incomingCalledNumbersFrequency);//sort according to most frequent in a descending order
            $newest = [];
            foreach($incomingCalledNumbersFrequency as $key=>$value)
            {
                $newest[] = [$key=>$value];
            }
            $incomingCalledNumbersFrequency = collect($incomingCalledNumbersFrequency);
            $incomingMostFrequentCalledNumbers = $incomingCalledNumbersFrequency->keys();
            $incomingTenMostFrequentCalledNumbers = $incomingMostFrequentCalledNumbers->filter(function ($item, $key) {
                return $key < 10;//take only 10 numbers
            });
            $response['data']['incomingcallednumbers'] = ['mostfrequent'=>$incomingTenMostFrequentCalledNumbers,
                'frequency'=> $incomingCalledNumbersFrequency->take(10)->toArray(),
                'frequency_two'=>$newest,
                'lastcalltime'=> $lastIncomingCallTime->toArray()
            ]; 

            // - Freq Call Time Belt incoming
            $incomingCallDates = $collection->whereIn("type",["1",1])->pluck('date');
            $incomingCallDates = $incomingCallDates->map(function ($item, $key) {
                if(date("H",(int)$item/1000) >= 0 && date("H",(int)$item/1000)< 6){
                    return "early morning";
                }
                elseif(date("H",(int)$item/1000) >= 6 && date("H",(int)$item/1000)< 12){
                    return "morning";
                }
                elseif(date("H",(int)$item/1000) >= 12 && date("H",(int)$item/1000)< 18){
                    return "afternoon";
                }
                else{
                    return "evening";
                }
            });
            $response['data']['incomingfreqcalltimebelt'] = $incomingCallDates->mode();
            // - Freq Call Time Belt outgoing
            $outgoingCallDates = $collection->whereIn("type",["2",2])->pluck('date');
            $outgoingCallTimeBelts = $outgoingCallDates->map(function ($item, $key) {
                if(date("H",(int)$item/1000) >= 0 && date("H",(int)$item/1000)< 6){
                    return "early morning";
                }
                elseif(date("H",(int)$item/1000) >= 6 && date("H",(int)$item/1000)< 12){
                    return "morning";
                }
                elseif(date("H",(int)$item/1000) >= 12 && date("H",(int)$item/1000)< 18){
                    return "afternoon";
                }
                else{
                    return "evening";
                }
            });
            $response['data']['outgoingfreqcalltimebelt'] = $outgoingCallTimeBelts->mode();
            // - Percentage of Keywords calls (eg 25% named, 75% un named)
            $countOfCallsWithoutName = $collection->where("cachedName","")->count();
            $countOfCalls = $collection->count();
            $countOfCallsWithName = $collection->where("cachedName","!=","")->count();  
            $response['data']['percentageofkeywordcalls'] = ['namedcallspercentage'=>(($countOfCallsWithName/$countOfCalls) * 100),
                'unamedcallspercentage'=>(($countOfCallsWithoutName/$countOfCalls) * 100)
            ];

            $cachedNameList = $collection->where('cachedName',"!=","")->pluck('cachedName');
            // $cachedNameList->transform(function($item, $key){
            //     return ($item);//strtolower
            // });
            $risk_score= 0;
            $cachedNameListArray = $cachedNameList->toArray();  
            $landLordKeyword = ['landlord','land lord'];
            $doctorKeyword = ['doctor','dr','dr.','doc','doc.'];
            $betKeyword = ['bet','gamble','casino','club'];
            $embassyKeyword = ['embassy','airport'];
            $churchKeyword = ['pst','pst.','evang','prayer','pastor'];
            $churchKeywordsFound = $this->getFamilyKeywordsInCallLogs($cachedNameListArray,$churchKeyword,$c=[]);
            $churchKeywordsFoundCount = count($churchKeywordsFound);
            $church_risk =  $churchKeywordsFoundCount > 0 ? true :false;  
            if($church_risk == false)
            {
                $risk_score += 1;
            }  
            $landLordKeywordsFound = $this->getFamilyKeywordsInCallLogs($cachedNameListArray,$landLordKeyword,$l=[]);
            $landLordKeywordsFoundCount = count($landLordKeywordsFound);
            $landlord_risk =  $landLordKeywordsFoundCount > 0 ? true :false;
            if($landlord_risk == false)
            {
                $risk_score += 1;
            }
            $betKeywordsFound = $this->getFamilyKeywordsInCallLogs($cachedNameListArray,$betKeyword,$b=[]);
            
            $betKeywordsFoundCount = count($betKeywordsFound); 
            
            $bet_risk =  $betKeywordsFoundCount > 0 ? true :false;
            if($bet_risk == false)
            {
                $risk_score += 1;
            }
            $doctorKeywordsFound = $this->getFamilyKeywordsInCallLogs($cachedNameListArray, $doctorKeyword,$d=[]) ;
            $doctorKeywordsFoundCount = count($doctorKeywordsFound);
            $doctor_risk =  $doctorKeywordsFoundCount > 0 ? true :false;
            if($doctor_risk == false)
            {
                $risk_score += 1;
            }
            $risk_score = ($risk_score/4) * 100;
            // $risk = [ $church_risk, $landlord_risk, $bet_risk, $doctor_risk];
            // $riskCount = count($risk);
            // $risk = array_count_values($risk);
            //$risk_score = ($risk["true"]/$riskCount) * 100;
            $dateNumberLandLord = $collection->whereIn("cachedName",$landLordKeywordsFound)->pluck('number','date'); 
            //dd($landLordKeywordsFound);
            $_temp = [];
            $dateNumberLandLord = $dateNumberLandLord->toArray();
            foreach ($dateNumberLandLord as $key => $item) {
               $_month = date("r",(int)$key/1000);
               // $_count = date("H",(int)$item/1000);
                if (!isset($_temp[$item])) {
                    $_temp[$item] = [];
                }
                $_temp[$item][] = $_month;
            }
            $groupedDateNumberLandLord =  collect($_temp);

            // $groupedDateNumberLandLord = $dateNumberLandLord->mapToGroups(function ($item, $key) {
            //     return [$item=>date("r",(int)$key/1000)];
            // });
           // dd($groupedDateNumberLandLord);
            $frequencyDataLandLord = $groupedDateNumberLandLord->map(function ($item, $key) use($collection) {
                $name = $collection->where('number',$key)->pluck('cachedName')[0];
                return ['name'=>$name,'number'=>$key,'frequency'=>$item->count(),'lastcalltime'=>Carbon::parse(collect($item)->max())->toDateTimeString()];
            });
            $frequencyDataLandLord = $frequencyDataLandLord->sortBy("frequency");

            $dateNumberDoctor = $collection->whereIn("cachedName",$doctorKeywordsFound)->pluck('number','date'); 
            //dd($landLordKeywordsFound);
            $_temp = [];
            $dateNumberDoctor = $dateNumberDoctor->toArray();
            foreach ($dateNumberDoctor as $key => $item) {
               $_month = date("r",(int)$key/1000);
               // $_count = date("H",(int)$item/1000);
                if (!isset($_temp[$item])) {
                    $_temp[$item] = [];
                }
                $_temp[$item][] = $_month;
            }
            $groupedDateNumberDoctor =  collect($_temp);

            // $groupedDateNumberDoctor = $dateNumberDoctor->mapToGroups(function ($item, $key) {
            //     return [$item=>date("r",(int)$key/1000)];
            // });
           // dd($groupedDateNumberDoctor);
            $frequencyDataDoctor = $groupedDateNumberDoctor->map(function ($item, $key) use($collection) {
                $name = $collection->where('number',$key)->pluck('cachedName')[0];
                return ['name'=>$name,'number'=>$key,'frequency'=>$item->count(),'lastcalltime'=>Carbon::parse(collect($item)->max())->toDateTimeString()];
            });
            $frequencyDataDoctor = $frequencyDataDoctor->sortBy("frequency");
            $response['data']['otherkeysearches'] = [       
                'landlord'=>$frequencyDataLandLord->take(10)->toArray(),
                'doctor'=>$frequencyDataDoctor->take(10)->toArray()
            ];    

        $leaves_grade = [];
        //dd($collection);
          $cachedNameList = $collection->where('cachedName',"!=","")->pluck('cachedName');
            // $cachedNameList->transform(function($item, $key){
            //     return ($item);//strtolower
            // });
            $cachedNameListArray = $cachedNameList->toArray();  
        $externalNumbers = [];
        $countOfCalls = $collection->count();
        $allNumbers = $collection->pluck('number');
        foreach($allNumbers->toArray() as $number)
        {
            if(substr($number, 0, -(strlen($number)-1)) == "+" && 
            substr($number, 0, -(strlen($number)-4)) !="+234")
            {
                $externalNumbers[] = $number;
            }
        }
        $externalNumbersCount = count($externalNumbers);
        $callDurationAndDate = $collection->pluck('duration','date');

        //dd($callDurationAndDate);             
        // $grouped = $callDurationAndDate->mapToGroups(function ($item, $key) {
        // // $start = 0;
        //     return [date("F",$key/1000)=>$item];
        // });

		$_temp = [];
		$_callDate = $callDurationAndDate->toArray();
		foreach ($_callDate as $key => $_count) {
			$_month = date("F",$key/1000);
			if (!isset($_temp[$_month])) {
				$_temp[$_month] = [];
			}
			$_temp[$_month][] = $_count;
		}

        $monthsGroups = $_temp;
        //dd($monthsGroups);
        foreach($monthsGroups as $key=>$monthGroup)
        {
            $totalDurationForMonths[$key] = array_sum($monthsGroups[$key]);
        }
        //dd($totalDurationForMonths);
        foreach($totalDurationForMonths as $key=>$totalDurationForMonth)
        {
            //$totalCallSpendForMonths[$key] = ($totalDurationForMonth * 10)/100;//$db
            $totalCallSpendForMonths[] = [$key=>(($totalDurationForMonth * 10)/100)];
        }
        $total = 0;
      
            if($totalCallSpendForMonths != [])
            {
                $callSpendingPerMonth =  array_sum($totalCallSpendForMonths)/count($totalCallSpendForMonths);
            }
            if($totalCallSpendForMonths == [])
            {
                $leaves_grade[] = "failed"; 
            }
            else
            {
                $response['analytics']['callspending']['greaterthanx']['value'] =  $callSpendingPerMonth > $lender['PH_AN_MONTHLY_CALL'] 
                ?"true":"false";//$db  
                if(  $response['analytics']['callspending']['greaterthanx']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }  
                else
                {
                    $leaves_grade[] = "failed";
                } 
                   
            }
      

      
            if($totalCallSpendForMonths != [])
            {
                $callSpendingPerMonth =  array_sum($totalCallSpendForMonths)/count($totalCallSpendForMonths);
            }
            if($totalCallSpendForMonths == [])
            {
                $leaves_grade[] = "failed"; 
            }
            else
            {

                $response['analytics']['callspending']['withinmarketrangexandy']['value'] =  ($callSpendingPerMonth > $lender['PH_AN_MONTHLY_CALL_MARKET_AVG_MIN'] && $callSpendingPerMonth < $lender['PH_AN_MONTHLY_CALL_MARKET_AVG_MAX']) ?"true":"false";//$db  
                
                  if(  
                    $response['analytics']['callspending']['withinmarketrangexandy']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }  
                else
                {
                    $leaves_grade[] = "failed";
                } 
                        
                //     - Less than  {x%} of declared income
                // $callSpentPerMonthToDeclaredIncome =($callSpendingPerMonth/100) * 100;//$db
                // $response['analytics']['callspending']['lessthan_x_percent_ofdeclaredincome']['value'] =  ($callSpentPerMonthToDeclaredIncome <  $lender['PH_AN_PERCENTAGE_MONTHLY_CALL_TO_DECLARED_INCOME')) ?"true":"false";//$db        
                   
            }
       
       
            if($totalCallSpendForMonths != [])
            {
                $callSpendingPerMonth =  array_sum($totalCallSpendForMonths)/count($totalCallSpendForMonths);
            }
            if($totalCallSpendForMonths == [])
            {
                $leaves_grade[] = "failed"; 
            }
            else
            {     
                $data['NET_MONTHLY_INCOME'] = (is_null($data['NET_MONTHLY_INCOME'])||empty($data['NET_MONTHLY_INCOME']) ||$data['NET_MONTHLY_INCOME']<= 0) ? 1 :$data['NET_MONTHLY_INCOME'];
                    //- Less than  {x%} of declared income
                $callSpentPerMonthToDeclaredIncome =($callSpendingPerMonth/$data['NET_MONTHLY_INCOME']) * 100;//$db
                $response['analytics']['callspending']['lessthan_x_percent_ofdeclaredincome']['value'] =  ($callSpentPerMonthToDeclaredIncome <  $lender['PH_AN_PERCENTAGE_MONTHLY_CALL_TO_DECLARED_INCOME']) ?"true":"false";//$db
                if(  
                    $response['analytics']['callspending']['lessthan_x_percent_ofdeclaredincome']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }  
                else
                {
                    $leaves_grade[] = "failed";
                }         
                   
            }
      
        
            $outgoingCalledNumbersWithoutName = $collection->where("cachedName",'=',"")->pluck('number');
          
            $outgoingCalledNumbersWithoutNameCount = $outgoingCalledNumbersWithoutName->count();
            if($outgoingCalledNumbersWithoutName->toArray() != [])
            {
                //Percentage of nameless calls to total calls
                $percentageOfNamelessToTotal = ($outgoingCalledNumbersWithoutNameCount/$countOfCalls) * 100;
                $response['analytics']['namelesscalls']['namelesscalls_less_than_x_percent_oflogs'] = ($percentageOfNamelessToTotal < $lender['PH_AN_PERCENTAGE_NAMELESS_CALLS_TO_LOG']) ? "true" : "false";//$db
                if( $response['analytics']['namelesscalls']['namelesscalls_less_than_x_percent_oflogs'] == "true")
                {
                    $total++;
                    $leaves_grade [] = "passed";
                }  
                else
                {
                    $leaves_grade [] = "failed";
                }       
            }
            else
            {
                $leaves_grade [] = "failed";
            }
        
      
            if($externalNumbersCount == 0)
            {
                $leaves_grade[]= "passed";
            }
            else
            {
                $externalNumbersCollection = collect($externalNumbers);
                //  dd($externalNumbersCollection);
                $mostFrequentExternal = $externalNumbersCollection->mode()[0];

                $countriesNotAccepted = $lender['PH_AN_BLACKLISTED_EXTERNAL_COUNTRIES'];
                if($countriesNotAccepted == [])
                {
                    $blacklistedCountries = [];
                }
                else
                {
                    $countriesNotAcceptedISO = [];
                    $NotAcceptedISO = (new ISO3166);
                    foreach($countriesNotAccepted as $countryNotAccepted)
                    {
                        $countriesNotAcceptedISO[] = $NotAcceptedISO->name($countryNotAccepted)['alpha2'];
                    }
                    foreach($countriesNotAcceptedISO as $countryNotAcceptedISO)
                    {
                        if($countryNotAcceptedISO == PhoneNumber::parse($mostFrequentExternal)->getRegionCode())
                        {
                            $blacklistedCountries[] = "1";
                        }
                    }
                }

                $numbersAndDates = $collection->pluck('number','date');
                
                $response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value']= !(count($blacklistedCountries) > 0) ?"true":"false";//$db

                if($response['analytics']['frequentlyexternalcountry']['most_freq_not_to_a_blacklisted_country']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }
                else
                {
                    $leaves_grade[] = "failed";
                }                      
            }  
        
            if($externalNumbersCount == 0)
            {
                $leaves_grade[]= "failed";
            }
            else
            {
                $externalNumbersCollection = collect($externalNumbers);
                //  dd($externalNumbersCollection);
                $mostFrequentExternal = $externalNumbersCollection->mode()[0];

            
                $countriesAccepted = $lender['PH_AN_ACCEPTED_EXTERNAL_COUNTRIES'];
                if($countriesAccepted == [])
                {
                    $acceptedCountries = [];
                }
                else
                {

                    $countriesAccepted = $lender['PH_AN_ACCEPTED_EXTERNAL_COUNTRIES'];//$db
                    $AcceptedISO = (new ISO3166);
                    $countriesAcceptedISO = [];
                    foreach($countriesAccepted as $countryAccepted)
                    {
                        $countriesAcceptedISO[] = $AcceptedISO->name($countryAccepted)['alpha2'];
                    }
                   // dd($countriesAcceptedISO);
                    foreach($countriesAcceptedISO as $countryAcceptedISO)
                    {
                        if($countryAcceptedISO == PhoneNumber::parse($mostFrequentExternal)->getRegionCode())
                        {
                            $acceptedCountries[] = "1";
                        }
                    }
                }
 
                $numbersAndDates = $collection->pluck('number','date');
           
                $response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] = (count($acceptedCountries) > 0) ?"true":"false";//$db     
                if($response['analytics']['frequentlyexternalcountry']['most_freq_to_accepted_foreign_country']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";

                }  
                else
                {
                    $leaves_grade[] = "failed";
                }  
           
            }  
       
            if($externalNumbersCount == 0)
            {
                $leaves_grade[]= "failed";
            }
            else
            {
                $externalNumbersCollection = collect($externalNumbers);
                //  dd($externalNumbersCollection);
                $mostFrequentExternal = $externalNumbersCollection->mode()[0];

           
                $numbersAndDates = $collection->pluck('number','date');
               
                //newly implemented because of laravel 5.2 maptogroups issue
                $numbersAndDates =  $numbersAndDates->toArray();
                $temporal = [];
                foreach ($numbersAndDates as $key=>$numberAndDate) {
                	$singlemonth = date("F",$key/1000);
                	if(!isset($temporal[$singlemonth]))
                	{
                		$temporal[$singlemonth] = [];
                	}
                	if(substr($item, 0, -(strlen($item)-1)) == "+" && 
                    substr($item, 0, -(strlen($item)-4)) !="+234" )
                	{
                		$temporal[$singlemonth][] = $numberAndDate;
                	}
                	$temporal[$singlemonth] = [];
                }

                 $groupedExternalCountries =  collect($temporal);

                $groupedExternalCountries->transform(function($item,$key){
                    return collect($item)->count();
                });
                $externalCallFrequency = $groupedExternalCountries->avg();
                $externalCallToTotal = ($externalCallFrequency/$allNumbers->count()) * 100;


                $response['analytics']['frequentlyexternalcountry']['greaterthan_x_percent_per_monthoftotal']['value'] = $externalCallToTotal > $lender['PH_AN_PERCENTAGE_MONTHLY_EXTERNAL_COUNTRY_TO_TOTAL'] ?"true":"false";

                if( $response['analytics']['frequentlyexternalcountry']['greaterthan_x_percent_per_monthoftotal']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";

                }  
                else
                {
                    $leaves_grade[] = "failed";
                }  
                
            }  
       
            $callDates = $collection->pluck('date');
            $callDatesCount = $callDates->count();
            $callDates = $callDates->map(function ($item, $key) {
                if(date("H",(int)$item/1000) >= 0 && date("H",(int)$item/1000)< 6){
                    return "early morning";
                }
                elseif(date("H",(int)$item/1000) >= 6 && date("H",(int)$item/1000)< 12){
                    return "morning";
                }
                elseif(date("H",(int)$item/1000) >= 12 && date("H",(int)$item/1000)< 18){
                    return "afternoon";
                }
                else{
                    return "evening";
                }
            });
            if($callDatesCount = 0)
            {
                $leaves_grade[] = "failed";
            }
            else
            {
                $response['analytics']['freqCallTimeBelt']['Notbetweenspecifictimebelts'] = !($callDates->mode()[0] == $lender['PH_AN_REJECTED_FREQUENT_CALL_TIME_BELT']) ? "true":"false";//$db
                
                if( $response['analytics']['freqCallTimeBelt']['Notbetweenspecifictimebelts'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }
                else
                {
                    $leaves_grade[] = "failed";
                }             
            }
       
            $name = strtok($data['LEGAL_NAME'], " ");
            $familyTitles = ['mum', 'dad','daddy','mummy','mom','pops','papa','mama','mumcy','popsi','mami','pastor',$name];//add any body 
            //$cachedNameListArray =$cachedNameList->toArray();  
            
            $familyKeywordsFound = $this->getFamilyKeywordsInCallLogs($cachedNameListArray, $familyTitles,$v=[]) ;
            $familyKeywordsFoundCount = count($familyKeywordsFound);
            if($familyKeywordsFoundCount > 0)
            {
                $ownership_score += 1;
            }
            //dd($familyKeywordsFoundCount);
            if($familyKeywordsFoundCount == 0)
            {
               $leaves_grade[] = "failed";  
            }
            else
            {
                $response['analytics']['keywordsinname']['familykeywordsfound']['value'] = ($familyKeywordsFoundCount > 0 )?"true":"false";   //$db
                $response['analytics']['keywordsinname']['familykeywordsfound']['score'] = ($response['analytics']['keywordsinname']['familykeywordsfound']['value'] == "true") ? 1 : 0;
                if( $response['analytics']['keywordsinname']['familykeywordsfound']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";  
                }
                else
                {
                    $leaves_grade[] = "failed";
                }
               
            }
        
			//customer.BORROWER_NAME')
            $name = strtok($data['LEGAL_NAME'], " ");
            $familyTitles = ['mum', 'dad','daddy','mummy','mom','pops','papa','mama','mumcy','popsi','mami','pastor',$name];//add any body 
            //$cachedNameListArray =$cachedNameList->toArray();  
            $familyKeywordsFound = $this->getFamilyKeywordsInCallLogs($cachedNameListArray, $familyTitles,$v=[]) ;
            $familyKeywordsFoundCount = count($familyKeywordsFound);
            //dd($familyKeywordsFoundCount);
            if($familyKeywordsFoundCount == 0)
            {
               $leaves_grade[] = "failed";  
            }
            else
            {
             
                $percentageOfFamilyKeywords = ($familyKeywordsFoundCount/$countOfCalls) * 100;
                //dd($percentageOfFamilyKeywords);  
                $response['analytics']['keywordsinname']['Keywordscall_greater_than_x_percent_oftotal']['value'] = ($percentageOfFamilyKeywords > $lender['PH_AN_PERCENTAGE_OF_FAMILY_KEY_WORD_TO_TOTAL'])?"true":"false";//$db 

                if( $response['analytics']['keywordsinname']['Keywordscall_greater_than_x_percent_oftotal']['value'] == "true")
                {
                    $total++;
                    $leaves_grade[] = "passed";
                }
                else
                {
                    $leaves_grade[] = "failed";
                }
            }
        
            $allNumbers = $collection->pluck('number');
            $uniqueNumbers = $allNumbers->unique();
            $uniqueNum = $uniqueNumbers->filter(function($item, $key){
                return collect(str_split($item))->unique()->count() < 5;              
            });
            if($allNumbers->toArray() != [])
            {
                $response['analytics']['uniquenumbercount']['uniquenumber_greater_than_x'] = ($uniqueNum->count() > $lender['PH_AN_VANITY_NUMBER_COUNT'])? "true" : "false"; //$db  
                if( $response['analytics']['uniquenumbercount']['uniquenumber_greater_than_x'] == "true")
                {
                    $total++;
                    $leaves_grade [] = "passed";
                } 
                else
                {
                    $leaves_grade[] = "failed";
                }  
               
            }
            else
            {
                $leaves_grade [] = "failed";
            }
            //highlights
           
            if($totalCallSpendForMonths == [])
            {
                $callSpentPerMonthToDeclaredIncome = 100;
                //$callSpentPerMonthToDeclaredIncome = 100;
            }
            else
            {     
                $data['NET_MONTHLY_INCOME'] = (is_null($data['NET_MONTHLY_INCOME'])||empty($data['NET_MONTHLY_INCOME']) ||$data['NET_MONTHLY_INCOME']<= 0) ? 1 :$data['NET_MONTHLY_INCOME'];
           
                $callSpentPerMonthToDeclaredIncome =($callSpendingPerMonth/$data['NET_MONTHLY_INCOME']) * 100;//$db
                
           //$db                  
            }
            if($callSpentPerMonthToDeclaredIncome < 20)
            {
                $reliability_score += 1;
            }

            $reliability_score = ($reliability_score/2) * 100;
            $ownership_score = ($ownership_score/3) *100;
            $response['data']['highlights'] = [
                "consistency_score"=> $consistency_score,
                "activeness_score"=> $activeness_score,
                "ownership_score"=> $ownership_score,
                "reliability_score"=> $reliability_score,
                 "risk_score"=> $risk_score,
                
               


            ];
       
        $result = ["data"=>$response,"total"=>$total,"leaves_grades"=>$leaves_grade];
		return $result;
      
    }
 

    public function getFamilyKeywordsInCallLogs(array $cachedNames, array $familyKeywords, array $familyKeywordsAvailable=[]) 
    {
        foreach($familyKeywords as $familyKeyword) {
            foreach($cachedNames as $cachedName)
            {
                if (stripos($cachedName,$familyKeyword) !== false) 
                {
                    $familyKeywordsAvailable[] = $cachedName; 
                }
            }
        }
        return $familyKeywordsAvailable;
    }
    public function endpointsForTope(Request $request)
    {   
        $loan_request_id = $request->loan_request_id;
        $borrower_id = DB::table('loan_request')->select('PEOPLE_ID')->where('REQUEST_ID',$loan_request_id)->get()[0]->PEOPLE_ID;
        $addresses = DB::table('people_customers')->select('WORK_ADDRESS','HOME_ADDRESS')->where('PEOPLE_ID',$borrower_id)->get()[0];
        $collection = DB::table('loan_request')->select('USER_CALL_LOGS')->where('REQUEST_ID',$loan_request_id)->get()[0];
      
        $collection = json_decode($collection->USER_CALL_LOGS);

        $dateNumberNameless = collect($collection)->pluck('number'); 
      

		//$_temp = [];
        //$dateNumberNameless = $dateNumberNameless->toArray();
        $numbers = [];
        $response['frequent_nameless_calls'] = (array_count_values($dateNumberNameless->toArray())); 
        arsort($response['frequent_nameless_calls']);
        $response['frequent_nameless_calls'] = collect(($response['frequent_nameless_calls']))->take(10)->toArray();
        foreach($response['frequent_nameless_calls'] as $key=>$value) 
        {
            $numbers[] = $key;
        }
        $response['frequent_nameless_calls'] = $numbers;
        $response['adresses']['home_address'] =  $addresses->HOME_ADDRESS; 
        $response['adresses']['office_address'] =  $addresses->WORK_ADDRESS;
        

        // 	foreach ($dateNumberNameless as $key => $_count) {
        // 		//$_month = date("r",$key/1000);
        // 		if (!isset($_temp[$_month])) {
        // 			$_temp[$_month] = [];
        // 		}
        // 		$_temp[$_month][] = $_count;
        //     }
        //    // var_dump($dateNumberNameless);

        //     $groupedDateNumberNameless = $_temp;
        //     // var_dump($groupedDateNumberNameless);
        //     $groupedDateNumberNameless = collect($groupedDateNumberNameless);
            
        //     // $groupedDateNumberNameless = $dateNumberNameless->mapToGroups(function ($item, $key) use($collection) {
        //     //     return [$item=>date("r",(int)$key/1000)];
        //     // });
        //     //var_dump($groupedDateNumberNameless);
        //     $frequencyDataNameless = $groupedDateNumberNameless->map(function ($item, $key) use($collection) {
        //         //$name = $collection->where('number',$key)->pluck('cachedName')[0];
        //         return ['number'=>$item[0],'frequency'=>collect($item)->count()];
        //     });
            
        //     $frequencyDataNameless = $frequencyDataNameless->sortBy("frequency");
        // dd($frequencyDataNameless->toArray());
        // $response['frequent_nameless_calls'] = array_values($frequencyDataNameless->take(10)->toArray());  
            // $dates = collect($collection)->pluck('date');

            // $dates = $dates->mapToGroups(function ($item, $key) {
            //     return [date("F",(int)$item/1000)=>date("H",(int)$item/1000)];
            // });
        return json_encode(['result'=>($response)]);
    }


}
