<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\User;

class AuthController extends Controller
{
    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth:api', ['except' => ['login','test']]);
        $this->middleware('auth:api', ['except' => ['login','signup']]);
    }

    /**
     * Get a JWT token via given credentials.
     *
     * @param  \Illuminate\Http\Request  $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function login(Request $request)
    {
        //return "hotr";
        $credentials = $request->only('email', 'password');
        if ($token = $this->guard()->attempt($credentials)) {
            return $this->respondWithToken($token);
        }
        return response()->json(['error' => 'Unauthorized'], 401);

        // $rules = [
        //     'email'=>'required|email',
        //     'password'=>'required'
        // ];
        // $this->validate($request, $rules);
        
        // $credentials = request(['email', 'password']);
        // $email = Aameuser::where('email', $request->email)->first();
        // if(!$email)
        // {
        //     return $this->errorResponse("The email address that you've entered doesn't match any account!",401);
        // }
        // if($email)
        // {
        //     // if(!$aameUser)
        //     // {
        //     //     return $this->errorResponse('Incorrect Password!',401);
        //     // }
        //     if (!$token = auth()->attempt($credentials)) {
        //         return $this->errorResponse("The password entered doesn't match the specified email address!", 401);
        //     }
        //     return $this->respondWithToken($token);
        // }
    }
    public function signup(Request $request)
    {
        //return "hi";
        $rules = [
            'name'=>'required', 'address'=>'required','email'=>'required',
            'phone'=>'required', 'interest_rate'=>'required', 'interest_type'=>'required',
        ];
        $this->validate($request, $rules);
         
    }

    public function adminLogin(Request $request)
    {

        $credentials = $request->only('email', 'password');

        if ($token = $this->guard()->attempt($credentials)) {
            return $this->respondWithToken($token);
        }

        return response()->json(['error' => 'Unauthorized'], 401);

        // $rules = [
        //     'email'=>'required|email',
        //     'password'=>'required'
        // ];
        // $this->validate($request, $rules);
        
        // $credentials = request(['email', 'password']);
        // $email = Aameuser::where('email', $request->email)->first();
        // if(!$email)
        // {
        //     return $this->errorResponse("The email address that you've entered doesn't match any account!",401);
        // }
        // if($email)
        // {
        //     // if(!$aameUser)
        //     // {
        //     //     return $this->errorResponse('Incorrect Password!',401);
        //     // }
        //     if (!$token = auth()->attempt($credentials)) {
        //         return $this->errorResponse("The password entered doesn't match the specified email address!", 401);
        //     }
        //     return $this->respondWithToken($token);
        // }
    }
    /**
     * Get the authenticated User
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function me()
    {
       
        // if(!$this->guard()->user())
        // {
        //     return "howfar";       
        //  }

        return response()->json($this->guard()->user());
    }

    /**
     * Log the user out (Invalidate the token)
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function logout()
    {
        $this->guard()->logout();

        return response()->json(['message' => 'Successfully logged out']);
    }

    /**
     * Refresh a token.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function refresh()
    {
        return $this->respondWithToken($this->guard()->refresh());
    }

    /**
     * Get the token array structure.
     *
     * @param  string $token
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'user' => $this->guard()->user(),
            'expires_in' => $this->guard()->factory()->getTTL() * 60
        ]);
    }

    /**
     * Get the guard to be used during authentication.
     *
     * @return \Illuminate\Contracts\Auth\Guard
     */
    public function guard()
    {
        return Auth::guard('api');
    }

    public function adminMe()
    {
        return $this->guard()->user()->id;
    }
    public function test()
    {
        // $password = 'password';
        // $pass = bcrypt($password);
        // User::where('password', 'password')
        // ->update(['password' => $pass]);
        // return "done";
        $password = 'kachi';
        $password = bcrypt($password);
        DB::table('AAME')->insert(
            ['Name' => 'kachi','HospitalName' => 'kachi hospital','Addy' => '13 makoroko','Place'=>'Nigeria','Mobile'=>'08192991921','IsActive'=>true,'password'=>$password,'EMail' => 'onyedikachierugo@gmail.com']
        );
    }
}
