<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Dompdf\Dompdf;

use App\Http\Requests;
use Lcobucci\JWT\Parser;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class AccountsController extends Controller
{
    public function getPDF(Request $request)
    {
        // instantiate and use the dompdf class
        $dompdf = new Dompdf();
        $html = $request->html; 
        
        $dompdf->loadHtml($html);

        // (Optional) Setup the paper size and orientation
        $dompdf->setPaper('A4', 'landscape');

        // Render the HTML as PDF
        $dompdf->render();

        // Output the generated PDF to Browser
        return $dompdf->stream();

    }
    public function testPDF(Request $request)
    {
        // instantiate and use the dompdf class
        $dompdf = new Dompdf();
        $html = $request->html; 
        
        $dompdf->loadHtml($html);

        // (Optional) Setup the paper size and orientation
        $dompdf->setPaper('A4', 'landscape');

        // Render the HTML as PDF
        $dompdf->render();

        // Output the generated PDF to Browser
        return $dompdf->stream();

    }
    public function getCustomersWithBookedLoans(Request $request)
    {   
        $token = $request->token;
        $lender_id = $this->getToken($token); 
        $search_name = $request->search_name;
        $request_ids = DB::table('loan_request')->select('REQUEST_ID')->get(); 
        $all_request_ids = [];
        foreach($request_ids as $id)
        {
            $all_request_ids[] = $id->REQUEST_ID;
        }
        $people_with_booked_loans =  DB::table('people_customers as p')->join('customer_accounts as c','c.CUSTOMER_ID','=','p.PEOPLE_ID')->join('loan_request as l','l.PEOPLE_ID','=','p.PEOPLE_ID')->select('c.GL_ACCOUNT_ID','p.PEOPLE_ID','p.LEGAL_NAME')->where('p.LEGAL_NAME','like',"%$search_name%")->where('c.ACCOUNT_TYPE',3)->where('p.LENDER_ID',$lender_id)->whereIn('l.REQUEST_ID',$all_request_ids)->where('l.BOOKED',1)->groupBy('p.PEOPLE_ID')->get();
        return json_encode(['people_with_booked_loans'=>$people_with_booked_loans,'status'=>true]);  
    }
    public function getLoansForCustomer(Request $request)
    {   
        $token = $request->token;
        $lender_id = $this->getToken($token); 
        $customer_id = $request->customer_id;
        $customer_loans = DB::table('loan_request')->select('REQUEST_ID','REQUEST_PRINCIPAL','LOAN_ID')->where('PEOPLE_ID', $customer_id)->where('BOOKED', 1)->where('lender_id',$lender_id)->get(); 
        // $all_request_ids = [];
        // foreach($request_ids as $id)
        // {
        //     $all_request_ids[] = $id->REQUEST_ID;
        // }
        // $people_with_booked_loans =  DB::table('people_customers as p')->join('loan_request as l','l.PEOPLE_ID','=','p.PEOPLE_ID')->select('p.PEOPLE_iD','LEGAL_NAME')->whereIn('l.REQUEST_ID',$all_request_ids)->where('l.BOOKED',1)->get();
        return json_encode(['customer_loans'=>$customer_loans,'status'=>true]);  
    }
    public function displayLocalAccounts(Request $request)
    {   
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $pagenumber = $request->pagenumber;
        $next = $request->next;
        $end = "";
        if($next === true)
        {
         //    return "true";
             $pagenumber = $pagenumber + 1;
        }
        if($next === false)
        {
             // return "false";
             $pagenumber = $pagenumber - 1;
        }
        $pagenumber =($pagenumber <= 0) ? 1 : $pagenumber;
        if($pagenumber == 1)
        {
            $end = false;
        }
       
        $selected_lender_accountsmaster =  DB::table('lender_accounts')->select('ACCOUNT_ID','GL_NAME as NAME')->where('IS_LOAN_PRODUCT','!=',1)->where('LENDER_ID',$lender_id)->get();
		 
        $selected_lender_accounts = collect($selected_lender_accountsmaster)->forPage($pagenumber,20)->toArray();      
        $selected_lender_accounts = array_values($selected_lender_accounts);
        $selected_lender_accountsNext = collect($selected_lender_accountsmaster)->forPage($pagenumber+1,20)->toArray();
        $selected_lender_accountsNext = array_values($selected_lender_accountsNext);
        if(!empty($selected_lender_accounts) && empty($selected_lender_accountsNext))
        {
            $end = true;
        }
        if(empty($selected_lender_accounts))
        {
            $selected_lender_accounts = collect($selected_lender_accounts)->forPage($pagenumber-1,20)->toArray();
            $selected_lender_accounts = array_values($selected_lender_accounts);
        } 
       return json_encode(['selected_accounts'=> $selected_lender_accounts,'end'=>$end,'status'=>true]);
  
    }
    public function displayGlobalAccounts(Request $request)
    {   
        // $token = $request->token;
        // $lender_id = $this->getToken($token);
        $selected_lender_accounts =  DB::table('new_global_accounts')->select('*')->get();
        foreach($selected_lender_accounts as $account)
        {
            $account->ischecked = false;
        }
       return json_encode(['global_accounts'=> $selected_lender_accounts]);
  
    }
    public function addNewAccounts(Request $request)
    {   
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $account_id = $request->account_id;
        $name = $request->name;
    
        $new_selected_accounts = [];
      
        $global_account = DB::table('new_global_accounts')->select('*')->where('ACCOUNT_ID', $account_id)->get();
        if(!empty($global_account))
        {
            $global_account = json_decode(json_encode($global_account[0]),true);
            unset($global_account['ACCOUNT_ID']);
            $global_account['GL_NAME'] = $name;
            $global_account['LENDER_ID'] = $lender_id;
            $global_account['DATE_ADDED'] = Carbon::now();
            $global_account['ADDED_BY'] =  $user_id;

            $added_account = DB::table('lender_accounts')->insertGetId(
                $global_account
            );
            if(!empty($added_account))
            {
                return json_encode(['response'=>"account was added successfully",'status'=>true]);
            }
            else
            {
                return json_encode(['response'=>"account could not be added",'status'=>false]);
            }
        }
        else
        {
            return json_encode(['response'=>"account was not correctly specified",'status'=>false]);
        }
            
        //    $new_selected_accounts['GL_NAME'] = $name; 
        //    $new_selected_accounts['GL_TYPE'] = $global_account[0]->GL_TYPE;
        //    $new_selected_accounts['GL_PARENT'] = $global_account[0]->GL_PARENT; 
        //    $new_selected_accounts['GL_CATEGORY'] = $global_account[0]->GL_CATEGORY;  
        //    $new_selected_accounts['GL_CODE'] = $global_account[0]->GL_CODE; 

        //    $new_selected_accounts['LENDER_ID'] = $lender_id;
        //    $new_selected_accounts['DATE_ADDED'] = Carbon::now();
        //    $new_selected_accounts['ADDED_BY'] =  $user_id;
        
        // if(!empty($new_selected_accounts))
        // {
        //     $added_account = DB::table('lender_accounts')->insertGetId(
        //         $new_selected_accounts
        //     );
        //     if(!empty($added_account))
        //     {
        //         return json_encode(['response'=>"account was added successfully",'status'=>true]);
        //     }
        //     else
        //     {
        //         return json_encode(['response'=>"account could not be added",'status'=>false]);
        //     }
        // }
     
    }


    public function editSelectedAccounts(Request $request)
    {   
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $account_id = $request->account_id;
        $local_name_change = DB::table('lender_accounts')->where('LENDER_ID', $lender_id)->where('ACCOUNT_ID',$account_id)->update([
            'GL_NAME'=>$request->NEW_NAME
        ]);
        //$new_selected_accounts = [];
        if($local_name_change == 1)
        {
            return json_encode(['response'=>"account name has been changed succesfully",'status'=>true]);   
        }
        else
        {
            return json_encode(['response'=>"change of account name  was not successful",'status'=>false]);
        }
    }
    public function createChartOfAccount(Request $request)
    {   
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $last_gl_code = DB::select("select MAX(GL_CODE) as GL_CODE from lender_accounts where lender_id=$lender_id");
        $last_gl_code = !empty($last_gl_code[0]->GL_CODE) ? $last_gl_code[0]->GL_CODE : 0;
        $last_gl_code = $last_gl_code + 1;
        $newAccount = DB::table('lender_accounts')->insert([
            'GL_CODE'=> $last_gl_code,
            'GL_PARENT'=>$request->GL_PARENT,
            'GL_TYPE'=>$request->GL_TYPE,
            'GL_NAME'=> $request->GL_NAME,
            'GL_CURRENCY_CODE'=> $request->GL_CURRENCY_CODE,
            'GL_CATEGORY'=> $request->GL_CATEGORY,
            'LENDER_ID'=> $lender_id,
            'ADDED_BY'=> $user_id,
            'DATE_ADDED'=> Carbon::now(),
        ]);
        if($newAccount == 1)
        {
            return json_encode(['response'=>"account created successfully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"account creation was not successful",'status'=>false]);
        }
    }

    public function readChartOfAccount(Request $request)
    {

        $token = $request->token;
        $lender_id = $this->getToken($token);
        $pagenumber = $request->pagenumber;
        $next = $request->next;
        $end = "unavailable";
        if($next === true)
        {
         //    return "true";
             $pagenumber = $pagenumber + 1;
        }
        if($next === false)
        {
             // return "false";
             $pagenumber = $pagenumber - 1;
        }
 
        $pagenumber =($pagenumber <= 0) ? 1 : $pagenumber;
        if($pagenumber == 1)
        {
            $end = false;
        }
 
        $readChart = DB::table('lender_accounts')->select('GL_CODE','GL_NAME','GL_CURRENCY_CODE','GL_CATEGORY')->where('LENDER_ID',$lender_id)->get();

        $readChart = collect($readChart)->forPage($pagenumber,20)->toArray();
        $readChart = array_values($readChart);

        $readChartNext = collect($readChart)->forPage($pagenumber+1,20)->toArray();
        $readChartNext = array_values($readChartNext);

        if(!empty($readChart) && empty($readChartNext))
        {
            $end = true;
        }
        if(empty($readChart))
        {
            $readChart = collect($readChart)->forPage($pagenumber-1,20)->toArray();
            $readChart = array_values($readChart);
        } 

        return json_encode(['chart'=>$readChart,'end'=>$end,'status'=>true]);
    }

    public function updateChartOfAccount(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $chartaccount_id = $request->chartaccount_id;
        $newAccount = DB::table('lender_accounts')->where('ACCOUNT_ID',$chartaccount_id)->update([
            //'GL_CODE'=> $last_gl_code,
            'GL_PARENT'=>$request->GL_PARENT,
            'GL_TYPE'=>$request->GL_TYPE,
            'GL_NAME'=> $request->GL_NAME,
            'GL_CURRENCY_CODE'=> $request->GL_CURRENCY_CODE,
            'GL_CATEGORY'=> $request->GL_CATEGORY,
            //'LENDER_ID'=> $lender_id,
            //'ADDED_BY'=> $user_id,
            'DATE_MODIFIED'=> Carbon::now(),
        ]);
        if($newAccount == 1)
        {
            return json_encode(['response'=>"account updated successfully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"account was not updated successful",'status'=>false]);
        }
    }

    public function deleteChartOfAccount(Request $request)
    {   
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $chartaccount_id = $request->chartaccount_id;
        $delete_count = DB::table('lender_accounts')->where('LENDER_ID',$lender_id)->where('ACCOUNT_ID',$chartaccount_id)->delete();

        if($delete_count == 1)
        {
            return json_encode(['response'=>"chart of account deleted succefully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"chart of account was not deleted ",'status'=>false]);
        } 

    }
    public function getToken($token)
    {
        $parser = new Parser;
        $parsedToken = $parser->parse($token);
        $lender_id = $parsedToken->getClaims()['lender_id'];   
        return $lender_id;  
    }
    public function getUserId($token)
    {
        $parser = new Parser;
        $parsedToken = $parser->parse($token);
        $user_id = $parsedToken->getClaims()['id'];   
        return $user_id;  
    }
    public function displayAccounts(Request $request)
    {
        // $token = $request->token;
        // $parser = new Parser;
        // $parsedToken = $parser->parse($token);
        // $lender_id = $parsedToken->getClaims()['lender_id'];   
        $token = $request->token;
       // return $token;
        $lender_id = $this->getToken($token);  
        $all_accounts =  DB::table('lender_accounts')->select('ACCOUNT_ID as id','GL_NAME as account_name')->where('lender_id',$lender_id)->where('IS_LOAN_PRODUCT','!=',1)->get();
        return json_encode(["all_accounts"=>$all_accounts]);
    }

    public function saveJournal(Request $request)
    {
        
        $token = $request->token; 
       // return $token;       
        //return $request->token; 
        $transactions = $request->transactions;
        $journal = $request->journal;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);

       
        $journal = json_decode(json_encode($request->journal));
        // return $journal;
       
        $journal = [
            'journal_entry_id'=>$journal->JOURNAL_ENTRY_ID,
            //'USE_AS_SUB'=>$journal->USE_AS_SUB,
            'journal_date'=>$journal->DATE_ADDED,
            'journal_narration'=>$journal->NARRATION,
            'TOTAL_DEBIT'=>$journal->TOTAL_DEBIT,
            'TOTAL_CREDIT'=>$journal->TOTAL_CREDIT,
        ];
        $total_credit = 0;
        $total_debit = 0;
        $transaction_array = [];
        $transactions = json_decode(json_encode($request->transactions));
       
        //return 
        if($journal['TOTAL_DEBIT'] == $journal['TOTAL_CREDIT'])
        {
            $journal_entry_id = DB::table('journal')->insertGetId([
                'NARRATIVE'=>  $journal['journal_narration'],
                'DATE_CREATED'=> Carbon::now(),
                // 'DATE_MODIFIED'=> NULL,
                'LENDER_ID'=> $lender_id, //no
                'ADDED_BY'=>  $user_id,//no
                'JOURNAL_DATE'=>  $journal['journal_date'],
                //'BATCH_ID'=> $new_batch_id,
                //'SOURCE'=>  $journal['journal_date'],
                'IS_APPROVED'=>  0,
                // 'APPROVED_BY'=>  $journal['journal_date'],
                // 'DATE_APPROVED'=>  $journal['journal_narration'], 
                //  'LOAN_ID'=>  !empty($journal->LOAN_ID) ? $journal->LOAN_ID :NULL ,  
                // 'IS_INITIAL_OFFERING'=>  $journal['journal_narration'], 
                // 'SINGLE_SCHEDULE'=>  $journal['journal_date'], 
                // 'SCHEDULE_PERIOD'=>  $journal['journal_narration'], 
                // 'JOURNAL_REF'=>  $journal['journal_date'], 
                // 'EDITABLE'=>  $journal['journal_narration'], 
                // 'REJECT_REASON'=>  $journal['journal_date'], 
                // 'REJECT_TO_LEVEL'=>  $journal['journal_narration'], 
                // 'REJECT_NOTES'=>  $journal['journal_date'], 
                // 'HOW_MUCH_WAS_GIVEN'=>  $journal['journal_narration'], 
                // 'DRAWDOWN'=>  $journal['journal_date'], 
                // 'IS_TOP_UP'=>  $journal['journal_narration'], 
                // 'TOP_UP_AMOUNT'=>  $journal['journal_date'], 
                // 'SCHEDULE_TO_BE_CLEARED'=>  $journal['journal_narration'], 
                // 'CURRENT_IMPAIRMENT'=>  $journal['journal_date'], 
                // 'CURRENT_IMPAIRMENT_'=>  $journal['journal_narration'], 
                // 'IS_TREATED'=>  $journal['journal_date'], 
                'TOTAL_DEBIT'=>  $journal['TOTAL_DEBIT'], 
                'TOTAL_CREDIT'=>  $journal['TOTAL_CREDIT'], 
                //  'USE_AS_SUB'=>  $journal['USE_AS_SUB'], 
                // 'LOAN_REPAYMENT_ID'=>  $journal['journal_date'], 
                // 'PEOPLE_ID'=>  $journal['journal_narration'], 
                // 'CHECK_LOAN_BALANCE'=>  $journal['journal_date'],
            ]);
            
            DB::table('journal')->where('JOURNAL_ENTRY_ID',$journal_entry_id)->where('LENDER_ID',$lender_id)->update([
              
                'BATCH_ID'=> $journal_entry_id,
            ]);
            
            foreach($transactions as $key=>$transaction)
            {
                // if($transaction->TTYPE == 1)
                // {
                //     $total_debit += (int)$transaction->AMOUNT;
                // }
                // if($transaction->TTYPE == 2)
                // {
                //     $total_credit += (int)$transaction->AMOUNT_;
                // }       
                $transaction_array[$key]['DEBIT'] = $transaction->DEBIT;
                $transaction_array[$key]['CREDIT'] = $transaction->CREDIT;
                $transaction_array[$key]['DATE_ADDED'] = $transaction->DATE_ADDED;
                $transaction_array[$key]['ACCOUNT_ID'] = $transaction->ACCOUNT_ID;
                $transaction_array[$key]['TRANSACTION_CODE'] = str_random(40);
                $transaction_array[$key]['IFN'] = $transaction->IFN;
                $transaction_array[$key]['LENDER_ID'] = $lender_id;
                $transaction_array[$key]['DATE_ADDED'] =  Carbon::now()->toDateTimeString();
                $transaction_array[$key]['ADDED_BY'] = $user_id;
                $transaction_array[$key]['LOAN_ID'] = !empty($transaction->LOAN_ID) ?$transaction->LOAN_ID :NULL;
                // $transaction_array[$key]['INVESTMENTS'] = $transaction->INVESTMENTS;
                $transaction_array[$key]['NARRATION'] = $transaction->NARRATION;
                $transaction_array[$key]['TTYPE'] = $transaction->TTYPE;
                $transaction_array[$key]['BATCH_ID'] =  $journal_entry_id;
    
            }

            DB::table('chart_account_transactions')->insert($transaction_array);
            return json_encode(['status'=>true,'reponse'=>"succesfully created journal"]);
        }
        else
        {
            return json_encode(['error'=>"inbalanced journal transactions",'status'=>false]);
        }
      
    }


    public function listAllJournals(Request $request)
    {
        $token = $request->token;
        $pagenumber = $request->pagenumber;
        $next = $request->next;
        $end = "anything";
        
        if($next === true)
        {
         //    return "true";
             $pagenumber = $pagenumber + 1;
        }
        if($next === false)
        {
             // return "false";
             $pagenumber = $pagenumber - 1;
        }
        $pagenumber =($pagenumber <= 0) ? 1 : $pagenumber;
        if($pagenumber == 1) 
        {
             $end = false;
        }
        // $token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IjExNTUiLCJlbWFpbCI6Im1veW9zb2x1d2Eub2d1bmtvbGFAY3JlZGl0Y2xhbi5jb20iLCJpYXQiOjE1NTQ4ODI5NDksImV4cCI6MTU1NTA5ODk0OSwibGVuZGVyX2lkIjoiNjg0OSIsImlzX2NvbXBhbnlfc3RhZmYiOmZhbHNlLCJjb21wYW55X2lkIjpudWxsfQ.NcHYvCpdzLDy0GtdM_hscIhgkerKZMTUV-ADHQijzi8";
        $lender_id = $this->getToken($token);
        //$user_id = $this->getUserId($token);
        $allJournals_master = DB::table('journal as j')->leftjoin('people_peoples as p','p.PEOPLE_PEOPLE_ID','=','j.ADDED_BY')->leftJoin('people_peoples as pp','pp.PEOPLE_PEOPLE_ID','=','j.APPROVED_BY')->select('j.JOURNAL_ENTRY_ID','j.IS_APPROVED','j.JOURNAL_DATE','j.DATE_APPROVED','j.NARRATIVE as NARRATION','pp.LEGAL_NAME as APPROVED_BY','p.LEGAL_NAME as ADDED_BY')->where('lender_id',$lender_id)->where('j.IS_APPROVED',0)->get();

        foreach($allJournals_master as $journal)
        {
            $journal->ischecked = false;
        }

        $newAllJournals = $allJournals_master;

        $allJournals = collect($allJournals_master)->forPage($pagenumber,20)->toArray();
        $formattedAllJournals = array_values($allJournals);

        $allJournalsNext = collect($allJournals_master)->forPage($pagenumber+1,20)->toArray();
        $allJournalsNext = array_values($allJournalsNext);
        
        if(!empty($allJournals) && empty($allJournalsNext))
        {
            $end = true;
        }
        if(empty($allJournals))
        {
            $newAllJournals = collect($newAllJournals)->forPage($pagenumber-1,20)->toArray();
            $formattedAllJournals = array_values($newAllJournals);
        } 
     

        return json_encode(['all_journals_list'=>$formattedAllJournals,'status'=>true]);

      
    }
    public function listSingleJournal(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $journal_id = $request->journal_id;
        $end = false; 
        $start = false;

        $singleJournal = DB::table('journal')->select('JOURNAL_ENTRY_ID','JOURNAL_DATE','EDITABLE','NARRATIVE as NARRATION','BATCH_ID','TOTAL_CREDIT','TOTAL_DEBIT','IS_APPROVED')->where('JOURNAL_ENTRY_ID',$journal_id)->where('LENDER_ID',$lender_id)->get();

        $minmax = DB::select("select MIN(JOURNAL_ENTRY_ID) as min, MAX(JOURNAL_ENTRY_ID) as max from journal where lender_id=$lender_id");

        $nextJournal = DB::select("select JOURNAL_ENTRY_ID from journal where LENDER_ID=$lender_id AND JOURNAL_ENTRY_ID = (select min(JOURNAL_ENTRY_ID) from journal where LENDER_ID=$lender_id AND JOURNAL_ENTRY_ID > $journal_id)");

        $prevJournal = DB::select("select JOURNAL_ENTRY_ID from journal where LENDER_ID=$lender_id AND JOURNAL_ENTRY_ID = (select max(JOURNAL_ENTRY_ID) from journal where LENDER_ID=$lender_id AND JOURNAL_ENTRY_ID < $journal_id)");

        $max = !empty($minmax[0]->max) ? $minmax[0]->max :0;

        if($journal_id ==  $max )
        {
            $end =true;
        }
      
        $min = !empty($minmax[0]->min) ? $minmax[0]->min :0;
        if($journal_id ==  $min )
        {
            $start =true;
        }
        $nextJournal = !empty($nextJournal) ?  $nextJournal[0]->JOURNAL_ENTRY_ID : $max;

        $prevJournal = !empty($prevJournal) ?  $prevJournal[0]->JOURNAL_ENTRY_ID : $min;


        $all_transactions_for_single_journal = DB::table('chart_account_transactions as c')->leftjoin('lender_accounts as l','c.ACCOUNT_ID','=','l.ACCOUNT_ID')->select('c.DATE_ADDED','c.ACCOUNT_ID','l.GL_NAME as ACCOUNT_NAME','c.IFN','c.NARRATION','c.TTYPE','c.AMOUNT','c.AMOUNT_','c.DEBIT','c.CREDIT')->where('BATCH_ID',$journal_id)->where('c.LENDER_ID',$lender_id)->get();
        // var_dump($all_transactions_for_single_journal);
        // die();
        $debit = [];
        $credit = [];
        if(!empty($all_transactions_for_single_journal))
        {
            foreach( $all_transactions_for_single_journal as $transaction)
            {
                if($transaction->TTYPE == 1)
                {
                    $debit[] = $transaction;
                }
                if($transaction->TTYPE == 2)
                {
                    $credit[] = $transaction;
                }
            }
        }
        else
        {
            return json_encode(['singleJournal'=>$singleJournal,'prev_journal_id'=>$prevJournal,'next_journal_id'=>$nextJournal,'all_debits'=>$debit,'all_credits'=>$credit,'start'=>$start,'end'=>$end,'status'=>true]); 
        }
       
        //'all_transactions'=>$all_transactions_for_single_journal
        return json_encode(['singleJournal'=>$singleJournal,'prev_journal_id'=>$prevJournal,'next_journal_id'=>$nextJournal,'all_debits'=>$debit,'all_credits'=>$credit,'start'=>$start,'end'=>$end,'status'=>true]);        
        
    }
    public function editJournal(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $journal_id = $request->journal_id;
        $journal = json_decode(json_encode($request->journal));
        $transaction_array = [];
        $transactions = json_decode(json_encode($request->transactions));
        // $batch_id = DB::table('journal')->select('BATCH_ID')->where('JOURNAL_ENTRY_ID',$journal_id)->get();
        // $batch_id = !empty($batch_id) ? $batch_id[0]->BATCH_ID : 0;
        $total_credit = 0;
        $total_debit = 0;

        // var_dump($total_credit);
        // var_dump($total_debit);
        // die();
        if(!empty($transactions))
        {
            foreach($transactions as $key=>$transaction)
            {         
                    $total_debit += (int)$transaction->DEBIT;

                    $total_credit += (int)$transaction->CREDIT;
                    
                $transaction_array[$key]['DEBIT'] = $transaction->DEBIT;
                $transaction_array[$key]['CREDIT'] = $transaction->CREDIT;
                $transaction_array[$key]['DATE_ADDED'] = $transaction->DATE_ADDED;
                $transaction_array[$key]['ACCOUNT_ID'] = $transaction->ACCOUNT_ID;
                $transaction_array[$key]['TRANSACTION_CODE'] = str_random(40);
                $transaction_array[$key]['IFN'] = $transaction->IFN;

                $transaction_array[$key]['LENDER_ID'] = $lender_id;
                $transaction_array[$key]['ADDED_BY'] = $user_id;
                $transaction_array[$key]['LOAN_ID'] = !empty($transaction->LOAN_ID) ?$transaction->LOAN_ID :NULL;
                // $transaction_array[$key]['ISA'] = $transaction->ISA;
                // $transaction_array[$key]['LOANS'] = $transaction->LOANS;
                // $transaction_array[$key]['INVESTMENTS'] = $transaction->INVESTMENTS;
                $transaction_array[$key]['NARRATION'] = $transaction->NARRATION;
                $transaction_array[$key]['TTYPE'] = !empty($transaction->DEBIT) ? 1 : 2;
                $transaction_array[$key]['BATCH_ID'] =  $journal_id;
    
            }
            
            if($total_credit == $total_debit)
            {
                DB::table('chart_account_transactions')->where('LENDER_ID', $lender_id)->where('BATCH_ID', $journal_id)->delete();
                DB::table('journal')->where('LENDER_ID', $lender_id)->where('JOURNAL_ENTRY_ID',$journal_id)->update([
                    'NARRATIVE'=>  $journal->NARRATION,
                    //'DATE_CREATED'=> Carbon::now(),
                    'DATE_MODIFIED'=> Carbon::now(),
                    //'LENDER_ID'=> $lender_id, //no
                    //'ADDED_BY'=> $user_id, //no
                    'JOURNAL_DATE'=> $journal->DATE_ADDED,
                    //'BATCH_ID'=> $new_batch_id,
                    'TOTAL_DEBIT'=> $journal->TOTAL_DEBIT, 
                    'TOTAL_CREDIT'=> $journal->TOTAL_CREDIT, 
                    //'USE_AS_SUB'=> $journal->USE_AS_SUB, 
                ]);
    
                DB::table('chart_account_transactions')->insert($transaction_array);

                return json_encode(['status'=>true,'response'=>"journal edited succesfully"]);
            }
            else
            {
                return json_encode(['response'=>"inbalanced journal transactions",'status'=>false]);
            }
        }
        else
            {
                return json_encode(['response'=>"transactions cannot be empty",'status'=>false]);
            }
       
      

       

    }

    public function approveJournal(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $journal_id = $request->journal_id;
        // $batch_id = DB::table('journal')->select('BATCH_ID')->where('JOURNAL_ENTRY_ID',$journal_id)->get();
        //$batch_id = !empty($batch_id) ? $batch_id[0]->BATCH_ID : 0;
        $batch_id = $journal_id;
        $count_journal = DB::table('journal')->where('JOURNAL_ENTRY_ID',$journal_id)->where('LENDER_ID', $lender_id)->update([
            'IS_APPROVED'=>1,
            'APPROVED_BY'=>$user_id
        ]); 
        $count_transactions = DB::table('chart_account_transactions')->where('BATCH_ID',$batch_id)->where('LENDER_ID', $lender_id)->update([
            'IS_APPROVED'=>1,
            'APPROVED_BY'=>$user_id
        ]);
        // $batchIdCounts = DB::select("select count(BATCH_ID) as c from chart_account_transactions where LENDER_ID=$lender_id AND BATCH_ID=$batch_id");
        // $batchIdCounts = !empty($batchIdCounts) ?  $batchIdCounts[0]->c : 0;

        // if($count_journal == 1 && $count_transactions == $batchIdCounts &&  $batchIdCounts != 0 )
        // {
            return json_encode(['response'=>"journal approved succesfully",'status'=>true]);
        // }
        // else
        // {
        //     return json_encode(['response'=>"journal was not approved ",'status'=>false]);
        // } 
    }

    public function setToPending(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $journal_id = $request->journal_id;
        // $batch_id = DB::table('journal')->select('BATCH_ID')->where('JOURNAL_ENTRY_ID',$journal_id)->get();

        //$batch_id = !empty($batch_id) ? $batch_id[0]->BATCH_ID : 0;
        $batch_id = $journal_id;
        $count_journal = DB::table('journal')->where('LENDER_ID', $lender_id)->where('JOURNAL_ENTRY_ID',$journal_id)->update([
            'IS_APPROVED'=>0,
            'APPROVED_BY'=>NULL
        ]); 
        $count_transactions = DB::table('chart_account_transactions')->where('LENDER_ID', $lender_id)->where('BATCH_ID',$batch_id)->update([
            'IS_APPROVED'=>0,
            'APPROVED_BY'=>NULL
        ]);
        $batchIdCounts = DB::select("select count(BATCH_ID) as c from chart_account_transactions where LENDER_ID=$lender_id AND BATCH_ID=$batch_id");
        $batchIdCounts = !empty($batchIdCounts) ?  $batchIdCounts[0]->c : 0;

        if($count_journal == 1 && $count_transactions == $batchIdCounts &&  $batchIdCounts != 0 )
        {
            return json_encode(['response'=>"journal set to pending succesfully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"journal was not set to pending",'status'=>false]);
        } 
    }

    public function rejectJournal(Request $request)
    {
        //reject reason is integer but notes is text
        //set is approved to -1
        $token = $request->token;
        $REJECT_REASON_ID = $request->REJECT_REASON_ID;
        $REJECT_NOTES = $request->REJECT_NOTES;
        $journal_id = $request->journal_id;

        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
      
        // $batch_id = DB::table('journal')->select('BATCH_ID')->where('JOURNAL_ENTRY_ID',$journal_id)->get();
        //$batch_id = !empty($batch_id) ? $batch_id[0]->BATCH_ID : 0;
        $batch_id = $journal_id;
        $count_journal = DB::table('journal')->where('LENDER_ID', $lender_id)->where('JOURNAL_ENTRY_ID',$journal_id)->update([
            'IS_APPROVED'=>-1,
            'APPROVED_BY'=>NULL,
            'REJECT_REASON'=>$REJECT_REASON_ID,
            'REJECT_NOTES'=>$REJECT_NOTES,
            'DATE_APPROVED'=>NULL,
        ]); 
        $count_transactions = DB::table('chart_account_transactions')->where('LENDER_ID', $lender_id)->where('BATCH_ID',$batch_id)->update([
            'IS_APPROVED'=>-1,
            'APPROVED_BY'=>NULL,
            'DATE_APPROVED'=>NULL,
        ]);
        $batchIdCounts = DB::select("select count(BATCH_ID) as c from chart_account_transactions where LENDER_ID=$lender_id AND BATCH_ID=$batch_id");
        $batchIdCounts = !empty($batchIdCounts) ?  $batchIdCounts[0]->c : 0;

        if($count_journal == 1 && $count_transactions == $batchIdCounts &&  $batchIdCounts != 0 )
        {
            return json_encode(['response'=>"journal rejected succesfully",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"journal was not rejected ",'status'=>false]);
        }
        
        

       

    }

    public function nextAllJournals(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $pagenumber = $request->pagenumber;
       $next = $request->next;
       $end = "anything";
       if($next === true)
       {
        //    return "true";
            $pagenumber = $pagenumber + 1;
       }
       if($next === false)
       {
            // return "false";
            $pagenumber = $pagenumber - 1;
       }

       $pagenumber =($pagenumber <= 0) ? 1 : $pagenumber;
       if($pagenumber == 1) 
       {
            $end = false;
       }

        $allJournals_master = DB::table('journal as j')->join('people_peoples as p','p.PEOPLE_PEOPLE_ID','=','j.ADDED_BY')->leftJoin('people_peoples as pp','pp.PEOPLE_PEOPLE_ID','=','j.APPROVED_BY')->select('j.JOURNAL_ENTRY_ID','j.IS_APPROVED','j.JOURNAL_DATE','j.DATE_APPROVED','j.NARRATIVE as NARRATION','pp.LEGAL_NAME as APPROVED_BY','p.LEGAL_NAME as ADDED_BY')->where('lender_id',$lender_id)->get();

        $newAllJournals = $allJournals_master;

        $allJournals = collect($allJournals_master)->forPage($pagenumber,20)->toArray();
        $formattedAllJournals = array_values($allJournals);

        $allJournalsNext = collect($allJournals_master)->forPage($pagenumber+1,20)->toArray();
        $allJournalsNext = array_values($allJournalsNext);
        
        if(!empty($allJournals) && empty($allJournalsNext))
        {
            $end = true;
        }
        if(empty($allJournals))
        {
            $newAllJournals = collect($newAllJournals)->forPage($pagenumber-1,20)->toArray();
            $formattedAllJournals = array_values($newAllJournals);
        } 
     
        return json_encode(['all_journals_list'=>$formattedAllJournals,'end'=>$end,'status'=>true]);


    }

    public function nextorPreviousJournal(Request $request)
    {
        $token = $request->token;
        $journal_id = $request->journal_id;
        $next = $request->next;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);

        $minmax = DB::select("select MIN(JOURNAL_ENTRY_ID) as min, MAX(JOURNAL_ENTRY_ID) as max from journal where lender_id=$lender_id");

        $nextJournal = DB::select("select JOURNAL_ENTRY_ID from journal where LENDER_ID=$lender_id AND JOURNAL_ENTRY_ID = (select min(JOURNAL_ENTRY_ID) from journal where JOURNAL_ENTRY_ID > $journal_id)");


        $prevJournal = DB::select("select JOURNAL_ENTRY_ID from journal where LENDER_ID=$lender_id AND JOURNAL_ENTRY_ID = (select max(JOURNAL_ENTRY_ID) from journal where JOURNAL_ENTRY_ID < $journal_id)");

        $max = !empty($minmax[0]->max) ? $minmax[0]->max :0;
        $min = !empty($minmax[0]->min) ? $minmax[0]->min :0;

        $nextJournal = !empty($nextJournal) ?  $nextJournal[0]->JOURNAL_ENTRY_ID : $max;

        $prevJournal = !empty($prevJournal) ?  $prevJournal[0]->JOURNAL_ENTRY_ID : $min;

        if($next === true)
        {
            $journal_id =  $nextJournal;            
        }
        if($next === false)
        {
            $journal_id =  $prevJournal;
        }

        //$journal_id = $next === true ? $journal_id + 1 : $journal_id - 1;
      
        $singleJournal = DB::table('journal')->select('JOURNAL_ENTRY_ID as folio_number','JOURNAL_DATE','NARRATIVE as NARRATION','BATCH_ID','TOTAL_CREDIT','TOTAL_DEBIT','IS_APPROVED')->where('JOURNAL_ENTRY_ID',$journal_id)->where('LENDER_ID', $lender_id)->get();
        $batch_id = $journal_id;
        // if(!empty($singleJournal))
        // {
        //     $batch_id = $singleJournal[0]->BATCH_ID;
        // }
        // else
        // {
        //     $batch_id = 0; 
        // }
        $all_transactions_for_single_journal = DB::table('chart_account_transactions as c')->join('lender_accounts as l','c.ACCOUNT_ID','=','l.ACCOUNT_ID')->select('l.GL_NAME as ACCOUNT_NAME','c.IFN','c.NARRATION','c.TTYPE','c.AMOUNT','c.AMOUNT_','c.DEBIT','c.CREDIT')->where('BATCH_ID',$batch_id)->where('c.LENDER_ID', $lender_id)->get();

        $debit = [];
        $credit = [];
        foreach( $all_transactions_for_single_journal as $transaction)
        {
            if($transaction->TTYPE == 1)
            {
                $debit[] = $transaction;
            }
            if($transaction->TTYPE == 2)
            {
                $credit[] = $transaction;
            }
        }

        return json_encode(['singleJournal'=>$singleJournal,'all_debits'=>$debit,'all_credits'=>$credit,'status'=>true]);

    }

    public function searchAllJournals(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        //$user_id = $this->getUserId($token);
        // $start_date = $request->start_date;
        // $end_date = $request->end_date;
        // $source = $request->source;
        // $status = $request->status;
        // $journal_no = $request->journal_no;
        $pagenumber = $request->pagenumber;
        $next = $request->next;
        $end = "anything";

        if($next === true)
        {
         //    return "true";
             $pagenumber = $pagenumber + 1;
        }
        if($next === false)
        {
             // return "false";
             $pagenumber = $pagenumber - 1;
        }
 
        $pagenumber =($pagenumber <= 0) ? 1 : $pagenumber;
        if($pagenumber == 1) 
        {
             $end = false;
        }

        $start_date_value = $request->start_date_value;
        $end_date_value = $request->end_date_value;
        $source_value = $request->source_value;

        $status_value = $request->status_value;
        $journal_no_value = $request->journal_no_value;

        $start_date_value = !empty($start_date_value) ? date('Y-m-d',strtotime($start_date_value))  : "";
        $end_date_value = !empty($end_date_value) ? date('Y-m-d',strtotime($end_date_value))  : "";
      

        $allJournals = DB::table('journal as j')->leftjoin('people_peoples as p','p.PEOPLE_PEOPLE_ID','=','j.ADDED_BY')->leftJoin('people_peoples as pp','pp.PEOPLE_PEOPLE_ID','=','j.APPROVED_BY')->select('j.JOURNAL_ENTRY_ID','j.IS_APPROVED','j.JOURNAL_DATE','j.DATE_APPROVED','j.NARRATIVE as NARRATION','pp.LEGAL_NAME as APPROVED_BY','p.LEGAL_NAME as ADDED_BY')->where('lender_id',$lender_id);
        $newAllJournals = $allJournals;

        if(!empty($start_date_value) && empty($end_date_value))
        {
           $newAllJournals =  $allJournals->where('j.JOURNAL_DATE','>=',$start_date_value);
            // $searchquery .= where('j.JOURNAL_DATE','>=',$start_date);
        }
        if(empty($start_date) && !empty($end_date_value))
        {
            $newAllJournals =  $allJournals->where('j.JOURNAL_DATE','<=',$end_date_value);
            // $searchquery .= $searchquery->where('j.JOURNAL_DATE','<=',$end_date);
        }
        if(!empty($start_date_value) && !empty($end_date_value))
        {
            $newAllJournals = $allJournals->whereBetween('j.JOURNAL_DATE',[$start_date_value,$end_date_value]);
            // $searchquery .= $allJournals->whereBetween('j.JOURNAL_DATE',[$start_date,$end_date]);
        }
        if(!empty($journal_no_value))
        {
            $newAllJournals = $newAllJournals->where('j.JOURNAL_ENTRY_ID', $journal_no_value);
        }
        if(!empty($status_value) && $status_value == 0)
        {
            $newAllJournals = $newAllJournals->where('j.IS_APPROVED', 0);
        }
        if(!empty($status_value) && $status_value == 1)
        {
            $newAllJournals = $newAllJournals->where('j.IS_APPROVED', 1);
        }
        $source_array = [];
        if(!empty($source_value))
        {
            $source_array = [$source_value];
            $newAllJournals = $newAllJournals->whereIn('j.SOURCE', $source_array);
        }

        $newAllJournals = $newAllJournals->get();
        $allJournals_master= $newAllJournals;

        $allJournals_ = collect($allJournals_master)->forPage($pagenumber,20)->toArray();
        $newAllJournals = array_values($allJournals_);

        $allJournalsNext = collect($allJournals_master)->forPage($pagenumber+1,20)->toArray();
        $allJournalsNext = array_values($allJournalsNext);
        if(!empty($allJournals_) && empty($allJournalsNext))
        {
            $end = true;
        }
        // if(empty($allJournals))
        // {
        //     $newAllJournals = collect($newAllJournals)->forPage($pagenumber-1,20)->toArray();
        //     $formattedAllJournals = array_values($newAllJournals);
        // } 
        
        return json_encode(['all_journals_list'=>$newAllJournals,'count'=>count($newAllJournals),'end'=>$end,'status'=>true]);

    }

    public function bulkApproveJournals(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        //journal_id will be an array of ids
        $journal_ids = json_decode(json_encode($request->journal_ids));
        // $batch_ids = DB::table('journal')->select('BATCH_ID')->whereIn('JOURNAL_ENTRY_ID',$journal_id)->get();

        $all_batch_ids = [];
        foreach($journal_ids as $journal_id)
        {
            if($journal_id->ischecked === true)
            {
                $all_batch_ids[] = $journal_id->JOURNAL_ENTRY_ID;
            }
        }
        $journal_ids = $all_batch_ids;
    

        $count_journal = DB::table('journal')->whereIn('JOURNAL_ENTRY_ID',$journal_ids)->where('LENDER_ID', $lender_id)->update([
            'IS_APPROVED'=>1,
            'APPROVED_BY'=>$user_id
        ]);
        $count_transactions = DB::table('chart_account_transactions')->whereIn('BATCH_ID',$journal_ids)->where('LENDER_ID', $lender_id)->update([
            'IS_APPROVED'=>1,
            'APPROVED_BY'=>$user_id
        ]);

        // $batchIdCounts = DB::select("select count(BATCH_ID) as c from chart_account_transactions where BATCH_ID=$batch_id");
        $batchIdCounts = DB::table('chart_account_transactions')->select('BATCH_ID')->where('LENDER_ID', $lender_id)->whereIn('BATCH_ID',$journal_ids)->get();
        $batchIdCounts = count($batchIdCounts);
        $countOfJournalIds = count($journal_ids);
        // $batchIdCounts = !empty($batchIdCounts) ?  $batchIdCounts[0]->c : 0;
        if($count_journal == $countOfJournalIds && $count_transactions == $batchIdCounts &&  $batchIdCounts != 0 )
        {
            return json_encode(['response'=>"final bulk approval was successful",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"final bulk approval was not successful",'status'=>false]);
        }


    }

    public function deleteJournal(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $journal_id = $request->journal_id;
        // $batch_id = DB::table('journal')->select('BATCH_ID')->where('JOURNAL_ENTRY_ID',$journal_id)->get();
        // $batch_id = !empty($batch_id) ? $batch_id[0]->BATCH_ID : 0;
        $batch_id = $journal_id;
       // $all_batch_ids = [];
        // if(!empty($batch_ids))
        // {
        //     foreach($batch_ids as $batch_id)
        //     {   
        //         $all_batch_ids[] = $batch_id->BATCH_ID;
        //     }
        // }
        // else
        // {
        //     return json_encode(['response'=>"bulk approval was not successful",'status'=>true]);
        // }
        $batchIdCounts = DB::table('chart_account_transactions')->select('BATCH_ID')->where('LENDER_ID', $lender_id)->where('BATCH_ID',$batch_id)->get();
        $batchIdCounts = count($batchIdCounts);
        $count_journal = DB::table('journal')->where('JOURNAL_ENTRY_ID',$journal_id)->where('LENDER_ID', $lender_id)->delete();
        $count_transactions = DB::table('chart_account_transactions')->where('LENDER_ID', $lender_id)->where('BATCH_ID',$batch_id)->delete();
       
      
      
        $countOfJournalIds = count($journal_id);
        // $batchIdCounts = !empty($batchIdCounts) ?  $batchIdCounts[0]->c : 0;
        if($count_journal == 1 && $count_transactions == $batchIdCounts &&  $batchIdCounts != 0 )
        {
            return json_encode(['response'=>"journal delete was successful",'status'=>true]);
        }
        else
        {
            return json_encode(['response'=>"journal delete was not successful",'status'=>false]);
        }

    }

    public function getJournalReport(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $journal_start_date = $request->start_date;
        $journal_end_date = $request->end_date;
        $journal_start_date = !empty($journal_start_date) ? date('Y-m-d',strtotime($journal_start_date))  : "";
        $journal_end_date = !empty($journal_end_date) ? date('Y-m-d',strtotime($journal_end_date))  : "";
        //->leftjoin('lender_accounts as l','l.PEOPLE_PEOPLE_ID','=','j.ADDED_BY')
        if(!empty($journal_start_date) && !empty($journal_end_date))
        {
         
            $report_transactions = DB::select("select (c.DATE_ADDED),j.JOURNAL_ENTRY_ID,c.NARRATION,c.ACCOUNT_ID,l.GL_NAME,l.GL_CODE, c.DEBIT as debit,c.CREDIT as credit,j.JOURNAL_DATE from chart_account_transactions as c
            join journal as j on c.BATCH_ID=j.JOURNAL_ENTRY_ID join lender_accounts as l on c.ACCOUNT_ID=l.ACCOUNT_ID where c.BATCH_ID in (select JOURNAL_ENTRY_ID from journal WHERE lender_id=$lender_id AND date(JOURNAL_DATE) BETWEEN '".$journal_start_date."' AND '".$journal_end_date."') AND c.LENDER_ID=$lender_id");   
            $total_debit = 0;
            $total_credit = 0;
            if(!empty($report_transactions))
            {
                foreach($report_transactions as $transaction)
                {
                    $total_credit += $transaction->credit;
                    $total_debit += $transaction->debit;
                }
            }
           
            return json_encode(['all'=>$report_transactions,'total_credit'=>$total_credit,'total_debit'=>$total_debit,'status'=>true]);
         
        }
        else
        {
            return json_encode(['response'=>"start and end dates cannot be empty",'status'=>false]);
        }      

    }

    public function getGeneralLedgerReportNew(Request $request)
    {

        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $account_type =  $request->account_type;
    
        if($account_type == 1)//for company accounts
        {
            $accounts_between_date =  DB::table('chart_account_transactions as c')->join('lender_accounts as l','c.ACCOUNT_ID','=','l.ACCOUNT_ID')->select('c.*','l.GL_NAME','l.GL_CODE')->where('l.LENDER_ID',$lender_id)->whereBetween('c.DATE_ADDED',[$start_date,$end_date])->where('l.IS_LOAN_PRODUCT','!=',1);

            $accounts_between_dates =  $accounts_between_date->groupBy('c.ACCOUNT_ID')->get();


          
            //return $accounts_between_dates;
            $account_ids = [];
            $t = [];
            if(!empty($accounts_between_dates))
            {
                foreach($accounts_between_dates as $key=>$account)
                {
                    $account_ids[] = $account->ACCOUNT_ID;

                    $data=array();

                    $data["OPENING_BALANCE"]=0;

                    $data["TOTAL_TRANSACTIONS"]=0;

                    $data["REMAINING_TRANSACTIONS"]=0;

                 
                    // $chart_account_transactions = $data["chart_account_transactions"];
                
                    // $data["chart_account_transactions"] = json_decode(json_encode($data["chart_account_transactions"]),true);
              
                    //  $result = $data["chart_account_transactions"];

                    // $data["contra_charts"]=$this->getContraCharts($data["chart_account_transactions"]);

                 
                    // $data["chart_account_transactions"] =
                    // $chart_account_transactions ; 
                    // $accounts[$key]['data']=$data;

                    // $t[]=$data;
                   
        
                }
                $new_chart_account_transactions = [];
                $data["chart_account_transactions"] =  DB::table('chart_account_transactions as c')->join('lender_accounts as l','c.ACCOUNT_ID','=','l.ACCOUNT_ID')->select('c.CHART_ACCOUNT_TRANSACTION_ID','c.ACCOUNT_ID','c.DEBIT','c.CREDIT','c.NARRATION','c.TTYPE','c.BATCH_ID','c.IFN','c.DATE_ADDED','l.GL_NAME','l.GL_CODE')->where('l.LENDER_ID',$lender_id)->whereBetween('c.DATE_ADDED',[$start_date,$end_date])->where('l.IS_LOAN_PRODUCT','!=',1)->whereIn('c.ACCOUNT_ID',$account_ids)->orderBy('c.DATE_ADDED')->get();
                foreach( $data["chart_account_transactions"] as $value)
                {
                   $new_chart_account_transactions[$value->ACCOUNT_ID][] = $value;
                }
                //var_dump($new_chart_account_transactions);
                //$new_chart_account_transactions
                $account_details = DB::table('lender_accounts')->select('*')->whereIn('ACCOUNT_ID',$account_ids)->get();

                $new_chart_account_transactions = array_values($new_chart_account_transactions);

               $chart_account_transactions= json_decode(json_encode($new_chart_account_transactions),true);
               
            //    var_dump($chart_account_transactions);
            //     var_dump($new_chart_account_transactions);
            //     die();
               
                // $row = DB::select("SELECT * FROM chart_account_transactions where CHART_ACCOUNT_TRANSACTION_ID = '".$value_["CHART_ACCOUNT_TRANSACTION_ID"]."'");

                foreach($account_ids as $key=> $id)
                {
                    $data["account_details"] =  $account_details[$key];
                    $data["chart_account_transactions"] = $new_chart_account_transactions[$key];
                    // foreach($chart_account_transactions[$key] as $value)
                    // {
                    //     $chart_transaction_ids[] = $value['CHART_ACCOUNT_TRANSACTION_ID'];
                    // }
                    //$trans = $chart_account_transactions[$key];
                    $data["contra_charts"]=$this->getContraCharts($chart_account_transactions[$key]);
                    // if(sizeof($trans)>0)
                    // {

                    //     foreach($trans as $tran)
                    //     {
                    //         // $chart_ids[] = $tran['CHART_ACCOUNT_TRANSACTION_ID'];
                    //         $temp[]=$this->getContraTrans_($tran);    
            
                    //     }
            
                    // }
                   // $data["contra_charts"] = $temp;
                    $t[]=$data;
                }
            
               
                //$d['accounts']=$accounts;

                $d['accounts']=$t;
                //The opposite side of each of those transaction
                return json_encode(['final'=>$d]);
            }

        }
     
    }
      
    public function getGeneralLedgerReport(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $account_type =  $request->account_type;
        $start_date = !empty($start_date) ? date('Y-m-d',strtotime($start_date))  : "";
        $end_date = !empty($end_date) ? date('Y-m-d',strtotime($end_date))  : "";
        if(!empty($start_date) && !empty($end_date))
        {
            if($account_type == 1)//for company accounts
            {
                $accounts_between_date =  DB::table('chart_account_transactions as c')->join('lender_accounts as l','c.ACCOUNT_ID','=','l.ACCOUNT_ID')->select('c.*','l.GL_NAME','l.GL_CODE')->where('l.LENDER_ID',$lender_id)->whereBetween('c.DATE_ADDED',[$start_date,$end_date])->where('l.IS_LOAN_PRODUCT','!=',1);

                $accounts_between_dates =  $accounts_between_date->groupBy('c.ACCOUNT_ID')->get();
                //return $accounts_between_dates;

                if(!empty($accounts_between_dates))
                {
                    foreach($accounts_between_dates as $key=>$account)
                    {
                        $data=array();
                        $data["account_details"] = DB::table('lender_accounts')->select('GL_NAME','GL_CODE','GL_CATEGORY')->where('ACCOUNT_ID',$account->ACCOUNT_ID)->get();
                        $account_details_one = $data["account_details"][0];
                        $account_details_one = json_decode(json_encode($account_details_one),true);
                        $data["direction"] = "1";
                        switch($account_details_one["GL_CATEGORY"])
                        {
                            case "1":
                            case "5":
                                $data["direction"] = "1";
                            break;
                            case "2":
                            case "3":
                            case "4":
                                $data["direction"] = "2";
                            break;
                        }

                        $data["OPENING_BALANCE"]=$this->getAccountCurrentBalance($account->ACCOUNT_ID,$start_date,$end_date,$data["direction"],$lender_id);

                        $data["TOTAL_TRANSACTIONS"]=0;

                        $data["REMAINING_TRANSACTIONS"]=0;

                    
                        
                        // $result=$this->accounting_model->getAllCOTTransactions__($account['ACCOUNT_ID'],$this->session->group_lender_id,$d["FISCAL_DATE_START"],$d["FISCAL_DATE_END"],$data["direction"]);

                        $data["chart_account_transactions"] =  DB::table('chart_account_transactions as c')->join('lender_accounts as l','c.ACCOUNT_ID','=','l.ACCOUNT_ID')->select('c.CHART_ACCOUNT_TRANSACTION_ID','c.ACCOUNT_ID','c.DEBIT','c.CREDIT','c.NARRATION','c.TTYPE','c.BATCH_ID','c.IFN','c.DATE_ADDED','l.GL_NAME','l.GL_CODE')->where('c.is_approved',1)->where('l.LENDER_ID',$lender_id)->whereBetween('c.DATE_ADDED',[$start_date,$end_date])->where('l.IS_LOAN_PRODUCT','!=',1)->where('c.ACCOUNT_ID',$account->ACCOUNT_ID)->orderBy('c.DATE_ADDED')->get();
                        $chart_account_transactions = $data["chart_account_transactions"];
                        // if($key == 0)
                        // {
                        
                        //     $hola = $accounts_between_date->where('c.ACCOUNT_ID',$account->ACCOUNT_ID)->orderBy('c.DATE_ADDED')->get();
                        //     return $hola;
                        // }
                        $data["chart_account_transactions"] = json_decode(json_encode($data["chart_account_transactions"]),true);
                    
                        // var_dump($data["chart_account_transactions"]);
                        // die();
                        $result = $data["chart_account_transactions"];

                        $data["contra_charts"]=$this->getContraCharts($data["chart_account_transactions"], $data["OPENING_BALANCE"]);

                        // var_dump($data["chart_account_transactions"]);
                        // die();

                        // $data["OPENING_BALANCE"]=$data["chart_account_transactions"][0]["opening_balance"];

                        // $data["TOTAL_TRANSACTIONS"]=$data["chart_account_transactions"][0]["current_balance"];

                        // $data["REMAINING_TRANSACTIONS"]=$data["chart_account_transactions"][0]["remaining_balance"];

                        // if($request->input('SHOW_ZERO_BALANCE')==0){

                        //     if($data["OPENING_BALANCE"]+$data["TOTAL_TRANSACTIONS"]+$data["REMAINING_TRANSACTIONS"]==0){

                        //         continue;

                        //     }



                        // }
                        $data["chart_account_transactions"] =
                        $chart_account_transactions ; 
                        $accounts[$key]['data']=$data;

                        $t[]=$data;
                    
            
                    }
                    $d['accounts']=$accounts;

                    $d['accounts']=$t;
                    //The opposite side of each of those transaction
                    return json_encode(['final'=>$d]);
                }

            }
        }
        else
        {
            return json_encode(['response'=>"start and end dates cannot be empty",'status'=>false]);
        }
      
        
    }

    public function getContraCharts($trans,$opening_balance){

        $temp = array();
        $new = [];

        if(sizeof($trans)>0){

            foreach($trans as $tran){
                
                // $temp[]=$this->getContraTrans_($tran,$opening_balance);  
                $new=$this->getContraTrans_($tran,$opening_balance);   
                $temp = array_merge($temp,$new) ;

            }

        }

        return $temp;

    }

    public function getContraTrans_($value_,$opening_balance)
    {
        $row = DB::select("SELECT CREDIT,DEBIT,BATCH_ID,IFN FROM chart_account_transactions where CHART_ACCOUNT_TRANSACTION_ID = '".$value_["CHART_ACCOUNT_TRANSACTION_ID"]."'");
        
        $row = json_decode(json_encode($row),true);
        $row = $row[0];
        $remaining_balance  = $opening_balance;
        //$value['remaining_balance'] = $opening_balance;
		//what side am i on
        if($row["CREDIT"] ==0 || $row["CREDIT"] =="")
        {

			//we are getting the opposite credit trans

			$sql = "SELECT a.CHART_ACCOUNT_TRANSACTION_ID,a.ACCOUNT_ID,a.DEBIT,a.CREDIT,a.NARRATION,a.DATE_ADDED,b.GL_NAME,b.GL_CODE FROM chart_account_transactions as a

			LEFT JOIN lender_accounts as b on a.ACCOUNT_ID = b.ACCOUNT_ID

            WHERE a.BATCH_ID = '".$row["BATCH_ID"]."' AND a.IFN = '".$row['IFN']."' AND a.TTYPE = 2";
            
            $result = DB::select($sql);

            $result = json_decode(json_encode($result),true);

            //$result =  $result;

            //we are getting the opposite DEBIT trans
            
			$sql = "SELECT a.CHART_ACCOUNT_TRANSACTION_ID,a.ACCOUNT_ID,a.DEBIT,a.CREDIT,a.NARRATION,a.DATE_ADDED,b.GL_NAME,b.GL_CODE FROM chart_account_transactions as a

			LEFT JOIN lender_accounts as b on a.ACCOUNT_ID = b.ACCOUNT_ID

			WHERE a.BATCH_ID = '".$row["BATCH_ID"]."' AND a.IFN = '".$row['IFN']."' AND a.TTYPE = 1";

            $result_ = DB::select($sql);


            $result_ = json_decode(json_encode($result_),true);

           // $result_ =  $result_[0];
            //if the opposite side is more
            
            if(sizeof($result) > sizeof($result_))
            {



				//this means the transaction chosen is the master



				//if the transaction chosen is the master



				//we need to return the slaves as the transaction type of the master



				$temp = array();



				if(sizeof($result)>0){



					foreach ($result as $key => $value) {



						# code...



						$value["DEBIT"]=$value["CREDIT"];



						$value["CREDIT"] = 0;

                        // if($value['CREDIT'])
                        // {
                            //$value['remaining_balance'] = 0;
                            $value['remaining_balance'] = $remaining_balance += $value["DEBIT"];
                       // }
                        

						// $value["journaldetails"]=$this->getAllJournalsEntries($value["LENDER_ID"],$value["BATCH_ID"],1);







						$temp[] = $value;



					}



				}



				return $temp;



            }
            else
            {



				//the transaction chosen is the slave



				//if the transaction chosen is the slave we need to return the transaction of the slave with master as the account id



				$temp = array();



				if(sizeof($result)>0){



					foreach ($result as $key => $value) {



						# code...



						$value["DEBIT"]=$value_["DEBIT"];



						$value["CREDIT"] = 0;


                        $value['remaining_balance'] = $remaining_balance += $value["DEBIT"];
						// $value["journaldetails"]=$this->getAllJournalsEntries($value["LENDER_ID"],$value["BATCH_ID"],1);



						$temp[] = $value;



					}



				}



				return $temp;







			}

		}

        if($row["DEBIT"]==0||$row["DEBIT"]=="")
        {



			//we are getting the opposite credit trans



			$sql = "SELECT a.CHART_ACCOUNT_TRANSACTION_ID,a.ACCOUNT_ID,a.DEBIT,a.CREDIT,a.NARRATION,a.DATE_ADDED,b.GL_NAME,b.GL_CODE FROM chart_account_transactions as a



			JOIN lender_accounts as b on a.ACCOUNT_ID = b.ACCOUNT_ID



			WHERE a.BATCH_ID = '".$row["BATCH_ID"]."' AND a.IFN = '".$row["IFN"]."' AND a.TTYPE = 1";


            $result = DB::select($sql);

            $result = json_decode(json_encode($result),true);
			// $d = $this->db->query("SELECT ACCOUNTING_MODEL FROM people WHERE PEOPLE_ID = '".$value_["LENDER_ID"]."'")->row_array();




			//$result = $this->db->query($sql)->result_array();







			//we are getting the opposite DEBIT trans



			$sql = "SELECT a.CHART_ACCOUNT_TRANSACTION_ID,a.ACCOUNT_ID,a.DEBIT,a.CREDIT,a.NARRATION,a.DATE_ADDED,b.GL_NAME,b.GL_CODE FROM chart_account_transactions as a



			JOIN lender_accounts as b on a.ACCOUNT_ID = b.ACCOUNT_ID



			WHERE a.BATCH_ID = '".$row["BATCH_ID"]."' AND a.IFN = '".$row["IFN"]."' AND a.TTYPE = 2";



			// $d = $this->db->query("SELECT ACCOUNTING_MODEL FROM people WHERE PEOPLE_ID = '".$value_["LENDER_ID"]."'")->row_array();


            $result_ = DB::select($sql);


            $result_ = json_decode(json_encode($result_),true);

			//$result_ = $this->db->query($sql)->result_array();



			//if the opposite side is more



			if(sizeof($result) > sizeof($result_)){



				//this means the transaction chosen is the master



				//if the transaction chosen is the master



				//we need to return the slaves as the transaction type of the master



				$temp = array();



				if(sizeof($result)>0){



					foreach ($result as $key => $value) {



						# code...



						$cr = $value["CREDIT"];



						$dr = $value["DEBIT"];



						$value["DEBIT"]=$cr;



						$value["CREDIT"] = $dr;

                        if(!empty($value["CREDIT"]))
                        {
                            $value['remaining_balance'] = $remaining_balance -= $value["CREDIT"];
                        }
                        if(!empty($value["DEBIT"]))
                        {
                            $value['remaining_balance'] = $remaining_balance +=  $value["DEBIT"];
                        }

						// $value["journaldetails"]=$this->getAllJournalsEntries($value["LENDER_ID"],$value["BATCH_ID"],1);



						$temp[] = $value;



					}



				}



				return $temp;



			}



			else{



				//the transaction chosen is the slave



				//if the transaction chosen is the slave we need to return the transaction of the slave with master as the account id



				$temp = array();



				if(sizeof($result)>0){



					foreach ($result as $key => $value) {



						# code...



						$value["CREDIT"]=$value_["CREDIT"];



						$value["DEBIT"] = 0;

                        // if(!empty($value["DEBIT"]))
                        // {
                            $value['remaining_balance'] = $remaining_balance -= $value["CREDIT"];
                        //}

						// $value["journaldetails"]=$this->getAllJournalsEntries($value["LENDER_ID"],$value["BATCH_ID"],1);



						$temp[] = $value;



					}



				}



				return $temp;







			}







		}



    }
    
    public function getTrialBalance(Request $request)
    {   
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $start_date = $request->start_date;
        $start_date = !empty($start_date) ? date('Y-m-d',strtotime($start_date))  : "";
        $trial_balance = [];

       
        if(!empty($start_date))
        {
            $com_accounts = $this->getAllCompanyAccountsForSelectLeaf($lender_id);

            $com_accounts = json_decode(json_encode($com_accounts),true);
            // var_dump($com_accounts);
            // die();
            if(sizeof($com_accounts)>0)
            {
                foreach($com_accounts as $acc)
                {
                    // ($this->getGLAccount((int)$acc["ACCOUNT_ID"],$lender_id));
                    $trial_balance[$acc["ACCOUNT_ID"]]=$this->getGLAccount($acc["ACCOUNT_ID"],$lender_id)[0];
                    $trial_balance[$acc["ACCOUNT_ID"]] = json_decode(json_encode($trial_balance[$acc["ACCOUNT_ID"]]),true);

                //var_dump($trial_balance);
                // die();

                switch($trial_balance[$acc["ACCOUNT_ID"]]["GL_CATEGORY"])
                    {
                        case "1":
                        case "5":
                        $trial_balance[$acc["ACCOUNT_ID"]]["direction"]=1;
                        break;
                        default:
                        $trial_balance[$acc["ACCOUNT_ID"]]["direction"]=2;
                        break;
                    }
                    $trial_balance[$acc["ACCOUNT_ID"]]["OPENING_BALANCE"] = $this->gACB_($acc["ACCOUNT_ID"],$start_date,$start_date,$trial_balance[$acc["ACCOUNT_ID"]]["direction"],$lender_id);


                    // $trial_balance[$acc["GL_CODE"]]["result"]=  DB::table('chart_account_transactions as c')->join('lender_accounts as l','c.ACCOUNT_ID','=','l.ACCOUNT_ID')->select('c.CHART_ACCOUNT_TRANSACTION_ID','c.ACCOUNT_ID','c.DEBIT','c.CREDIT','c.NARRATION','c.TTYPE','c.BATCH_ID','c.IFN','c.DATE_ADDED','l.GL_NAME','l.GL_CODE')->where('l.LENDER_ID',$lender_id)->whereDate('c.DATE_ADDED','=',$start_date)->where('l.IS_LOAN_PRODUCT','!=',1)->where('c.ACCOUNT_ID',$acc["ACCOUNT_ID"])->orderBy('c.DATE_ADDED')->get();

                    //    $trial_balance[$acc["GL_CODE"]]["OPENING_BALANCE"]=$trial_balance[$acc["GL_CODE"]]["result"]["opening_balance"]+$trial_balance[$acc["GL_CODE"]]["result"]["remaining_balance"]+$trial_balance[$acc["GL_CODE"]]["result"]["current_balance"];

                }

            }
            $a=array();
            if(!empty($trial_balance))
            {   
                foreach($trial_balance as $d)
                {    
                    $U=array("GL_CODE"=>$d["GL_CODE"],"GL_NAME"=>$d["GL_NAME"]);
                    if($d["direction"]=="1"){
                        if($d["OPENING_BALANCE"]<0){
                            $U["DEBIT"] = 0;
                            $U["CREDIT"] = $d["OPENING_BALANCE"]*(-1);
                        }else{
                            $U["DEBIT"] = $d["OPENING_BALANCE"];
                            $U["CREDIT"] = 0;
                        }
                    }
                    if($d["direction"]=="2"){
                        if($d["OPENING_BALANCE"]<0){
                            $U["DEBIT"] = $d["OPENING_BALANCE"]*(-1);
                            $U["CREDIT"] = 0;
                        }else{
                            $U["DEBIT"] = 0;
                            $U["CREDIT"] = $d["OPENING_BALANCE"];
                        }
                    }
                    $a[]=$U;
                }
            }
             // ksort($trial_balance);
             $total_credit = 0;
             $total_debit = 0;
             foreach($a as $item)
             {
                 $total_credit += $item['CREDIT'];
                 $total_debit += $item['DEBIT'];
             }
            return json_encode(['trial_balance'=>$a,'total_debit'=>$total_debit,'total_credit'=>$total_credit]);
        }
        else
        {
            return json_encode(['response'=>"Date Field cannot be empty",'status'=>false]);
        } 
       
      
    }
    
    public function gACB_($LENDER_ACCOUNT_ID,$fiscal_date_start,$fiscal_date_end,$direction,$lender_id)
    {
        $OPENING_BALANCE = 0;
        //first the previous year balance from the date start
        //get the total of transaction between end of previous year and date start
        $YEAR_END = date('Y',strtotime($fiscal_date_start))-1;
        $account_details=$this->getGLAccount($LENDER_ACCOUNT_ID,$lender_id);

        $sql="SELECT CLOSING_BALANCE FROM coa_balances
            where YEAR_END='".$YEAR_END."' AND LENDER_ID = '".$lender_id."' and ACCOUNT_ID = '".$LENDER_ACCOUNT_ID."'";

            
            //what the clsoing balance for that year
           // $result=$this->db->query($sql)->row_array();
           $result = DB::select($sql);
           $result = json_decode(json_encode($result),true);
          

            if(!empty($result[0])){
                $result = $result[0];
                $OPENING_BALANCE+=$result["CLOSING_BALANCE"];
            }
        //add what has been done from the year end to current
        $fromdate = date('Y',strtotime($fiscal_date_start)).'-01'.'-01';
        $sqlx="SELECT SUM(DEBIT) AS DEBIT, SUM(CREDIT) AS CREDIT
         FROM chart_account_transactions
         WHERE is_approved=1 and lender_id = '".$lender_id."'
         AND (DATE_ADDED BETWEEN '".$fromdate."' AND '".$fiscal_date_start."')
         AND ACCOUNT_ID = '".$LENDER_ACCOUNT_ID."'";

        //  $rowx = $this->db->query("SELECT ACCOUNTING_MODEL FROM people WHERE PEOPLE_ID = '".$lender_id."'")->row_array();
        
        //$resultx = $this->db->query($sqlx)->row_array();
        $resultx = DB::select($sqlx);  
        $resultx = json_decode(json_encode($resultx),true);
        if(!empty($resultx))
        {
            $resultx = $resultx[0];
            if($direction=="1"){
                return $OPENING_BALANCE+$resultx["DEBIT"]-$resultx["CREDIT"];
            }else{
                return $OPENING_BALANCE-$resultx["DEBIT"]+$resultx["CREDIT"];
            }
        }
             
        return $OPENING_BALANCE;
    }
    public function getAllCompanyAccountsForSelectLeaf($lender_id)
    {
        $sql = "SELECT * FROM lender_accounts WHERE LENDER_ID = '".$lender_id."' AND IS_LOAN_PRODUCT != 1 ORDER BY GL_CATEGORY,GL_CODE ASC";
        //$result = $this->db->query($sql)->result_array();
        $result = DB::select($sql);
        $result = json_decode(json_encode($result),true);
        $temp=array();
       
        if(sizeof($result)>0)
        {

            foreach($result as $k=>$res)
            {

                $all_c = $this->count_all_children($res["ACCOUNT_ID"],$lender_id);
                $size_of_all_c = count($all_c);
                //var_dump($all_c);
                if($size_of_all_c > 0){

                    unset($result[$k]);    

                }else{

                    $temp[]=$result[$k];    

                }

            }
            
            //die();

        }
       
        return $temp;

    }
    public function count_all_children($acc,$lender_id)
    {

        return DB::select("select account_id from lender_accounts where GL_PARENT = '".$acc."' and lender_id='".$lender_id."'");

    }
    public function getGLAccount($k,$lender_id)
    {
        $row = DB::select("SELECT HAS_BEEN_USED_FOR_BAL_GL,IS_LOAN_PRODUCT,GL_CATEGORY,ACCOUNT_ID,GL_CODE,GL_NAME,IS_INV FROM lender_accounts WHERE LENDER_ID = '".$lender_id."' AND ACCOUNT_ID = '".$k."'");

        return $row;

    }

    public function getAccountCurrentBalance($LENDER_ACCOUNT_ID,$fiscal_date_start,$fiscal_date_end,$direction,$lender_id)
    {
        $OPENING_BALANCE = 0;
        //first the previous year balance from the date start
        //get the total of transaction between end of previous year and date start
        $YEAR_END = date('Y',strtotime($fiscal_date_start))-1;
        // var_dump($LENDER_ACCOUNT_ID);
        // var_dump($YEAR_END);
        // var_dump($lender_id);
        //what the clsoing balance for that year
        $row=("SELECT CLOSING_BALANCE FROM coa_balances WHERE ACCOUNT_ID = '".$LENDER_ACCOUNT_ID."' AND YEAR_END = '".$YEAR_END."' AND LENDER_ID = '".$lender_id."'");

       
        $row = DB::select($row);
        $row = json_decode(json_encode($row),true);
        // var_dump($row);
        // die();
        if(!empty($row[0]))
        {
            $row = $row[0];
            $OPENING_BALANCE+=$row["CLOSING_BALANCE"];
        } 
        else
        {
            $OPENING_BALANCE = 0;
        }
       
        $account_details = ("select * from lender_accounts where account_id = '".$LENDER_ACCOUNT_ID."'");
        $account_details = DB::select($account_details);
        $account_details = json_decode(json_encode($account_details),true);
        $account_details = $account_details [0];
        //  var_dump($account_details);
        // die();
        if($account_details["GL_CATEGORY"]=="4"||$account_details["GL_CATEGORY"]=="5")
        {
            $OPENING_BALANCE=0;
        }
        if(date("m-d",strtotime($fiscal_date_start))=="01-01")
        {}
        else
        {
            $fromdate = date('Y',strtotime($fiscal_date_start)).'-01'.'-01';
            $sqlx="SELECT a.*,b.GL_NAME,b.GL_CODE FROM chart_account_transactions as a
            LEFT JOIN lender_accounts as b on a.ACCOUNT_ID = b.ACCOUNT_ID
            WHERE a.ACCOUNT_ID='".$LENDER_ACCOUNT_ID."' and a.is_approved=1 and a.lender_id = '".$lender_id."'
            and (a.date_added  >= '".$fromdate."' and a.date_added < '".$fiscal_date_start."')";

            // $rowx = ("SELECT ACCOUNTING_MODEL FROM people WHERE PEOPLE_ID = '".$lender_id."'");

            // if($rowx["ACCOUNTING_MODEL"]=="")
            // {
            //     $sqlx.=" AND (a.IS_BOTH=1 OR a.IS_BOTH = 3)";
    
            // }
            // else
            // {
            //         switch($rowx["ACCOUNTING_MODEL"]){
            //             case "1":
            //                 $sqlx.=" AND (a.IS_BOTH=1 OR a.IS_BOTH = 3)";
            //             break;
            //             case "2":
            //                 $sqlx.=" AND (a.IS_BOTH=2 OR a.IS_BOTH = 3)";
            //             break;
    
            //         }
    
            // }
            $resultx = DB::select($sqlx);
            $resultx = json_decode(json_encode($resultx),true);
            $OPENING_BALANCE+=$this->getCurrentBalance($resultx,0,$direction);
        }
        return $OPENING_BALANCE;
    }

    private function getCurrentBalance($trans,$y=0,$ddire=1)
    {
        $prev_bal = 0;
        $total_debit = 0;
        $total_credit = 0;
        if(sizeof($trans)>0)
        {

            foreach($trans as $tran){

                if($y==0){
                    $total_credit+=$tran["CREDIT"];
                    $total_debit+=$tran["DEBIT"];
                }else{
                    $total_credit+=$tran["SUMC"];
                    $total_debit+=$tran["SUMD"];
                }
            }
        }
        if($ddire=="1")
        {
            return $prev_bal+$total_debit-$total_credit;
        }
        else
        {
            return $prev_bal-$total_debit+$total_credit;
        }


    }

    public function AddPLGroup(Request $request)
    { 
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);      
        $group_title = $request->group_title;
        $group_category_id = $request->group_category_id;
        $account_ids = $request->account_ids;

        if(!empty($account_ids) && !empty($group_title) && !empty($group_category_id))
        {
            //$account_ids = implode(',',$account_ids);
            $grouped_items = [];
            $group_order = DB::table('profit_loss_groups')->where('LENDER_ID',$lender_id)->where('GROUP_CATEGORY',$group_category_id)->max('ORDERING');
            $group_order = !empty($group_order) ? (int)$group_order : 0;
            //$group_order = 0;
            //return  $group_order;
            $inserted_group_id = DB::table('profit_loss_groups')->insertGetId([
                'GROUP_TITLE'=>$group_title,
                'GROUP_CATEGORY'=>$group_category_id,
                //'GROUP_ITEMS_TEXT'=>$account_ids,
                'LENDER_ID'=>$lender_id,
                'USER_ID'=>$user_id,
                'DATE_CREATED'=>Carbon::now(),
                'ORDERING'=>$group_order + 1,
            ]);
            $order = 0;
            foreach($account_ids as $key=>$account_id)
            {
                $order+=1;
                $account_name = DB::table('lender_accounts')->select('GL_NAME')->where('ACCOUNT_ID',$account_id)->get();
                $account_name = !empty($account_name) ? $account_name[0]->GL_NAME : "no name";
                $grouped_items[$key]['ACCOUNT_ID'] = $account_id;
                $grouped_items[$key]['LENDER_ID'] = $lender_id;
                $grouped_items[$key]['GROUP_ID'] =  $inserted_group_id;
                $grouped_items[$key]['DATE_ADDED'] = Carbon::now();
                $grouped_items[$key]['USER_ID'] = $user_id;
                $grouped_items[$key]['ACCOUNT_NAME'] = $account_name; $grouped_items[$key]['ORDERING'] = $order;

            }
            DB::table('bs_report_group_items')->insert($grouped_items);
            
            if(!empty($inserted_group_id))
            {
                return json_encode(['response'=>"profit loss group was created successfully",'status'=>true]); 
            }
            else
            {
                return json_encode(['response'=>"profit loss group was not created",'status'=>false]);
            }

        }
        else
        {
            return json_encode(['response'=>"one or more field(s) is empty",'status'=>false]);
        }
    }
    public function updatePLGroup(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_id = $request->group_id;
        $group_category_id = $request->group_category_id;
        $group_title = $request->group_title;
        $account_ids = $request->account_ids;
        if(!empty($group_id) && !empty($group_category_id) && !empty($group_title)&& !empty($account_ids))
        {
            //$account_ids = implode(',',$account_ids);
            $grouped_items = [];
          
            $group_order = DB::table('profit_loss_groups')->where('LENDER_ID',$lender_id)->where('GROUP_CATEGORY',$group_category_id)->max('ORDERING');
            $group_order = !empty($group_order) ? (int)$group_order : 0;
            $updated_group_id = DB::table('profit_loss_groups')->where('LENDER_ID',$lender_id)->where('GROUP_ID',$group_id)->update([
                'GROUP_TITLE'=>$group_title,
                'GROUP_CATEGORY'=>$group_category_id,
                //'GROUP_ITEMS_TEXT'=>$account_ids,
                //'LENDER_ID'=>$lender_id,
                //'USER_ID'=>$user_id,
                //'DATE_CREATED'=>Carbon::now(),
                'DATE_MODIFIED'=>Carbon::now(),
                'ORDERING'=>$group_order + 1,
            ]);
            $order = DB::table('bs_report_group_items')->where('LENDER_ID',$lender_id)->where('GROUP_ID',$group_id)->max('ORDERING');
           $order = !empty($order) ? $order: 0;
            foreach($account_ids as $key=>$account_id)
            {
                $order+=1;
                $account_name = DB::table('lender_accounts')->select('GL_NAME')->where('ACCOUNT_ID',$account_id)->get();
                $account_name = !empty($account_name) ? $account_name[0]->GL_NAME : "no name";
                $grouped_items[$key]['ACCOUNT_ID'] = $account_id;
                $grouped_items[$key]['LENDER_ID'] = $lender_id;
                $grouped_items[$key]['GROUP_ID'] =  $group_id;
                $grouped_items[$key]['DATE_ADDED'] = Carbon::now();
                $grouped_items[$key]['USER_ID'] = $user_id;
                $grouped_items[$key]['ACCOUNT_NAME'] = $account_name; $grouped_items[$key]['ORDERING'] = $order;

            }
            DB::table('bs_report_group_items')->insert($grouped_items);
            
            if(!empty($updated_group_id))
            {
                return json_encode(['response'=>"item was added successfully",'status'=>true]); 
            }
            else
            {
                return json_encode(['response'=>"item was not added",'status'=>false]);
            }

        }
        else
        {
            return json_encode(['response'=>"one or more field(s) is empty",'status'=>false]);
        }
       

    }
    public function listPLGroup(Request $request)
    {
        // $min = DB::table('profit_loss_groups')->where('GROUP_CATEGORY',5)->min('ORDERING');
        // $max = DB::table('profit_loss_groups')->where('GROUP_CATEGORY',5)->max('ORDERING');
        // var_dump((int)$min);
        // var_dump((int)$max + 1);
        // die();  

        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        // $group_title = $request->group_title;
        // $group_category_id = $request->group_category_id;
        // $account_ids = $request->account_ids;
        // $data = DB::table('profit_loss_groups as p')->select('*')->join('lender_accounts as l','l.')->where('LENDER_ID',$lender_id)->get();
       $plgroups = DB::select("select GROUP_ID,GROUP_TITLE,GROUP_CATEGORY,GROUP_ITEMS_TEXT,ORDERING from profit_loss_groups where LENDER_ID=$lender_id ORDER BY GROUP_CATEGORY,ORDERING ");
       //return $plgroups;
        // collect();
       //return $data['plgroups'];
        //    $min_max = DB::table('profit_loss_groups')->where('GROUP_CATEGORY',$data['glgroup']->GROUP_CATEGORY)->min('ORDERING');
        $pl_groups =[];
        if(!empty($plgroups))
        {
            foreach($plgroups as $key=>$data)
            {
                //$data->GROUP_ITEMS_TEXT = explode(',',$data->GROUP_ITEMS_TEXT);
                $up = true;
                $down= true;
                $min = DB::table('profit_loss_groups')->where('LENDER_ID',$lender_id)->where('GROUP_CATEGORY',$data->GROUP_CATEGORY)->min('ORDERING');
                $min = (int)$min;
                $max = DB::table('profit_loss_groups')->where('LENDER_ID',$lender_id)->where('GROUP_CATEGORY',$data->GROUP_CATEGORY)->max('ORDERING');
                $max = (int)$max;
                // var_dump($min);
                // var_dump($max);
                
                if($min == 1 && $max==1 && $data->ORDERING == 1)
                {
                    $up = false;
                    $down = false;
                }
                if($min == 1  && $max>1 && $data->ORDERING == 1)
                {
                    $up = false;
                }

                if($min == 1 && $max>1 && $data->ORDERING == $max)
                {
                    $down = false;
                }
                $data->up = $up;
                $data->down = $down;
                $data->account_details = DB::table('bs_report_group_items')->select('GROUP_ITEM_ID','ACCOUNT_NAME','ACCOUNT_ID','GROUP_ID','ORDERING')->where('GROUP_ID',$data->GROUP_ID)->where('LENDER_ID',$lender_id)->orderby('ORDERING')->get();
                
                if(!empty($data->account_details))
                {
                    foreach($data->account_details as $account_detail)
                    {
                        $up_acct = true;
                        $down_acct = true;
                        $min_acct_order = DB::table('bs_report_group_items')->where('GROUP_ID',$account_detail->GROUP_ID)->where('LENDER_ID',$lender_id)->min('ORDERING');
                        $max_acct_order = DB::table('bs_report_group_items')->where('GROUP_ID',$account_detail->GROUP_ID)->where('LENDER_ID',$lender_id)->max('ORDERING');
                        if($min_acct_order == 1 && $max_acct_order==1 && $account_detail->ORDERING == 1)
                        {
                            $up_acct = false;
                            $down_acct = false;
                        }
                        if($min_acct_order == 1  && $max_acct_order>1 && $account_detail->ORDERING == 1)
                        {
                            $up_acct = false;
                        }
        
                        if($min_acct_order == 1 && $max_acct_order>1 && $account_detail->ORDERING == $max_acct_order)
                        {
                            $down_acct = false;
                        }
                        $account_detail->left = $up_acct;
                        $account_detail->right = $down_acct;
                    }
                }
               
               


                $pl_groups[] = $data;
            }
            return json_encode(['pl_groups'=>$pl_groups,'status'=>true]); 
        }
        else
        {
            return json_encode(['response'=>"no profit loss groups available",'status'=>false]);
        }
      

    }

    public function deletePLGroup(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_id = $request->group_id;
       $deleted_id = DB::table('profit_loss_groups')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->delete();

       $deleted_ids_count = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->count();

       $deleted_ids = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->delete();

        if($deleted_id == 1 && $deleted_ids == $deleted_ids_count)
        {
          
            return json_encode(['response'=>'profit loss group was deleted succesfully','status'=>true]); 
        }
        else
        {
            return json_encode(['response'=>"group delete failed",'status'=>false]);
        }
      

    }

    public function deleteAccountFromGroup(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_item_id = $request->group_item_id;
        $account_id = $request->account_id;
        $account_to_delete = DB::table('bs_report_group_items')->where('GROUP_ITEM_ID',$group_item_id)->where('LENDER_ID',$lender_id)->delete();

        // if(!empty($account_to_delete))
        // {
        //     $items = explode(',',$account_to_delete[0]->GROUP_ITEMS_TEXT);
        //     foreach($items as $item)
        //     {
        //         if($item == $account_id)
        //         {
        //             unset($item);
        //         }
        //     }

        //     // $account_tobe_deleted = DB::table('profit_loss_groups')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->update([
        //     //     'GROUP_ITEMS_TEXT'=>str_replace($account_id,'',$account_to_delete[0]->GROUP_ITEMS_TEXT)
        //     // ]);
        // }
      

        if($account_to_delete == 1)
        {
          
            return json_encode(['response'=>'account was  succesfully deleted from group','status'=>true]); 
        }
        else
        {
            return json_encode(['response'=>"account was not deleted from group",'status'=>false]);
        }
      

    }

    public function moveGroupOrder(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_id = $request->group_id;
        $up = $request->up;
        $down = $request->down;
        $group_category_id = $request->group_category_id;

        // $category_groups = DB::table('profit_loss_groups')->select('*')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->orderby('ORDERING')->get();

        $group_ordering = DB::table('profit_loss_groups')->select('ORDERING')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->get();
        $group_ordering = !empty($group_ordering) ? (int)($group_ordering[0]->ORDERING) : 0;

        if($up == true)
        {          
            $previous_ordering = DB::table('profit_loss_groups')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->where('ORDERING','<',$group_ordering)->max('ORDERING');

             $prev_order = $previous_ordering;

            $update_one = DB::table('profit_loss_groups')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->where('ORDERING',$previous_ordering)->update([
                    'ORDERING'=> $group_ordering
            ]);
            $update_two = DB::table('profit_loss_groups')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->update([
                'ORDERING'=> $prev_order
            ]);
        }
        if($down == true)
        {          
            $next_ordering = DB::table('profit_loss_groups')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->where('ORDERING','>',$group_ordering)->min('ORDERING');

            $next_order = $next_ordering;

            $update_one = DB::table('profit_loss_groups')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->where('ORDERING',$next_ordering)->update([
                    'ORDERING'=> $group_ordering
            ]);
            $update_two = DB::table('profit_loss_groups')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->update([
                'ORDERING'=> $next_order
            ]);
        }
        // $plgroups = DB::select("select GROUP_ID,GROUP_TITLE,GROUP_CATEGORY,GROUP_ITEMS_TEXT,ORDERING from profit_loss_groups where LENDER_ID=$lender_id ORDER BY GROUP_CATEGORY,ORDERING ");

        return json_encode(['response'=>"group was moved succesfully",'status'=>true]);
    
    }

    public function moveAccountOrder(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_item_id = $request->group_item_id;
        $left = $request->left;//means left
        $right = $request->right;//means right
        $group_id = $request->group_id;

        $acct_ordering = DB::table('bs_report_group_items')->select('ORDERING')->where('GROUP_ITEM_ID',$group_item_id)->where('LENDER_ID',$lender_id)->get();
        $acct_ordering = !empty($acct_ordering) ? (int)($acct_ordering[0]->ORDERING) : 0;

        if($left == true)
        {          
            $previous_ordering = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->where('ORDERING','<',$acct_ordering)->max('ORDERING');

             $prev_order = $previous_ordering;

            $update_one = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->where('ORDERING',$previous_ordering)->update([
                    'ORDERING'=> $acct_ordering
            ]);
            $update_two = DB::table('bs_report_group_items')->where('GROUP_ITEM_ID',$group_item_id)->where('LENDER_ID',$lender_id)->update([
                'ORDERING'=> $prev_order
            ]);
        }
        if($right == true)
        {          
            $next_ordering = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->where('ORDERING','>',$acct_ordering)->min('ORDERING');

            $next_order = $next_ordering;

            $update_one = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->where('ORDERING',$next_ordering)->update([
                    'ORDERING'=> $acct_ordering
            ]);
            $update_two = DB::table('bs_report_group_items')->where('GROUP_ITEM_ID',$group_item_id)->where('LENDER_ID',$lender_id)->update([
                'ORDERING'=> $next_order
            ]);
        }
        // $plgroups = DB::select("select GROUP_ID,GROUP_TITLE,GROUP_CATEGORY,GROUP_ITEMS_TEXT,ORDERING from profit_loss_groups where LENDER_ID=$lender_id ORDER BY GROUP_CATEGORY,ORDERING ");

        return json_encode(['response'=>"account was moved succesfully",'status'=>true]);
      
    }
   

    public function AddBSGroup(Request $request)
    { 
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);      
        $group_title = $request->group_title;
        $group_category_id = $request->group_category_id;
        $account_ids = $request->account_ids;

        if(!empty($account_ids) && !empty($group_title) && !empty($group_category_id))
        {
            //$account_ids = implode(',',$account_ids);
            $grouped_items = [];
            $group_order = DB::table('balance_sheet_groups')->where('LENDER_ID',$lender_id)->where('GROUP_CATEGORY',$group_category_id)->max('ORDERING');
            $group_order = !empty($group_order) ? (int)$group_order : 0;
            //$group_order = 0;
            //return  $group_order;
            $inserted_group_id = DB::table('balance_sheet_groups')->insertGetId([
                'GROUP_TITLE'=>$group_title,
                'GROUP_CATEGORY'=>$group_category_id,
                //'GROUP_ITEMS_TEXT'=>$account_ids,
                'LENDER_ID'=>$lender_id,
                'USER_ID'=>$user_id,
                'DATE_CREATED'=>Carbon::now(),
                'ORDERING'=>$group_order + 1,
            ]);
            $order = 0;
            foreach($account_ids as $key=>$account_id)
            {
                $order++;
                $account_name = DB::table('lender_accounts')->select('GL_NAME')->where('ACCOUNT_ID',$account_id)->get();
                $account_name = !empty($account_name) ? $account_name[0]->GL_NAME : "no name";
                $grouped_items[$key]['ACCOUNT_ID'] = $account_id;
                $grouped_items[$key]['LENDER_ID'] = $lender_id;
                $grouped_items[$key]['GROUP_ID'] =  $inserted_group_id;
                $grouped_items[$key]['DATE_ADDED'] = Carbon::now();
                $grouped_items[$key]['USER_ID'] = $user_id;
                $grouped_items[$key]['ACCOUNT_NAME'] = $account_name; $grouped_items[$key]['ORDERING'] = $order;

            }
            DB::table('bs_report_group_items')->insert($grouped_items);
            
            if(!empty($inserted_group_id))
            {
                return json_encode(['response'=>"balance sheet group was created successfully",'status'=>true]); 
            }
            else
            {
                return json_encode(['response'=>"balance sheet group was not created",'status'=>false]);
            }

        }
        else
        {
            return json_encode(['response'=>"one or more field(s) is empty",'status'=>false]);
        }
    }
    public function updateBSGroup(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_id = $request->group_id;
        $group_category_id = $request->group_category_id;
        $group_title = $request->group_title;
        $account_ids = $request->account_ids;
        if(!empty($group_id) && !empty($group_category_id) && !empty($group_title)&& !empty($account_ids))
        {
            //$account_ids = implode(',',$account_ids);
            $grouped_items = [];
          
            $group_order = DB::table('balance_sheet_groups')->where('LENDER_ID',$lender_id)->where('GROUP_CATEGORY',$group_category_id)->max('ORDERING');
            $group_order = !empty($group_order) ? (int)$group_order : 0;
            $updated_group_id = DB::table('balance_sheet_groups')->where('LENDER_ID',$lender_id)->where('GROUP_ID',$group_id)->update([
                'GROUP_TITLE'=>$group_title,
                'GROUP_CATEGORY'=>$group_category_id,
                //'GROUP_ITEMS_TEXT'=>$account_ids,
                //'LENDER_ID'=>$lender_id,
                //'USER_ID'=>$user_id,
                //'DATE_CREATED'=>Carbon::now(),
                'DATE_MODIFIED'=>Carbon::now(),
                'ORDERING'=>$group_order + 1,
            ]);
            $order = DB::table('bs_report_group_items')->where('LENDER_ID',$lender_id)->where('GROUP_ID',$group_id)->max('ORDERING');
           $order = !empty($order) ? $order: 0;
            foreach($account_ids as $key=>$account_id)
            {
                $order++;
                $account_name = DB::table('lender_accounts')->select('GL_NAME')->where('ACCOUNT_ID',$account_id)->get();
                $account_name = !empty($account_name) ? $account_name[0]->GL_NAME : "no name";
                $grouped_items[$key]['ACCOUNT_ID'] = $account_id;
                $grouped_items[$key]['LENDER_ID'] = $lender_id;
                $grouped_items[$key]['GROUP_ID'] =  $group_id;
                $grouped_items[$key]['DATE_ADDED'] = Carbon::now();
                $grouped_items[$key]['USER_ID'] = $user_id;
                $grouped_items[$key]['ACCOUNT_NAME'] = $account_name; $grouped_items[$key]['ORDERING'] = $order;

            }
            DB::table('bs_report_group_items')->insert($grouped_items);
            
            if(!empty($updated_group_id))
            {
                return json_encode(['response'=>"item was added successfully",'status'=>true]); 
            }
            else
            {
                return json_encode(['response'=>"item was not added",'status'=>false]);
            }

        }
        else
        {
            return json_encode(['response'=>"one or more field(s) is empty",'status'=>false]);
        }
       

    }
    public function listBSGroup(Request $request)
    {
        // $min = DB::table('balance_sheet_groups')->where('GROUP_CATEGORY',5)->min('ORDERING');
        // $max = DB::table('balance_sheet_groups')->where('GROUP_CATEGORY',5)->max('ORDERING');
        // var_dump((int)$min);
        // var_dump((int)$max + 1);
        // die();  

        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        // $group_title = $request->group_title;
        // $group_category_id = $request->group_category_id;
        // $account_ids = $request->account_ids;
        // $data = DB::table('balance_sheet_groups as p')->select('*')->join('lender_accounts as l','l.')->where('LENDER_ID',$lender_id)->get();
       $plgroups = DB::select("select GROUP_ID,GROUP_TITLE,GROUP_CATEGORY,GROUP_ITEMS_TEXT,ORDERING from balance_sheet_groups where LENDER_ID=$lender_id ORDER BY GROUP_CATEGORY,ORDERING ");
       //return $plgroups;
        // collect();
       //return $data['plgroups'];
        //    $min_max = DB::table('balance_sheet_groups')->where('GROUP_CATEGORY',$data['glgroup']->GROUP_CATEGORY)->min('ORDERING');
        $pl_groups =[];
        if(!empty($plgroups))
        {
            foreach($plgroups as $key=>$data)
            {
                //$data->GROUP_ITEMS_TEXT = explode(',',$data->GROUP_ITEMS_TEXT);
                $up = true;
                $down= true;
                $min = DB::table('balance_sheet_groups')->where('LENDER_ID',$lender_id)->where('GROUP_CATEGORY',$data->GROUP_CATEGORY)->min('ORDERING');
                $min = (int)$min;
                $max = DB::table('balance_sheet_groups')->where('LENDER_ID',$lender_id)->where('GROUP_CATEGORY',$data->GROUP_CATEGORY)->max('ORDERING');
                $max = (int)$max;
                // var_dump($min);
                // var_dump($max);
                
                if($min == 1 && $max==1 && $data->ORDERING == 1)
                {
                    $up = false;
                    $down = false;
                }
                if($min == 1  && $max>1 && $data->ORDERING == 1)
                {
                    $up = false;
                }

                if($min == 1 && $max>1 && $data->ORDERING == $max)
                {
                    $down = false;
                }
                $data->up = $up;
                $data->down = $down;
                $data->account_details = DB::table('bs_report_group_items')->select('GROUP_ITEM_ID','ACCOUNT_NAME','ACCOUNT_ID','GROUP_ID','ORDERING')->where('LENDER_ID',$lender_id)->where('GROUP_ID',$data->GROUP_ID)->orderby('ORDERING')->get();
                
                if(!empty($data->account_details))
                {
                    foreach($data->account_details as $account_detail)
                    {
                        $up_acct = true;
                        $down_acct = true;
                        $min_acct_order = DB::table('bs_report_group_items')->where('LENDER_ID',$lender_id)->where('GROUP_ID',$account_detail->GROUP_ID)->min('ORDERING');
                        $max_acct_order = DB::table('bs_report_group_items')->where('LENDER_ID',$lender_id)->where('GROUP_ID',$account_detail->GROUP_ID)->max('ORDERING');
                        if($min_acct_order == 1 && $max_acct_order==1 && $account_detail->ORDERING == 1)
                        {
                            $up_acct = false;
                            $down_acct = false;
                        }
                        if($min_acct_order == 1  && $max_acct_order>1 && $account_detail->ORDERING == 1)
                        {
                            $up_acct = false;
                        }
        
                        if($min_acct_order == 1 && $max_acct_order>1 && $account_detail->ORDERING == $max_acct_order)
                        {
                            $down_acct = false;
                        }
                        $account_detail->left = $up_acct;
                        $account_detail->right = $down_acct;
                    }
                }
               
               


                $pl_groups[] = $data;
            }
            return json_encode(['bs_groups'=>$pl_groups,'status'=>true]); 
        }
        else
        {
            return json_encode(['response'=>"no balance sheet groups available",'status'=>false]);
        }
      

    }

    public function deleteBSGroup(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_id = $request->group_id;
       $deleted_id = DB::table('balance_sheet_groups')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->delete();

       $deleted_ids_count = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->count();

       $deleted_ids = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->delete();

        if($deleted_id == 1 && $deleted_ids == $deleted_ids_count)
        {
          
            return json_encode(['response'=>'balance sheet group was deleted succesfully','status'=>true]); 
        }
        else
        {
            return json_encode(['response'=>"group delete failed",'status'=>false]);
        }
      

    }

    public function deleteAccountFromBSGroup(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_item_id = $request->group_item_id;
        $account_id = $request->account_id;
        $account_to_delete = DB::table('bs_report_group_items')->where('GROUP_ITEM_ID',$group_item_id)->where('LENDER_ID',$lender_id)->delete();

        // if(!empty($account_to_delete))
        // {
        //     $items = explode(',',$account_to_delete[0]->GROUP_ITEMS_TEXT);
        //     foreach($items as $item)
        //     {
        //         if($item == $account_id)
        //         {
        //             unset($item);
        //         }
        //     }

        //     // $account_tobe_deleted = DB::table('balance_sheet_groups')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->update([
        //     //     'GROUP_ITEMS_TEXT'=>str_replace($account_id,'',$account_to_delete[0]->GROUP_ITEMS_TEXT)
        //     // ]);
        // }
      

        if($account_to_delete == 1)
        {
          
            return json_encode(['response'=>'account was  succesfully deleted from group','status'=>true]); 
        }
        else
        {
            return json_encode(['response'=>"account was not deleted from group",'status'=>false]);
        }
      

    }

    public function moveBSGroupOrder(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_id = $request->group_id;
        $up = $request->up;
        $down = $request->down;
        $group_category_id = $request->group_category_id;

        // $category_groups = DB::table('balance_sheet_groups')->select('*')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->orderby('ORDERING')->get();

        $group_ordering = DB::table('balance_sheet_groups')->select('ORDERING')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->get();
        $group_ordering = !empty($group_ordering) ? (int)($group_ordering[0]->ORDERING) : 0;

        if($up == true)
        {          
            $previous_ordering = DB::table('balance_sheet_groups')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->where('ORDERING','<',$group_ordering)->max('ORDERING');

             $prev_order = $previous_ordering;

            $update_one = DB::table('balance_sheet_groups')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->where('ORDERING',$previous_ordering)->update([
                    'ORDERING'=> $group_ordering
            ]);
            $update_two = DB::table('balance_sheet_groups')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->update([
                'ORDERING'=> $prev_order
            ]);
        }
        if($down == true)
        {          
            $next_ordering = DB::table('balance_sheet_groups')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->where('ORDERING','>',$group_ordering)->min('ORDERING');

            $next_order = $next_ordering;

            $update_one = DB::table('balance_sheet_groups')->where('GROUP_CATEGORY',$group_category_id)->where('LENDER_ID',$lender_id)->where('ORDERING',$next_ordering)->update([
                    'ORDERING'=> $group_ordering
            ]);
            $update_two = DB::table('balance_sheet_groups')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->update([
                'ORDERING'=> $next_order
            ]);
        }
        // $plgroups = DB::select("select GROUP_ID,GROUP_TITLE,GROUP_CATEGORY,GROUP_ITEMS_TEXT,ORDERING from balance_sheet_groups where LENDER_ID=$lender_id ORDER BY GROUP_CATEGORY,ORDERING ");

        return json_encode(['response'=>"group was moved succesfully",'status'=>true]);
    
    }

    public function moveBSAccountOrder(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
        $group_item_id = $request->group_item_id;
        $left = $request->left;//means left
        $right = $request->right;//means right
        $group_id = $request->group_id;

        $acct_ordering = DB::table('bs_report_group_items')->select('ORDERING')->where('GROUP_ITEM_ID',$group_item_id)->where('LENDER_ID',$lender_id)->get();
        $acct_ordering = !empty($acct_ordering) ? (int)($acct_ordering[0]->ORDERING) : 0;

        if($left == true)
        {          
            $previous_ordering = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->where('ORDERING','<',$acct_ordering)->max('ORDERING');

             $prev_order = $previous_ordering;

            $update_one = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->where('ORDERING',$previous_ordering)->update([
                    'ORDERING'=> $acct_ordering
            ]);
            $update_two = DB::table('bs_report_group_items')->where('GROUP_ITEM_ID',$group_item_id)->where('LENDER_ID',$lender_id)->update([
                'ORDERING'=> $prev_order
            ]);
        }
        if($right == true)
        {          
            $next_ordering = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->where('ORDERING','>',$acct_ordering)->min('ORDERING');

            $next_order = $next_ordering;

            $update_one = DB::table('bs_report_group_items')->where('GROUP_ID',$group_id)->where('LENDER_ID',$lender_id)->where('ORDERING',$next_ordering)->update([
                    'ORDERING'=> $acct_ordering
            ]);
            $update_two = DB::table('bs_report_group_items')->where('GROUP_ITEM_ID',$group_item_id)->where('LENDER_ID',$lender_id)->update([
                'ORDERING'=> $next_order
            ]);
        }
        // $plgroups = DB::select("select GROUP_ID,GROUP_TITLE,GROUP_CATEGORY,GROUP_ITEMS_TEXT,ORDERING from balance_sheet_groups where LENDER_ID=$lender_id ORDER BY GROUP_CATEGORY,ORDERING ");

        return json_encode(['response'=>"account was moved succesfully",'status'=>true]);
      
    }
    public function getProfitLossStatement(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $FISCAL_DATE_START = $request->start_date;
        $FISCAL_DATE_START = !empty($FISCAL_DATE_START) ? date('Y-m-d',strtotime($FISCAL_DATE_START))  : "";
        $FISCAL_DATE_END = $request->end_date;
        $FISCAL_DATE_END = !empty($FISCAL_DATE_END) ? date('Y-m-d',strtotime($FISCAL_DATE_END))  : "";
        $trial_balance = array();
        
        $trial_balance["CATEORIES"]=array();
        $trial_balance["CATEORIES"][1]=array("CATEGORY_ID"=>"1","CATEGORY_NAME"=>'Income');
        $trial_balance["CATEORIES"][2]=array("CATEGORY_ID"=>"2","CATEGORY_NAME"=>'Expenses');
        $trial_balance["CATEORIES"][3]=array("CATEGORY_ID"=>"3","CATEGORY_NAME"=>'Income Tax');
        $trial_balance["CATEORIES"][4]=array("CATEGORY_ID"=>"4","CATEGORY_NAME"=>'OCI');
        
        foreach($trial_balance["CATEORIES"] as $k=>$cat)
        {
            $trial_balance["CATEORIES"][$k]["GROUPS"]=array_values($this->getProfitLossGroups($lender_id,$cat["CATEGORY_ID"],0));
             $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]=0;
             $category_total = 0;
             $cat_total = 0;
            if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"])>0)
            {
                //$trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]=0;
                foreach($trial_balance["CATEORIES"][$k]["GROUPS"] as $a=>$group)
                {
                   
                    // if(!empty($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_ITEMS"]))
                    // {
                    //     $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_ITEMS"] = array_values($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_ITEMS"]) ;
                    // }

                    
                    $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"]=0;
                    $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_DETAILS"]=($group);
                    $group["GROUP_TOTAL"] = 0;
                    // $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_ITEMS"]=array_values($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_ITEMS"]);
                    $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"]=array();
                    $group_total = 0;
                    if(sizeof($group["GROUP_ITEMS"])>0)
                    {
                      
                        foreach($group["GROUP_ITEMS"] as $item)
                        {
                           
                            // $group_total+=$item["OPENING_BALANCE"];
                            //    $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]=$this->getGLAccount($item["ACCOUNT_ID"],$lender_id);

                            $new_one = $this->getGLAccount($item["ACCOUNT_ID"],$lender_id);
                            $new_one = json_decode(json_encode($new_one),true);
                            $new_one = $new_one[0];

                            $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"] = $new_one;
                                switch($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"])
                                {
                                          case "1":
                                          case "5":
                                            $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"]=1;
                                          break;
                                          default:
                                            $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"]=2;
                                          break;
                                }

                                $result=$this->getAllCOTTransactions__($item["ACCOUNT_ID"],$lender_id,$FISCAL_DATE_START,$FISCAL_DATE_END,$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"]);

                                // $result = DB::table('chart_account_transactions as c')->join('lender_accounts as l','c.ACCOUNT_ID','=','l.ACCOUNT_ID')->select('c.CHART_ACCOUNT_TRANSACTION_ID','c.ACCOUNT_ID','c.DEBIT','c.CREDIT','c.NARRATION','c.TTYPE','c.BATCH_ID','c.IFN','c.DATE_ADDED','l.GL_NAME','l.GL_CODE')->where('c.is_approved',1)->where('l.LENDER_ID',$lender_id)->whereBetween('c.DATE_ADDED',[$FISCAL_DATE_START,$FISCAL_DATE_END])->where('l.IS_LOAN_PRODUCT','!=',1)->where('c.ACCOUNT_ID',$item["ACCOUNT_ID"])->orderBy('c.DATE_ADDED')->get();
                                $OPENING_BALANCE=$result["opening_balance"];

                                if($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"]=="4"||$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"]=="5")
                                {
                                  $OPENING_BALANCE=0;
                                }
                                // $OPENING_BALANCE=0;
                                // $TOTAL_TRANSACTIONS = 0;
                                // $REMAINING_TRANSACTIONS = 0;
                                $TOTAL_TRANSACTIONS=$result["current_balance"];
                                $REMAINING_TRANSACTIONS=$result["remaining_balance"];

                                //                                if($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"]=="4"||$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"]=="5"){
                                //                                  $OPENING_BALANCE=0;
                                //                                  $REMAINING_TRANSACTIONS=0;
                                //                                }
                               $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["OPENING_BALANCE"]=$OPENING_BALANCE+$REMAINING_TRANSACTIONS+$TOTAL_TRANSACTIONS;
                               $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"]+=$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["OPENING_BALANCE"];
                                
                              $cat_total += 50;
                               $group_total+=$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["OPENING_BALANCE"];


                               $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] = array_values( $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"]);
                            //    $group[]
                        }

                         $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_ITEMS"]=array_values($group["GROUP_ITEMS"]);
                        // $group["GROUP_ITEMS"] = array_values($group["GROUP_ITEMS"]);
                                
                    }
                    $total_income = 0;
                    if($group["GROUP_CATEGORY"] == 1)
                    {
                        $group_total_income = 0; 
                        if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"])>0)
                        {
                            foreach($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] as $k=>$v){
                                $group_total_income+=$v["OPENING_BALANCE"];
                            }
                        }
                        $total_income+=$group_total_income;
                        // $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][] = $total_income;

                    }
                    $total_expenses=0;
                    if($group["GROUP_CATEGORY"] == 2)
                    {
                        $group_total_expense = 0; 
                        if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"])>0)
                        {
                            foreach($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] as $k=>$v){
                                $group_total_expense+=$v["OPENING_BALANCE"];
                            }
                        }
                        $total_expenses+=$group_total_expense;
                    }
                    $total_ic=0;
                    if($group["GROUP_CATEGORY"] == 3)
                    {
                        $group_total_ic = 0; 
                        if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"])>0)
                        {
                            foreach($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] as $k=>$v){
                                $group_total_ic+=$v["OPENING_BALANCE"];
                            }
                        }
                        $total_ic+=$group_total_ic;
                    }
                    $total_oci=0;
                    if($group["GROUP_CATEGORY"] == 4)
                    {
                        $group_total_oci = 0; 
                        if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"])>0)
                        {
                            foreach($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] as $k=>$v){
                                $group_total_oci+=$v["OPENING_BALANCE"];
                            }
                        }
                        $total_oci+=$group_total_oci;
                    }
                    // $total_expenses=0;


                    // if(!empty($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"]))
                    // {
                    //     // $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]+=$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"]; 
                    //     $category_total += 1;
                    //     $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]=$category_total; 
                    // }
                    // else
                    // {
                    //     $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"] =  $group_total;
                    //     $category_total +=$group_total;
                    //     // $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]=$category_total;
                    // }


                    // $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]+=$group["GROUP_TOTAL"];    
                    // $category_total += $group["GROUP_TOTAL"];
                    // if(!empty($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"]))
                    // {
                    //     $category_total+= $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"];
                      
                     
                    // }
                    // else
                    // {
                    //     $category_total+=0;
                    // }
                    $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]= $cat_total;
                }
                
            }
           

          
        }
        $trial_balance["profit_before_tax"] = $total_income-$total_expenses;
        $trial_balance["profit_after_tax"] = ($total_income-$total_expenses)-$total_ic;
        $trial_balance["total_comprehensive_income"] = (($total_income-$total_expenses)-$total_ic)+$total_oci;
        $trial_balance["CATEORIES"] = array_values($trial_balance["CATEORIES"]);
        // $trial_balance["CATEORIES"] = array_values($trial_balance["CATEORIES"]);
        return $trial_balance;
    }

    public function getProfitLossStatementNew(Request $request)
    {

        $token = $request->token;
        $lender_id = $this->getToken($token);
        $FISCAL_DATE_START = $request->start_date;
        $FISCAL_DATE_START = !empty($FISCAL_DATE_START) ? date('Y-m-d',strtotime($FISCAL_DATE_START))  : "";
        $FISCAL_DATE_END = $request->end_date;
        $FISCAL_DATE_END = !empty($FISCAL_DATE_END) ? date('Y-m-d',strtotime($FISCAL_DATE_END))  : "";

        $trial_balance = array();
        $trial_balance["CATEORIES"]=array();
        $trial_balance["CATEORIES"][1]=array("CATEGORY_ID"=>"1","CATEGORY_NAME"=>'Income');

        $trial_balance["CATEORIES"][2]=array("CATEGORY_ID"=>"2","CATEGORY_NAME"=>'Expenses');
        $trial_balance["CATEORIES"][3]=array("CATEGORY_ID"=>"3","CATEGORY_NAME"=>'Income Tax');

        $trial_balance["CATEORIES"][4]=array("CATEGORY_ID"=>"4","CATEGORY_NAME"=>'OCI');

        $total_income = 0;
        $total_expenses = 0;
        $total_ic = 0;
        $total_oci = 0;
        $group_total_income = 0;
        $group_total_expense = 0; 
        $group_total_ic = 0; 
        $group_total_oci = 0;
        foreach($trial_balance["CATEORIES"] as $k=>$cat)
        {
            $trial_balance["CATEORIES"][$k]["GROUPS"]=array_values($this->getProfitLossGroups($lender_id,$cat["CATEGORY_ID"],0));
             $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]=0;

            if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"])>0)
            {
                foreach($trial_balance["CATEORIES"][$k]["GROUPS"] as $a=>$group)
                {
                   
                    $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"]=0;
                    $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_DETAILS"]=$group;
                    $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"]=array();

                    if(sizeof($group["GROUP_ITEMS"])>0)
                    {
                        foreach($group["GROUP_ITEMS"] as $item)
                        {



                            // $v=$this->accounting_model->doesAccountHaveChildren($item["ACCOUNT_ID"],$lender_id);



                            $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]=$this->getGLAccount($item["ACCOUNT_ID"],$lender_id);

                            $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"] = json_decode(json_encode(  $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]),true);
                            $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"] = $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"][0];


                                switch($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"]){



                                          case "1":



                                          case "5":



                                            $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"]=1;



                                          break;



                                          default:



                                            $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"]=2;



                                          break;



                                }


                                $result=$this->getAllCOTTransactions__($item["ACCOUNT_ID"],$lender_id,$FISCAL_DATE_START,$FISCAL_DATE_END,$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"]);



                                $OPENING_BALANCE=$result["opening_balance"];



                                if($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"]=="4"||$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"]=="5"){



                                  $OPENING_BALANCE=0;



                                }



                                $TOTAL_TRANSACTIONS=$result["current_balance"];



                                $REMAINING_TRANSACTIONS=$result["remaining_balance"];





                               $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["OPENING_BALANCE"]=$OPENING_BALANCE+$REMAINING_TRANSACTIONS+$TOTAL_TRANSACTIONS;

                                



                              $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"]+=$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["OPENING_BALANCE"];

                         




                              $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] = array_values( $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"]);     



                        }

                        $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_ITEMS"]=array_values($group["GROUP_ITEMS"]);

                       



                    }

                    if($group["GROUP_CATEGORY"] == 1)
                    {
                      $group_total_income +=  $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"];
                    }
                    if($group["GROUP_CATEGORY"] == 2)
                    {
                      $group_total_expense +=  $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"];
                    }
                    if($group["GROUP_CATEGORY"] == 3)
                    {
                      $group_total_ic +=  $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"];
                    }
                    if($group["GROUP_CATEGORY"] == 4)
                    {
                      $group_total_oci +=  $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"];
                    }       

                    // $total_income = 0;
                    // if($group["GROUP_CATEGORY"] == 1)
                    // {
                    //     $group_total_income = 0; 
                    //     if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"])>0)
                    //     {
                    //         foreach($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] as $k=>$v){
                    //             $group_total_income+=$v["OPENING_BALANCE"];
                    //         }
                    //     }
                    //     $total_income+=$group_total_income;
                    //     // $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][] = $total_income;

                    // }
                    // $total_expenses=0;
                    // if($group["GROUP_CATEGORY"] == 2)
                    // {
                    //     $group_total_expense = 0; 
                    //     if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"])>0)
                    //     {
                    //         foreach($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] as $k=>$v){
                    //             $group_total_expense+=$v["OPENING_BALANCE"];
                    //         }
                    //     }
                    //     $total_expenses+=$group_total_expense;
                    // }
                    // $total_ic=0;
                    // if($group["GROUP_CATEGORY"] == 3)
                    // {
                    //     $group_total_ic = 0; 
                    //     if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"])>0)
                    //     {
                    //         foreach($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] as $k=>$v){
                    //             $group_total_ic+=$v["OPENING_BALANCE"];
                    //         }
                    //     }
                    //     $total_ic+=$group_total_ic;
                    // }
                    // $total_oci=0;
                    // if($group["GROUP_CATEGORY"] == 4)
                    // {
                    //     $group_total_oci = 0; 
                    //     if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"])>0)
                    //     {
                    //         foreach($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] as $k=>$v){
                    //             $group_total_oci+=$v["OPENING_BALANCE"];
                    //         }
                    //     }
                    //     $total_oci+=$group_total_oci;
                    // }
                    



                    



                    $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]+=$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_TOTAL"];        



                }



                


            }
            



        }


        $total_income=$group_total_income;
            $total_expenses=$group_total_expense;
            $total_ic=$group_total_ic;
            $total_oci=$group_total_oci;
        $trial_balance["total_income"] = $total_income;
        $trial_balance["total_expenses"] = $total_expenses;
        $trial_balance["profit_before_tax"] = $total_income-$total_expenses;
        $trial_balance["profit_after_tax"] = ($total_income-$total_expenses)-$total_ic;
        $trial_balance["total_comprehensive_income"] = (($total_income-$total_expenses)-$total_ic)+$total_oci;
        
        $trial_balance["CATEORIES"] = array_values($trial_balance["CATEORIES"]);

        return $trial_balance;



    }

    public function getAllCOTTransactions__($LENDER_ACCOUNT_ID,$group_lender_id,$fiscal_date_start,$fiscal_date_end,$direction,$is_migrated=0)
    {



        $thre=false;



        $from_date = $fiscal_date_start;



        $to_date  = $fiscal_date_end;



        $sql="SELECT a.*,b.GL_NAME,b.GL_CODE FROM chart_account_transactions as a



        JOIN lender_accounts as b on a.ACCOUNT_ID = b.ACCOUNT_ID



        WHERE a.ACCOUNT_ID='".$LENDER_ACCOUNT_ID."' and a.is_approved=1 and a.lender_id = '".$group_lender_id."'



        and a.date_added  BETWEEN '".$from_date."' AND  '".$to_date."'";



        // $row = $this->db->query("SELECT ACCOUNTING_MODEL FROM people WHERE PEOPLE_ID = '".$group_lender_id."'")->row_array();



        // switch($row["ACCOUNTING_MODEL"])
        // {



        //             case "1":



        //                 $sql.=" AND (a.IS_BOTH=1 OR a.IS_BOTH = 3)";



        //             break;



        //             case "2":



        //                 $sql.=" AND (a.IS_BOTH=2 OR a.IS_BOTH = 3)";



        //             break;







        // }



        $sql.=" ORDER BY a.DATE_ADDED";







        //$result = $this->db->query($sql)->result_array();

        $result = DB::select($sql);

        $result = json_decode(json_encode($result),true);



        $data = array();



        $data["chart_account_transactions"] = $result;



        $data["sql"] = $sql;



        $data["opening_balance"] = $this->getAccountCurrentBalance($LENDER_ACCOUNT_ID,$fiscal_date_start,$fiscal_date_end,$direction,$group_lender_id);






      
        $data["current_balance"] = $this->getCurrentBalance($result,0,$direction);



        $data["remaining_balance"] = 0;



        



        return $data;



    }
    
    public function getProfitLossGroups($lender_id,$cat_id="",$t=0)
    {
        $temp=array();
        if($t=="1")
        {
            
            $sql="SELECT GROUP_CATEGORY,count(GROUP_CATEGORY) as NOS
                    FROM `profit_loss_groups`  WHERE LENDER_ID = '".$lender_id."'
                    group by GROUP_CATEGORY";    
            //$temp=$this->db->query($sql)->result_array();
            $temp  = DB::select($sql);
            $temp = json_decode(json_encode($temp),true);
            if(!empty($temp))
            {
                foreach($temp as $k=>$bs)
                {
                    $temp[$k]["GROUP_CATEGORY_ITEMS"]=array();
                    $sql="SELECT * FROM profit_loss_groups WHERE LENDER_ID = '".$lender_id."' and GROUP_CATEGORY='".$bs["GROUP_CATEGORY"]."'
                     ORDER BY GROUP_CATEGORY,ORDERING ASC";
                    //$a=$this->db->query($sql)->result_array();
                    $a  = DB::select($sql);
                    $a = json_decode(json_encode($a),true);
                    if(!empty($a))
                    {
                        foreach($a as $gc=>$grcat)
                        {
                            $temp[$k]["GROUP_CATEGORY_ITEMS"][$grcat["ORDERING"]]=$grcat;
                            $temp[$k]["GROUP_CATEGORY_ITEMS"][$grcat["ORDERING"]]["GROUP_ITEMS"]=$this->getReportGroupItems($grcat["GROUP_ID"],$lender_id,1);
                        }
                        
                        
                    }
                }
            }
    
        }
        else
        {
            $sql="SELECT * FROM profit_loss_groups WHERE LENDER_ID = '".$lender_id."'";
            if($cat_id!=""){
                $sql.=" AND GROUP_CATEGORY = '".$cat_id."'";
                $sql.=" ORDER BY GROUP_CATEGORY,ORDERING ASC";    
            }else{
               $sql.=" ORDER BY GROUP_CATEGORY,ORDERING ASC";
            }
            //$result=$this->db->query($sql)->result_array();
            $result  = DB::select($sql);
            $result = json_decode(json_encode($result),true);
            if(!empty($result)){
                foreach($result as $k=>$res){
                    if($t==1){
                        $result[$k]["GROUP_ITEMS"]=$this->getReportGroupItems($res["GROUP_ID"],$lender_id);
                        $temp[$res["ORDERING"]]=$result[$k];
                    }else{
                        $result[$k]["GROUP_ITEMS"]=$this->getReportGroupItems($res["GROUP_ID"],$lender_id);
                        $temp[$res["GROUP_ID"]]=$result[$k];
                    }
                    
                }
                
            }
        }
        return $temp;
    }

    public function getReportGroupItems($GROUP_ID,$Lender_id,$t=0)
    {
        // $sql="SELECT A.* FROM report_group_items as A JOIN lender_accounts as B ON A.ACCOUNT_ID = B.ACCOUNT_ID
        // WHERE A.GROUP_ID = '".$GROUP_ID."' AND A.LENDER_ID = '".$Lender_id."' ORDER BY ORDERING ASC";

        $sql="SELECT A.* FROM bs_report_group_items as A JOIN lender_accounts as B ON A.ACCOUNT_ID = B.ACCOUNT_ID
        WHERE A.GROUP_ID = '".$GROUP_ID."' AND A.LENDER_ID = '".$Lender_id."' ORDER BY ORDERING ASC";
        $temp=array();
        //$result= $this->db->query($sql)->result_array();
        $result  = DB::select($sql);
        $result = json_decode(json_encode($result),true);
        if(sizeof($result)>0){
            foreach($result as $k=>$res){
                if($t==0){
                    $temp[$res["ORDERING"]]=$res;    
                }else{
                    $temp[$res["ACCOUNT_ID"]]=$res;    
                }
            }
        }
        return $temp;
    }

    public function getBalanceSheetStatement(Request $request)
    {
        $token = $request->token;
        $lender_id = $this->getToken($token);
        $FISCAL_DATE_END = $request->date;
        $FISCAL_DATE_END = !empty($FISCAL_DATE_END) ? date('Y-m-d',strtotime($FISCAL_DATE_END))  : "";

        $trial_balance = array();

        $trial_balance["CATEORIES"]=array();

        $trial_balance["CATEORIES"][1]=array("CATEGORY_ID"=>"1","CATEGORY_NAME"=>'Asset');

        $trial_balance["CATEORIES"][2]=array("CATEGORY_ID"=>"2","CATEGORY_NAME"=>'Liabilities');

        $trial_balance["CATEORIES"][3]=array("CATEGORY_ID"=>"3","CATEGORY_NAME"=>'Equity');

        $trial_balance["CATEORIES"][4]=array("CATEGORY_ID"=>"4","CATEGORY_NAME"=>'Contigent Liabilities');

        foreach($trial_balance["CATEORIES"] as $k=>$cat)
        {
            $trial_balance["CATEORIES"][$k]["GROUPS"]=array_values($this->getBalanceSheetGroups($lender_id,$cat["CATEGORY_ID"],0));

            $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"] = 0;
            if(sizeof($trial_balance["CATEORIES"][$k]["GROUPS"])>0)
            {

                foreach($trial_balance["CATEORIES"][$k]["GROUPS"] as $a=>$group)
                {
                   $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_DETAILS"]=$group;

                   $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"]=array();

                   $trial_balance["CATEORIES"][$k]["GROUPS"][$a]['GROUP_TOTAL'] = 0;
                   if(sizeof($group["GROUP_ITEMS"])>0)
                   {

                       foreach($group["GROUP_ITEMS"] as $item)
                       {
                           $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]=$this->getGLAccount($item["ACCOUNT_ID"],$lender_id);


                           $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"] = json_decode(json_encode(  $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]),true);
                           $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"] = $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"][0];


                           switch($trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["GL_CATEGORY"]){




                                     case "1":



                                     case "5":



                                       $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"]=1;



                                     break;



                                     default:



                                       $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"]=2;



                                     break;



                           }

                          $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["OPENING_BALANCE"] = $this->gACB_($item["ACCOUNT_ID"],$FISCAL_DATE_END,$FISCAL_DATE_END,$trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["DETAILS"]["direction"],$lender_id);

                          $trial_balance["CATEORIES"][$k]["GROUPS"][$a]['GROUP_TOTAL']  += $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"][$item["ACCOUNT_ID"]]["OPENING_BALANCE"];

                        

                       }
                      

                   }
                   $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"] += $trial_balance["CATEORIES"][$k]["GROUPS"][$a]['GROUP_TOTAL'];

                   $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"] = array_values( $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["ITEMS"]);
                   $trial_balance["CATEORIES"][$k]["GROUPS"][$a]["GROUP_ITEMS"]=array_values($group["GROUP_ITEMS"]);
                }


            }
            // if()
            // {

            // }
            // $trial_balance["LIABILITY_PLUS_EQUITY"] = $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"] + $trial_balance["CATEORIES"][$k]["CATEGORY_TOTAL"]; 

        }
        $trial_balance["CATEORIES"] = array_values($trial_balance["CATEORIES"]);

        return $trial_balance;

    }

    public function getBalanceSheetGroups($lender_id,$cat_id="",$t=0)
    {
        $temp=array();

        if($t==1)
        {
            $sql="SELECT GROUP_CATEGORY,count(GROUP_CATEGORY) as NOS



                    FROM `balance_sheet_groups`  WHERE LENDER_ID = '".$lender_id."'



                    group by GROUP_CATEGORY";    



            //$temp=$this->db->query($sql)->result_array();

            $temp  = DB::select($sql);
            $temp = json_decode(json_encode($temp),true);

            if(!empty($temp)){



                foreach($temp as $k=>$bs){



                    $temp[$k]["GROUP_CATEGORY_ITEMS"]=array();



                    $sql="SELECT * FROM balance_sheet_groups WHERE LENDER_ID = '".$lender_id."' and GROUP_CATEGORY='".$bs["GROUP_CATEGORY"]."'



                     ORDER BY GROUP_CATEGORY,ORDERING ASC";



                    //$a=$this->db->query($sql)->result_array();

                    $a  = DB::select($sql);
                    $a = json_decode(json_encode($a),true);

                    if(!empty($a))
                    {



                        foreach($a as $gc=>$grcat){



                            $temp[$k]["GROUP_CATEGORY_ITEMS"][$grcat["ORDERING"]]=$grcat;



                            $temp[$k]["GROUP_CATEGORY_ITEMS"][$grcat["ORDERING"]]["GROUP_ITEMS"]=$this->getReportGroupItems_($grcat["GROUP_ID"],$lender_id,1);



                        }


                    }

                }

            }

        }
        else
        {



            



            $temp=array();



            $sql="SELECT * FROM balance_sheet_groups WHERE LENDER_ID = '".$lender_id."'";



            if($cat_id!=""){



                $sql.=" AND GROUP_CATEGORY = '".$cat_id."'";



                $sql.=" ORDER BY ORDERING ASC";    



            }else{



               $sql.=" ORDER BY GROUP_CATEGORY,ORDERING ASC";



            }



           // $result=$this->db->query($sql)->result_array();
           $result  = DB::select($sql);
           $result = json_decode(json_encode($result),true);


            if(!empty($result)){



                foreach($result as $k=>$res){



                    $result[$k]["GROUP_ITEMS"]=$this->getReportGroupItems_($res["GROUP_ID"],$lender_id,$t);



                    $temp[$res["GROUP_ID"]]=$result[$k];



                }



                



            }



        }

        return $temp;

    }

    public function getReportGroupItems_($GROUP_ID,$Lender_id,$t=0)
    {



        $sql="SELECT A.*,B.CURRENT_BALANCE,B.OTHER_CURRENT_BALANCE



        FROM bs_report_group_items as A



        JOIN lender_accounts as B ON A.ACCOUNT_ID = B.ACCOUNT_ID



        WHERE A.GROUP_ID = '".$GROUP_ID."' AND A.LENDER_ID = '".$Lender_id."' ORDER BY ORDERING ASC";



        $temp=array();



        //$result= $this->db->query($sql)->result_array();

        $result  = DB::select($sql);
        $result = json_decode(json_encode($result),true);

        if(sizeof($result)>0){



            foreach($result as $k=>$res){



                if($t==0){



                    $temp[$res["ORDERING"]]=$res;    



                }else{



                    $temp[$res["ACCOUNT_ID"]]=$res;    



                }



                



            }



        }



        return $temp;



    }

    public function saveJournalForm(Request $request)
    {        
        $token = $request->token; 
        $lender_id = $this->getToken($token);
        $user_id = $this->getUserId($token);
       // return $token;       
        //return $request->token; 
        $description = $request->description;
        $date = $request->date;
        $debit_account = $request->debit_account;
        $credit_account = $request->credit_account;
        $amount = $request->amount;
    
        if(empty($description))
        {

        }
        if(empty($date))
        {

        }

        if(empty($debit_account))
        {

        }
        if(empty($credit_account))
        {

        }
        $transaction_array = [];
             $journal_entry_id = DB::table('journal')->insertGetId([
                'NARRATIVE'=>  $description,
                'DATE_CREATED'=> Carbon::now(),
                'LENDER_ID'=> $lender_id, //no
                'ADDED_BY'=>  $user_id,//no
                'JOURNAL_DATE'=> $date,
                'IS_APPROVED'=>  0,   
                'TOTAL_DEBIT'=>  $amount, 
                'TOTAL_CREDIT'=>  $amount, 
              
            ]);
            
            DB::table('journal')->where('JOURNAL_ENTRY_ID',$journal_entry_id)->where('LENDER_ID',$lender_id)->update([
              
                'BATCH_ID'=> $journal_entry_id,
            ]);
            $transactions = ['debit','credit'];
            foreach($transactions as $key=>$transaction)
            {      
                if($transaction == 'debit')
                {
                    $transaction_array[$key]['DEBIT'] = $amount;
                    $transaction_array[$key]['CREDIT'] = 0;
                    $transaction_array[$key]['DATE_ADDED'] = $date;
                    $transaction_array[$key]['ACCOUNT_ID'] = $debit_account;
                    $transaction_array[$key]['TRANSACTION_CODE'] = str_random(40);
                    $transaction_array[$key]['IFN'] = 0;
                    $transaction_array[$key]['LENDER_ID'] = $lender_id;
                    $transaction_array[$key]['DATE_ADDED'] =  $date;
                    $transaction_array[$key]['ADDED_BY'] = $user_id;
                    // $transaction_array[$key]['LOAN_ID'] = !empty($transaction->LOAN_ID) ?$transaction->LOAN_ID :NULL;
                    $transaction_array[$key]['NARRATION'] = $description;
                    $transaction_array[$key]['TTYPE'] = 1;
                    $transaction_array[$key]['BATCH_ID'] =  $journal_entry_id;
                }     
                if($transaction == 'credit')
                {
                    $transaction_array[$key]['DEBIT'] = 0;
                    $transaction_array[$key]['CREDIT'] = $amount;
                    $transaction_array[$key]['DATE_ADDED'] = $date;
                    $transaction_array[$key]['ACCOUNT_ID'] = $credit_account;
                    $transaction_array[$key]['TRANSACTION_CODE'] = str_random(40);
                    $transaction_array[$key]['IFN'] = 0;
                    $transaction_array[$key]['LENDER_ID'] = $lender_id;
                    $transaction_array[$key]['DATE_ADDED'] =  $date;
                    $transaction_array[$key]['ADDED_BY'] = $user_id;
                    // $transaction_array[$key]['LOAN_ID'] = !empty($transaction->LOAN_ID) ?$transaction->LOAN_ID :NULL;
                    $transaction_array[$key]['NARRATION'] = $description;
                    $transaction_array[$key]['TTYPE'] = 2;
                    $transaction_array[$key]['BATCH_ID'] =  $journal_entry_id;
                } 
    
            }

            DB::table('chart_account_transactions')->insert($transaction_array);

            return json_encode(['status'=>true,'reponse'=>"succesfully created journal"]);

     
      
    }

}