<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class AccountController extends Controller
{
    public function determineAccountAnalytics($data,$payload,$lender,$leafIds="")
    {        
        
        // unset($leafIds[2]);
        // unset($leafIds[3]);
        $grades = [];
       $newGrade = [];
    
       $leaves = [
           'name'=>1,
           'accepted bank'=>2
       ];
       $leaves = array_values($leaves);
       $runAnalyticsData = $this->runAccountAnalytics($data,$leafIds,$leaves,$payload,$lender);
        
        foreach($leaves as $key=>$leafId)
        {
            $grades[$leafId] = $runAnalyticsData["leaves_grades"][$key];
        }
        
        foreach($grades as $key=>$grade)
        {
            if($grade == "passed")
            {
                $newGrade["passed"][] = $key;
            }
            else
            {
                $newGrade["failed"][] = $key;
            }
        }

        $analytics_data = [];
        // $analytics_data['score'] = ($runAnalyticsData["total"]/count($leafIds)) * 100;
        // $analytics_data['result'] = $analytics_data['score'] == 100 ? "eligible" : "not eligible";
        $analytics_data['grades'] = $newGrade;
        
        return json_encode(["data"=>$analytics_data,"status"=>true]);
    }

    public function runAccountAnalytics($data,$leafIds,$leaves,$payload,$lender)
    {       
        $leaves_grade = [];
        $total = 0;
            $found = 0;
            //checking if card bank is disbursement bank     
            $legal_name = explode(" ",str_replace(',','',strtolower($payload['customer']['LEGAL_NAME'])));
            
            $bankname = explode(" ",str_replace('.','',str_replace(',','',strtolower($payload['account']['CARD_NAME']))));
            
            foreach($bankname as $name){
                if(in_array($name,$legal_name)){
                    $found++;    
                }
            }
            
            $found_percent = $found == 0 ? 0 : ($found/sizeof($bankname))*100;
            
            if($found_percent >= 50){
                $total++;  $leaves_grade[] = "passed";
            }
            else
            {
                    $leaves_grade[] = "failed";
            }
                
            //checking if card bank is allowed
            $card_types = explode(',',$payload['lender']['ALLOWED_ACCOUNT_BANKS']);    
            
            
            if(in_array($payload['account']['BANK_ID'],$card_types)){
                $total++;  $leaves_grade[] = "passed";
            }
            else
            {
                    $leaves_grade[] = "failed";
            }


        $result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
            return $result;

    }


    public function determineAccountEligibility($data,$payload,$lender,$leafIds)
    {        
        
        unset($leafIds[2]);
        unset($leafIds[3]);
        $grades = [];
       $newGrade = [];
    
       $leaves = [
           'name'=>1,
           'accepted bank'=>2
       ];
        
       $runEligibiltyData = $this->runAccountEligibilty($data,$leafIds,$leaves,$payload,$lender);
        
        foreach($leafIds as $key=>$leafId)
        {
            $grades[$leafId] = $runEligibiltyData["leaves_grades"][$key];
        }
        
        foreach($grades as $key=>$grade)
        {
            if($grade == "passed")
            {
                $newGrade["passed"][] = $key;
            }
            else
            {
                $newGrade["failed"][] = $key;
            }
        }

        $eligibility_data = [];
        $eligibility_data['score'] = ($runEligibiltyData["total"]/count($leafIds)) * 100;
        $eligibility_data['result'] = $eligibility_data['score'] == 100 ? "eligible" : "not eligible";
        $eligibility_data['grades'] = $newGrade;
        
        return json_encode(["data"=>$eligibility_data,"status"=>true]);
    }

   public function runAccountEligibilty($data,$leafIds,$leaves,$payload,$lender)
   {
        
       $leaves_grade = [];
       $total = 0;
       if(in_array($leaves['name'],$leafIds))
        {
            $found = 0;
            //checking if card bank is disbursement bank     
            $legal_name = explode(" ",str_replace(',','',strtolower($payload['customer']['LEGAL_NAME'])));
            
            $bankname = explode(" ",str_replace('.','',str_replace(',','',strtolower($payload['account']['CARD_NAME']))));
            
            foreach($bankname as $name){
                if(in_array($name,$legal_name)){
                    $found++;    
                }
            }
            
            $found_percent = $found == 0 ? 0 : ($found/sizeof($bankname))*100;
            
            if($found_percent >= 50){
                $total++;  $leaves_grade[] = "passed";
            }
            else
            {
                    $leaves_grade[] = "failed";
            }
            
       }
        
        if(in_array($leaves['accepted bank'],$leafIds))
        {
            //checking if card bank is allowed
            $card_types = explode(',',$payload['lender']['ALLOWED_ACCOUNT_BANKS']);    
            
            
            if(in_array($payload['account']['BANK_ID'],$card_types)){
                $total++;  $leaves_grade[] = "passed";
            }
            else
            {
                    $leaves_grade[] = "failed";
            }
       }


       $result = ["total"=>$total,"leaves_grades"=>$leaves_grade];
        return $result;

   }
}
